/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.interactionhandling;

import com.ldtteam.blockout.views.Window;
import com.minecolonies.api.colony.ICitizen;
import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.ICitizenDataView;
import com.minecolonies.api.colony.interactionhandling.AbstractInteractionResponseHandler;
import com.minecolonies.api.colony.interactionhandling.IChatPriority;
import com.minecolonies.api.colony.interactionhandling.InteractionValidatorRegistry;
import com.minecolonies.api.util.Tuple;
import com.minecolonies.coremod.Network;
import com.minecolonies.coremod.client.gui.WindowCitizen;
import com.minecolonies.coremod.network.messages.server.colony.InteractionResponse;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

public abstract class ServerCitizenInteraction
extends AbstractInteractionResponseHandler {
    private static final String TAG_DELAY = "delay";
    private static final String TAG_PARENT = "parent";
    private static final String TAG_PARENTS = "parents";
    private static final String TAG_VALIDATOR_ID = "validator";
    private int displayAtWorldTick = 0;
    private Predicate<ICitizenData> validator;
    protected ITextComponent validatorId;
    protected Set<ITextComponent> parents = new HashSet<ITextComponent>();

    @SafeVarargs
    public ServerCitizenInteraction(ITextComponent inquiry, boolean primary, IChatPriority priority, Predicate<ICitizenData> validator, ITextComponent validatorId, Tuple<ITextComponent, ITextComponent> ... responseTuples) {
        super(inquiry, primary, priority, responseTuples);
        this.validator = validator;
        this.validatorId = validatorId;
    }

    public ServerCitizenInteraction(ICitizen data) {
    }

    @Override
    public boolean isVisible(World world) {
        return this.displayAtWorldTick == 0 || (long)this.displayAtWorldTick < world.func_82737_E();
    }

    @Override
    public boolean isValid(ICitizenData citizen) {
        return this.validator == null && !this.parents.isEmpty() || this.validator != null && this.validator.test(citizen);
    }

    public void addParent(ITextComponent parent) {
        this.parents.add(parent);
    }

    @Override
    public void removeParent(ITextComponent oldParent) {
        this.parents.remove(oldParent);
    }

    @Override
    public void onServerResponseTriggered(ITextComponent response, PlayerEntity player, ICitizenData data) {
        if (response instanceof TranslationTextComponent) {
            if (((TranslationTextComponent)response).func_150268_i().equals("com.minecolonies.coremod.gui.chat.remindmelater")) {
                this.displayAtWorldTick = (int)(player.field_70170_p.func_82737_E() + 12000L);
            } else if (((TranslationTextComponent)response).func_150268_i().equals("com.minecolonies.coremod.gui.chat.ignore")) {
                this.displayAtWorldTick = (int)(player.field_70170_p.func_82737_E() + 24000L);
            }
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean onClientResponseTriggered(ITextComponent response, PlayerEntity player, ICitizenDataView data, Window window) {
        if (((TranslationTextComponent)response).func_150268_i().equals("com.minecolonies.coremod.gui.chat.skipchitchat")) {
            WindowCitizen windowCitizen = new WindowCitizen(data);
            windowCitizen.open();
        }
        Network.getNetwork().sendToServer(new InteractionResponse(data.getColonyId(), data.getId(), player.field_70170_p.func_201675_m().func_186058_p().func_186068_a(), this.getInquiry(), response));
        return true;
    }

    @Override
    public CompoundNBT serializeNBT() {
        CompoundNBT compoundNBT = super.serializeNBT();
        compoundNBT.func_74768_a(TAG_DELAY, this.displayAtWorldTick);
        ListNBT list = new ListNBT();
        for (ITextComponent element : this.parents) {
            CompoundNBT elementTag = new CompoundNBT();
            elementTag.func_74778_a(TAG_PARENT, ITextComponent.Serializer.func_150696_a((ITextComponent)element));
            list.add((Object)elementTag);
        }
        compoundNBT.func_218657_a(TAG_PARENTS, (INBT)list);
        compoundNBT.func_74778_a(TAG_VALIDATOR_ID, ITextComponent.Serializer.func_150696_a((ITextComponent)this.validatorId));
        return compoundNBT;
    }

    @Override
    public void deserializeNBT(@NotNull CompoundNBT compoundNBT) {
        super.deserializeNBT(compoundNBT);
        this.displayAtWorldTick = compoundNBT.func_74762_e(TAG_DELAY);
        this.parents.clear();
        ListNBT list = compoundNBT.func_150295_c(TAG_PARENTS, 10);
        for (int i = 0; i < list.size(); ++i) {
            this.parents.add(ITextComponent.Serializer.func_150699_a((String)compoundNBT.func_74779_i(TAG_PARENT)));
        }
        this.validatorId = ITextComponent.Serializer.func_150699_a((String)compoundNBT.func_74779_i(TAG_VALIDATOR_ID));
        this.loadValidator();
    }

    protected void loadValidator() {
        this.validator = InteractionValidatorRegistry.getStandardInteractionValidatorPredicate(this.validatorId);
    }
}

