/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.jobs;

import com.minecolonies.api.client.render.modeltype.BipedModelType;
import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.jobs.ModJobs;
import com.minecolonies.api.colony.jobs.registry.JobEntry;
import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import com.minecolonies.coremod.colony.jobs.AbstractJobCrafter;
import com.minecolonies.coremod.entity.ai.citizen.lumberjack.EntityAIWorkLumberjack;
import com.minecolonies.coremod.entity.ai.citizen.lumberjack.Tree;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JobLumberjack
extends AbstractJobCrafter<EntityAIWorkLumberjack, JobLumberjack> {
    public static final double BONUS_SPEED_PER_LEVEL = 0.003;
    @Nullable
    private Tree tree;

    public JobLumberjack(ICitizenData entity) {
        super(entity);
    }

    @Override
    public CompoundNBT serializeNBT() {
        CompoundNBT compound = super.serializeNBT();
        CompoundNBT treeTag = new CompoundNBT();
        if (this.tree != null) {
            this.tree.write(treeTag);
        }
        compound.func_218657_a("Tree", (INBT)treeTag);
        return compound;
    }

    @Override
    public JobEntry getJobRegistryEntry() {
        return ModJobs.lumberjack;
    }

    @Override
    @NotNull
    public String getName() {
        return "com.minecolonies.coremod.job.Lumberjack";
    }

    @Override
    @NotNull
    public BipedModelType getModel() {
        return BipedModelType.LUMBERJACK;
    }

    @Override
    public void deserializeNBT(CompoundNBT compound) {
        super.deserializeNBT(compound);
        if (compound.func_150296_c().contains("Tree")) {
            this.tree = Tree.read(compound.func_74775_l("Tree"));
            if (!this.tree.isTree()) {
                this.tree = null;
            }
        }
    }

    @Override
    public void onLevelUp() {
        if (this.getCitizen().getEntity().isPresent()) {
            AbstractEntityCitizen worker = this.getCitizen().getEntity().get();
            worker.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.3 + (double)this.getCitizen().getCitizenSkillHandler().getLevel(this.getCitizen().getWorkBuilding().getSecondarySkill()) / 2.0 * 0.003);
        }
    }

    @Nullable
    public Tree getTree() {
        return this.tree;
    }

    public void setTree(@Nullable Tree tree) {
        this.tree = tree;
    }

    @Override
    @NotNull
    public EntityAIWorkLumberjack generateAI() {
        return new EntityAIWorkLumberjack(this);
    }
}

