/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.requestsystem.data;

import com.google.common.reflect.TypeToken;
import com.minecolonies.api.colony.requestsystem.StandardFactoryController;
import com.minecolonies.api.colony.requestsystem.data.IRequestSystemDeliveryManJobDataStore;
import com.minecolonies.api.colony.requestsystem.factory.FactoryVoidInput;
import com.minecolonies.api.colony.requestsystem.factory.IFactory;
import com.minecolonies.api.colony.requestsystem.factory.IFactoryController;
import com.minecolonies.api.colony.requestsystem.token.IToken;
import com.minecolonies.api.util.NBTUtils;
import com.minecolonies.api.util.constant.TypeConstants;
import java.util.LinkedList;
import java.util.stream.Collectors;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.PacketBuffer;
import org.jetbrains.annotations.NotNull;

public class StandardRequestSystemDeliveryManJobDataStore
implements IRequestSystemDeliveryManJobDataStore {
    private IToken<?> id;
    private final LinkedList<IToken<?>> queue;

    public StandardRequestSystemDeliveryManJobDataStore(IToken<?> id, LinkedList<IToken<?>> queue) {
        this.id = id;
        this.queue = queue;
    }

    public StandardRequestSystemDeliveryManJobDataStore() {
        this(StandardFactoryController.getInstance().getNewInstance(TypeConstants.ITOKEN), new LinkedList());
    }

    @Override
    public LinkedList<IToken<?>> getQueue() {
        return this.queue;
    }

    @Override
    public IToken<?> getId() {
        return this.id;
    }

    @Override
    public void setId(IToken<?> id) {
        this.id = id;
    }

    public static class Factory
    implements IFactory<FactoryVoidInput, StandardRequestSystemDeliveryManJobDataStore> {
        @Override
        @NotNull
        public TypeToken<? extends StandardRequestSystemDeliveryManJobDataStore> getFactoryOutputType() {
            return TypeToken.of(StandardRequestSystemDeliveryManJobDataStore.class);
        }

        @Override
        @NotNull
        public TypeToken<? extends FactoryVoidInput> getFactoryInputType() {
            return TypeConstants.FACTORYVOIDINPUT;
        }

        @Override
        @NotNull
        public StandardRequestSystemDeliveryManJobDataStore getNewInstance(@NotNull IFactoryController factoryController, @NotNull FactoryVoidInput factoryVoidInput, Object ... context) throws IllegalArgumentException {
            return new StandardRequestSystemDeliveryManJobDataStore();
        }

        @Override
        @NotNull
        public CompoundNBT serialize(@NotNull IFactoryController controller, @NotNull StandardRequestSystemDeliveryManJobDataStore standardRequestSystemDeliveryManJobDataStore) {
            CompoundNBT compound = new CompoundNBT();
            compound.func_218657_a("Token", (INBT)controller.serialize(standardRequestSystemDeliveryManJobDataStore.id));
            compound.func_218657_a("List", (INBT)standardRequestSystemDeliveryManJobDataStore.queue.stream().map(controller::serialize).collect(NBTUtils.toListNBT()));
            return compound;
        }

        @Override
        @NotNull
        public StandardRequestSystemDeliveryManJobDataStore deserialize(@NotNull IFactoryController controller, @NotNull CompoundNBT nbt) throws Throwable {
            IToken token = (IToken)controller.deserialize(nbt.func_74775_l("Token"));
            LinkedList queue = NBTUtils.streamCompound(nbt.func_150295_c("List", 10)).map(CompoundNBT2 -> (IToken)controller.deserialize((CompoundNBT)CompoundNBT2)).collect(Collectors.toCollection(LinkedList::new));
            return new StandardRequestSystemDeliveryManJobDataStore(token, queue);
        }

        @Override
        public void serialize(IFactoryController controller, StandardRequestSystemDeliveryManJobDataStore input, PacketBuffer packetBuffer) {
            controller.serialize(packetBuffer, input.id);
            packetBuffer.writeInt(input.queue.size());
            input.queue.forEach(entry -> controller.serialize(packetBuffer, entry));
        }

        @Override
        public StandardRequestSystemDeliveryManJobDataStore deserialize(IFactoryController controller, PacketBuffer buffer) throws Throwable {
            IToken id = (IToken)controller.deserialize(buffer);
            LinkedList queue = new LinkedList();
            int queueSize = buffer.readInt();
            for (int i = 0; i < queueSize; ++i) {
                queue.add((IToken<?>)controller.deserialize(buffer));
            }
            return new StandardRequestSystemDeliveryManJobDataStore(id, queue);
        }

        @Override
        public short getSerializationId() {
            return 38;
        }
    }
}

