/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.requestsystem.locations;

import com.google.common.reflect.TypeToken;
import com.minecolonies.api.colony.requestsystem.factory.IFactoryController;
import com.minecolonies.api.colony.requestsystem.location.ILocation;
import com.minecolonies.api.colony.requestsystem.location.ILocationFactory;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;
import org.jetbrains.annotations.NotNull;

public class StaticLocation
implements ILocation {
    private static final int NUMBER_OR_CONTEXTS = 1;
    @NotNull
    private final BlockPos pos;
    private final int dimension;

    public StaticLocation(@NotNull BlockPos pos, int dimension) {
        this.pos = pos;
        this.dimension = dimension;
    }

    @Override
    @NotNull
    public BlockPos getInDimensionLocation() {
        return this.pos;
    }

    @Override
    public int getDimension() {
        return this.dimension;
    }

    @Override
    public boolean isReachableFromLocation(@NotNull ILocation location) {
        return location.getDimension() == this.getDimension();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof StaticLocation)) {
            return false;
        }
        StaticLocation that = (StaticLocation)o;
        if (this.getDimension() != that.getDimension()) {
            return false;
        }
        return this.pos.equals((Object)that.pos);
    }

    public int hashCode() {
        int result = this.pos.hashCode();
        result = 31 * result + this.getDimension();
        return result;
    }

    public String toString() {
        return "Dim: " + this.dimension + " " + this.pos.func_177958_n() + "." + this.pos.func_177956_o() + "." + this.pos.func_177952_p() + " ";
    }

    public static void serialize(PacketBuffer buffer, StaticLocation location) {
        buffer.func_179255_a(location.pos);
        buffer.writeInt(location.dimension);
    }

    public static StaticLocation deserialize(PacketBuffer buffer) {
        BlockPos pos = buffer.func_179259_c();
        int dimension = buffer.readInt();
        return new StaticLocation(pos, dimension);
    }

    public static class Factory
    implements ILocationFactory<BlockPos, StaticLocation> {
        private static final String NBT_POS = "Pos";
        private static final String NBT_DIM = "Dim";

        @Override
        @NotNull
        public TypeToken<StaticLocation> getFactoryOutputType() {
            return TypeToken.of(StaticLocation.class);
        }

        @Override
        @NotNull
        public TypeToken<BlockPos> getFactoryInputType() {
            return TypeToken.of(BlockPos.class);
        }

        @Override
        @NotNull
        public CompoundNBT serialize(@NotNull IFactoryController controller, @NotNull StaticLocation request) {
            CompoundNBT compound = new CompoundNBT();
            compound.func_74772_a(NBT_POS, request.getInDimensionLocation().func_218275_a());
            compound.func_74768_a(NBT_DIM, request.getDimension());
            return compound;
        }

        @Override
        @NotNull
        public StaticLocation deserialize(@NotNull IFactoryController controller, @NotNull CompoundNBT nbt) {
            BlockPos pos = BlockPos.func_218283_e((long)nbt.func_74763_f(NBT_POS));
            Integer dim = nbt.func_74762_e(NBT_DIM);
            return new StaticLocation(pos, dim);
        }

        @Override
        @NotNull
        public StaticLocation getNewInstance(@NotNull IFactoryController factoryController, @NotNull BlockPos blockPos, Object ... context) {
            if (context.length != 1) {
                throw new IllegalArgumentException("Unsupported context - Not the correct amount available. Needed is 1!");
            }
            if (!(context[0] instanceof Integer)) {
                throw new IllegalArgumentException("Unsupported context - First context object is not a Integer. Provide an Integer as Dimension.");
            }
            return new StaticLocation(blockPos, (Integer)context[0]);
        }

        @Override
        @NotNull
        public StaticLocation getNewInstance(@NotNull IFactoryController factoryController, @NotNull BlockPos input) {
            return new StaticLocation(input, 0);
        }

        @Override
        public void serialize(IFactoryController controller, StaticLocation input, PacketBuffer packetBuffer) {
            StaticLocation.serialize(packetBuffer, input);
        }

        @Override
        public StaticLocation deserialize(IFactoryController controller, PacketBuffer buffer) throws Throwable {
            return StaticLocation.deserialize(buffer);
        }

        @Override
        public short getSerializationId() {
            return 3;
        }
    }
}

