/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.requestsystem.requests;

import com.google.common.collect.ImmutableList;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.requestsystem.request.RequestState;
import com.minecolonies.api.colony.requestsystem.requestable.Burnable;
import com.minecolonies.api.colony.requestsystem.requestable.Food;
import com.minecolonies.api.colony.requestsystem.requestable.Stack;
import com.minecolonies.api.colony.requestsystem.requestable.StackList;
import com.minecolonies.api.colony.requestsystem.requestable.Tag;
import com.minecolonies.api.colony.requestsystem.requestable.Tool;
import com.minecolonies.api.colony.requestsystem.requestable.crafting.AbstractCrafting;
import com.minecolonies.api.colony.requestsystem.requestable.crafting.PrivateCrafting;
import com.minecolonies.api.colony.requestsystem.requestable.crafting.PublicCrafting;
import com.minecolonies.api.colony.requestsystem.requestable.deliveryman.Delivery;
import com.minecolonies.api.colony.requestsystem.requestable.deliveryman.Pickup;
import com.minecolonies.api.colony.requestsystem.requester.IRequester;
import com.minecolonies.api.colony.requestsystem.token.IToken;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.coremod.colony.requestable.SmeltableOre;
import com.minecolonies.coremod.colony.requestsystem.requests.AbstractRequest;
import com.minecolonies.coremod.util.text.NonSiblingFormattingTextComponent;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.AbstractFurnaceTileEntity;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import org.jetbrains.annotations.NotNull;

public final class StandardRequests {
    private StandardRequests() {
    }

    public static class BurnableRequest
    extends AbstractRequest<Burnable> {
        private static ImmutableList<ItemStack> burnableExamples;

        BurnableRequest(@NotNull IRequester requester, @NotNull IToken<?> token, @NotNull Burnable requested) {
            super(requester, token, requested);
        }

        BurnableRequest(@NotNull IRequester requester, @NotNull IToken<?> token, @NotNull RequestState state, @NotNull Burnable requested) {
            super(requester, token, state, requested);
        }

        @Override
        @NotNull
        public ITextComponent getShortDisplayString() {
            NonSiblingFormattingTextComponent result = new NonSiblingFormattingTextComponent();
            result.func_150257_a((ITextComponent)new TranslationTextComponent("com.minecolonies.coremod.request.burnable", new Object[0]));
            return result;
        }

        @Override
        @NotNull
        public List<ItemStack> getDisplayStacks() {
            if (burnableExamples == null) {
                burnableExamples = ImmutableList.copyOf((Collection)IColonyManager.getInstance().getCompatibilityManager().getBlockList().stream().filter(AbstractFurnaceTileEntity::func_213991_b).collect(Collectors.toList()));
            }
            return burnableExamples;
        }
    }

    public static class SmeltAbleOreRequest
    extends AbstractRequest<SmeltableOre> {
        private static ImmutableList<ItemStack> oreExamples;

        SmeltAbleOreRequest(@NotNull IRequester requester, @NotNull IToken<?> token, @NotNull SmeltableOre requested) {
            super(requester, token, requested);
        }

        SmeltAbleOreRequest(@NotNull IRequester requester, @NotNull IToken<?> token, @NotNull RequestState state, @NotNull SmeltableOre requested) {
            super(requester, token, state, requested);
        }

        @Override
        @NotNull
        public ITextComponent getShortDisplayString() {
            return new TranslationTextComponent("com.minecolonies.coremod.request.smeltableore", new Object[0]);
        }

        @Override
        @NotNull
        public List<ItemStack> getDisplayStacks() {
            if (oreExamples == null) {
                oreExamples = ImmutableList.copyOf((Collection)IColonyManager.getInstance().getCompatibilityManager().getBlockList().stream().filter(IColonyManager.getInstance().getCompatibilityManager()::isOre).collect(Collectors.toList()));
            }
            return oreExamples;
        }
    }

    public static class FoodRequest
    extends AbstractRequest<Food> {
        private static ImmutableList<ItemStack> foodExamples;

        FoodRequest(@NotNull IRequester requester, @NotNull IToken<?> token, @NotNull Food requested) {
            super(requester, token, requested);
        }

        FoodRequest(@NotNull IRequester requester, @NotNull IToken<?> token, @NotNull RequestState state, @NotNull Food requested) {
            super(requester, token, state, requested);
        }

        @Override
        @NotNull
        public ITextComponent getShortDisplayString() {
            NonSiblingFormattingTextComponent result = new NonSiblingFormattingTextComponent();
            result.func_150257_a((ITextComponent)new TranslationTextComponent("com.minecolonies.coremod.request.food", new Object[0]));
            return result;
        }

        @Override
        @NotNull
        public List<ItemStack> getDisplayStacks() {
            if (foodExamples == null) {
                foodExamples = ImmutableList.copyOf((Collection)IColonyManager.getInstance().getCompatibilityManager().getBlockList().stream().filter(item -> item.func_77973_b().func_219971_r()).collect(Collectors.toList()));
            }
            return foodExamples;
        }
    }

    public static class ToolRequest
    extends AbstractRequest<Tool> {
        public ToolRequest(@NotNull IRequester requester, @NotNull IToken<?> token, @NotNull Tool requested) {
            super(requester, token, requested);
        }

        public ToolRequest(@NotNull IRequester requester, @NotNull IToken<?> token, @NotNull RequestState state, @NotNull Tool requested) {
            super(requester, token, state, requested);
        }

        @Override
        @NotNull
        public ITextComponent getLongDisplayString() {
            NonSiblingFormattingTextComponent result = new NonSiblingFormattingTextComponent();
            TranslationTextComponent preType = new TranslationTextComponent("com.minecolonies.coremod.request.tool.pretype", new Object[0]);
            result.func_150257_a((ITextComponent)preType);
            result.func_150257_a(((Tool)this.getRequest()).getToolClass().getDisplayName());
            if (((Tool)this.getRequest()).getMinLevel() > -1) {
                result.func_150258_a(" ");
                result.func_150257_a((ITextComponent)new TranslationTextComponent("com.minecolonies.coremod.request.tool.preminlevel", new Object[0]));
                result.func_150258_a(((Tool)this.getRequest()).isArmor() ? ItemStackUtils.swapArmorGrade(((Tool)this.getRequest()).getMinLevel()) : ItemStackUtils.swapToolGrade(((Tool)this.getRequest()).getMinLevel()));
            }
            if (((Tool)this.getRequest()).getMaxLevel() < 32) {
                if (((Tool)this.getRequest()).getMinLevel() > -1) {
                    result.func_150258_a(" ");
                    result.func_150257_a((ITextComponent)new TranslationTextComponent("com.minecolonies.coremod.general.and", new Object[0]));
                }
                result.func_150258_a(" ");
                result.func_150257_a((ITextComponent)new TranslationTextComponent("com.minecolonies.coremod.request.tool.premaxlevel", new Object[0]));
                result.func_150258_a(((Tool)this.getRequest()).isArmor() ? ItemStackUtils.swapArmorGrade(((Tool)this.getRequest()).getMaxLevel()) : ItemStackUtils.swapToolGrade(((Tool)this.getRequest()).getMaxLevel()));
            }
            return result;
        }

        @Override
        @NotNull
        public ITextComponent getShortDisplayString() {
            NonSiblingFormattingTextComponent result = new NonSiblingFormattingTextComponent();
            result.func_150257_a(((Tool)this.getRequest()).getToolClass().getDisplayName());
            return result;
        }
    }

    public static class PublicCraftingRequest
    extends AbstractCraftingRequest<PublicCrafting> {
        protected PublicCraftingRequest(@NotNull IRequester requester, @NotNull IToken<?> token, @NotNull PublicCrafting requested) {
            super(requester, token, requested);
        }

        protected PublicCraftingRequest(@NotNull IRequester requester, @NotNull IToken<?> token, @NotNull RequestState state, @NotNull PublicCrafting requested) {
            super(requester, token, state, requested);
        }

        @Override
        protected String getTranslationKey() {
            return "com.minecolonies.coremod.request.crafting";
        }

        @Override
        protected String getDisplayIconFile() {
            return "minecolonies:textures/gui/citizen/crafting_public.png";
        }
    }

    public static class PrivateCraftingRequest
    extends AbstractCraftingRequest<PrivateCrafting> {
        protected PrivateCraftingRequest(@NotNull IRequester requester, @NotNull IToken<?> token, @NotNull PrivateCrafting requested) {
            super(requester, token, requested);
        }

        protected PrivateCraftingRequest(@NotNull IRequester requester, @NotNull IToken<?> token, @NotNull RequestState state, @NotNull PrivateCrafting requested) {
            super(requester, token, state, requested);
        }

        @Override
        protected String getTranslationKey() {
            return "com.minecolonies.coremod.request.crafting";
        }

        @Override
        protected String getDisplayIconFile() {
            return "minecolonies:textures/gui/citizen/crafting_public.png";
        }
    }

    public static abstract class AbstractCraftingRequest<C extends AbstractCrafting>
    extends AbstractRequest<C> {
        protected AbstractCraftingRequest(@NotNull IRequester requester, @NotNull IToken<?> token, @NotNull C requested) {
            super(requester, token, requested);
        }

        protected AbstractCraftingRequest(@NotNull IRequester requester, @NotNull IToken<?> token, @NotNull RequestState state, @NotNull C requested) {
            super(requester, token, state, requested);
        }

        @Override
        @NotNull
        public final ITextComponent getShortDisplayString() {
            NonSiblingFormattingTextComponent result = new NonSiblingFormattingTextComponent();
            TranslationTextComponent preType = new TranslationTextComponent(this.getTranslationKey(), new Object[0]);
            result.func_150257_a((ITextComponent)preType);
            preType.func_150257_a(((AbstractCrafting)this.getRequest()).getStack().func_151000_E());
            return result;
        }

        protected abstract String getTranslationKey();

        @Override
        @NotNull
        public final List<ItemStack> getDisplayStacks() {
            return ImmutableList.of();
        }

        @Override
        @NotNull
        public final ResourceLocation getDisplayIcon() {
            return new ResourceLocation(this.getDisplayIconFile());
        }

        protected abstract String getDisplayIconFile();
    }

    public static class PickupRequest
    extends AbstractRequest<Pickup> {
        public PickupRequest(@NotNull IRequester requester, @NotNull IToken<?> token, @NotNull RequestState state, @NotNull Pickup requested) {
            super(requester, token, state, requested);
        }

        @Override
        @NotNull
        public ImmutableList<ItemStack> getDeliveries() {
            return ImmutableList.of();
        }

        @Override
        @NotNull
        public ITextComponent getShortDisplayString() {
            NonSiblingFormattingTextComponent result = new NonSiblingFormattingTextComponent();
            result.func_150257_a((ITextComponent)new TranslationTextComponent("com.minecolonies.coremod.request.pickup", new Object[0]));
            return result;
        }

        @Override
        @NotNull
        public List<ItemStack> getDisplayStacks() {
            return ImmutableList.of();
        }

        @Override
        @NotNull
        public ResourceLocation getDisplayIcon() {
            return new ResourceLocation("minecolonies:textures/gui/citizen/delivery.png");
        }
    }

    public static class DeliveryRequest
    extends AbstractRequest<Delivery> {
        public DeliveryRequest(@NotNull IRequester requester, @NotNull IToken<?> token, @NotNull RequestState state, @NotNull Delivery requested) {
            super(requester, token, state, requested);
        }

        @Override
        @NotNull
        public ImmutableList<ItemStack> getDeliveries() {
            return ImmutableList.of();
        }

        @Override
        @NotNull
        public ITextComponent getShortDisplayString() {
            NonSiblingFormattingTextComponent result = new NonSiblingFormattingTextComponent();
            result.func_150257_a(new TranslationTextComponent("com.minecolonies.coremod.request.delivery", new Object[0]).func_150257_a((ITextComponent)new StringTextComponent(((Delivery)this.getRequest()).getStack().func_190916_E() + " ")).func_150257_a(((Delivery)this.getRequest()).getStack().func_151000_E()));
            return result;
        }

        @Override
        @NotNull
        public List<ItemStack> getDisplayStacks() {
            return ImmutableList.of();
        }

        @Override
        @NotNull
        public ResourceLocation getDisplayIcon() {
            return new ResourceLocation("minecolonies:textures/gui/citizen/delivery.png");
        }
    }

    public static class ItemTagRequest
    extends AbstractRequest<Tag> {
        private List<ItemStack> stacks;

        public ItemTagRequest(@NotNull IRequester requester, @NotNull IToken<?> token, @NotNull Tag requested) {
            super(requester, token, requested);
            this.stacks = requested.getTag().func_199885_a().stream().flatMap(item -> {
                NonNullList list = NonNullList.func_191196_a();
                item.func_150895_a(item.func_77640_w(), list);
                return list.stream();
            }).collect(Collectors.toList());
        }

        public ItemTagRequest(@NotNull IRequester requester, @NotNull IToken<?> token, @NotNull RequestState state, @NotNull Tag requested) {
            super(requester, token, state, requested);
            this.stacks = requested.getTag().func_199885_a().stream().flatMap(item -> {
                NonNullList list = NonNullList.func_191196_a();
                item.func_150895_a(item.func_77640_w(), list);
                return list.stream();
            }).collect(Collectors.toList());
        }

        @Override
        @NotNull
        public ITextComponent getShortDisplayString() {
            NonSiblingFormattingTextComponent combined = new NonSiblingFormattingTextComponent();
            combined.func_150257_a((ITextComponent)new StringTextComponent(((Tag)this.getRequest()).getCount() + " "));
            combined.func_150257_a((ITextComponent)new StringTextComponent("#" + ((Tag)this.getRequest()).getTag().func_199886_b().toString()));
            return combined;
        }

        @Override
        public List<ItemStack> getDisplayStacks() {
            return Collections.unmodifiableList(this.stacks);
        }
    }

    public static class ItemStackListRequest
    extends AbstractRequest<StackList> {
        private ImmutableList<ItemStack> displayList;
        private StackList stackList;

        public ItemStackListRequest(@NotNull IRequester requester, @NotNull IToken<?> token, @NotNull StackList requested) {
            super(requester, token, requested);
            this.displayList = ImmutableList.copyOf(requested.getStacks());
            this.stackList = requested;
        }

        public ItemStackListRequest(@NotNull IRequester requester, @NotNull IToken<?> token, @NotNull RequestState state, @NotNull StackList requested) {
            super(requester, token, state, requested);
            this.displayList = ImmutableList.copyOf(requested.getStacks());
            this.stackList = requested;
        }

        @Override
        @NotNull
        public ITextComponent getShortDisplayString() {
            NonSiblingFormattingTextComponent result = new NonSiblingFormattingTextComponent();
            result.func_150257_a((ITextComponent)new TranslationTextComponent(this.stackList.getDescription(), new Object[0]));
            return result;
        }

        @Override
        @NotNull
        public List<ItemStack> getDisplayStacks() {
            if (this.displayList.isEmpty()) {
                return ImmutableList.of();
            }
            return this.displayList;
        }
    }

    public static class ItemStackRequest
    extends AbstractRequest<Stack> {
        public ItemStackRequest(@NotNull IRequester requester, @NotNull IToken<?> token, @NotNull Stack requested) {
            super(requester, token, requested);
        }

        public ItemStackRequest(@NotNull IRequester requester, @NotNull IToken<?> token, @NotNull RequestState state, @NotNull Stack requested) {
            super(requester, token, state, requested);
        }

        @Override
        @NotNull
        public ITextComponent getShortDisplayString() {
            NonSiblingFormattingTextComponent combined = new NonSiblingFormattingTextComponent();
            combined.func_150257_a((ITextComponent)new StringTextComponent(((Stack)this.getRequest()).getCount() + " "));
            combined.func_150257_a(((Stack)this.getRequest()).getStack().func_151000_E());
            return combined;
        }

        @Override
        @NotNull
        public List<ItemStack> getDisplayStacks() {
            return ((Stack)this.getRequest()).getRequestedItems();
        }
    }
}

