/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.requestsystem.resolvers;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.reflect.TypeToken;
import com.minecolonies.api.MinecoloniesAPIProxy;
import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.requestsystem.location.ILocation;
import com.minecolonies.api.colony.requestsystem.manager.IRequestManager;
import com.minecolonies.api.colony.requestsystem.request.IRequest;
import com.minecolonies.api.colony.requestsystem.request.RequestState;
import com.minecolonies.api.colony.requestsystem.requestable.IDeliverable;
import com.minecolonies.api.colony.requestsystem.requestable.IRequestable;
import com.minecolonies.api.colony.requestsystem.resolver.player.IPlayerRequestResolver;
import com.minecolonies.api.colony.requestsystem.token.IToken;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.constant.TypeConstants;
import com.minecolonies.coremod.colony.Colony;
import com.minecolonies.coremod.colony.buildings.AbstractBuilding;
import com.minecolonies.coremod.colony.requestsystem.requesters.BuildingBasedRequester;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StandardPlayerRequestResolver
implements IPlayerRequestResolver {
    @NotNull
    private final ILocation location;
    @NotNull
    private final IToken<?> token;
    @NotNull
    private final Set<IToken<?>> assignedRequests = new HashSet();

    public StandardPlayerRequestResolver(@NotNull ILocation location, @NotNull IToken<?> token) {
        this.location = location;
        this.token = token;
    }

    @Override
    public TypeToken<IRequestable> getRequestType() {
        return TypeConstants.REQUESTABLE;
    }

    @Override
    public void onRequestedRequestComplete(@NotNull IRequestManager manager, @NotNull IRequest<?> request) {
    }

    @Override
    public boolean canResolveRequest(@NotNull IRequestManager manager, IRequest<?> requestToCheck) {
        return !manager.getColony().getWorld().field_72995_K;
    }

    @Override
    public void onRequestedRequestCancelled(@NotNull IRequestManager manager, @NotNull IRequest<?> request) {
    }

    @Override
    @Nullable
    public List<IToken<?>> attemptResolveRequest(@NotNull IRequestManager manager, @NotNull IRequest<?> request) {
        if (this.canResolveRequest(manager, request)) {
            return Lists.newArrayList();
        }
        return null;
    }

    @Override
    @NotNull
    public ITextComponent getRequesterDisplayName(@NotNull IRequestManager manager, @NotNull IRequest<?> request) {
        return new StringTextComponent("Player");
    }

    @Override
    public void resolveRequest(@NotNull IRequestManager manager, @NotNull IRequest<?> request) throws RuntimeException {
        IColony colony = manager.getColony();
        if (colony instanceof Colony && ((Boolean)MinecoloniesAPIProxy.getInstance().getConfig().getCommon().creativeResolve.get()).booleanValue() && request.getRequest() instanceof IDeliverable && request.getRequester() instanceof BuildingBasedRequester && ((BuildingBasedRequester)request.getRequester()).getBuilding(manager, (IToken<?>)request.getId()).isPresent() && ((BuildingBasedRequester)request.getRequester()).getBuilding(manager, (IToken<?>)request.getId()).get() instanceof AbstractBuilding) {
            AbstractBuilding building = (AbstractBuilding)((BuildingBasedRequester)request.getRequester()).getBuilding(manager, (IToken<?>)request.getId()).get();
            Optional<ICitizenData> citizenDataOptional = building.getCitizenForRequest((IToken<?>)request.getId());
            List<ItemStack> resolvablestacks = request.getDisplayStacks();
            if (!resolvablestacks.isEmpty() && citizenDataOptional.isPresent()) {
                ItemStack resolveStack = resolvablestacks.get(0);
                resolveStack.func_190920_e(Math.min(((IDeliverable)request.getRequest()).getCount(), resolveStack.func_77976_d()));
                ItemStack remainingItemStack = InventoryUtils.addItemStackToItemHandlerWithResult((IItemHandler)citizenDataOptional.get().getInventory(), resolveStack);
                if (ItemStackUtils.isEmpty(remainingItemStack).booleanValue()) {
                    manager.updateRequestState((IToken<?>)request.getId(), RequestState.RESOLVED);
                    return;
                }
            }
        }
        this.assignedRequests.add((IToken<?>)request.getId());
    }

    @Override
    public void onAssignedRequestBeingCancelled(@NotNull IRequestManager manager, @NotNull IRequest<? extends IRequestable> request) {
        this.assignedRequests.remove(request.getId());
    }

    @Override
    public void onAssignedRequestCancelled(@NotNull IRequestManager manager, @NotNull IRequest<? extends IRequestable> request) {
    }

    @Override
    public int getPriority() {
        return 0;
    }

    @Override
    public IToken<?> getId() {
        return this.token;
    }

    @Override
    @NotNull
    public ILocation getLocation() {
        return this.location;
    }

    @Override
    public ImmutableList<IToken<?>> getAllAssignedRequests() {
        return ImmutableList.copyOf(this.assignedRequests);
    }

    @Override
    public void onSystemReset() {
        this.assignedRequests.clear();
    }

    @Override
    public void onColonyUpdate(@NotNull IRequestManager manager, @NotNull Predicate<IRequest<?>> shouldTriggerReassign) {
        new ArrayList(this.assignedRequests).stream().map(manager::getRequestForToken).filter(shouldTriggerReassign.and(Objects::nonNull)).forEach(request -> {
            IToken<?> newResolverToken = manager.reassignRequest((IToken<?>)request.getId(), (Collection<IToken<?>>)ImmutableList.of(this.token));
            if (newResolverToken != null && !newResolverToken.equals(this.token)) {
                this.assignedRequests.remove(request.getId());
            }
        });
    }

    public void setAllAssignedRequests(Set<IToken<?>> assignedRequests) {
        this.assignedRequests.clear();
        this.assignedRequests.addAll(assignedRequests);
    }
}

