/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.requestsystem.resolvers;

import com.minecolonies.api.colony.requestsystem.location.ILocation;
import com.minecolonies.api.colony.requestsystem.request.IRequest;
import com.minecolonies.api.colony.requestsystem.requestable.IConcreteDeliverable;
import com.minecolonies.api.colony.requestsystem.requestable.IDeliverable;
import com.minecolonies.api.colony.requestsystem.token.IToken;
import com.minecolonies.coremod.colony.requestsystem.resolvers.core.AbstractWarehouseRequestResolver;
import com.minecolonies.coremod.tileentities.TileEntityWareHouse;
import java.util.Set;
import net.minecraft.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class WarehouseConcreteRequestResolver
extends AbstractWarehouseRequestResolver {
    public WarehouseConcreteRequestResolver(@NotNull ILocation location, @NotNull IToken<?> token) {
        super(location, token);
    }

    @Override
    protected boolean internalCanResolve(Set<TileEntityWareHouse> wareHouses, IRequest<? extends IDeliverable> requestToCheck) {
        IDeliverable deliverable = requestToCheck.getRequest();
        if (deliverable instanceof IConcreteDeliverable) {
            for (ItemStack possible : ((IConcreteDeliverable)deliverable).getRequestedItems()) {
                for (TileEntityWareHouse wareHouse : wareHouses) {
                    if (!wareHouse.hasMatchingItemStackInWarehouse(possible, requestToCheck.getRequest().getMinimumCount())) continue;
                    return true;
                }
            }
        }
        return false;
    }
}

