/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.workorders;

import com.ldtteam.structurize.management.StructureName;
import com.ldtteam.structurize.util.LanguageHandler;
import com.minecolonies.api.advancements.AdvancementTriggers;
import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.workorders.IWorkManager;
import com.minecolonies.api.colony.workorders.WorkOrderType;
import com.minecolonies.api.util.Log;
import com.minecolonies.coremod.colony.Colony;
import com.minecolonies.coremod.colony.workorders.AbstractWorkOrder;
import com.minecolonies.coremod.colony.workorders.WorkOrderBuildBuilding;
import com.minecolonies.coremod.colony.workorders.WorkOrderBuildRemoval;
import com.minecolonies.coremod.entity.ai.citizen.builder.ConstructionTapeHelper;
import com.minecolonies.coremod.tileentities.TileEntityDecorationController;
import com.minecolonies.coremod.util.AdvancementUtils;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;

public class WorkOrderBuildDecoration
extends AbstractWorkOrder {
    private static final String TAG_WORKORDER_NAME = "workOrderName";
    private static final String TAG_IS_CLEARED = "cleared";
    private static final String TAG_IS_REQUESTED = "requested";
    private static final String TAG_IS_MIRRORED = "mirrored";
    private static final String TAG_SCHEMATIC_NAME = "structureName";
    private static final String TAG_BUILDING_ROTATION = "buildingRotation";
    private static final String TAG_AMOUNT_OF_RES = "resQuantity";
    protected boolean isBuildingMirrored;
    protected int buildingRotation;
    protected String structureName;
    protected boolean cleared;
    protected String workOrderName;
    protected int amountOfRes;
    protected boolean levelUp = false;
    protected boolean hasSentMessageForThisWorkOrder = false;
    private boolean requested;

    public WorkOrderBuildDecoration() {
    }

    public WorkOrderBuildDecoration(String structureName, String workOrderName, int rotation, BlockPos location, boolean mirror) {
        StructureName sn = new StructureName(structureName);
        this.structureName = sn.toString();
        this.workOrderName = workOrderName;
        this.buildingRotation = rotation;
        this.buildingLocation = location;
        this.cleared = false;
        this.isBuildingMirrored = mirror;
        this.requested = false;
    }

    public void setLevelUp() {
        this.levelUp = true;
    }

    public String getName() {
        return this.workOrderName.replaceAll("schematics/(?:decorations/)?", "");
    }

    @Override
    public void read(@NotNull CompoundNBT compound, IWorkManager manager) {
        super.read(compound, manager);
        StructureName sn = new StructureName(compound.func_74779_i(TAG_SCHEMATIC_NAME));
        this.structureName = sn.toString();
        this.workOrderName = compound.func_74779_i(TAG_WORKORDER_NAME);
        this.cleared = compound.func_74767_n(TAG_IS_CLEARED);
        this.buildingRotation = compound.func_74762_e(TAG_BUILDING_ROTATION);
        this.requested = compound.func_74767_n(TAG_IS_REQUESTED);
        this.isBuildingMirrored = compound.func_74767_n(TAG_IS_MIRRORED);
        this.amountOfRes = compound.func_74762_e(TAG_AMOUNT_OF_RES);
        this.levelUp = compound.func_74767_n("level");
    }

    @Override
    public void write(@NotNull CompoundNBT compound) {
        super.write(compound);
        if (this.workOrderName != null) {
            compound.func_74778_a(TAG_WORKORDER_NAME, this.workOrderName);
        }
        compound.func_74757_a(TAG_IS_CLEARED, this.cleared);
        if (this.structureName == null) {
            Log.getLogger().error("WorkOrderBuild.write: structureName should not be null!!!", (Throwable)new Exception());
        } else {
            compound.func_74778_a(TAG_SCHEMATIC_NAME, this.structureName);
        }
        compound.func_74768_a(TAG_BUILDING_ROTATION, this.buildingRotation);
        compound.func_74757_a(TAG_IS_REQUESTED, this.requested);
        compound.func_74757_a(TAG_IS_MIRRORED, this.isBuildingMirrored);
        compound.func_74768_a(TAG_AMOUNT_OF_RES, this.amountOfRes);
        compound.func_74757_a("level", this.levelUp);
    }

    @Override
    public boolean isValid(IColony colony) {
        return this.structureName != null && super.isValid(colony);
    }

    @Override
    @NotNull
    protected WorkOrderType getType() {
        return WorkOrderType.BUILD;
    }

    @Override
    protected String get() {
        return this.workOrderName;
    }

    @Override
    public void onAdded(IColony colony, boolean readingFromNbt) {
        super.onAdded(colony, readingFromNbt);
        if (!readingFromNbt && colony != null && colony.getWorld() != null) {
            ConstructionTapeHelper.placeConstructionTape(this, colony.getWorld());
            LanguageHandler.sendPlayersMessage(colony.getImportantMessageEntityPlayers(), (String)"com.minecolonies.coremod.decoorderadded", (Object[])new Object[0]);
        }
    }

    @Override
    public void onRemoved(IColony colony) {
        super.onRemoved(colony);
        ConstructionTapeHelper.removeConstructionTape(this, colony.getWorld());
    }

    protected boolean canBuild(@NotNull ICitizenData citizen) {
        return true;
    }

    protected void sendBuilderMessage(@NotNull Colony colony, boolean hasBuilder, boolean sendMessage) {
        if (this.hasSentMessageForThisWorkOrder || hasBuilder) {
            return;
        }
        this.hasSentMessageForThisWorkOrder = true;
        LanguageHandler.sendPlayersMessage(colony.getMessagePlayerEntities(), (String)"entity.builder.messageNoBuilder", (Object[])new Object[0]);
    }

    @Override
    public void onCompleted(IColony colony, ICitizenData citizen) {
        TileEntity tileEntity;
        super.onCompleted(colony, citizen);
        StructureName structureName = new StructureName(this.getStructureName());
        if (this instanceof WorkOrderBuildBuilding) {
            int level = ((WorkOrderBuildBuilding)this).getUpgradeLevel();
            AdvancementUtils.TriggerAdvancementPlayersForColony(colony, player -> AdvancementTriggers.COMPLETE_BUILD_REQUEST.trigger((ServerPlayerEntity)player, structureName, level));
        } else if (this instanceof WorkOrderBuildRemoval) {
            LanguageHandler.sendPlayersMessage(colony.getMessagePlayerEntities(), (String)"entity.builder.messageremovalcomplete", (Object[])new Object[]{this.getStructureName()});
        } else {
            AdvancementUtils.TriggerAdvancementPlayersForColony(colony, player -> AdvancementTriggers.COMPLETE_BUILD_REQUEST.trigger((ServerPlayerEntity)player, structureName, 0));
            if (citizen.getName().isEmpty()) {
                LanguageHandler.sendPlayersMessage(colony.getMessagePlayerEntities(), (String)"entity.builder.messagebuildcomplete", (Object[])new Object[]{this.getName()});
            } else {
                LanguageHandler.sendPlayersMessage(colony.getMessagePlayerEntities(), (String)"entity.builder.messagebuildcomplete_generic", (Object[])new Object[]{citizen.getName(), this.getName()});
            }
        }
        if (this.levelUp && (tileEntity = colony.getWorld().func_175625_s(this.buildingLocation)) instanceof TileEntityDecorationController) {
            ((TileEntityDecorationController)tileEntity).setLevel(((TileEntityDecorationController)tileEntity).getLevel() + 1);
        }
    }

    public String getStructureName() {
        return this.structureName;
    }

    public BlockPos getBuildingLocation() {
        return this.buildingLocation;
    }

    public int getRotation(World world) {
        return this.buildingRotation;
    }

    public boolean isCleared() {
        return this.cleared;
    }

    public void setCleared(boolean cleared) {
        this.cleared = cleared;
    }

    public boolean isRequested() {
        return this.requested;
    }

    public void setRequested(boolean requested) {
        this.requested = requested;
    }

    public boolean isMirrored() {
        return this.isBuildingMirrored;
    }

    public int getAmountOfRes() {
        return this.amountOfRes;
    }

    public void setAmountOfRes(int amountOfRes) {
        this.amountOfRes = amountOfRes;
    }
}

