/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.commands.colonycommands;

import com.ldtteam.structurize.util.LanguageHandler;
import com.minecolonies.api.colony.IChunkmanagerCapability;
import com.minecolonies.api.util.Log;
import com.minecolonies.coremod.MineColonies;
import com.minecolonies.coremod.commands.commandTypes.IMCCommand;
import com.minecolonies.coremod.commands.commandTypes.IMCOPCommand;
import com.minecolonies.coremod.util.ChunkDataHelper;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import net.minecraft.command.CommandSource;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;

public class CommandClaimChunks
implements IMCOPCommand {
    @Override
    public int onExecute(CommandContext<CommandSource> context) {
        Entity sender = ((CommandSource)context.getSource()).func_197022_f();
        if (!(sender instanceof PlayerEntity)) {
            return 0;
        }
        int colonyID = IntegerArgumentType.getInteger(context, (String)"colonyID");
        int range = IntegerArgumentType.getInteger(context, (String)"range");
        if (range > (Integer)MineColonies.getConfig().getCommon().maxColonySize.get()) {
            LanguageHandler.sendPlayerMessage((PlayerEntity)((PlayerEntity)sender), (String)"com.minecolonies.command.claim.toolarge", (Object[])new Object[]{colonyID});
            return 0;
        }
        boolean add = BoolArgumentType.getBool(context, (String)"add");
        IChunkmanagerCapability chunkManager = (IChunkmanagerCapability)sender.field_70170_p.getCapability(MineColonies.CHUNK_STORAGE_UPDATE_CAP, null).orElse(null);
        if (chunkManager == null) {
            Log.getLogger().error("Unable to find Chunk manager in world capability, please report this to the mod author!", (Throwable)new Exception());
            return 0;
        }
        if (chunkManager.getAllChunkStorages().size() > 5000) {
            LanguageHandler.sendPlayerMessage((PlayerEntity)((PlayerEntity)sender), (String)"com.minecolonies.command.claim.maxchunks", (Object[])new Object[0]);
            return 0;
        }
        ChunkDataHelper.claimChunksInRange(colonyID, ((CommandSource)context.getSource()).func_197023_e().field_73011_w.func_186058_p().func_186068_a(), add, sender.func_180425_c(), range, 0, sender.field_70170_p);
        LanguageHandler.sendPlayerMessage((PlayerEntity)((PlayerEntity)sender), (String)"com.minecolonies.command.claim.success", (Object[])new Object[0]);
        return 1;
    }

    @Override
    public String getName() {
        return "claim";
    }

    @Override
    public LiteralArgumentBuilder<CommandSource> build() {
        return (LiteralArgumentBuilder)IMCCommand.newLiteral(this.getName()).then(IMCCommand.newArgument("colonyID", IntegerArgumentType.integer((int)1)).then(IMCCommand.newArgument("range", IntegerArgumentType.integer((int)1, (int)10)).then(IMCCommand.newArgument("add", BoolArgumentType.bool()).executes(this::checkPreConditionAndExecute))));
    }
}

