/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.commands.colonycommands;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.coremod.commands.commandTypes.IMCCommand;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.command.CommandSource;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.event.ClickEvent;

public class CommandListColonies
implements IMCCommand {
    public static final String DESC = "list";
    private static final String ID_AND_NAME_TEXT = "ID: %s  Name: %s";
    private static final String COORDINATES_TEXT = "Coordinates: ";
    private static final String COORDINATES_XYZ = "x=%s y=%s z=%s";
    private static final String LIST_COMMAND_SUGGESTED = "/minecolonies colony list ";
    private static final String TELEPORT_COMMAND = "/minecolonies colony teleport ";
    private static final String PAGE_TOP_LEFT = "   ------------------ page ";
    private static final String PAGE_TOP_RIGHT = " ------------------";
    private static final String PAGE_TOP_MIDDLE = " of ";
    private static final String PREV_PAGE = " <- prev";
    private static final String NEXT_PAGE = "next -> ";
    private static final String PAGE_LINE = " ----------------";
    private static final String PAGE_LINE_DIVIDER = " | ";
    private static final String COMMAND_COLONY_INFO = "/minecolonies colony info %d";
    private static final int COLONIES_ON_PAGE = 9;
    public static final String START_PAGE_ARG = "startpage";

    @Override
    public int onExecute(CommandContext<CommandSource> context) {
        return this.executeCommand(context, 1);
    }

    private int executeWithPage(CommandContext<CommandSource> context) {
        if (this.checkPreCondition(context)) {
            return this.executeCommand(context, IntegerArgumentType.getInteger(context, (String)START_PAGE_ARG));
        }
        return 0;
    }

    private int executeCommand(CommandContext<CommandSource> context, int startpage) {
        int page = startpage;
        List<IColony> colonies = IColonyManager.getInstance().getAllColonies();
        int colonyCount = colonies.size();
        int halfPage = colonyCount % 9 == 0 ? 0 : 1;
        int pageCount = colonyCount / 9 + halfPage;
        if (page < 1 || page > pageCount) {
            page = 1;
        }
        int pageStartIndex = 9 * (page - 1);
        int pageStopIndex = Math.min(9 * page, colonyCount);
        int prevPage = Math.max(1, page - 1);
        int nextPage = Math.min(page + 1, colonyCount / 9 + halfPage);
        List<Object> coloniesPage = pageStartIndex < 0 || pageStartIndex >= colonyCount ? new ArrayList() : colonies.subList(pageStartIndex, pageStopIndex);
        StringTextComponent headerLine = new StringTextComponent(PAGE_TOP_LEFT + page + PAGE_TOP_MIDDLE + pageCount + PAGE_TOP_RIGHT);
        ((CommandSource)context.getSource()).func_197030_a((ITextComponent)headerLine, true);
        for (IColony iColony : coloniesPage) {
            ((CommandSource)context.getSource()).func_197030_a(new StringTextComponent(String.format(ID_AND_NAME_TEXT, iColony.getID(), iColony.getName())).func_150255_a(new Style().func_150241_a(new ClickEvent(ClickEvent.Action.RUN_COMMAND, String.format(COMMAND_COLONY_INFO, iColony.getID())))), true);
            BlockPos center = iColony.getCenter();
            StringTextComponent teleport = new StringTextComponent(COORDINATES_TEXT + String.format(COORDINATES_XYZ, center.func_177958_n(), center.func_177956_o(), center.func_177952_p()));
            teleport.func_150255_a(new Style().func_150227_a(Boolean.valueOf(true)).func_150238_a(TextFormatting.GOLD).func_150241_a(new ClickEvent(ClickEvent.Action.RUN_COMMAND, TELEPORT_COMMAND + iColony.getID())));
            ((CommandSource)context.getSource()).func_197030_a((ITextComponent)teleport, true);
        }
        ITextComponent prevButton = new StringTextComponent(PREV_PAGE).func_150255_a(new Style().func_150227_a(Boolean.valueOf(true)).func_150238_a(TextFormatting.GOLD).func_150241_a(new ClickEvent(ClickEvent.Action.RUN_COMMAND, LIST_COMMAND_SUGGESTED + prevPage)));
        ITextComponent iTextComponent = new StringTextComponent(NEXT_PAGE).func_150255_a(new Style().func_150227_a(Boolean.valueOf(true)).func_150238_a(TextFormatting.GOLD).func_150241_a(new ClickEvent(ClickEvent.Action.RUN_COMMAND, LIST_COMMAND_SUGGESTED + nextPage)));
        StringTextComponent beginLine = new StringTextComponent(PAGE_LINE);
        StringTextComponent endLine = new StringTextComponent(PAGE_LINE);
        ((CommandSource)context.getSource()).func_197030_a(beginLine.func_150257_a(prevButton).func_150257_a((ITextComponent)new StringTextComponent(PAGE_LINE_DIVIDER)).func_150257_a(iTextComponent).func_150257_a((ITextComponent)endLine), true);
        return 1;
    }

    @Override
    public String getName() {
        return DESC;
    }

    @Override
    public LiteralArgumentBuilder<CommandSource> build() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)IMCCommand.newLiteral(this.getName()).then(IMCCommand.newArgument(START_PAGE_ARG, IntegerArgumentType.integer((int)1)).executes(this::executeWithPage))).executes(this::checkPreConditionAndExecute);
    }
}

