/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.datalistener;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import com.ldtteam.blockout.Log;
import com.minecolonies.coremod.colony.crafting.CustomRecipeManager;
import java.util.Map;
import net.minecraft.client.resources.JsonReloadListener;
import net.minecraft.profiler.IProfiler;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;

public class CrafterRecipeListener
extends JsonReloadListener {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();

    public CrafterRecipeListener() {
        super(GSON, "crafterrecipes");
    }

    protected void apply(Map<ResourceLocation, JsonObject> object, IResourceManager resourceManager, IProfiler profiler) {
        Log.getLogger().info("Beginning load of custom recipes for colony workers");
        CustomRecipeManager recipeManager = CustomRecipeManager.getInstance();
        for (Map.Entry<ResourceLocation, JsonObject> entry : object.entrySet()) {
            ResourceLocation key = entry.getKey();
            JsonObject recipeJson = entry.getValue();
            if (recipeJson.has("type") && recipeJson.get("type").getAsString().equals("recipe")) {
                recipeManager.addRecipe(recipeJson, key);
            }
            if (!recipeJson.has("type") || !recipeJson.get("type").getAsString().equals("remove")) continue;
            recipeManager.removeRecipe(recipeJson, key);
        }
    }
}

