/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity.ai.basic;

import com.minecolonies.api.colony.buildings.IGuardBuilding;
import com.minecolonies.api.entity.ai.citizen.guards.GuardGear;
import com.minecolonies.api.entity.ai.citizen.guards.GuardGearBuilder;
import com.minecolonies.api.entity.ai.statemachine.AITarget;
import com.minecolonies.api.entity.ai.statemachine.states.AIWorkerState;
import com.minecolonies.api.entity.ai.statemachine.states.IAIState;
import com.minecolonies.api.entity.citizen.Skill;
import com.minecolonies.api.util.InventoryFunctions;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.constant.GuardConstants;
import com.minecolonies.api.util.constant.ToolType;
import com.minecolonies.coremod.colony.buildings.AbstractBuildingGuards;
import com.minecolonies.coremod.colony.jobs.AbstractJobGuard;
import com.minecolonies.coremod.entity.ai.basic.AbstractEntityAIInteract;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.LivingEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractEntityAIFight<J extends AbstractJobGuard<J>, B extends AbstractBuildingGuards>
extends AbstractEntityAIInteract<J, B> {
    public final List<ToolType> toolsNeeded = new ArrayList<ToolType>();
    public final List<List<GuardGear>> itemsNeeded = new ArrayList<List<GuardGear>>();
    protected LivingEntity target = null;
    private static final double COMBAT_SPEED = 1.0;
    public static final double SPEED_LEVEL_BONUS = 0.01;

    public AbstractEntityAIFight(@NotNull J job) {
        super(job);
        super.registerTargets(new AITarget((IAIState)AIWorkerState.IDLE, AIWorkerState.START_WORKING, 1), new AITarget((IAIState)AIWorkerState.START_WORKING, this::startWorkingAtOwnBuilding, 100), new AITarget((IAIState)AIWorkerState.PREPARING, this::prepare, 20));
        this.worker.func_98053_h(true);
        this.itemsNeeded.add(GuardGearBuilder.buildGearForLevel(3, 100, GuardConstants.LEATHER_LEVEL_RANGE, GuardConstants.DIA_BUILDING_LEVEL_RANGE));
        this.itemsNeeded.add(GuardGearBuilder.buildGearForLevel(2, 4, GuardConstants.LEATHER_LEVEL_RANGE, GuardConstants.DIA_BUILDING_LEVEL_RANGE));
        this.itemsNeeded.add(GuardGearBuilder.buildGearForLevel(0, 3, GuardConstants.LEATHER_LEVEL_RANGE, GuardConstants.IRON_BUILDING_LEVEL_RANGE));
        this.itemsNeeded.add(GuardGearBuilder.buildGearForLevel(0, 2, GuardConstants.LEATHER_LEVEL_RANGE, GuardConstants.CHAIN_BUILDING_LEVEL_RANGE));
        this.itemsNeeded.add(GuardGearBuilder.buildGearForLevel(0, 1, GuardConstants.LEATHER_LEVEL_RANGE, GuardConstants.GOLD_BUILDING_LEVEL_RANGE));
    }

    protected abstract int getAttackRange();

    protected IAIState startWorkingAtOwnBuilding() {
        this.worker.getCitizenStatusHandler().setLatestStatus(new ITextComponent[]{new TranslationTextComponent("com.minecolonies.coremod.status.worker.goingtohut", new Object[0])});
        if (this.walkToBuilding()) {
            return this.getState();
        }
        return AIWorkerState.PREPARING;
    }

    private IAIState prepare() {
        this.setDelay(100);
        for (ToolType tool : this.toolsNeeded) {
            if (this.checkForToolOrWeapon(tool)) {
                return this.getState();
            }
            if (this.getOwnBuilding() == null) continue;
            InventoryFunctions.matchFirstInProviderWithSimpleAction((ICapabilityProvider)this.worker, stack -> ItemStackUtils.isEmpty(stack) == false && ItemStackUtils.doesItemServeAsWeapon(stack) && ItemStackUtils.hasToolLevel(stack, tool, 0, ((AbstractBuildingGuards)this.getOwnBuilding()).getMaxToolLevel()), itemStack -> this.worker.getCitizenItemHandler().setMainHeldItem((int)itemStack));
        }
        this.equipInventoryArmor();
        if (this.worker.func_180425_c().func_177951_i((Vec3i)((AbstractBuildingGuards)this.getOwnBuilding()).getID()) > 50.0) {
            return AIWorkerState.DECIDE;
        }
        this.atBuildingActions();
        return AIWorkerState.DECIDE;
    }

    protected void atBuildingActions() {
        IGuardBuilding building = (IGuardBuilding)this.getOwnBuilding();
        for (List<GuardGear> itemList : this.itemsNeeded) {
            for (GuardGear item : itemList) {
                int slot;
                Map<IItemHandler, List<Integer>> items;
                if (building.getBuildingLevel() < item.getMinBuildingLevelRequired() || building.getBuildingLevel() > item.getMaxBuildingLevelRequired()) continue;
                int bestSlot = -1;
                int bestLevel = -1;
                IItemHandler bestHandler = null;
                if (!ItemStackUtils.isEmpty(this.worker.func_184582_a(item.getType())).booleanValue()) {
                    bestLevel = ItemStackUtils.getMiningLevel(this.worker.func_184582_a(item.getType()), item.getItemNeeded());
                }
                if ((items = InventoryUtils.findAllSlotsInProviderWith(building, item::test)).isEmpty()) {
                    if (ItemStackUtils.isEmpty(this.worker.func_184582_a(item.getType())).booleanValue()) {
                        this.checkForToolorWeaponASync(item.getItemNeeded(), item.getMinArmorLevel(), item.getMaxArmorLevel());
                    }
                } else {
                    for (Map.Entry<IItemHandler, List<Integer>> entry : items.entrySet()) {
                        for (Integer slot2 : entry.getValue()) {
                            int currentLevel;
                            ItemStack stack2 = entry.getKey().getStackInSlot(slot2.intValue());
                            if (ItemStackUtils.isEmpty(stack2).booleanValue() || (currentLevel = ItemStackUtils.getMiningLevel(stack2, item.getItemNeeded())) <= bestLevel) continue;
                            bestLevel = currentLevel;
                            bestSlot = slot2;
                            bestHandler = entry.getKey();
                        }
                    }
                }
                if (bestHandler == null) continue;
                if (!ItemStackUtils.isEmpty(this.worker.func_184582_a(item.getType())).booleanValue() && (slot = InventoryUtils.findFirstSlotInItemHandlerNotEmptyWith((IItemHandler)this.worker.getInventoryCitizen(), stack -> stack == this.worker.func_184582_a(item.getType()))) > -1) {
                    InventoryUtils.transferItemStackIntoNextFreeSlotInProvider((IItemHandler)this.worker.getInventoryCitizen(), slot, building);
                }
                this.worker.func_184201_a(item.getType(), bestHandler.getStackInSlot(bestSlot));
                InventoryUtils.transferItemStackIntoNextFreeSlotInItemHandler(bestHandler, bestSlot, (IItemHandler)this.worker.getInventoryCitizen());
            }
        }
        this.equipInventoryArmor();
    }

    public double getCombatMovementSpeed() {
        if (this.worker.getCitizenData() == null) {
            return 1.0;
        }
        double levelAdjustment = this.getCombatSpeedBonus();
        if (this.getOwnBuilding() != null) {
            levelAdjustment += (double)(((AbstractBuildingGuards)this.getOwnBuilding()).getBuildingLevel() * 2 - 1) * 0.01;
        }
        levelAdjustment = levelAdjustment > 0.3 ? 0.3 : levelAdjustment;
        return 1.0 + levelAdjustment;
    }

    protected double getCombatSpeedBonus() {
        return 0.0;
    }

    protected int getAttackDelay() {
        if (this.worker.getCitizenData() != null) {
            int delay = 20 - this.worker.getCitizenData().getCitizenSkillHandler().getLevel(Skill.Adaptability) / 5;
            return delay > 10 ? 10 : delay;
        }
        return 20;
    }

    @Override
    public IAIState afterDump() {
        return AIWorkerState.PREPARING;
    }

    public void equipInventoryArmor() {
        this.cleanArmor();
        IGuardBuilding building = (IGuardBuilding)this.getOwnBuilding();
        for (List<GuardGear> itemList : this.itemsNeeded) {
            for (GuardGear item : itemList) {
                if (building.getBuildingLevel() < item.getMinBuildingLevelRequired() || building.getBuildingLevel() > item.getMaxBuildingLevelRequired()) continue;
                int slot = InventoryUtils.findFirstSlotInItemHandlerNotEmptyWith((IItemHandler)this.worker.getInventoryCitizen(), item::test);
                if (slot <= -1) continue;
                this.worker.func_184201_a(item.getType(), this.worker.getInventoryCitizen().getStackInSlot(slot));
            }
        }
    }

    public void cleanArmor() {
        this.worker.func_184201_a(EquipmentSlotType.CHEST, ItemStackUtils.EMPTY);
        this.worker.func_184201_a(EquipmentSlotType.FEET, ItemStackUtils.EMPTY);
        this.worker.func_184201_a(EquipmentSlotType.HEAD, ItemStackUtils.EMPTY);
        this.worker.func_184201_a(EquipmentSlotType.LEGS, ItemStackUtils.EMPTY);
        this.worker.func_184201_a(EquipmentSlotType.OFFHAND, ItemStackUtils.EMPTY);
    }
}

