/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity.ai.basic;

import com.google.common.collect.ImmutableList;
import com.google.common.reflect.TypeToken;
import com.minecolonies.api.colony.interactionhandling.ChatPriority;
import com.minecolonies.api.colony.requestsystem.request.IRequest;
import com.minecolonies.api.colony.requestsystem.request.RequestState;
import com.minecolonies.api.colony.requestsystem.requestable.StackList;
import com.minecolonies.api.colony.requestsystem.requestable.crafting.PublicCrafting;
import com.minecolonies.api.crafting.IRecipeStorage;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.entity.ai.statemachine.AIEventTarget;
import com.minecolonies.api.entity.ai.statemachine.AITarget;
import com.minecolonies.api.entity.ai.statemachine.states.AIBlockingEventType;
import com.minecolonies.api.entity.ai.statemachine.states.AIWorkerState;
import com.minecolonies.api.entity.ai.statemachine.states.IAIState;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.Tuple;
import com.minecolonies.api.util.WorldUtil;
import com.minecolonies.coremod.colony.buildings.AbstractBuildingSmelterCrafter;
import com.minecolonies.coremod.colony.interactionhandling.StandardInteraction;
import com.minecolonies.coremod.colony.jobs.AbstractJobCrafter;
import com.minecolonies.coremod.entity.ai.basic.AbstractEntityAICrafting;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.block.Blocks;
import net.minecraft.block.FurnaceBlock;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.FurnaceTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractEntityAIRequestSmelter<J extends AbstractJobCrafter<?, J>, B extends AbstractBuildingSmelterCrafter>
extends AbstractEntityAICrafting<J, B> {
    private static final double BASE_XP_GAIN = 5.0;
    private BlockPos fuelPos = null;
    private IAIState preFuelState = null;

    public AbstractEntityAIRequestSmelter(@NotNull J smelteryJob) {
        super(smelteryJob);
        super.registerTargets(new AITarget((IAIState)AIWorkerState.START_USING_FURNACE, this::fillUpFurnace, 20), new AITarget((IAIState)AIWorkerState.RETRIEVING_END_PRODUCT_FROM_FURNACE, this::retrieveSmeltableFromFurnace, 20), new AITarget((IAIState)AIWorkerState.ADD_FUEL_TO_FURNACE, this::addFuelToFurnace, 20), new AIEventTarget(AIBlockingEventType.STATE_BLOCKING, this::isFuelNeeded, this::checkFurnaceFuel, 20), new AIEventTarget(AIBlockingEventType.STATE_BLOCKING, this::accelerateFurnaces, 20));
    }

    @Override
    protected int getExtendedCount(ItemStack stack) {
        if (this.currentRecipeStorage != null && this.currentRecipeStorage.getIntermediate() == Blocks.field_150460_al) {
            int count = 0;
            for (BlockPos pos : ((AbstractBuildingSmelterCrafter)this.getOwnBuilding()).getFurnaces()) {
                TileEntity entity;
                if (!WorldUtil.isBlockLoaded((IWorld)this.world, pos) || !((entity = this.world.func_175625_s(pos)) instanceof FurnaceTileEntity)) continue;
                FurnaceTileEntity furnace = (FurnaceTileEntity)entity;
                ItemStack smeltableSlot = furnace.func_70301_a(0);
                ItemStack resultSlot = furnace.func_70301_a(2);
                if (ItemStackUtils.compareItemStacksIgnoreStackSize(stack, smeltableSlot).booleanValue()) {
                    count += smeltableSlot.func_190916_E();
                    continue;
                }
                if (!ItemStackUtils.compareItemStacksIgnoreStackSize(stack, resultSlot).booleanValue()) continue;
                count += resultSlot.func_190916_E();
            }
            return count;
        }
        return 0;
    }

    @Override
    protected IAIState getRecipe() {
        IAIState newState;
        IRequest currentTask = ((AbstractJobCrafter)this.job).getCurrentTask();
        if (currentTask == null) {
            this.worker.func_184611_a(Hand.MAIN_HAND, ItemStackUtils.EMPTY);
            return AIWorkerState.START_WORKING;
        }
        ((AbstractJobCrafter)this.job).setMaxCraftingCount(((PublicCrafting)currentTask.getRequest()).getCount());
        BlockPos furnacePos = this.getPositionOfOvenToRetrieveFrom();
        if (furnacePos != null) {
            this.currentRequest = currentTask;
            this.walkTo = furnacePos;
            return AIWorkerState.RETRIEVING_END_PRODUCT_FROM_FURNACE;
        }
        if (this.currentRecipeStorage != null && this.currentRecipeStorage.getIntermediate() == Blocks.field_150460_al) {
            for (BlockPos pos : ((AbstractBuildingSmelterCrafter)this.getOwnBuilding()).getFurnaces()) {
                FurnaceTileEntity furnace;
                TileEntity entity = this.world.func_175625_s(pos);
                if (!(entity instanceof FurnaceTileEntity) || !(furnace = (FurnaceTileEntity)entity).func_214006_r() && ItemStackUtils.isEmpty(furnace.func_70301_a(2)).booleanValue() && ItemStackUtils.isEmpty(furnace.func_70301_a(0)).booleanValue()) continue;
                if (furnace.func_214006_r()) {
                    this.setDelay(20);
                }
                return AIWorkerState.CRAFT;
            }
        }
        if ((newState = super.getRecipe()) == AIWorkerState.QUERY_ITEMS && this.currentRecipeStorage != null && !((AbstractBuildingSmelterCrafter)this.getOwnBuilding()).getAllowedFuel().isEmpty() && ((AbstractBuildingSmelterCrafter)this.getOwnBuilding()).isAllowedFuel(this.currentRecipeStorage.getPrimaryOutput())) {
            ((AbstractJobCrafter)this.job).setCraftCounter(0);
        }
        return newState;
    }

    private int countOfBurningFurnaces() {
        int count = 0;
        World world = ((AbstractBuildingSmelterCrafter)this.getOwnBuilding()).getColony().getWorld();
        for (BlockPos pos : ((AbstractBuildingSmelterCrafter)this.getOwnBuilding()).getFurnaces()) {
            FurnaceTileEntity furnace;
            TileEntity entity;
            if (!WorldUtil.isBlockLoaded((IWorld)world, pos) || !((entity = world.func_175625_s(pos)) instanceof FurnaceTileEntity) || !(furnace = (FurnaceTileEntity)entity).func_214006_r()) continue;
            ++count;
        }
        return count;
    }

    private IAIState accelerateFurnaces() {
        int accelerationTicks = this.worker.getCitizenData().getCitizenSkillHandler().getLevel(((AbstractBuildingSmelterCrafter)this.getOwnBuilding()).getSecondarySkill()) / 10 * 2;
        World world = ((AbstractBuildingSmelterCrafter)this.getOwnBuilding()).getColony().getWorld();
        for (BlockPos pos : ((AbstractBuildingSmelterCrafter)this.getOwnBuilding()).getFurnaces()) {
            TileEntity entity;
            if (!WorldUtil.isBlockLoaded((IWorld)world, pos) || !((entity = world.func_175625_s(pos)) instanceof FurnaceTileEntity)) continue;
            FurnaceTileEntity furnace = (FurnaceTileEntity)entity;
            for (int i = 0; i < accelerationTicks; ++i) {
                if (!furnace.func_214006_r()) continue;
                furnace.func_73660_a();
            }
        }
        return this.getState();
    }

    private List<ItemStack> getActivePossibleFuels() {
        List<ItemStack> possibleFuels = ((AbstractBuildingSmelterCrafter)this.getOwnBuilding()).getAllowedFuel();
        if (possibleFuels.isEmpty()) {
            if (this.worker.getCitizenData() != null) {
                this.worker.getCitizenData().triggerInteraction(new StandardInteraction((ITextComponent)new TranslationTextComponent("com.minecolonies.coremod.furnaceuser.nofuel", new Object[0]), ChatPriority.IMPORTANT));
            }
            return ImmutableList.of();
        }
        if (this.currentRecipeStorage != null) {
            possibleFuels.removeIf(stack -> ItemStackUtils.compareItemStacksIgnoreStackSize(stack, this.currentRecipeStorage.getPrimaryOutput()));
            possibleFuels.removeIf(stack -> ItemStackUtils.compareItemStacksIgnoreStackSize(stack, this.currentRecipeStorage.getCleanedInput().get(0).getItemStack()));
        }
        return possibleFuels;
    }

    private boolean isFuelNeeded() {
        for (BlockPos pos : ((AbstractBuildingSmelterCrafter)this.getOwnBuilding()).getFurnaces()) {
            TileEntity entity;
            FurnaceTileEntity furnace;
            if (!WorldUtil.isBlockLoaded((IWorld)this.world, pos) || (furnace = (FurnaceTileEntity)(entity = this.world.func_175625_s(pos))).func_214006_r() || !ItemStackUtils.hasSmeltableInFurnaceAndNoFuel(furnace) && !ItemStackUtils.hasNeitherFuelNorSmeltAble(furnace) || this.currentRecipeStorage == null || this.currentRecipeStorage.getIntermediate() != Blocks.field_150460_al) continue;
            return true;
        }
        return false;
    }

    private static Predicate<ItemStack> isCorrectFuel(List<ItemStack> possibleFuels) {
        return item -> FurnaceTileEntity.func_213991_b((ItemStack)item) && possibleFuels.stream().anyMatch(candidate -> ItemStackUtils.compareItemStacksIgnoreStackSize(candidate, item));
    }

    private IAIState checkFurnaceFuel() {
        World world = ((AbstractBuildingSmelterCrafter)this.getOwnBuilding()).getColony().getWorld();
        List<ItemStack> possibleFuels = this.getActivePossibleFuels();
        if (!(InventoryUtils.hasItemInItemHandler((IItemHandler)this.worker.getInventoryCitizen(), AbstractEntityAIRequestSmelter.isCorrectFuel(possibleFuels)) || InventoryUtils.hasItemInProvider(this.getOwnBuilding(), AbstractEntityAIRequestSmelter.isCorrectFuel(possibleFuels)) || ((AbstractBuildingSmelterCrafter)this.getOwnBuilding()).hasWorkerOpenRequestsOfType(this.worker.getCitizenData(), TypeToken.of(StackList.class)) || this.currentRecipeStorage == null || this.currentRecipeStorage.getIntermediate() != Blocks.field_150460_al)) {
            this.worker.getCitizenData().createRequestAsync(new StackList(possibleFuels, "com.minecolonies.coremod.request.burnable", 64, 1));
            return this.getState();
        }
        for (BlockPos pos : ((AbstractBuildingSmelterCrafter)this.getOwnBuilding()).getFurnaces()) {
            FurnaceTileEntity furnace;
            TileEntity entity;
            if (!WorldUtil.isBlockLoaded((IWorld)world, pos) || !((entity = world.func_175625_s(pos)) instanceof FurnaceTileEntity) || (furnace = (FurnaceTileEntity)entity).func_214006_r() || !ItemStackUtils.hasSmeltableInFurnaceAndNoFuel(furnace) && !ItemStackUtils.hasNeitherFuelNorSmeltAble(furnace) || this.currentRecipeStorage == null || this.currentRecipeStorage.getIntermediate() != Blocks.field_150460_al) continue;
            if (!InventoryUtils.hasItemInItemHandler((IItemHandler)this.worker.getInventoryCitizen(), AbstractEntityAIRequestSmelter.isCorrectFuel(possibleFuels))) {
                if (InventoryUtils.hasItemInProvider(this.getOwnBuilding(), AbstractEntityAIRequestSmelter.isCorrectFuel(possibleFuels))) {
                    this.needsCurrently = new Tuple<Predicate<ItemStack>, Integer>(AbstractEntityAIRequestSmelter.isCorrectFuel(possibleFuels), 64);
                    return AIWorkerState.GATHERING_REQUIRED_MATERIALS;
                }
                return this.getState();
            }
            this.fuelPos = pos;
            if (this.preFuelState == null) {
                this.preFuelState = this.getState();
            }
            return AIWorkerState.ADD_FUEL_TO_FURNACE;
        }
        return this.getState();
    }

    private IAIState addFuelToFurnace() {
        TileEntity entity;
        List<ItemStack> possibleFuels = this.getActivePossibleFuels();
        if (!InventoryUtils.hasItemInItemHandler((IItemHandler)this.worker.getInventoryCitizen(), AbstractEntityAIRequestSmelter.isCorrectFuel(possibleFuels))) {
            if (InventoryUtils.hasItemInProvider(this.getOwnBuilding(), AbstractEntityAIRequestSmelter.isCorrectFuel(possibleFuels))) {
                this.needsCurrently = new Tuple<Predicate<ItemStack>, Integer>(AbstractEntityAIRequestSmelter.isCorrectFuel(possibleFuels), 64);
                return AIWorkerState.GATHERING_REQUIRED_MATERIALS;
            }
            this.preFuelState = null;
            this.fuelPos = null;
            return AIWorkerState.START_WORKING;
        }
        if (this.fuelPos == null || this.walkToBlock(this.fuelPos)) {
            return this.getState();
        }
        if (WorldUtil.isBlockLoaded((IWorld)this.world, this.fuelPos) && (entity = this.world.func_175625_s(this.fuelPos)) instanceof FurnaceTileEntity) {
            FurnaceTileEntity furnace = (FurnaceTileEntity)entity;
            if (InventoryUtils.hasItemInItemHandler((IItemHandler)this.worker.getInventoryCitizen(), AbstractEntityAIRequestSmelter.isCorrectFuel(possibleFuels)) && (ItemStackUtils.hasSmeltableInFurnaceAndNoFuel(furnace) || ItemStackUtils.hasNeitherFuelNorSmeltAble(furnace))) {
                InventoryUtils.transferXOfFirstSlotInItemHandlerWithIntoInItemHandler((IItemHandler)this.worker.getInventoryCitizen(), AbstractEntityAIRequestSmelter.isCorrectFuel(possibleFuels), 64, (IItemHandler)new InvWrapper((IInventory)furnace), 1);
                if (this.preFuelState != null && this.preFuelState != AIWorkerState.ADD_FUEL_TO_FURNACE) {
                    IAIState returnState = this.preFuelState;
                    this.preFuelState = null;
                    this.fuelPos = null;
                    return returnState;
                }
            }
        }
        this.preFuelState = null;
        this.fuelPos = null;
        return AIWorkerState.START_WORKING;
    }

    private int getMaxUsableFurnaces() {
        int maxSkillFurnaces = this.worker.getCitizenData().getCitizenSkillHandler().getLevel(((AbstractBuildingSmelterCrafter)this.getOwnBuilding()).getPrimarySkill()) / 10 + 1;
        return Math.min(maxSkillFurnaces, ((AbstractBuildingSmelterCrafter)this.getOwnBuilding()).getFurnaces().size());
    }

    private BlockPos getPositionOfOvenToRetrieveFrom() {
        for (BlockPos pos : ((AbstractBuildingSmelterCrafter)this.getOwnBuilding()).getFurnaces()) {
            int countInResultSlot;
            TileEntity entity = this.world.func_175625_s(pos);
            if (!(entity instanceof FurnaceTileEntity)) continue;
            FurnaceTileEntity furnace = (FurnaceTileEntity)entity;
            int n = countInResultSlot = ItemStackUtils.isEmpty(furnace.func_70301_a(2)) != false ? 0 : furnace.func_70301_a(2).func_190916_E();
            if (furnace.func_214006_r() || countInResultSlot <= 0 || !ItemStackUtils.isEmpty(furnace.func_70301_a(0)).booleanValue()) continue;
            this.worker.getCitizenStatusHandler().setLatestStatus(new ITextComponent[]{new TranslationTextComponent("com.minecolonies.coremod.status.retrieving", new Object[0])});
            return pos;
        }
        return null;
    }

    @Override
    protected IAIState checkForItems(@NotNull IRecipeStorage storage) {
        if (storage.getIntermediate() != Blocks.field_150460_al) {
            return super.checkForItems(storage);
        }
        List<ItemStorage> input = storage.getCleanedInput();
        int countInFurnaces = this.getExtendedCount(storage.getPrimaryOutput());
        int outputInInv = InventoryUtils.getItemCountInItemHandler((IItemHandler)this.worker.getInventoryCitizen(), stack -> ItemStackUtils.compareItemStacksIgnoreStackSize(stack, storage.getPrimaryOutput()));
        for (ItemStorage inputStorage : input) {
            int inputInInv;
            Predicate<ItemStack> predicate = stack -> ItemStackUtils.isEmpty(stack) == false && ItemStackUtils.compareItemStacksIgnoreStackSize(stack, inputStorage.getItemStack()) != false;
            int inputInFurnace = this.getExtendedCount(inputStorage.getItemStack());
            if (countInFurnaces + inputInFurnace + (inputInInv = InventoryUtils.getItemCountInItemHandler((IItemHandler)this.worker.getInventoryCitizen(), predicate)) + outputInInv < inputStorage.getAmount() * ((AbstractJobCrafter)this.job).getMaxCraftingCount() && InventoryUtils.hasItemInProvider(this.getOwnBuilding(), predicate)) {
                this.needsCurrently = new Tuple<Predicate<ItemStack>, Integer>(predicate, inputStorage.getAmount() * (((AbstractJobCrafter)this.job).getMaxCraftingCount() - countInFurnaces - inputInFurnace));
                return AIWorkerState.GATHERING_REQUIRED_MATERIALS;
            }
            int countOfInput = inputInInv + InventoryUtils.getItemCountInProvider(this.getOwnBuilding(), predicate) + countInFurnaces + inputInFurnace + outputInInv;
            if (countOfInput >= inputStorage.getAmount() * ((AbstractJobCrafter)this.job).getMaxCraftingCount()) continue;
            ((AbstractJobCrafter)this.job).finishRequest(false);
            this.resetValues();
        }
        return AIWorkerState.CRAFT;
    }

    private IAIState retrieveSmeltableFromFurnace() {
        this.worker.getCitizenStatusHandler().setLatestStatus(new ITextComponent[]{new TranslationTextComponent("com.minecolonies.coremod.status.retrieving", new Object[0])});
        if (this.walkTo == null || this.currentRequest == null) {
            return AIWorkerState.START_WORKING;
        }
        TileEntity entity = this.world.func_175625_s(this.walkTo);
        if (!(entity instanceof FurnaceTileEntity) || ItemStackUtils.isEmpty(((FurnaceTileEntity)entity).func_70301_a(2)).booleanValue()) {
            this.walkTo = null;
            return AIWorkerState.START_WORKING;
        }
        if (this.walkToBlock(this.walkTo)) {
            return this.getState();
        }
        this.walkTo = null;
        int preExtractCount = InventoryUtils.getItemCountInItemHandler((IItemHandler)this.worker.getInventoryCitizen(), stack -> ItemStackUtils.compareItemStacksIgnoreStackSize(((PublicCrafting)this.currentRequest.getRequest()).getStack(), stack));
        this.extractFromFurnace((FurnaceTileEntity)entity);
        int resultCount = InventoryUtils.getItemCountInItemHandler((IItemHandler)this.worker.getInventoryCitizen(), stack -> ItemStackUtils.compareItemStacksIgnoreStackSize(((PublicCrafting)this.currentRequest.getRequest()).getStack(), stack)) - preExtractCount;
        if (resultCount > 0) {
            ItemStack stack2 = ((PublicCrafting)this.currentRequest.getRequest()).getStack().func_77946_l();
            stack2.func_190920_e(resultCount);
            this.currentRequest.addDelivery(stack2);
            ((AbstractJobCrafter)this.job).setCraftCounter(((AbstractJobCrafter)this.job).getCraftCounter() + resultCount);
            ((AbstractJobCrafter)this.job).setProgress(((AbstractJobCrafter)this.job).getProgress() - resultCount);
            if (((AbstractJobCrafter)this.job).getMaxCraftingCount() == 0) {
                ((AbstractJobCrafter)this.job).setMaxCraftingCount(((PublicCrafting)this.currentRequest.getRequest()).getCount());
            }
            if (((AbstractJobCrafter)this.job).getCraftCounter() >= ((AbstractJobCrafter)this.job).getMaxCraftingCount() && ((AbstractJobCrafter)this.job).getProgress() <= 0) {
                ((AbstractJobCrafter)this.job).finishRequest(true);
                this.resetValues();
                this.currentRecipeStorage = null;
                this.incrementActionsDoneAndDecSaturation();
                return AIWorkerState.INVENTORY_FULL;
            }
        }
        this.setDelay(5);
        return AIWorkerState.START_WORKING;
    }

    private void extractFromFurnace(FurnaceTileEntity furnace) {
        InventoryUtils.transferItemStackIntoNextFreeSlotInItemHandler((IItemHandler)new InvWrapper((IInventory)furnace), 2, (IItemHandler)this.worker.getInventoryCitizen());
        this.worker.getCitizenExperienceHandler().addExperience(5.0);
    }

    private IAIState checkIfAbleToSmelt() {
        int burning = this.countOfBurningFurnaces();
        if (burning > 0 && (burning >= this.getMaxUsableFurnaces() || ((AbstractJobCrafter)this.job).getCraftCounter() + ((AbstractJobCrafter)this.job).getProgress() >= ((AbstractJobCrafter)this.job).getMaxCraftingCount())) {
            this.setDelay(20);
            return this.getState();
        }
        for (BlockPos pos : ((AbstractBuildingSmelterCrafter)this.getOwnBuilding()).getFurnaces()) {
            TileEntity entity = this.world.func_175625_s(pos);
            if (entity instanceof FurnaceTileEntity) {
                if (((FurnaceTileEntity)entity).func_214006_r()) continue;
                this.walkTo = pos;
                return AIWorkerState.START_USING_FURNACE;
            }
            if (this.world.func_180495_p(pos).func_177230_c() instanceof FurnaceBlock) continue;
            ((AbstractBuildingSmelterCrafter)this.getOwnBuilding()).removeFromFurnaces(pos);
        }
        if (burning > 0) {
            this.setDelay(20);
        }
        return this.getState();
    }

    /*
     * Enabled aggressive block sorting
     */
    private IAIState fillUpFurnace() {
        block13: {
            block11: {
                int amountOfSmeltableInInv;
                int amountOfSmeltableInBuilding;
                int targetCount;
                Predicate<ItemStack> smeltable;
                block12: {
                    if (((AbstractBuildingSmelterCrafter)this.getOwnBuilding()).getFurnaces().isEmpty()) {
                        if (this.worker.getCitizenData() != null) {
                            this.worker.getCitizenData().triggerInteraction(new StandardInteraction((ITextComponent)new TranslationTextComponent("com.minecolonies.coremod.bakery.nofurnace", new Object[0]), ChatPriority.BLOCKING));
                        }
                        this.setDelay(5);
                        return AIWorkerState.START_WORKING;
                    }
                    if (this.walkTo == null || this.world.func_180495_p(this.walkTo).func_177230_c() != Blocks.field_150460_al) {
                        this.walkTo = null;
                        this.setDelay(5);
                        return AIWorkerState.START_WORKING;
                    }
                    int burningCount = this.countOfBurningFurnaces();
                    TileEntity entity = this.world.func_175625_s(this.walkTo);
                    if (!(entity instanceof FurnaceTileEntity) || this.currentRecipeStorage == null) break block11;
                    FurnaceTileEntity furnace = (FurnaceTileEntity)entity;
                    int maxFurnaces = this.getMaxUsableFurnaces();
                    smeltable = stack -> ItemStackUtils.compareItemStacksIgnoreStackSize(this.currentRecipeStorage.getCleanedInput().get(0).getItemStack(), stack);
                    int smeltableInFurnaces = this.getExtendedCount(this.currentRecipeStorage.getCleanedInput().get(0).getItemStack());
                    int resultInFurnaces = this.getExtendedCount(this.currentRecipeStorage.getPrimaryOutput());
                    int resultInCitizenInv = InventoryUtils.getItemCountInItemHandler((IItemHandler)this.worker.getInventoryCitizen(), stack -> ItemStackUtils.compareItemStacksIgnoreStackSize(stack, this.currentRecipeStorage.getPrimaryOutput()));
                    targetCount = ((PublicCrafting)this.currentRequest.getRequest()).getCount() - smeltableInFurnaces - resultInFurnaces - resultInCitizenInv;
                    if (targetCount <= 0) {
                        return AIWorkerState.START_WORKING;
                    }
                    amountOfSmeltableInBuilding = InventoryUtils.getItemCountInProvider(this.getOwnBuilding(), smeltable);
                    amountOfSmeltableInInv = InventoryUtils.getItemCountInItemHandler((IItemHandler)this.worker.getInventoryCitizen(), smeltable);
                    if (this.worker.func_184586_b(Hand.MAIN_HAND).func_190926_b()) {
                        this.worker.func_184611_a(Hand.MAIN_HAND, this.currentRecipeStorage.getCleanedInput().get(0).getItemStack().func_77946_l());
                    }
                    if (amountOfSmeltableInInv <= 0) break block12;
                    if (ItemStackUtils.hasFuelInFurnaceAndNoSmeltable(furnace) || ItemStackUtils.hasNeitherFuelNorSmeltAble(furnace)) {
                        int toTransfer = 0;
                        if (burningCount < maxFurnaces) {
                            int availableFurnaces = maxFurnaces - burningCount;
                            toTransfer = targetCount > 64 * availableFurnaces ? 64 : Math.min(targetCount / availableFurnaces + targetCount % availableFurnaces, 64);
                        }
                        if (toTransfer > 0) {
                            if (this.walkToBlock(this.walkTo)) {
                                return this.getState();
                            }
                            this.worker.getCitizenItemHandler().hitBlockWithToolInHand(this.walkTo);
                            InventoryUtils.transferXInItemHandlerIntoSlotInItemHandler((IItemHandler)this.worker.getInventoryCitizen(), smeltable, toTransfer, (IItemHandler)new InvWrapper((IInventory)furnace), 0);
                        }
                    }
                    break block13;
                }
                if (amountOfSmeltableInBuilding >= targetCount - amountOfSmeltableInInv && this.currentRecipeStorage.getIntermediate() == Blocks.field_150460_al) {
                    this.needsCurrently = new Tuple<Predicate<ItemStack>, Integer>(smeltable, targetCount);
                    return AIWorkerState.GATHERING_REQUIRED_MATERIALS;
                }
                ((AbstractJobCrafter)this.job).finishRequest(false);
                this.resetValues();
                return AIWorkerState.IDLE;
            }
            if (!(this.world.func_180495_p(this.walkTo).func_177230_c() instanceof FurnaceBlock)) {
                ((AbstractBuildingSmelterCrafter)this.getOwnBuilding()).removeFromFurnaces(this.walkTo);
            }
        }
        this.walkTo = null;
        this.setDelay(5);
        return AIWorkerState.START_WORKING;
    }

    @Override
    protected IAIState craft() {
        List<ItemStack> possibleFuels = ((AbstractBuildingSmelterCrafter)this.getOwnBuilding()).getAllowedFuel();
        if (possibleFuels.isEmpty()) {
            if (this.worker.getCitizenData() != null) {
                this.worker.getCitizenData().triggerInteraction(new StandardInteraction((ITextComponent)new TranslationTextComponent("com.minecolonies.coremod.furnaceuser.nofuel", new Object[0]), ChatPriority.BLOCKING));
            }
            return this.getState();
        }
        if (this.currentRecipeStorage != null) {
            possibleFuels.removeIf(stack -> ItemStackUtils.compareItemStacksIgnoreStackSize(stack, this.currentRecipeStorage.getPrimaryOutput()));
            possibleFuels.removeIf(stack -> ItemStackUtils.compareItemStacksIgnoreStackSize(stack, this.currentRecipeStorage.getCleanedInput().get(0).getItemStack()));
        }
        if (this.walkToBuilding()) {
            this.setDelay(5);
            return this.getState();
        }
        if (this.currentRecipeStorage != null && this.currentRequest == null) {
            this.currentRequest = ((AbstractJobCrafter)this.job).getCurrentTask();
        }
        if (this.currentRecipeStorage != null && this.currentRecipeStorage.getIntermediate() != Blocks.field_150460_al) {
            return super.craft();
        }
        if (((AbstractBuildingSmelterCrafter)this.getOwnBuilding()).getFurnaces().isEmpty()) {
            if (this.worker.getCitizenData() != null) {
                this.worker.getCitizenData().triggerInteraction(new StandardInteraction((ITextComponent)new TranslationTextComponent("com.minecolonies.coremod.bakery.nofurnace", new Object[0]), ChatPriority.BLOCKING));
            }
            this.setDelay(5);
            return AIWorkerState.START_WORKING;
        }
        BlockPos posOfOven = this.getPositionOfOvenToRetrieveFrom();
        if (posOfOven != null) {
            this.walkTo = posOfOven;
            this.worker.getCitizenStatusHandler().setLatestStatus(new ITextComponent[]{new TranslationTextComponent("com.minecolonies.coremod.status.retrieving", new Object[0])});
            return AIWorkerState.RETRIEVING_END_PRODUCT_FROM_FURNACE;
        }
        if (this.currentRequest != null && ((AbstractJobCrafter)this.job).getMaxCraftingCount() > 0 && ((AbstractJobCrafter)this.job).getCraftCounter() >= ((AbstractJobCrafter)this.job).getMaxCraftingCount()) {
            ((AbstractJobCrafter)this.job).finishRequest(true);
            this.currentRecipeStorage = null;
            this.currentRequest = null;
            this.resetValues();
            return AIWorkerState.INVENTORY_FULL;
        }
        if (this.currentRequest != null && (this.currentRequest.getState() == RequestState.CANCELLED || this.currentRequest.getState() == RequestState.FAILED)) {
            this.incrementActionsDone(this.getActionRewardForCraftingSuccess());
            this.currentRecipeStorage = null;
            this.currentRequest = null;
            this.resetValues();
            return AIWorkerState.START_WORKING;
        }
        return this.checkIfAbleToSmelt();
    }
}

