/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity.ai.citizen.composter;

import com.minecolonies.api.colony.requestsystem.requestable.StackList;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.entity.ai.statemachine.AITarget;
import com.minecolonies.api.entity.ai.statemachine.states.AIWorkerState;
import com.minecolonies.api.entity.ai.statemachine.states.IAIState;
import com.minecolonies.api.entity.citizen.VisibleCitizenStatus;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.coremod.MineColonies;
import com.minecolonies.coremod.colony.buildings.workerbuildings.BuildingComposter;
import com.minecolonies.coremod.colony.jobs.JobComposter;
import com.minecolonies.coremod.entity.ai.basic.AbstractEntityAIInteract;
import com.minecolonies.coremod.tileentities.TileEntityBarrel;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.Blocks;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;

public class EntityAIWorkComposter
extends AbstractEntityAIInteract<JobComposter, BuildingComposter> {
    private static final double BASE_XP_GAIN = 1.0;
    private BlockPos currentTarget;
    private static final int TICKS_UNTIL_COMPLAIN = 12000;
    private int ticksToComplain = 0;
    private static final int DECIDE_DELAY = 40;
    private static final int AFTER_TASK_DELAY = 5;
    private static final String COMPOSTABLE_LIST = "compostables";
    private static final VisibleCitizenStatus COMPOST = new VisibleCitizenStatus(new ResourceLocation("minecolonies", "textures/icons/work/composter.png"), "com.minecolonies.gui.visiblestatus.composter");

    public EntityAIWorkComposter(@NotNull JobComposter job) {
        super(job);
        super.registerTargets(new AITarget((IAIState)AIWorkerState.IDLE, AIWorkerState.START_WORKING, 1), new AITarget((IAIState)AIWorkerState.GET_MATERIALS, this::getMaterials, 20), new AITarget((IAIState)AIWorkerState.START_WORKING, this::decideWhatToDo, 1), new AITarget((IAIState)AIWorkerState.COMPOSTER_FILL, this::fillBarrels, 10), new AITarget((IAIState)AIWorkerState.COMPOSTER_HARVEST, this::harvestBarrels, 10));
        this.worker.func_98053_h(true);
    }

    private IAIState getMaterials() {
        int slot;
        if (this.walkToBuilding()) {
            this.setDelay(2);
            return this.getState();
        }
        if (((BuildingComposter)this.getOwnBuilding()).getCopyOfAllowedItems().isEmpty()) {
            this.complain();
            return this.getState();
        }
        if (InventoryUtils.hasItemInProvider(this.getOwnBuilding(), stack -> ((BuildingComposter)this.getOwnBuilding()).isAllowedItem(COMPOSTABLE_LIST, new ItemStorage((ItemStack)stack)))) {
            InventoryUtils.transferItemStackIntoNextFreeSlotFromProvider(this.getOwnBuilding(), InventoryUtils.findFirstSlotInProviderNotEmptyWith(this.getOwnBuilding(), stack -> ((BuildingComposter)this.getOwnBuilding()).isAllowedItem(COMPOSTABLE_LIST, new ItemStorage((ItemStack)stack))), (IItemHandler)this.worker.getInventoryCitizen());
        }
        if ((slot = InventoryUtils.findFirstSlotInItemHandlerWith((IItemHandler)this.worker.getInventoryCitizen(), stack -> ((BuildingComposter)this.getOwnBuilding()).isAllowedItem(COMPOSTABLE_LIST, new ItemStorage((ItemStack)stack)))) >= 0) {
            this.worker.func_184611_a(Hand.MAIN_HAND, this.worker.getInventoryCitizen().getStackInSlot(slot));
            return AIWorkerState.START_WORKING;
        }
        this.worker.func_184611_a(Hand.MAIN_HAND, ItemStack.field_190927_a);
        if (!((BuildingComposter)this.getOwnBuilding()).hasWorkerOpenRequests(this.worker.getCitizenData())) {
            ArrayList<ItemStack> itemList = new ArrayList<ItemStack>();
            for (ItemStorage item : ((BuildingComposter)this.getOwnBuilding()).getCopyOfAllowedItems().get(COMPOSTABLE_LIST)) {
                ItemStack itemStack = item.getItemStack();
                itemStack.func_190920_e(itemStack.func_77976_d());
                itemList.add(itemStack);
            }
            if (!itemList.isEmpty()) {
                this.worker.getCitizenData().createRequestAsync(new StackList(itemList, "com.minecolonies.coremod.request.compostable", 64, 1));
            }
        }
        this.setDelay(2);
        return AIWorkerState.START_WORKING;
    }

    private IAIState decideWhatToDo() {
        TileEntity te;
        this.worker.getCitizenStatusHandler().setLatestStatus(new ITextComponent[]{new TranslationTextComponent("com.minecolonies.coremod.status.idling", new Object[0])});
        this.worker.getCitizenData().setVisibleStatus(VisibleCitizenStatus.WORKING);
        if (this.walkToBuilding()) {
            this.setDelay(2);
            return this.getState();
        }
        BuildingComposter building = (BuildingComposter)this.getOwnBuilding();
        for (BlockPos barrel : building.getBarrels()) {
            te = this.world.func_175625_s(barrel);
            if (!(te instanceof TileEntityBarrel)) continue;
            this.currentTarget = barrel;
            if (!((TileEntityBarrel)te).isDone()) continue;
            this.setDelay(40);
            this.worker.getCitizenData().setVisibleStatus(COMPOST);
            return AIWorkerState.COMPOSTER_HARVEST;
        }
        for (BlockPos barrel : building.getBarrels()) {
            te = this.world.func_175625_s(barrel);
            if (!(te instanceof TileEntityBarrel) || ((TileEntityBarrel)te).checkIfWorking()) continue;
            this.currentTarget = barrel;
            this.setDelay(40);
            this.worker.getCitizenData().setVisibleStatus(COMPOST);
            return AIWorkerState.COMPOSTER_FILL;
        }
        this.setDelay(40);
        return AIWorkerState.START_WORKING;
    }

    private IAIState fillBarrels() {
        this.worker.getCitizenStatusHandler().setLatestStatus(new ITextComponent[]{new TranslationTextComponent("com.minecolonies.coremod.status.fillingbarrels", new Object[0])});
        if (this.worker.func_184586_b(Hand.MAIN_HAND) == ItemStack.field_190927_a) {
            int slot = InventoryUtils.findFirstSlotInItemHandlerWith((IItemHandler)this.worker.getInventoryCitizen(), stack -> ((BuildingComposter)this.getOwnBuilding()).isAllowedItem(COMPOSTABLE_LIST, new ItemStorage((ItemStack)stack)));
            if (slot >= 0) {
                this.worker.func_184611_a(Hand.MAIN_HAND, this.worker.getInventoryCitizen().getStackInSlot(slot));
            } else {
                return AIWorkerState.GET_MATERIALS;
            }
        }
        if (this.walkToBlock(this.currentTarget)) {
            this.setDelay(2);
            return this.getState();
        }
        if (this.world.func_175625_s(this.currentTarget) instanceof TileEntityBarrel) {
            TileEntityBarrel barrel = (TileEntityBarrel)this.world.func_175625_s(this.currentTarget);
            this.worker.getCitizenItemHandler().hitBlockWithToolInHand(this.currentTarget);
            barrel.addItem(this.worker.func_184586_b(Hand.MAIN_HAND));
            this.worker.getCitizenExperienceHandler().addExperience(1.0);
            this.incrementActionsDoneAndDecSaturation();
            this.worker.func_184611_a(Hand.MAIN_HAND, ItemStackUtils.EMPTY);
            this.incrementActionsDone();
        }
        this.setDelay(5);
        return AIWorkerState.START_WORKING;
    }

    private IAIState harvestBarrels() {
        this.worker.getCitizenStatusHandler().setLatestStatus(new ITextComponent[]{new TranslationTextComponent("com.minecolonies.coremod.status.harvestingbarrels", new Object[0])});
        if (this.walkToBlock(this.currentTarget)) {
            this.setDelay(2);
            return this.getState();
        }
        if (this.world.func_175625_s(this.currentTarget) instanceof TileEntityBarrel) {
            this.worker.getCitizenItemHandler().hitBlockWithToolInHand(this.currentTarget);
            TileEntityBarrel te = (TileEntityBarrel)this.world.func_175625_s(this.currentTarget);
            ItemStack compost = te.retrieveCompost(this.getLootMultiplier(new Random()));
            if (((BuildingComposter)this.getOwnBuilding()).shouldRetrieveDirtFromCompostBin()) {
                InventoryUtils.addItemStackToItemHandler((IItemHandler)this.worker.getInventoryCitizen(), new ItemStack((IItemProvider)Blocks.field_150346_d, ((Integer)MineColonies.getConfig().getCommon().dirtFromCompost.get()).intValue()));
            } else {
                InventoryUtils.addItemStackToItemHandler((IItemHandler)this.worker.getInventoryCitizen(), compost);
            }
            this.worker.getCitizenExperienceHandler().addExperience(1.0);
            this.incrementActionsDoneAndDecSaturation();
        }
        this.setDelay(5);
        return AIWorkerState.START_WORKING;
    }

    private double getLootMultiplier(Random random) {
        int citizenLevel = (int)((double)this.getSecondarySkillLevel() / 2.0);
        int diceResult = random.nextInt(100);
        if (diceResult <= citizenLevel * 2) {
            return 2.0;
        }
        if (diceResult <= citizenLevel * 4) {
            return 1.5;
        }
        if (diceResult <= citizenLevel * 8) {
            return 1.25;
        }
        return 1.0;
    }

    @Override
    protected int getActionsDoneUntilDumping() {
        return 1;
    }

    private void complain() {
        if (this.ticksToComplain <= 0) {
            this.ticksToComplain = 12000;
            for (PlayerEntity player : ((BuildingComposter)this.getOwnBuilding()).getColony().getMessagePlayerEntities()) {
                player.func_145747_a((ITextComponent)new TranslationTextComponent("entity.composter.noitems", new Object[0]));
            }
        } else {
            --this.ticksToComplain;
        }
    }

    @Override
    public Class<BuildingComposter> getExpectedBuildingClass() {
        return BuildingComposter.class;
    }
}

