/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity.ai.citizen.deliveryman;

import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.buildings.IBuildingContainer;
import com.minecolonies.api.colony.buildings.IBuildingWorker;
import com.minecolonies.api.colony.buildings.workerbuildings.IBuildingDeliveryman;
import com.minecolonies.api.colony.buildings.workerbuildings.IWareHouse;
import com.minecolonies.api.colony.interactionhandling.ChatPriority;
import com.minecolonies.api.colony.requestsystem.location.ILocation;
import com.minecolonies.api.colony.requestsystem.request.IRequest;
import com.minecolonies.api.colony.requestsystem.requestable.deliveryman.Delivery;
import com.minecolonies.api.colony.requestsystem.requestable.deliveryman.IDeliverymanRequestable;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.entity.ai.statemachine.AITarget;
import com.minecolonies.api.entity.ai.statemachine.states.AIWorkerState;
import com.minecolonies.api.entity.ai.statemachine.states.IAIState;
import com.minecolonies.api.entity.citizen.VisibleCitizenStatus;
import com.minecolonies.api.inventory.InventoryCitizen;
import com.minecolonies.api.tileentities.AbstractTileEntityColonyBuilding;
import com.minecolonies.api.tileentities.TileEntityColonyBuilding;
import com.minecolonies.api.util.InventoryFunctions;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.Log;
import com.minecolonies.coremod.colony.buildings.AbstractBuildingWorker;
import com.minecolonies.coremod.colony.buildings.workerbuildings.BuildingCook;
import com.minecolonies.coremod.colony.buildings.workerbuildings.BuildingDeliveryman;
import com.minecolonies.coremod.colony.interactionhandling.PosBasedInteraction;
import com.minecolonies.coremod.colony.interactionhandling.StandardInteraction;
import com.minecolonies.coremod.colony.jobs.JobDeliveryman;
import com.minecolonies.coremod.colony.requestsystem.requests.StandardRequests;
import com.minecolonies.coremod.entity.ai.basic.AbstractEntityAIInteract;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.ChestTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EntityAIWorkDeliveryman
extends AbstractEntityAIInteract<JobDeliveryman, BuildingDeliveryman> {
    private static final int MIN_DISTANCE_TO_WAREHOUSE = 5;
    private static final int DECISION_DELAY = 100;
    private static final int PICKUP_DELAY = 2;
    private static final int SLOT_HAND = 0;
    private static final int PRIORITY_FORCING_DUMP = 10;
    private static final VisibleCitizenStatus DELIVERING = new VisibleCitizenStatus(new ResourceLocation("minecolonies", "textures/icons/work/delivery.png"), "com.minecolonies.gui.visiblestatus.delivery");
    private int currentSlot = 0;
    private List<ItemStorage> alreadyKept = new ArrayList<ItemStorage>();

    public EntityAIWorkDeliveryman(@NotNull JobDeliveryman deliveryman) {
        super(deliveryman);
        super.registerTargets(new AITarget((IAIState)AIWorkerState.IDLE, () -> AIWorkerState.START_WORKING, 1), new AITarget(AIWorkerState.START_WORKING, this::checkIfExecute, this::decide, 100), new AITarget((IAIState)AIWorkerState.PREPARE_DELIVERY, this::prepareDelivery, 5), new AITarget((IAIState)AIWorkerState.DELIVERY, this::deliver, 5), new AITarget((IAIState)AIWorkerState.PICKUP, this::pickup, 2), new AITarget((IAIState)AIWorkerState.DUMPING, this::dump, 20));
        this.worker.func_98053_h(true);
    }

    @Override
    public Class<BuildingDeliveryman> getExpectedBuildingClass() {
        return BuildingDeliveryman.class;
    }

    private IAIState pickup() {
        IRequest<IDeliverymanRequestable> currentTask = ((JobDeliveryman)this.job).getCurrentTask();
        if (!(currentTask instanceof StandardRequests.PickupRequest)) {
            return AIWorkerState.START_WORKING;
        }
        if (this.cannotHoldMoreItems()) {
            this.alreadyKept = new ArrayList<ItemStorage>();
            this.currentSlot = 0;
            return AIWorkerState.DUMPING;
        }
        this.worker.getCitizenData().setVisibleStatus(DELIVERING);
        this.worker.getCitizenStatusHandler().setLatestStatus(new ITextComponent[]{new TranslationTextComponent("com.minecolonies.coremod.status.gathering", new Object[0])});
        BlockPos pickupTarget = currentTask.getRequester().getLocation().getInDimensionLocation();
        if (pickupTarget != BlockPos.field_177992_a && !this.worker.isWorkerAtSiteWithMove(pickupTarget, 5)) {
            this.setDelay(20);
            return AIWorkerState.PICKUP;
        }
        Object ownBuilding = this.getOwnBuilding();
        if (ownBuilding == null) {
            return AIWorkerState.START_WORKING;
        }
        IBuilding pickupBuilding = ownBuilding.getColony().getBuildingManager().getBuilding(pickupTarget);
        if (pickupBuilding == null) {
            ((JobDeliveryman)this.job).finishRequest(false);
            return AIWorkerState.START_WORKING;
        }
        if (this.pickupFromBuilding(pickupBuilding)) {
            this.alreadyKept = new ArrayList<ItemStorage>();
            this.currentSlot = 0;
            ((JobDeliveryman)this.job).finishRequest(true);
            if (currentTask.getRequest().getPriority() >= 10) {
                return AIWorkerState.DUMPING;
            }
            return AIWorkerState.START_WORKING;
        }
        ++this.currentSlot;
        return AIWorkerState.PICKUP;
    }

    private boolean pickupFromBuilding(@NotNull IBuilding building) {
        if (this.cannotHoldMoreItems()) {
            return false;
        }
        IItemHandler handler = (IItemHandler)building.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null).orElseGet(null);
        if (handler == null) {
            return false;
        }
        if (this.currentSlot >= handler.getSlots()) {
            return true;
        }
        ItemStack stack = handler.getStackInSlot(this.currentSlot);
        if (stack.func_190926_b()) {
            return false;
        }
        int amount = EntityAIWorkDeliveryman.workerRequiresItem(building, stack, this.alreadyKept);
        if (amount <= 0 || building instanceof BuildingCook && ItemStackUtils.CAN_EAT.test(stack)) {
            return false;
        }
        if (ItemStackUtils.isEmpty(handler.getStackInSlot(this.currentSlot)).booleanValue()) {
            return false;
        }
        if (InventoryUtils.openSlotCount((IItemHandler)this.worker.getInventoryCitizen()) <= 0L) {
            return true;
        }
        ItemStack activeStack = handler.extractItem(this.currentSlot, amount, false);
        InventoryUtils.transferItemStackIntoNextBestSlotInItemHandler(activeStack, (IItemHandler)this.worker.getInventoryCitizen());
        building.markDirty();
        this.worker.decreaseSaturationForContinuousAction();
        this.worker.getCitizenExperienceHandler().addExperience(0.01);
        this.worker.getCitizenItemHandler().setHeldItem(Hand.MAIN_HAND, 0);
        return false;
    }

    private boolean cannotHoldMoreItems() {
        if (((BuildingDeliveryman)this.getOwnBuilding()).getBuildingLevel() >= ((BuildingDeliveryman)this.getOwnBuilding()).getMaxBuildingLevel()) {
            return false;
        }
        return (double)InventoryUtils.getAmountOfStacksInItemHandler((IItemHandler)this.worker.getInventoryCitizen()) >= Math.pow(2.0, (double)((BuildingDeliveryman)this.getOwnBuilding()).getBuildingLevel() - 1.0) + 1.0;
    }

    public static int workerRequiresItem(IBuilding building, ItemStack stack, List<ItemStorage> localAlreadyKept) {
        return building.buildingRequiresCertainAmountOfItem(stack, localAlreadyKept, false);
    }

    private IAIState dump() {
        this.worker.getCitizenStatusHandler().setLatestStatus(new ITextComponent[]{new TranslationTextComponent("com.minecolonies.coremod.status.dumping", new Object[0])});
        if (!this.worker.isWorkerAtSiteWithMove(this.getAndCheckWareHouse().getPosition(), 5)) {
            this.setDelay(20);
            return AIWorkerState.DUMPING;
        }
        this.getAndCheckWareHouse().getTileEntity().dumpInventoryIntoWareHouse(this.worker.getInventoryCitizen());
        this.worker.getCitizenItemHandler().setHeldItem(Hand.MAIN_HAND, 0);
        return AIWorkerState.START_WORKING;
    }

    @Nullable
    private IWareHouse getAndCheckWareHouse() {
        ArrayList<IWareHouse> wareHouses = new ArrayList<IWareHouse>(((JobDeliveryman)this.job).getColony().getBuildingManager().getWareHouses());
        wareHouses.sort((wh1, wh2) -> (int)(wh1.getPosition().func_177951_i((Vec3i)((BuildingDeliveryman)this.getOwnBuilding()).getPosition()) - wh2.getPosition().func_177951_i((Vec3i)((BuildingDeliveryman)this.getOwnBuilding()).getPosition())));
        for (IWareHouse wareHouse : wareHouses) {
            wareHouse.unregisterFromWareHouse((IBuildingDeliveryman)this.getOwnBuilding());
        }
        for (IWareHouse wareHouse : wareHouses) {
            if (!wareHouse.registerWithWareHouse((IBuildingDeliveryman)this.getOwnBuilding())) continue;
            return wareHouse;
        }
        return null;
    }

    private IAIState deliver() {
        IRequest<IDeliverymanRequestable> currentTask = ((JobDeliveryman)this.job).getCurrentTask();
        if (!(currentTask instanceof StandardRequests.DeliveryRequest)) {
            return AIWorkerState.DUMPING;
        }
        this.worker.getCitizenData().setVisibleStatus(DELIVERING);
        this.worker.getCitizenStatusHandler().setLatestStatus(new ITextComponent[]{new TranslationTextComponent("com.minecolonies.coremod.status.delivering", new Object[0])});
        ILocation targetBuildingLocation = ((Delivery)currentTask.getRequest()).getTarget();
        if (!targetBuildingLocation.isReachableFromLocation(this.worker.getLocation())) {
            Log.getLogger().info(this.worker.getCitizenColonyHandler().getColony().getName() + ": " + this.worker.func_200200_C_() + ": Can't inter dimension yet: ");
            return AIWorkerState.START_WORKING;
        }
        if (!this.worker.isWorkerAtSiteWithMove(targetBuildingLocation.getInDimensionLocation(), 5)) {
            this.setDelay(20);
            return AIWorkerState.DELIVERY;
        }
        TileEntity tileEntity = this.world.func_175625_s(targetBuildingLocation.getInDimensionLocation());
        if (!(tileEntity instanceof TileEntityColonyBuilding)) {
            ((JobDeliveryman)this.job).finishRequest(true);
            return AIWorkerState.START_WORKING;
        }
        IBuildingContainer targetBuilding = ((AbstractTileEntityColonyBuilding)tileEntity).getBuilding();
        boolean success = true;
        boolean extracted = false;
        InventoryCitizen workerInventory = this.worker.getInventoryCitizen();
        for (int i = 0; i < workerInventory.getSlots(); ++i) {
            ItemStack stack = workerInventory.extractItem(i, Integer.MAX_VALUE, false);
            if (ItemStackUtils.isEmpty(stack).booleanValue()) continue;
            extracted = true;
            ItemStack insertionResultStack = targetBuilding instanceof AbstractBuildingWorker ? InventoryUtils.forceItemStackToItemHandler((IItemHandler)targetBuilding.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null).orElseGet(null), stack, ((IBuildingWorker)targetBuilding)::isItemStackInRequest) : InventoryUtils.forceItemStackToItemHandler((IItemHandler)targetBuilding.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null).orElseGet(null), stack, itemStack -> true);
            if (ItemStackUtils.isEmpty(insertionResultStack).booleanValue()) continue;
            if (ItemStack.func_77989_b((ItemStack)insertionResultStack, (ItemStack)stack) && this.worker.getCitizenData() != null) {
                success = false;
                if (targetBuilding instanceof AbstractBuildingWorker) {
                    this.worker.getCitizenData().triggerInteraction(new PosBasedInteraction((ITextComponent)new TranslationTextComponent("com.minecolonies.coremod.job.deliveryman.namedworkerchestfull", new Object[]{targetBuilding.getMainCitizen().getName()}), ChatPriority.IMPORTANT, (ITextComponent)new TranslationTextComponent("com.minecolonies.coremod.job.deliveryman.workerchestfull", new Object[0]), targetBuilding.getID()));
                } else {
                    this.worker.getCitizenData().triggerInteraction(new PosBasedInteraction((ITextComponent)new TranslationTextComponent("com.minecolonies.coremod.job.deliveryman.workerchestfull", new Object[]{new StringTextComponent(" :" + targetBuilding.getSchematicName())}), ChatPriority.IMPORTANT, (ITextComponent)new TranslationTextComponent("com.minecolonies.coremod.job.deliveryman.workerchestfull", new Object[0]), targetBuildingLocation.getInDimensionLocation()));
                }
            }
            workerInventory.insertItem(i, insertionResultStack, false);
        }
        if (!extracted) {
            this.worker.decreaseSaturationForContinuousAction();
            this.worker.getCitizenItemHandler().setHeldItem(Hand.MAIN_HAND, 0);
            ((JobDeliveryman)this.job).finishRequest(false);
            return AIWorkerState.START_WORKING;
        }
        this.worker.getCitizenExperienceHandler().addExperience(1.0);
        this.worker.decreaseSaturationForContinuousAction();
        this.worker.getCitizenItemHandler().setHeldItem(Hand.MAIN_HAND, 0);
        ((JobDeliveryman)this.job).finishRequest(true);
        return success ? AIWorkerState.START_WORKING : AIWorkerState.DUMPING;
    }

    private IAIState prepareDelivery() {
        IRequest<IDeliverymanRequestable> currentTask = ((JobDeliveryman)this.job).getCurrentTask();
        if (!(currentTask instanceof StandardRequests.DeliveryRequest)) {
            return AIWorkerState.START_WORKING;
        }
        List<IRequest<? extends Delivery>> taskList = ((JobDeliveryman)this.job).getTaskListWithSameDestination(currentTask);
        ArrayList<ItemStack> alreadyInInv = new ArrayList<ItemStack>();
        Delivery nextPickUp = null;
        int parallelDeliveryCount = 0;
        for (IRequest<? extends Delivery> task : taskList) {
            ++parallelDeliveryCount;
            int totalCount = InventoryUtils.getItemCountInItemHandler((IItemHandler)this.worker.getInventoryCitizen(), itemStack -> ItemStackUtils.compareItemStacksIgnoreStackSize(((Delivery)task.getRequest()).getStack(), itemStack));
            int hasCount = 0;
            for (ItemStack stack : alreadyInInv) {
                if (!ItemStackUtils.compareItemStacksIgnoreStackSize(stack, task.getRequest().getStack()).booleanValue()) continue;
                hasCount += stack.func_190916_E();
            }
            if (totalCount < hasCount + task.getRequest().getStack().func_190916_E()) {
                nextPickUp = task.getRequest();
                break;
            }
            alreadyInInv.add(task.getRequest().getStack());
        }
        if (nextPickUp == null || (double)parallelDeliveryCount > 1.0 + (double)this.getSecondarySkillLevel() / 5.0) {
            ((JobDeliveryman)this.job).setParallelDeliveries(parallelDeliveryCount - 1);
            return AIWorkerState.DELIVERY;
        }
        ILocation location = nextPickUp.getStart();
        if (!location.isReachableFromLocation(this.worker.getLocation())) {
            ((JobDeliveryman)this.job).finishRequest(false);
            return AIWorkerState.START_WORKING;
        }
        if (this.walkToBlock(location.getInDimensionLocation())) {
            return AIWorkerState.PREPARE_DELIVERY;
        }
        TileEntity tileEntity = this.world.func_175625_s(location.getInDimensionLocation());
        if (tileEntity instanceof ChestTileEntity && !(tileEntity instanceof TileEntityColonyBuilding)) {
            if (((ChestTileEntity)tileEntity).field_145987_o == 0) {
                this.world.func_175641_c(tileEntity.func_174877_v(), tileEntity.func_195044_w().func_177230_c(), 1, 1);
                this.world.func_195593_d(tileEntity.func_174877_v(), tileEntity.func_195044_w().func_177230_c());
                this.world.func_195593_d(tileEntity.func_174877_v().func_177977_b(), tileEntity.func_195044_w().func_177230_c());
                return AIWorkerState.PREPARE_DELIVERY;
            }
            this.world.func_175641_c(tileEntity.func_174877_v(), tileEntity.func_195044_w().func_177230_c(), 1, 0);
            this.world.func_195593_d(tileEntity.func_174877_v(), tileEntity.func_195044_w().func_177230_c());
            this.world.func_195593_d(tileEntity.func_174877_v().func_177977_b(), tileEntity.func_195044_w().func_177230_c());
        }
        if (this.gatherIfInTileEntity(tileEntity, nextPickUp.getStack())) {
            return AIWorkerState.PREPARE_DELIVERY;
        }
        if (parallelDeliveryCount > 1) {
            ((JobDeliveryman)this.job).setParallelDeliveries(parallelDeliveryCount - 1);
            return AIWorkerState.DELIVERY;
        }
        ((JobDeliveryman)this.job).finishRequest(false);
        return AIWorkerState.START_WORKING;
    }

    public boolean gatherIfInTileEntity(TileEntity entity, ItemStack is) {
        return is != null && InventoryFunctions.matchFirstInProviderWithAction((ICapabilityProvider)entity, stack -> ItemStackUtils.isEmpty(stack) == false && ItemStackUtils.compareItemStacksIgnoreStackSize(is, stack, true, true, true), (provider, index) -> InventoryUtils.transferXOfItemStackIntoNextFreeSlotFromProvider(provider, index, is.func_190916_E(), (IItemHandler)this.worker.getInventoryCitizen()));
    }

    private IAIState decide() {
        this.worker.getCitizenData().setVisibleStatus(VisibleCitizenStatus.WORKING);
        IRequest<IDeliverymanRequestable> currentTask = ((JobDeliveryman)this.job).getCurrentTask();
        if (currentTask == null) {
            if (!this.worker.isWorkerAtSiteWithMove(this.getAndCheckWareHouse().getPosition(), 5)) {
                this.setDelay(20);
                return AIWorkerState.START_WORKING;
            }
            if (!this.worker.getInventoryCitizen().isEmpty()) {
                return AIWorkerState.DUMPING;
            }
            return AIWorkerState.START_WORKING;
        }
        if (currentTask instanceof StandardRequests.DeliveryRequest) {
            if (!this.worker.getInventoryCitizen().isEmpty()) {
                return AIWorkerState.DUMPING;
            }
            return AIWorkerState.PREPARE_DELIVERY;
        }
        return AIWorkerState.PICKUP;
    }

    private boolean checkIfExecute() {
        IWareHouse wareHouse = this.getAndCheckWareHouse();
        if (wareHouse != null && wareHouse.getTileEntity() != null) {
            ((JobDeliveryman)this.job).setActive(true);
            return true;
        }
        ((JobDeliveryman)this.job).setActive(false);
        if (this.worker.getCitizenData() != null) {
            this.worker.getCitizenData().triggerInteraction(new StandardInteraction((ITextComponent)new TranslationTextComponent("com.minecolonies.coremod.job.deliveryman.nowarehouse", new Object[0]), ChatPriority.BLOCKING));
        }
        return false;
    }
}

