/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity.ai.citizen.enchanter;

import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.interactionhandling.ChatPriority;
import com.minecolonies.api.entity.ai.statemachine.AITarget;
import com.minecolonies.api.entity.ai.statemachine.states.AIWorkerState;
import com.minecolonies.api.entity.ai.statemachine.states.IAIState;
import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import com.minecolonies.api.entity.citizen.Skill;
import com.minecolonies.api.items.ModItems;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.api.util.Tuple;
import com.minecolonies.coremod.Network;
import com.minecolonies.coremod.colony.buildings.AbstractBuildingWorker;
import com.minecolonies.coremod.colony.buildings.workerbuildings.BuildingEnchanter;
import com.minecolonies.coremod.colony.interactionhandling.StandardInteraction;
import com.minecolonies.coremod.colony.jobs.JobEnchanter;
import com.minecolonies.coremod.entity.ai.basic.AbstractEntityAIInteract;
import com.minecolonies.coremod.network.messages.client.CircleParticleEffectMessage;
import com.minecolonies.coremod.network.messages.client.StreamParticleEffectMessage;
import com.minecolonies.coremod.util.WorkerUtil;
import java.util.ArrayList;
import java.util.Optional;
import java.util.Random;
import java.util.function.Predicate;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;

public class EntityAIWorkEnchanter
extends AbstractEntityAIInteract<JobEnchanter, BuildingEnchanter> {
    private static final Predicate<ItemStack> IS_ANCIENT_TOME = item -> !item.func_190926_b() && item.func_77973_b() == ModItems.ancientTome;
    private static final Predicate<ItemStack> IS_BOOK = item -> !item.func_190926_b() && item.func_77973_b() == Items.field_151122_aG;
    private static final long MIN_DISTANCE_TO_DRAIN = 5L;
    private static final int MAX_PROGRESS_TICKS = 60;
    private static final int MAX_ENCHANTMENT_TICKS = 300;
    private static final int MANA_REQ_PER_LEVEL = 10;
    private ICitizenData citizenToGatherFrom = null;
    private int progressTicks = 0;

    public EntityAIWorkEnchanter(@NotNull JobEnchanter job) {
        super(job);
        super.registerTargets(new AITarget((IAIState)AIWorkerState.IDLE, AIWorkerState.START_WORKING, 20), new AITarget((IAIState)AIWorkerState.START_WORKING, AIWorkerState.DECIDE, 20), new AITarget((IAIState)AIWorkerState.DECIDE, this::decide, 20), new AITarget((IAIState)AIWorkerState.ENCHANTER_DRAIN, this::gatherAndDrain, 10), new AITarget((IAIState)AIWorkerState.ENCHANT, this::enchant, 20));
        this.worker.func_98053_h(true);
    }

    private IAIState decide() {
        this.worker.func_184611_a(Hand.MAIN_HAND, ItemStack.field_190927_a);
        if (this.walkToBuilding()) {
            return AIWorkerState.DECIDE;
        }
        if (this.getPrimarySkillLevel() < ((BuildingEnchanter)this.getOwnBuilding()).getBuildingLevel() * 10) {
            BuildingEnchanter enchanterBuilding = (BuildingEnchanter)this.getOwnBuilding();
            if (enchanterBuilding.getBuildingsToGatherFrom().isEmpty()) {
                if (this.worker.getCitizenData() != null) {
                    this.worker.getCitizenData().triggerInteraction(new StandardInteraction((ITextComponent)new TranslationTextComponent("com.minecolonies.coremod.enchanter.nodrainingsset", new Object[0]), ChatPriority.BLOCKING));
                }
                return AIWorkerState.IDLE;
            }
            int booksInInv = InventoryUtils.getItemCountInItemHandler((IItemHandler)this.worker.getInventoryCitizen(), IS_BOOK);
            if (booksInInv <= 0) {
                int numberOfBooksInBuilding = InventoryUtils.getItemCountInProvider(this.getOwnBuilding(), IS_BOOK);
                if (numberOfBooksInBuilding > 0) {
                    this.needsCurrently = new Tuple<Predicate<ItemStack>, Integer>(IS_BOOK, 1);
                    return AIWorkerState.GATHERING_REQUIRED_MATERIALS;
                }
                this.checkIfRequestForItemExistOrCreateAsynch(new ItemStack((IItemProvider)Items.field_151122_aG, 1));
                return AIWorkerState.IDLE;
            }
            BlockPos posToDrainFrom = enchanterBuilding.getRandomBuildingToDrainFrom();
            if (posToDrainFrom == null) {
                return AIWorkerState.IDLE;
            }
            ((JobEnchanter)this.job).setBuildingToDrainFrom(posToDrainFrom);
            return AIWorkerState.ENCHANTER_DRAIN;
        }
        int ancientTomesInInv = InventoryUtils.getItemCountInItemHandler((IItemHandler)this.worker.getInventoryCitizen(), IS_ANCIENT_TOME);
        if (ancientTomesInInv <= 0) {
            int amountOfAncientTomes = InventoryUtils.getItemCountInProvider(this.getOwnBuilding(), IS_ANCIENT_TOME);
            if (amountOfAncientTomes > 0) {
                this.needsCurrently = new Tuple<Predicate<ItemStack>, Integer>(IS_ANCIENT_TOME, 1);
                return AIWorkerState.GATHERING_REQUIRED_MATERIALS;
            }
            this.checkIfRequestForItemExistOrCreateAsynch(new ItemStack((IItemProvider)ModItems.ancientTome, 1));
            return AIWorkerState.IDLE;
        }
        return AIWorkerState.ENCHANT;
    }

    @Override
    protected int getActionsDoneUntilDumping() {
        return 1;
    }

    private IAIState enchant() {
        ICitizenData data;
        int ancientTomesInInv = InventoryUtils.getItemCountInItemHandler((IItemHandler)this.worker.getInventoryCitizen(), IS_ANCIENT_TOME);
        if (ancientTomesInInv < 1) {
            return AIWorkerState.DECIDE;
        }
        if (this.progressTicks++ < 300 / ((BuildingEnchanter)this.getOwnBuilding()).getBuildingLevel()) {
            Network.getNetwork().sendToTrackingEntity(new CircleParticleEffectMessage(this.worker.func_174791_d().func_72441_c(0.0, 2.0, 0.0), ParticleTypes.field_197623_p, this.progressTicks), (Entity)this.worker);
            Network.getNetwork().sendToTrackingEntity(new CircleParticleEffectMessage(this.worker.func_174791_d().func_72441_c(0.0, 1.5, 0.0), ParticleTypes.field_197623_p, this.progressTicks), (Entity)this.worker);
            Network.getNetwork().sendToTrackingEntity(new CircleParticleEffectMessage(this.worker.func_174791_d().func_72441_c(0.0, 1.0, 0.0), ParticleTypes.field_197623_p, this.progressTicks), (Entity)this.worker);
            if (this.worker.getRandom().nextBoolean()) {
                this.worker.func_184609_a(Hand.MAIN_HAND);
            } else {
                this.worker.func_184609_a(Hand.OFF_HAND);
            }
            return this.getState();
        }
        int slot = InventoryUtils.findFirstSlotInItemHandlerWith((IItemHandler)this.worker.getInventoryCitizen(), IS_ANCIENT_TOME);
        if (slot != -1 && (data = this.worker.getCitizenData()) != null) {
            int openSlot = InventoryUtils.getFirstOpenSlotFromItemHandler((IItemHandler)this.worker.getInventoryCitizen());
            if (openSlot == -1) {
                this.incrementActionsDone();
                this.progressTicks = 0;
                return AIWorkerState.IDLE;
            }
            Tuple<ItemStack, Integer> tuple = IColonyManager.getInstance().getCompatibilityManager().getRandomEnchantmentBook(((BuildingEnchanter)this.getOwnBuilding()).getBuildingLevel());
            data.getCitizenSkillHandler().incrementLevel(Skill.Mana, -tuple.getB().intValue());
            this.worker.getCitizenExperienceHandler().updateLevel();
            this.worker.getInventoryCitizen().setStackInSlot(openSlot, tuple.getA());
            InventoryUtils.reduceStackInItemHandler((IItemHandler)this.worker.getInventoryCitizen(), new ItemStack((IItemProvider)ModItems.ancientTome));
            this.incrementActionsDoneAndDecSaturation();
        }
        this.progressTicks = 0;
        return AIWorkerState.IDLE;
    }

    private IAIState gatherAndDrain() {
        if (((JobEnchanter)this.job).getPosToDrainFrom() == null) {
            return AIWorkerState.IDLE;
        }
        if (this.walkToBlock(((JobEnchanter)this.job).getPosToDrainFrom())) {
            return this.getState();
        }
        AbstractBuildingWorker buildingWorker = ((BuildingEnchanter)this.getOwnBuilding()).getColony().getBuildingManager().getBuilding(((JobEnchanter)this.job).getPosToDrainFrom(), AbstractBuildingWorker.class);
        if (buildingWorker == null) {
            this.resetDraining();
            ((BuildingEnchanter)this.getOwnBuilding()).removeWorker(((JobEnchanter)this.job).getPosToDrainFrom());
            return AIWorkerState.IDLE;
        }
        if (this.citizenToGatherFrom == null) {
            AbstractEntityCitizen citizen;
            ArrayList workers = new ArrayList();
            for (Optional<AbstractEntityCitizen> citizen2 : buildingWorker.getAssignedEntities()) {
                citizen2.ifPresent(workers::add);
            }
            if (workers.size() > 1) {
                citizen = (AbstractEntityCitizen)workers.get(this.worker.getRandom().nextInt(workers.size()));
            } else {
                if (workers.isEmpty()) {
                    this.resetDraining();
                    return AIWorkerState.DECIDE;
                }
                citizen = (AbstractEntityCitizen)workers.get(0);
            }
            this.citizenToGatherFrom = citizen.getCitizenData();
            this.progressTicks = 0;
            return this.getState();
        }
        if (!this.citizenToGatherFrom.getEntity().isPresent()) {
            this.citizenToGatherFrom = null;
            return this.getState();
        }
        if (this.progressTicks == 0 && BlockPosUtil.getDistance2D(this.citizenToGatherFrom.getEntity().get().func_180425_c(), this.worker.func_180425_c()) > 5L) {
            if (!((JobEnchanter)this.job).incrementWaitingTicks()) {
                this.resetDraining();
                return AIWorkerState.DECIDE;
            }
            return this.getState();
        }
        ++this.progressTicks;
        if (this.progressTicks < 60) {
            Vec3d start = this.worker.func_174791_d().func_72441_c(0.0, 2.0, 0.0);
            Vec3d goal = this.citizenToGatherFrom.getEntity().get().func_174791_d().func_72441_c(0.0, 2.0, 0.0);
            Network.getNetwork().sendToTrackingEntity(new StreamParticleEffectMessage(start, goal, ParticleTypes.field_197623_p, this.progressTicks % 60, 60), (Entity)this.worker);
            Network.getNetwork().sendToTrackingEntity(new CircleParticleEffectMessage(start, ParticleTypes.field_197632_y, this.progressTicks), (Entity)this.worker);
            WorkerUtil.faceBlock(new BlockPos(goal), this.worker);
            if (this.worker.getRandom().nextBoolean()) {
                this.worker.func_184609_a(Hand.MAIN_HAND);
            } else {
                this.worker.func_184609_a(Hand.OFF_HAND);
            }
            return this.getState();
        }
        int bookSlot = InventoryUtils.findFirstSlotInItemHandlerWith((IItemHandler)this.worker.getInventoryCitizen(), Items.field_151122_aG);
        if (bookSlot != -1) {
            int size = this.citizenToGatherFrom.getInventory().getSlots();
            int attempts = (int)((double)this.getSecondarySkillLevel() / 5.0);
            for (int i = 0; i < attempts; ++i) {
                int randomSlot = this.worker.getRandom().nextInt(size);
                ItemStack stack = this.citizenToGatherFrom.getInventory().getStackInSlot(randomSlot);
                if (stack.func_190926_b() || !stack.func_77956_u()) continue;
                EnchantmentHelper.func_77504_a((Random)this.worker.getRandom(), (ItemStack)stack, (int)(this.getSecondarySkillLevel() > 50 ? 2 : 1), (boolean)false);
                break;
            }
            this.worker.getInventoryCitizen().extractItem(bookSlot, 1, false);
            this.worker.getCitizenData().getCitizenSkillHandler().incrementLevel(Skill.Mana, 1);
            this.worker.getCitizenData().markDirty();
        }
        this.resetDraining();
        return AIWorkerState.IDLE;
    }

    private void resetDraining() {
        ((BuildingEnchanter)this.getOwnBuilding()).setAsGathered(((JobEnchanter)this.job).getPosToDrainFrom());
        this.citizenToGatherFrom = null;
        ((JobEnchanter)this.job).setBuildingToDrainFrom(null);
        this.progressTicks = 0;
        this.incrementActionsDoneAndDecSaturation();
    }

    @Override
    public Class<BuildingEnchanter> getExpectedBuildingClass() {
        return BuildingEnchanter.class;
    }
}

