/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity.ai.citizen.florist;

import com.minecolonies.api.colony.interactionhandling.ChatPriority;
import com.minecolonies.api.entity.ai.statemachine.AITarget;
import com.minecolonies.api.entity.ai.statemachine.states.AIWorkerState;
import com.minecolonies.api.entity.ai.statemachine.states.IAIState;
import com.minecolonies.api.entity.citizen.VisibleCitizenStatus;
import com.minecolonies.api.items.ModItems;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.Tuple;
import com.minecolonies.api.util.WorldUtil;
import com.minecolonies.coremod.colony.buildings.workerbuildings.BuildingFlorist;
import com.minecolonies.coremod.colony.interactionhandling.StandardInteraction;
import com.minecolonies.coremod.colony.jobs.JobFlorist;
import com.minecolonies.coremod.entity.ai.basic.AbstractEntityAIInteract;
import com.minecolonies.coremod.tileentities.TileEntityCompostedDirt;
import com.minecolonies.coremod.util.WorkerUtil;
import java.util.function.Predicate;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IWorld;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EntityAIWorkFlorist
extends AbstractEntityAIInteract<JobFlorist, BuildingFlorist> {
    private static final long MAX_DISTANCE = 50L;
    private static final int HARVEST_ACTIONS_TO_DUMP = 10;
    private static final double PERCENT_CHANGE_FOR_GROWTH = 0.5;
    private static final double BASE_XP_GAIN = 0.5;
    private static final int COMPOST_REQUEST_QTY = 16;
    private static final int BASE_BLOCK_MINING_DELAY = 10;
    private static final double PER_LEVEL_BONUS = 0.1;
    private static final double MAX_BONUS = 5.0;
    private static final VisibleCitizenStatus GARDENING = new VisibleCitizenStatus(new ResourceLocation("minecolonies", "textures/icons/work/florist.png"), "com.minecolonies.gui.visiblestatus.florist");
    private BlockPos harvestPosition;
    private BlockPos compostPosition;

    public EntityAIWorkFlorist(@NotNull JobFlorist job) {
        super(job);
        super.registerTargets(new AITarget((IAIState)AIWorkerState.IDLE, AIWorkerState.START_WORKING, 1), new AITarget((IAIState)AIWorkerState.START_WORKING, AIWorkerState.DECIDE, 20), new AITarget((IAIState)AIWorkerState.DECIDE, this::decide, 20), new AITarget((IAIState)AIWorkerState.FLORIST_HARVEST, this::harvest, 20), new AITarget((IAIState)AIWorkerState.FLORIST_COMPOST, this::compost, 20));
        this.worker.func_98053_h(true);
    }

    private IAIState decide() {
        this.worker.getCitizenData().setVisibleStatus(VisibleCitizenStatus.WORKING);
        if (((BuildingFlorist)this.getOwnBuilding()).getPlantGround().isEmpty()) {
            this.worker.getCitizenData().triggerInteraction(new StandardInteraction((ITextComponent)new TranslationTextComponent("com.minecolonies.coremod.florist.noplantground", new Object[0]), ChatPriority.BLOCKING));
            return AIWorkerState.IDLE;
        }
        this.worker.func_184611_a(Hand.MAIN_HAND, ItemStack.field_190927_a);
        long distance = BlockPosUtil.getDistance2D(this.worker.func_180425_c(), ((BuildingFlorist)this.getOwnBuilding()).getPosition());
        if (distance > 50L && this.walkToBuilding()) {
            return AIWorkerState.DECIDE;
        }
        int amountOfCompostInInv = InventoryUtils.getItemCountInItemHandler((IItemHandler)this.worker.getInventoryCitizen(), ItemStackUtils.IS_COMPOST);
        if (amountOfCompostInInv <= 0) {
            int amountOfCompostInBuilding = InventoryUtils.getItemCountInProvider(this.getOwnBuilding(), ItemStackUtils.IS_COMPOST);
            if (amountOfCompostInBuilding > 0) {
                this.needsCurrently = new Tuple<Predicate<ItemStack>, Integer>(ItemStackUtils.IS_COMPOST, 64);
                return AIWorkerState.GATHERING_REQUIRED_MATERIALS;
            }
            this.checkIfRequestForItemExistOrCreateAsynch(new ItemStack((IItemProvider)ModItems.compost, 16));
        }
        this.harvestPosition = this.areThereFlowersToGather();
        if (this.harvestPosition != null) {
            return AIWorkerState.FLORIST_HARVEST;
        }
        if (amountOfCompostInInv <= 0) {
            if (!WorkerUtil.isThereCompostedLand((BuildingFlorist)this.getOwnBuilding(), this.world)) {
                this.worker.getCitizenData().triggerInteraction(new StandardInteraction((ITextComponent)new TranslationTextComponent("com.minecolonies.coremod.florist.nocompost", new Object[0]), ChatPriority.BLOCKING));
                return AIWorkerState.START_WORKING;
            }
            return AIWorkerState.DECIDE;
        }
        this.compostPosition = this.getFirstNotCompostedLand();
        return AIWorkerState.FLORIST_COMPOST;
    }

    private IAIState compost() {
        if (this.compostPosition == null) {
            return AIWorkerState.START_WORKING;
        }
        this.worker.getCitizenData().setVisibleStatus(GARDENING);
        if (this.walkToBlock(this.compostPosition)) {
            return this.getState();
        }
        TileEntity entity = this.world.func_175625_s(this.compostPosition);
        if (entity instanceof TileEntityCompostedDirt) {
            ItemStack stack = ((BuildingFlorist)this.getOwnBuilding()).getFlowerToGrow();
            if (stack != null) {
                if (this.worker.getRandom().nextInt(200 - this.getPrimarySkillLevel()) < 0 || InventoryUtils.shrinkItemCountInItemHandler((IItemHandler)this.worker.getInventoryCitizen(), ItemStackUtils.IS_COMPOST)) {
                    ((TileEntityCompostedDirt)entity).compost(0.5, ((BuildingFlorist)this.getOwnBuilding()).getFlowerToGrow());
                }
            } else {
                this.worker.getCitizenData().triggerInteraction(new StandardInteraction((ITextComponent)new TranslationTextComponent("com.minecolonies.coremod.florist.noflowers", new Object[0]), ChatPriority.BLOCKING));
            }
        }
        this.worker.getCitizenExperienceHandler().addExperience(0.5);
        this.incrementActionsDone();
        this.worker.decreaseSaturationForContinuousAction();
        this.compostPosition = null;
        return AIWorkerState.START_WORKING;
    }

    private IAIState harvest() {
        if (this.harvestPosition == null) {
            return AIWorkerState.START_WORKING;
        }
        this.worker.getCitizenData().setVisibleStatus(GARDENING);
        if (this.walkToBlock(this.harvestPosition)) {
            return this.getState();
        }
        if (!this.mineBlock(this.harvestPosition)) {
            return this.getState();
        }
        this.worker.getCitizenExperienceHandler().addExperience(0.5);
        this.incrementActionsDone();
        this.worker.decreaseSaturationForContinuousAction();
        this.harvestPosition = null;
        return AIWorkerState.START_WORKING;
    }

    @Override
    protected int getActionsDoneUntilDumping() {
        return 10 * ((BuildingFlorist)this.getOwnBuilding()).getBuildingLevel();
    }

    @Override
    public int getBlockMiningDelay(@NotNull Block block, @NotNull BlockPos pos) {
        return 10 * (int)(1.0 + Math.max(0.0, 5.0 - 0.1 * ((double)this.getSecondarySkillLevel() / 2.0)));
    }

    @Nullable
    private BlockPos areThereFlowersToGather() {
        for (BlockPos pos : ((BuildingFlorist)this.getOwnBuilding()).getPlantGround()) {
            if (this.world.func_175623_d(pos.func_177984_a())) continue;
            return pos.func_177984_a();
        }
        return null;
    }

    private BlockPos getFirstNotCompostedLand() {
        for (BlockPos pos : ((BuildingFlorist)this.getOwnBuilding()).getPlantGround()) {
            if (!WorldUtil.isEntityBlockLoaded((IWorld)this.world, pos)) continue;
            TileEntity entity = this.world.func_175625_s(pos);
            if (entity instanceof TileEntityCompostedDirt) {
                if (((TileEntityCompostedDirt)entity).isComposted()) continue;
                return pos;
            }
            ((BuildingFlorist)this.getOwnBuilding()).removePlantableGround(pos);
        }
        return null;
    }

    @Override
    public Class<BuildingFlorist> getExpectedBuildingClass() {
        return BuildingFlorist.class;
    }
}

