/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity.ai.citizen.guard;

import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.buildings.IGuardBuilding;
import com.minecolonies.api.colony.buildings.views.MobEntryView;
import com.minecolonies.api.colony.guardtype.registry.ModGuardTypes;
import com.minecolonies.api.colony.permissions.Action;
import com.minecolonies.api.colony.requestsystem.location.ILocation;
import com.minecolonies.api.entity.ModEntities;
import com.minecolonies.api.entity.ai.citizen.guards.GuardTask;
import com.minecolonies.api.entity.ai.statemachine.AIEventTarget;
import com.minecolonies.api.entity.ai.statemachine.AIOneTimeEventTarget;
import com.minecolonies.api.entity.ai.statemachine.AITarget;
import com.minecolonies.api.entity.ai.statemachine.states.AIBlockingEventType;
import com.minecolonies.api.entity.ai.statemachine.states.AIWorkerState;
import com.minecolonies.api.entity.ai.statemachine.states.IAIState;
import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import com.minecolonies.api.entity.citizen.Skill;
import com.minecolonies.api.entity.mobs.AbstractEntityMinecoloniesMob;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.api.util.constant.Constants;
import com.minecolonies.api.util.constant.ToolType;
import com.minecolonies.coremod.Network;
import com.minecolonies.coremod.colony.buildings.AbstractBuildingGuards;
import com.minecolonies.coremod.colony.jobs.AbstractJobGuard;
import com.minecolonies.coremod.entity.SittingEntity;
import com.minecolonies.coremod.entity.ai.basic.AbstractEntityAIFight;
import com.minecolonies.coremod.entity.citizen.EntityCitizen;
import com.minecolonies.coremod.network.messages.client.SleepingParticleMessage;
import com.minecolonies.coremod.research.AdditionModifierResearchEffect;
import com.minecolonies.coremod.research.MultiplierModifierResearchEffect;
import com.minecolonies.coremod.research.UnlockAbilityResearchEffect;
import com.minecolonies.coremod.util.NamedDamageSource;
import com.minecolonies.coremod.util.TeleportHelper;
import java.lang.ref.WeakReference;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractEntityAIGuard<J extends AbstractJobGuard<J>, B extends AbstractBuildingGuards>
extends AbstractEntityAIFight<J, B> {
    private static final int ACTIONS_UNTIL_DUMPING = 5;
    private static final int MAX_PATROL_DERIVATION = 50;
    private static final int MAX_FOLLOW_DERIVATION = 40;
    private static final int MAX_GUARD_DERIVATION = 10;
    private static final int STOP_PERSECUTION_AFTER = 200;
    private static final double PATROL_DEVIATION_RAID_POINT = 40000.0;
    private static final int TARGET_RANGE_ATTACK_RANGE_BONUS = 18;
    protected static final int COMBAT_TIME = 30;
    protected int currentAttackDelay = 0;
    private int lastSeen = 0;
    protected LivingEntity target = null;
    private BlockPos currentPatrolPoint = null;
    private WeakReference<EntityCitizen> helpCitizen = new WeakReference<Object>(null);
    protected final IGuardBuilding buildingGuards;
    private static final int PARTICLE_INTERVAL = 30;
    private static final int SHOULD_SLEEP_INTERVAL = 200;
    private static final int CHECK_TARGET_INTERVAL = 10;
    private static final int SEARCH_TARGET_INTERVAL = 40;
    private static final int GUARD_TASK_INTERVAL = 100;
    private static final int GUARD_REGEN_INTERVAL = 40;
    private static final int RALLY_SATURATION_LOSS_INTERVAL = 240;
    private static final int ACTION_INCREASE_INTERVAL = 10;
    private int sleepTimer = 0;
    private int wakeTimer = 0;
    protected int fighttimer = 0;
    private WeakReference<EntityCitizen> sleepingGuard = new WeakReference<Object>(null);
    private Random randomGenerator = new Random();
    private int regularActionTimer = 0;

    public AbstractEntityAIGuard(@NotNull J job) {
        super(job);
        super.registerTargets(new AITarget((IAIState)AIWorkerState.DECIDE, this::decide, 100), new AITarget((IAIState)AIWorkerState.GUARD_DECIDE, this::decide, 100), new AITarget(AIWorkerState.GUARD_PATROL, this::shouldSleep, () -> AIWorkerState.GUARD_SLEEP, 200), new AIEventTarget(AIBlockingEventType.STATE_BLOCKING, this::checkAndAttackTarget, 10), new AITarget(AIWorkerState.GUARD_PATROL, () -> this.searchNearbyTarget() != null, this::checkAndAttackTarget, 40), new AITarget((IAIState)AIWorkerState.GUARD_PATROL, this::decide, 100), new AITarget((IAIState)AIWorkerState.GUARD_SLEEP, this::sleep, 1), new AITarget((IAIState)AIWorkerState.GUARD_SLEEP, this::sleepParticles, 30), new AITarget((IAIState)AIWorkerState.GUARD_WAKE, this::wakeUpGuard, 20), new AITarget((IAIState)AIWorkerState.GUARD_FOLLOW, this::decide, 100), new AITarget(AIWorkerState.GUARD_FOLLOW, () -> this.searchNearbyTarget() != null, this::checkAndAttackTarget, 40), new AITarget((IAIState)AIWorkerState.GUARD_RALLY, this::decide, 100), new AITarget(AIWorkerState.GUARD_RALLY, () -> this.searchNearbyTarget() != null, this::checkAndAttackTarget, 40), new AITarget((IAIState)AIWorkerState.GUARD_RALLY, this::decreaseSaturation, 240), new AITarget(AIWorkerState.GUARD_GUARD, this::shouldSleep, () -> AIWorkerState.GUARD_SLEEP, 200), new AITarget((IAIState)AIWorkerState.GUARD_GUARD, this::decide, 100), new AITarget(AIWorkerState.GUARD_GUARD, () -> this.searchNearbyTarget() != null, this::checkAndAttackTarget, 40), new AITarget((IAIState)AIWorkerState.GUARD_REGEN, this::regen, 40), new AITarget((IAIState)AIWorkerState.HELP_CITIZEN, this::helping, 100));
        this.buildingGuards = (IGuardBuilding)this.getOwnBuilding();
    }

    private IAIState wakeUpGuard() {
        if (this.sleepingGuard.get() == null || !(((EntityCitizen)this.sleepingGuard.get()).getCitizenJobHandler().getColonyJob() instanceof AbstractJobGuard) || !((EntityCitizen)this.sleepingGuard.get()).getCitizenJobHandler().getColonyJob(AbstractJobGuard.class).isAsleep()) {
            return AIWorkerState.GUARD_DECIDE;
        }
        ++this.wakeTimer;
        if (this.wakeTimer == 1) {
            return this.getState();
        }
        if (BlockPosUtil.getDistanceSquared(((EntityCitizen)this.sleepingGuard.get()).func_180425_c(), this.worker.func_180425_c()) <= 4L || this.wakeTimer > 10) {
            this.worker.func_184609_a(Hand.OFF_HAND);
            ((EntityCitizen)this.sleepingGuard.get()).func_70097_a(new NamedDamageSource("wakeywakey", (Entity)this.worker).func_76348_h(), 1.0f);
            ((EntityCitizen)this.sleepingGuard.get()).func_70604_c((LivingEntity)this.worker);
            return AIWorkerState.GUARD_DECIDE;
        }
        this.worker.getNavigator().moveToLivingEntity((Entity)this.sleepingGuard.get(), this.getCombatMovementSpeed());
        return this.getState();
    }

    private boolean shouldSleep() {
        if (this.worker.func_70643_av() != null || this.target != null || this.fighttimer > 0) {
            return false;
        }
        double chance = 1.0;
        MultiplierModifierResearchEffect effect = this.worker.getCitizenColonyHandler().getColony().getResearchManager().getResearchEffects().getEffect("Sleep Less", MultiplierModifierResearchEffect.class);
        if (effect != null) {
            chance = 1.0 - effect.getEffect();
        }
        if (this.worker.getRandom().nextInt((int)((double)this.worker.getCitizenData().getCitizenSkillHandler().getLevel(Skill.Adaptability) * 0.5) + 20) == 1 && this.worker.getRandom().nextDouble() < chance) {
            this.sleepTimer = this.worker.getRandom().nextInt(500) + 2500;
            SittingEntity entity = (SittingEntity)ModEntities.SITTINGENTITY.func_200721_a(this.world);
            entity.func_70107_b(this.worker.field_70165_t, this.worker.field_70163_u - 1.0, this.worker.field_70161_v);
            entity.setMaxLifeTime(this.sleepTimer);
            this.world.func_217376_c((Entity)entity);
            this.worker.func_184220_m(entity);
            this.worker.getNavigator().func_75499_g();
            return true;
        }
        return false;
    }

    private IAIState sleepParticles() {
        Network.getNetwork().sendToTrackingEntity(new SleepingParticleMessage(this.worker.field_70165_t, this.worker.field_70163_u + 2.0, this.worker.field_70161_v), (Entity)this.worker);
        if (this.worker.func_110143_aJ() < this.worker.func_110138_aP()) {
            this.worker.func_70606_j(this.worker.func_110143_aJ() + 0.5f);
        }
        return null;
    }

    private IAIState sleep() {
        if (this.worker.func_70643_av() != null || (this.sleepTimer -= this.getTickRate()) < 0) {
            this.stopSleeping();
            return AIWorkerState.GUARD_DECIDE;
        }
        this.worker.func_70671_ap().func_75650_a(this.worker.field_70165_t + (double)this.worker.func_174811_aO().func_82601_c(), this.worker.field_70163_u + (double)this.worker.func_174811_aO().func_96559_d(), this.worker.field_70161_v + (double)this.worker.func_174811_aO().func_82599_e(), 0.0f, 30.0f);
        return null;
    }

    private void stopSleeping() {
        if (this.getState() == AIWorkerState.GUARD_SLEEP) {
            this.resetTarget();
            this.worker.func_70604_c(null);
            this.worker.func_184210_p();
            this.worker.func_70107_b(this.worker.field_70165_t, this.worker.field_70163_u + 1.0, this.worker.field_70161_v);
            this.worker.getCitizenExperienceHandler().addExperience(1.0);
        }
    }

    private IAIState regen() {
        AdditionModifierResearchEffect effect = this.worker.getCitizenColonyHandler().getColony().getResearchManager().getResearchEffects().getEffect("Fleeing Speed", AdditionModifierResearchEffect.class);
        if (effect != null && !this.worker.func_70644_a(Effects.field_76424_c)) {
            this.worker.func_195064_c(new EffectInstance(Effects.field_76424_c, 200, (int)(0.0 + effect.getEffect())));
        }
        if (this.walkToBuilding()) {
            return AIWorkerState.GUARD_REGEN;
        }
        if ((double)this.worker.func_110143_aJ() < (double)((int)this.worker.func_110138_aP()) * 0.75 && this.buildingGuards.shallRetrieveOnLowHealth()) {
            if (!this.worker.func_70644_a(Effects.field_76428_l)) {
                this.worker.func_195064_c(new EffectInstance(Effects.field_76428_l, 200));
            }
            return AIWorkerState.GUARD_REGEN;
        }
        return AIWorkerState.START_WORKING;
    }

    public abstract IAIState getAttackState();

    private IAIState checkAndAttackTarget() {
        if (this.getState() == AIWorkerState.GUARD_SLEEP || this.getState() == AIWorkerState.GUARD_REGEN || this.getState() == AIWorkerState.GUARD_ATTACK_PROTECT || this.getState() == AIWorkerState.GUARD_ATTACK_PHYSICAL || this.getState() == AIWorkerState.GUARD_ATTACK_RANGED) {
            return null;
        }
        if (this.checkForTarget()) {
            if (!this.hasTool()) {
                return AIWorkerState.START_WORKING;
            }
            this.fighttimer = 30;
            this.equipInventoryArmor();
            this.moveInAttackPosition();
            return this.getAttackState();
        }
        if (this.fighttimer > 0) {
            --this.fighttimer;
        }
        return null;
    }

    private IAIState guard() {
        this.guardMovement();
        return AIWorkerState.GUARD_GUARD;
    }

    public void guardMovement() {
        this.worker.isWorkerAtSiteWithMove(this.buildingGuards.getGuardPos(), 3);
    }

    private IAIState follow() {
        if (BlockPosUtil.getDistance2D(this.worker.func_180425_c(), this.buildingGuards.getPositionToFollow()) > 40L) {
            TeleportHelper.teleportCitizen(this.worker, this.worker.func_130014_f_(), this.buildingGuards.getPositionToFollow());
            return AIWorkerState.GUARD_FOLLOW;
        }
        if (this.buildingGuards.isTightGrouping()) {
            this.worker.isWorkerAtSiteWithMove(this.buildingGuards.getPositionToFollow(), 8);
        } else if (!this.isWithinPersecutionDistance(this.buildingGuards.getPositionToFollow())) {
            this.worker.getNavigator().func_75499_g();
            this.worker.func_70605_aq().func_188488_a(0.0f, 0.0f);
        } else {
            this.worker.isWorkerAtSiteWithMove(this.buildingGuards.getPositionToFollow(), 15);
        }
        return AIWorkerState.GUARD_FOLLOW;
    }

    @Override
    protected int getActionsDoneUntilDumping() {
        return 5 * ((AbstractBuildingGuards)this.getOwnBuilding()).getBuildingLevel();
    }

    private IAIState rally(ILocation location) {
        ICitizenData citizenData = this.worker.getCitizenData();
        if (!this.worker.isWorkerAtSiteWithMove(location.getInDimensionLocation().func_177982_a(this.randomGenerator.nextInt(8) - 4, 0, this.randomGenerator.nextInt(8) - 4), 8) && citizenData != null && !this.worker.func_70644_a(Effects.field_76424_c)) {
            this.worker.func_195064_c(new EffectInstance(Effects.field_76424_c, 100, MathHelper.func_76125_a((int)(citizenData.getCitizenSkillHandler().getLevel(Skill.Adaptability) / 20 + 2), (int)2, (int)5), false, false));
        }
        return AIWorkerState.GUARD_RALLY;
    }

    @Override
    protected IAIState startWorkingAtOwnBuilding() {
        ILocation rallyLocation = this.buildingGuards.getRallyLocation();
        if (rallyLocation != null && rallyLocation.isReachableFromLocation(this.worker.getLocation()) || !this.canBeInterrupted()) {
            return AIWorkerState.PREPARING;
        }
        return super.startWorkingAtOwnBuilding();
    }

    protected IAIState decreaseSaturation() {
        ICitizenData citizenData = this.worker.getCitizenData();
        if (citizenData != null) {
            citizenData.decreaseSaturation(citizenData.getSaturation() * 0.05);
        }
        return this.getState();
    }

    public IAIState patrol() {
        if (this.buildingGuards.requiresManualTarget()) {
            if (this.currentPatrolPoint == null || this.worker.isWorkerAtSiteWithMove(this.currentPatrolPoint, 3)) {
                this.currentPatrolPoint = this.worker.getRandom().nextInt(5) <= 1 ? this.buildingGuards.getColony().getBuildingManager().getRandomBuilding(b -> true) : this.findRandomPositionToWalkTo(20);
                if (this.currentPatrolPoint != null) {
                    this.setNextPatrolTarget(this.currentPatrolPoint);
                }
            }
        } else {
            if (this.currentPatrolPoint == null) {
                this.currentPatrolPoint = this.buildingGuards.getNextPatrolTarget(false);
            }
            if (this.currentPatrolPoint != null && this.worker.isWorkerAtSiteWithMove(this.currentPatrolPoint, 3)) {
                this.buildingGuards.arrivedAtPatrolPoint(this.worker);
            }
        }
        return AIWorkerState.GUARD_PATROL;
    }

    public void setNextPatrolTarget(BlockPos target) {
        this.currentPatrolPoint = target;
        if (this.getState() == AIWorkerState.GUARD_PATROL) {
            this.worker.isWorkerAtSiteWithMove(this.currentPatrolPoint, 2);
        }
    }

    public boolean hasTool() {
        for (ToolType toolType : this.toolsNeeded) {
            if (InventoryUtils.hasItemHandlerToolWithLevel((IItemHandler)this.getInventory(), toolType, 0, this.buildingGuards.getMaxToolLevel())) continue;
            return false;
        }
        return true;
    }

    public void startHelpCitizen(EntityCitizen citizen, LivingEntity attacker) {
        if (this.canHelp()) {
            this.registerTarget(new AIOneTimeEventTarget(AIWorkerState.HELP_CITIZEN));
            this.target = attacker;
            this.helpCitizen = new WeakReference<EntityCitizen>(citizen);
        }
    }

    public boolean canHelp() {
        if (!this.isEntityValidTarget(this.target) && (this.getState() == AIWorkerState.GUARD_PATROL || this.getState() == AIWorkerState.GUARD_SLEEP) && this.canBeInterrupted()) {
            this.stopSleeping();
            return true;
        }
        return false;
    }

    private IAIState helping() {
        this.reduceAttackDelay(100 * this.getTickRate());
        if (this.helpCitizen.get() == null || !((EntityCitizen)this.helpCitizen.get()).isCurrentlyFleeing()) {
            return AIWorkerState.GUARD_DECIDE;
        }
        if (this.target == null || !this.target.func_70089_S()) {
            this.target = ((EntityCitizen)this.helpCitizen.get()).func_70643_av();
            if (this.target == null || !this.target.func_70089_S()) {
                return AIWorkerState.GUARD_DECIDE;
            }
        }
        this.currentPatrolPoint = null;
        if (this.worker.func_70635_at().func_75522_a((Entity)this.target) && this.isWithinPersecutionDistance(this.target.func_180425_c())) {
            this.target.func_70604_c((LivingEntity)this.worker);
            return this.checkAndAttackTarget();
        }
        this.moveInAttackPosition();
        return AIWorkerState.HELP_CITIZEN;
    }

    protected IAIState decide() {
        this.reduceAttackDelay(100 * this.getTickRate());
        ILocation rallyLocation = this.buildingGuards.getRallyLocation();
        if (this.regularActionTimer++ > 10) {
            this.incrementActionsDone();
            this.regularActionTimer = 0;
        }
        if (rallyLocation != null || this.buildingGuards.getTask() == GuardTask.FOLLOW) {
            this.worker.func_195064_c(new EffectInstance(Constants.GLOW_EFFECT, 600, 20, false, false));
        } else {
            this.worker.func_184596_c(Constants.GLOW_EFFECT);
        }
        if (rallyLocation != null && rallyLocation.isReachableFromLocation(this.worker.getLocation())) {
            return this.rally(rallyLocation);
        }
        switch (this.buildingGuards.getTask()) {
            case PATROL: {
                return this.patrol();
            }
            case GUARD: {
                return this.guard();
            }
            case FOLLOW: {
                return this.follow();
            }
        }
        return AIWorkerState.PREPARING;
    }

    protected boolean checkForTarget() {
        if (this.target != null && !this.target.func_70089_S()) {
            this.incrementActionsDoneAndDecSaturation();
            this.worker.getCitizenExperienceHandler().addExperience(15.0);
        }
        if (this.isEntityValidTarget(this.target)) {
            if (this.target != this.worker.func_70643_av() && this.isEntityValidTargetAndCanbeSeen(this.worker.func_70643_av()) && this.worker.func_70068_e((Entity)this.worker.func_70643_av()) < this.worker.func_70068_e((Entity)this.target) - 15.0) {
                this.target = this.worker.func_70643_av();
                this.onTargetChange();
            }
            this.lastSeen = !this.worker.func_70685_l((Entity)this.target) ? (this.lastSeen += 100) : 0;
            if (this.lastSeen > 200) {
                this.resetTarget();
                return false;
            }
            return true;
        }
        this.resetTarget();
        if (this.isEntityValidTargetAndCanbeSeen(this.worker.func_70643_av())) {
            this.target = this.worker.func_70643_av();
            this.onTargetChange();
            return true;
        }
        return this.target != null;
    }

    protected void onTargetChange() {
        for (ICitizenData iCitizenData : ((AbstractBuildingGuards)this.getOwnBuilding()).getAssignedCitizen()) {
            if (!iCitizenData.getEntity().isPresent() || iCitizenData.getEntity().get().func_70643_av() != null) continue;
            iCitizenData.getEntity().get().func_70604_c(this.target);
        }
        if (this.target instanceof AbstractEntityMinecoloniesMob) {
            for (Map.Entry entry : this.worker.getCitizenColonyHandler().getColony().getBuildingManager().getBuildings().entrySet()) {
                if (!(entry.getValue() instanceof AbstractBuildingGuards) || !(this.worker.func_180425_c().func_177951_i((Vec3i)entry.getKey()) < 40000.0)) continue;
                AbstractBuildingGuards building = (AbstractBuildingGuards)entry.getValue();
                building.setTempNextPatrolPoint(this.target.func_180425_c());
            }
        }
    }

    public boolean isEntityValidTargetAndCanbeSeen(LivingEntity entity) {
        return this.isEntityValidTarget(entity) && this.worker.func_70685_l((Entity)entity);
    }

    public boolean isEntityValidTarget(LivingEntity entity) {
        MobEntryView entry;
        if (entity == null || !entity.func_70089_S() || !this.isWithinPersecutionDistance(entity.func_180425_c())) {
            return false;
        }
        if (entity == this.worker.func_70643_av()) {
            return true;
        }
        if (entity instanceof IMob && (entry = this.buildingGuards.getMobsToAttack().get(entity.func_200600_R().getRegistryName())) != null && entry.shouldAttack()) {
            return true;
        }
        IColony colony = this.worker.getCitizenColonyHandler().getColony();
        if (colony == null) {
            return false;
        }
        if (entity instanceof PlayerEntity && (colony.getPermissions().hasPermission((PlayerEntity)entity, Action.GUARDS_ATTACK) || colony.isValidAttackingPlayer((PlayerEntity)entity))) {
            return true;
        }
        return entity instanceof EntityCitizen && colony.isValidAttackingGuard((AbstractEntityCitizen)entity);
    }

    public void resetTarget() {
        if (this.target == null) {
            return;
        }
        if (this.worker.func_110144_aD() == this.target) {
            this.worker.func_130011_c(null);
        }
        if (this.worker.func_70643_av() == this.target) {
            this.worker.func_70604_c(null);
        }
        this.target = null;
    }

    public abstract void moveInAttackPosition();

    public IAIState preAttackChecks() {
        UnlockAbilityResearchEffect effect;
        if (!this.hasMainWeapon()) {
            this.resetTarget();
            return AIWorkerState.START_WORKING;
        }
        if (this.buildingGuards.shallRetrieveOnLowHealth() && (double)this.worker.func_110143_aJ() < (double)((int)this.worker.func_110138_aP()) * 0.2 && (effect = this.worker.getCitizenColonyHandler().getColony().getResearchManager().getResearchEffects().getEffect("Retreat", UnlockAbilityResearchEffect.class)) != null) {
            this.resetTarget();
            return AIWorkerState.GUARD_REGEN;
        }
        if (!this.checkForTarget()) {
            return AIWorkerState.GUARD_DECIDE;
        }
        this.wearWeapon();
        return this.getState();
    }

    public abstract boolean hasMainWeapon();

    protected LivingEntity searchNearbyTarget() {
        IColony colony = this.worker.getCitizenColonyHandler().getColony();
        if (colony == null) {
            this.resetTarget();
            return null;
        }
        List entities = this.world.func_217357_a(LivingEntity.class, this.getSearchArea());
        int closest = Integer.MAX_VALUE;
        LivingEntity targetEntity = null;
        for (LivingEntity entity : entities) {
            int tempDistance;
            EntityCitizen citizen;
            if (!this.worker.func_70685_l((Entity)entity) || !entity.func_70089_S()) continue;
            if (entity instanceof EntityCitizen && (citizen = (EntityCitizen)entity).getCitizenJobHandler().getColonyJob() instanceof AbstractJobGuard && ((AbstractJobGuard)citizen.getCitizenJobHandler().getColonyJob()).isAsleep()) {
                this.sleepingGuard = new WeakReference<EntityCitizen>(citizen);
                this.wakeTimer = 0;
                this.registerTarget(new AIOneTimeEventTarget(AIWorkerState.GUARD_WAKE));
                return null;
            }
            if (!this.isEntityValidTarget(entity) || (tempDistance = (int)BlockPosUtil.getDistanceSquared(this.worker.func_180425_c(), entity.func_180425_c())) >= closest) continue;
            closest = tempDistance;
            targetEntity = entity;
        }
        this.target = targetEntity;
        this.onTargetChange();
        return targetEntity;
    }

    public abstract void wearWeapon();

    public boolean isInAttackDistance(BlockPos position) {
        return BlockPosUtil.getDistanceSquared2D(this.worker.func_180425_c(), position) <= (long)(this.getAttackRange() * this.getAttackRange());
    }

    public void reduceAttackDelay(int value) {
        if (this.currentAttackDelay > 0) {
            this.currentAttackDelay -= value;
        }
    }

    private boolean isWithinPersecutionDistance(BlockPos entityPos) {
        return (double)BlockPosUtil.getDistanceSquared(this.getTaskReferencePoint(), entityPos) <= Math.pow(this.getPersecutionDistance() + this.getAttackRange(), 2.0);
    }

    private BlockPos getTaskReferencePoint() {
        ILocation location = this.buildingGuards.getRallyLocation();
        if (location != null) {
            return this.buildingGuards.getRallyLocation().getInDimensionLocation();
        }
        switch (this.buildingGuards.getTask()) {
            case PATROL: {
                return this.currentPatrolPoint != null ? this.currentPatrolPoint : this.worker.func_180425_c();
            }
            case FOLLOW: {
                return this.buildingGuards.getPositionToFollow();
            }
        }
        return this.buildingGuards.getGuardPos();
    }

    private int getPersecutionDistance() {
        if (this.buildingGuards.getRallyLocation() != null) {
            return 40;
        }
        switch (this.buildingGuards.getTask()) {
            case PATROL: {
                return 50;
            }
            case FOLLOW: {
                return 40;
            }
        }
        return 10 + (this.buildingGuards.getGuardType() == ModGuardTypes.knight ? 20 : 0);
    }

    private AxisAlignedBB getSearchArea() {
        IGuardBuilding building = (IGuardBuilding)this.getOwnBuilding();
        int buildingBonus = building.getBonusVision() + Math.max(18, this.getAttackRange());
        Direction randomDirection = Direction.func_82600_a((int)(this.worker.getRandom().nextInt(4) + 2));
        double x1 = this.worker.func_180425_c().func_177958_n() + Math.max(buildingBonus * randomDirection.func_82601_c() + 16, 16);
        double x2 = this.worker.func_180425_c().func_177958_n() + Math.min(buildingBonus * randomDirection.func_82601_c() - 16, -16);
        double y1 = this.worker.func_180425_c().func_177956_o() + 5;
        double y2 = this.worker.func_180425_c().func_177956_o() - 20;
        double z1 = this.worker.func_180425_c().func_177952_p() + Math.max(buildingBonus * randomDirection.func_82599_e() + 16, 16);
        double z2 = this.worker.func_180425_c().func_177952_p() + Math.min(buildingBonus * randomDirection.func_82599_e() - 16, -16);
        return new AxisAlignedBB(x1, y1, z1, x2, y2, z2);
    }

    @Override
    protected abstract int getAttackRange();

    @Override
    public boolean canBeInterrupted() {
        if (this.fighttimer > 0 || this.getState() == AIWorkerState.GUARD_RALLY || this.target != null || this.buildingGuards.getRallyLocation() != null || this.buildingGuards.getTask() == GuardTask.FOLLOW) {
            return false;
        }
        return super.canBeInterrupted();
    }
}

