/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity.ai.citizen.guard;

import com.minecolonies.api.compatibility.tinkers.TinkersWeaponHelper;
import com.minecolonies.api.entity.ai.citizen.guards.GuardGear;
import com.minecolonies.api.entity.ai.statemachine.AITarget;
import com.minecolonies.api.entity.ai.statemachine.states.AIWorkerState;
import com.minecolonies.api.entity.ai.statemachine.states.IAIState;
import com.minecolonies.api.entity.citizen.Skill;
import com.minecolonies.api.entity.citizen.VisibleCitizenStatus;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.SoundUtils;
import com.minecolonies.api.util.constant.GuardConstants;
import com.minecolonies.api.util.constant.ToolType;
import com.minecolonies.coremod.MineColonies;
import com.minecolonies.coremod.colony.buildings.AbstractBuildingGuards;
import com.minecolonies.coremod.colony.jobs.JobKnight;
import com.minecolonies.coremod.entity.ai.citizen.guard.AbstractEntityAIGuard;
import com.minecolonies.coremod.research.AdditionModifierResearchEffect;
import com.minecolonies.coremod.research.UnlockAbilityResearchEffect;
import com.minecolonies.coremod.util.NamedDamageSource;
import java.util.List;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.item.ArmorStandEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.SwordItem;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;

public class EntityAIKnight
extends AbstractEntityAIGuard<JobKnight, AbstractBuildingGuards> {
    private static final int GUARD_ATTACK_INTERVAL = 8;
    private static final VisibleCitizenStatus COMBAT = new VisibleCitizenStatus(new ResourceLocation("minecolonies", "textures/icons/work/knight_combat.png"), "com.minecolonies.gui.visiblestatus.knight_combat");
    private static final int KNOCKBACK_CHANCE = 5;
    private final int KNOCKBACK_COOLDOWN = 240;
    private int knockbackAoeCooldown = 240;

    public EntityAIKnight(@NotNull JobKnight job) {
        super(job);
        super.registerTargets(new AITarget((IAIState)AIWorkerState.GUARD_ATTACK_PROTECT, this::attackProtect, 8), new AITarget((IAIState)AIWorkerState.GUARD_ATTACK_PHYSICAL, this::attackPhysical, 8));
        this.toolsNeeded.add(ToolType.SWORD);
        for (List list : this.itemsNeeded) {
            list.add(new GuardGear(ToolType.SHIELD, EquipmentSlotType.OFFHAND, 0, 0, GuardConstants.SHIELD_LEVEL_RANGE, GuardConstants.SHIELD_BUILDING_LEVEL_RANGE));
        }
    }

    @Override
    public IAIState getAttackState() {
        this.worker.getCitizenData().setVisibleStatus(COMBAT);
        return AIWorkerState.GUARD_ATTACK_PHYSICAL;
    }

    @Override
    protected int getAttackRange() {
        return 2;
    }

    @Override
    public boolean hasMainWeapon() {
        return InventoryUtils.getFirstSlotOfItemHandlerContainingTool((IItemHandler)this.getInventory(), ToolType.SWORD, 0, this.buildingGuards.getMaxToolLevel()) != -1;
    }

    @Override
    public void wearWeapon() {
        int weaponSlot = InventoryUtils.getFirstSlotOfItemHandlerContainingTool((IItemHandler)this.getInventory(), ToolType.SWORD, 0, this.buildingGuards.getMaxToolLevel());
        if (weaponSlot != -1) {
            this.worker.getCitizenItemHandler().setHeldItem(Hand.MAIN_HAND, weaponSlot);
        }
    }

    @Override
    protected int getAttackDelay() {
        int reload = 32 - this.worker.getCitizenData().getCitizenSkillHandler().getLevel(Skill.Adaptability) / 3;
        return Math.max(reload, 16);
    }

    @Override
    public void reduceAttackDelay(int value) {
        if (this.knockbackAoeCooldown > 0) {
            this.knockbackAoeCooldown -= value;
        }
        super.reduceAttackDelay(value);
    }

    @Override
    @NotNull
    protected List<ItemStack> itemsNiceToHave() {
        List<ItemStack> list = super.itemsNiceToHave();
        list.add(new ItemStack((IItemProvider)Items.field_185159_cQ, 1));
        return list;
    }

    protected IAIState attackProtect() {
        UnlockAbilityResearchEffect effect;
        int shieldSlot = InventoryUtils.findFirstSlotInItemHandlerWith((IItemHandler)this.getInventory(), Items.field_185159_cQ);
        if (this.target != null && this.target.func_70089_S() && (effect = this.worker.getCitizenColonyHandler().getColony().getResearchManager().getResearchEffects().getEffect("Shield Usage", UnlockAbilityResearchEffect.class)) != null && shieldSlot != -1) {
            this.worker.getCitizenItemHandler().setHeldItem(Hand.OFF_HAND, shieldSlot);
            this.worker.func_184598_c(Hand.OFF_HAND);
            ItemStack shieldStack = this.worker.getInventoryCitizen().getHeldItem(Hand.OFF_HAND);
            CompoundNBT nbt = shieldStack.func_190925_c("BlockEntityTag");
            nbt.func_218657_a("Patterns", (INBT)this.worker.getCitizenColonyHandler().getColony().getColonyFlag());
            this.worker.func_70625_a((Entity)this.target, 180.0f, 180.0f);
            this.worker.decreaseSaturationForContinuousAction();
        }
        return AIWorkerState.GUARD_ATTACK_PHYSICAL;
    }

    protected IAIState attackPhysical() {
        IAIState state = this.preAttackChecks();
        if (state != this.getState()) {
            this.worker.getNavigator().func_75499_g();
            this.worker.func_70605_aq().func_188488_a(0.0f, 0.0f);
            this.setDelay(5);
            this.worker.getCitizenData().setVisibleStatus(VisibleCitizenStatus.WORKING);
            return state;
        }
        this.fighttimer = 30;
        this.moveInAttackPosition();
        this.reduceAttackDelay(8);
        if (this.currentAttackDelay > 0) {
            return AIWorkerState.GUARD_ATTACK_PROTECT;
        }
        if (!this.isInAttackDistance(this.target.func_180425_c())) {
            return this.getState();
        }
        if (this.getOwnBuilding() != null) {
            UnlockAbilityResearchEffect effect;
            UnlockAbilityResearchEffect knockBackEnabled;
            int fireLevel;
            this.currentAttackDelay = this.getAttackDelay();
            this.worker.func_70625_a((Entity)this.target, 180.0f, 180.0f);
            this.worker.func_184609_a(Hand.MAIN_HAND);
            this.worker.func_184185_a(SoundEvents.field_187730_dW, 1.0f, (float)SoundUtils.getRandomPitch(this.worker.getRandom()));
            double damageToBeDealt = this.getAttackDamage();
            if ((double)this.worker.func_110143_aJ() <= (double)this.worker.func_110138_aP() * 0.2) {
                damageToBeDealt *= 2.0;
            }
            NamedDamageSource source = new NamedDamageSource(this.worker.func_200200_C_().func_150254_d(), (Entity)this.worker);
            if (((Boolean)MineColonies.getConfig().getCommon().pvp_mode.get()).booleanValue() && this.target instanceof PlayerEntity) {
                source.func_76348_h();
            }
            if ((fireLevel = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_77334_n, (ItemStack)this.worker.func_184586_b(Hand.MAIN_HAND))) > 0) {
                this.target.func_70015_d(fireLevel * 80);
            }
            if (this.knockbackAoeCooldown <= 0 && (knockBackEnabled = this.worker.getCitizenColonyHandler().getColony().getResearchManager().getResearchEffects().getEffect("Whirldwind ability", UnlockAbilityResearchEffect.class)) != null && knockBackEnabled.getEffect().booleanValue() && this.worker.getRandom().nextInt(5) == 0) {
                List entities = this.world.func_217357_a(LivingEntity.class, this.worker.func_174813_aQ().func_72314_b(2.0, 0.5, 2.0));
                for (LivingEntity livingentity : entities) {
                    if (livingentity == this.worker || this.worker.func_184191_r((Entity)livingentity) || livingentity instanceof ArmorStandEntity) continue;
                    livingentity.func_70653_a((Entity)this.worker, 2.0f, (double)MathHelper.func_76126_a((float)(livingentity.field_70177_z * (float)Math.PI)), (double)(-MathHelper.func_76134_b((float)(livingentity.field_70177_z * (float)Math.PI))));
                    livingentity.func_70097_a((DamageSource)source, (float)(damageToBeDealt / (double)entities.size()));
                }
                this.world.func_184148_a(null, this.worker.func_226277_ct_(), this.worker.func_226278_cu_(), this.worker.func_226281_cx_(), SoundEvents.field_187730_dW, this.worker.func_184176_by(), 1.0f, 1.0f);
                double d0 = -MathHelper.func_76126_a((float)(this.worker.field_70177_z * ((float)Math.PI / 180)));
                double d1 = MathHelper.func_76134_b((float)(this.worker.field_70177_z * ((float)Math.PI / 180)));
                if (this.worker.field_70170_p instanceof ServerWorld) {
                    ((ServerWorld)this.worker.field_70170_p).func_195598_a((IParticleData)ParticleTypes.field_197603_N, this.worker.func_226277_ct_() + d0, this.worker.func_226283_e_(0.5), this.worker.func_226281_cx_() + d1, 2, d0, 0.0, d1, 0.0);
                }
                this.knockbackAoeCooldown = 240;
            }
            this.target.func_70097_a((DamageSource)source, (float)damageToBeDealt);
            this.target.func_70604_c((LivingEntity)this.worker);
            if (this.target instanceof MobEntity && (effect = this.worker.getCitizenColonyHandler().getColony().getResearchManager().getResearchEffects().getEffect("Knight taunt mobs", UnlockAbilityResearchEffect.class)) != null && effect.getEffect().booleanValue()) {
                ((MobEntity)this.target).func_70624_b((LivingEntity)this.worker);
            }
            this.worker.decreaseSaturationForContinuousAction();
            this.worker.getCitizenItemHandler().damageItemInHand(Hand.MAIN_HAND, 1);
        }
        return AIWorkerState.GUARD_ATTACK_PHYSICAL;
    }

    private int getAttackDamage() {
        if (this.worker.getCitizenData() != null) {
            AdditionModifierResearchEffect effect;
            int addDmg = 0;
            ItemStack heldItem = this.worker.func_184586_b(Hand.MAIN_HAND);
            if (ItemStackUtils.doesItemServeAsWeapon(heldItem)) {
                addDmg = heldItem.func_77973_b() instanceof SwordItem ? (int)((float)addDmg + (((SwordItem)heldItem.func_77973_b()).func_200894_d() + 3.0f)) : (int)((double)addDmg + TinkersWeaponHelper.getDamage(heldItem));
                addDmg = (int)((double)addDmg + (double)EnchantmentHelper.func_152377_a((ItemStack)heldItem, (CreatureAttribute)this.target.func_70668_bt()) / 2.5);
            }
            if ((effect = this.worker.getCitizenColonyHandler().getColony().getResearchManager().getResearchEffects().getEffect("Melee Damage", AdditionModifierResearchEffect.class)) != null) {
                addDmg = (int)((double)addDmg + effect.getEffect());
            }
            return (int)((double)addDmg * (Double)MineColonies.getConfig().getCommon().knightDamageMult.get());
        }
        return (int)(3.0 * (Double)MineColonies.getConfig().getCommon().knightDamageMult.get());
    }

    @Override
    protected double getCombatSpeedBonus() {
        return (double)this.worker.getCitizenData().getCitizenSkillHandler().getLevel(Skill.Adaptability) * 0.01;
    }

    @Override
    public void moveInAttackPosition() {
        this.worker.getNavigator().func_75497_a((Entity)this.target, this.getCombatMovementSpeed());
    }

    @Override
    public Class<AbstractBuildingGuards> getExpectedBuildingClass() {
        return AbstractBuildingGuards.class;
    }
}

