/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity.ai.citizen.guard;

import com.minecolonies.api.entity.ai.citizen.guards.GuardTask;
import com.minecolonies.api.entity.ai.statemachine.AITarget;
import com.minecolonies.api.entity.ai.statemachine.states.AIWorkerState;
import com.minecolonies.api.entity.ai.statemachine.states.IAIState;
import com.minecolonies.api.entity.citizen.Skill;
import com.minecolonies.api.entity.citizen.VisibleCitizenStatus;
import com.minecolonies.api.entity.pathfinding.PathResult;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.SoundUtils;
import com.minecolonies.api.util.constant.ToolType;
import com.minecolonies.coremod.MineColonies;
import com.minecolonies.coremod.colony.buildings.AbstractBuildingGuards;
import com.minecolonies.coremod.colony.jobs.JobRanger;
import com.minecolonies.coremod.entity.ai.citizen.guard.AbstractEntityAIGuard;
import com.minecolonies.coremod.entity.pathfinding.MinecoloniesAdvancedPathNavigate;
import com.minecolonies.coremod.entity.pathfinding.pathjobs.PathJobCanSee;
import com.minecolonies.coremod.entity.pathfinding.pathjobs.PathJobWalkRandomEdge;
import com.minecolonies.coremod.research.AdditionModifierResearchEffect;
import com.minecolonies.coremod.research.MultiplierModifierResearchEffect;
import com.minecolonies.coremod.research.UnlockAbilityResearchEffect;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.projectile.ArrowEntity;
import net.minecraft.item.ArrowItem;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;

public class EntityAIRanger
extends AbstractEntityAIGuard<JobRanger, AbstractBuildingGuards> {
    private static final int TIME_STRAFING_BEFORE_SWITCHING_DIRECTIONS = 4;
    private static final double SWITCH_STRAFING_DIRECTION = 0.3;
    private static final double STRAFING_SPEED = (double)0.7f;
    private static final double ARROW_EXTRA_DAMAGE = 2.0;
    private static final VisibleCitizenStatus ARCHER_COMBAT = new VisibleCitizenStatus(new ResourceLocation("minecolonies", "textures/icons/work/archer_combat.png"), "com.minecolonies.gui.visiblestatus.archer_combat");
    private static final int GUARD_BONUS_RANGE = 10;
    private boolean movingToTarget = false;
    private int strafingClockwise = 1;
    private int strafingTime = -1;
    private int timeAtSameSpot = 0;
    private int tooCloseNumTicks = 0;
    private boolean fleeing = false;
    public static final int RANGED_ATTACK_DELAY_BASE = 30;
    private PathResult fleePath;
    private int timeCanSee = 0;
    private double lastDistance = 0.0;

    public EntityAIRanger(@NotNull JobRanger job) {
        super(job);
        super.registerTargets(new AITarget((IAIState)AIWorkerState.GUARD_ATTACK_RANGED, this::attackRanged, 10));
        this.toolsNeeded.add(ToolType.BOW);
        this.worker.getNavigator().getPathingOptions().withJumpDropCost(0.95);
    }

    @Override
    public IAIState getAttackState() {
        this.strafingTime = 0;
        this.tooCloseNumTicks = 0;
        this.timeAtSameSpot = 0;
        this.timeCanSee = 0;
        this.fleeing = false;
        this.movingToTarget = false;
        this.worker.getCitizenData().setVisibleStatus(ARCHER_COMBAT);
        return AIWorkerState.GUARD_ATTACK_RANGED;
    }

    @Override
    protected int getAttackRange() {
        return this.getRealAttackRange();
    }

    private int getRealAttackRange() {
        int attackDist = 10;
        if (this.buildingGuards != null) {
            attackDist += this.buildingGuards.getBuildingLevel();
        }
        if (this.worker.getCitizenData() != null) {
            attackDist = (int)((float)attackDist + (float)this.worker.getCitizenData().getCitizenSkillHandler().getLevel(Skill.Adaptability) / 50.0f * 15.0f);
        }
        attackDist = Math.min(attackDist, 24);
        if (this.target != null) {
            attackDist = (int)((double)attackDist + (this.worker.field_70163_u - this.target.field_70163_u));
        }
        if (this.buildingGuards.getTask() == GuardTask.GUARD) {
            attackDist += 10;
        }
        return attackDist;
    }

    @Override
    public boolean hasMainWeapon() {
        return !this.checkForToolOrWeapon(ToolType.BOW);
    }

    @Override
    public void wearWeapon() {
        int bowSlot = InventoryUtils.getFirstSlotOfItemHandlerContainingTool((IItemHandler)this.getInventory(), ToolType.BOW, 0, this.buildingGuards.getMaxToolLevel());
        if (bowSlot != -1) {
            this.worker.getCitizenItemHandler().setHeldItem(Hand.MAIN_HAND, bowSlot);
        }
    }

    protected IAIState attackRanged() {
        IAIState state = this.preAttackChecks();
        if (state != this.getState()) {
            this.worker.getNavigator().func_75499_g();
            this.worker.func_70605_aq().func_188488_a(0.0f, 0.0f);
            this.setDelay(5);
            this.worker.getCitizenData().setVisibleStatus(VisibleCitizenStatus.WORKING);
            return state;
        }
        this.fighttimer = 30;
        double sqDistanceToEntity = BlockPosUtil.getDistanceSquared2D(this.worker.func_180425_c(), this.target.func_180425_c());
        boolean canSee = this.worker.func_70635_at().func_75522_a((Entity)this.target);
        double sqAttackRange = this.getRealAttackRange() * this.getRealAttackRange();
        this.timeCanSee = canSee ? ++this.timeCanSee : --this.timeCanSee;
        this.timeAtSameSpot = this.lastDistance == sqDistanceToEntity ? ++this.timeAtSameSpot : 0;
        if (sqDistanceToEntity > sqAttackRange && this.timeAtSameSpot > 8 || !canSee && this.timeAtSameSpot > 8) {
            this.worker.getNavigator().func_75499_g();
            return AIWorkerState.DECIDE;
        }
        if (sqDistanceToEntity > sqAttackRange || !canSee) {
            if (this.worker.getNavigator().func_75500_f()) {
                this.moveInAttackPosition();
            }
            this.worker.func_70605_aq().func_188488_a(0.0f, 0.0f);
            this.movingToTarget = true;
            this.strafingTime = -1;
        } else if (this.movingToTarget && sqDistanceToEntity < sqAttackRange) {
            this.worker.getNavigator().func_75499_g();
            this.movingToTarget = false;
            this.strafingTime = -1;
        }
        if (this.fleeing && !this.fleePath.isComputing()) {
            this.fleeing = false;
            this.tooCloseNumTicks = 0;
        }
        if (sqDistanceToEntity < 7.0) {
            ++this.tooCloseNumTicks;
            this.strafingTime = -1;
            if (!this.fleeing && !this.movingToTarget && sqDistanceToEntity < 7.0 && this.tooCloseNumTicks > 3) {
                this.fleePath = this.worker.getNavigator().moveAwayFromLivingEntity((Entity)this.target, (double)this.getRealAttackRange() / 2.0, this.getCombatMovementSpeed());
                this.fleeing = true;
                this.worker.func_70605_aq().func_188488_a(0.0f, (float)this.strafingClockwise * 0.2f);
                this.strafingClockwise *= -1;
            }
        } else {
            this.tooCloseNumTicks = 0;
        }
        if (this.buildingGuards.getTask() != GuardTask.GUARD) {
            if (this.strafingTime >= 4) {
                if ((double)this.worker.func_70681_au().nextFloat() < 0.3) {
                    this.strafingClockwise *= -1;
                }
                this.strafingTime = 0;
            }
            if (sqDistanceToEntity < sqAttackRange / 2.0 && this.tooCloseNumTicks < 1) {
                ++this.strafingTime;
            } else if (sqDistanceToEntity > sqAttackRange / 2.0 + 5.0) {
                this.strafingTime = -1;
            }
            if (this.strafingTime > -1 && !this.fleeing && !this.movingToTarget) {
                this.worker.func_70605_aq().func_188488_a(0.0f, (float)(this.getCombatMovementSpeed() * (double)this.strafingClockwise * (double)0.7f));
                this.worker.func_70625_a((Entity)this.target, 180.0f, 180.0f);
            } else {
                this.worker.func_70625_a((Entity)this.target, 180.0f, 180.0f);
            }
        }
        if (this.worker.func_184587_cr()) {
            if (!canSee && this.timeCanSee < -6) {
                this.worker.func_184602_cy();
            } else if (canSee && sqDistanceToEntity <= sqAttackRange) {
                this.worker.func_70625_a((Entity)this.target, 180.0f, 180.0f);
                this.worker.func_184609_a(Hand.MAIN_HAND);
                int amountOfArrows = 1;
                MultiplierModifierResearchEffect effect = this.worker.getCitizenColonyHandler().getColony().getResearchManager().getResearchEffects().getEffect("Double Arrows", MultiplierModifierResearchEffect.class);
                if (effect != null && this.worker.getRandom().nextDouble() < effect.getEffect()) {
                    ++amountOfArrows;
                }
                double extraDamage = 0.0;
                AdditionModifierResearchEffect dmgEffect = this.worker.getCitizenColonyHandler().getColony().getResearchManager().getResearchEffects().getEffect("Archer Damage", AdditionModifierResearchEffect.class);
                if (dmgEffect != null) {
                    extraDamage += dmgEffect.getEffect().doubleValue();
                }
                for (int i = 0; i < amountOfArrows; ++i) {
                    int k;
                    ItemStack bow;
                    int slot;
                    ArrowEntity arrow = (ArrowEntity)EntityType.field_200790_d.func_200721_a(this.world);
                    arrow.func_212361_a((Entity)this.worker);
                    UnlockAbilityResearchEffect arrowPierceEffect = this.worker.getCitizenColonyHandler().getColony().getResearchManager().getResearchEffects().getEffect("Piercing Arrows", UnlockAbilityResearchEffect.class);
                    if (arrowPierceEffect != null && arrowPierceEffect.getEffect().booleanValue()) {
                        arrow.func_213872_b((byte)2);
                    }
                    arrow.func_70107_b(this.worker.func_226277_ct_(), this.worker.func_226278_cu_() + 1.0, this.worker.func_226281_cx_());
                    double xVector = this.target.field_70165_t - this.worker.func_226277_ct_();
                    double yVector = this.target.func_174813_aQ().field_72338_b + (double)this.target.func_213302_cg() / this.getAimHeight() - arrow.field_70163_u;
                    double zVector = this.target.field_70161_v - this.worker.func_226281_cx_();
                    double distance = MathHelper.func_76133_a((double)(xVector * xVector + zVector * zVector));
                    double damage = this.getRangedAttackDamage() + extraDamage;
                    UnlockAbilityResearchEffect arrowItemEffect = this.worker.getCitizenColonyHandler().getColony().getResearchManager().getResearchEffects().getEffect("Consume Arrows", UnlockAbilityResearchEffect.class);
                    if (arrowItemEffect != null && arrowItemEffect.getEffect().booleanValue() && (slot = InventoryUtils.findFirstSlotInItemHandlerWith((IItemHandler)this.worker.getInventoryCitizen(), item -> item.func_77973_b() instanceof ArrowItem)) != -1 && !ItemStackUtils.isEmpty(this.worker.getInventoryCitizen().extractItem(slot, 1, false)).booleanValue()) {
                        damage += 2.0;
                    }
                    if (EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185311_w, (ItemStack)(bow = this.worker.func_184586_b(Hand.MAIN_HAND))) > 0) {
                        arrow.func_70015_d(100);
                    }
                    if ((k = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185310_v, (ItemStack)bow)) > 0) {
                        arrow.func_70240_a(k);
                    }
                    double chance = 15.0 / (double)(this.worker.getCitizenData().getCitizenSkillHandler().getLevel(Skill.Adaptability) + 1);
                    arrow.func_70186_c(xVector, yVector + distance * (double)0.2f, zVector, 1.6f, (float)chance);
                    if ((double)this.worker.func_110143_aJ() <= (double)this.worker.func_110138_aP() * 0.2) {
                        damage *= 2.0;
                    }
                    arrow.func_70239_b(damage);
                    this.worker.func_184185_a(SoundEvents.field_187866_fi, 1.0f, (float)SoundUtils.getRandomPitch(this.worker.getRandom()));
                    this.worker.field_70170_p.func_217376_c((Entity)arrow);
                }
                double xDiff = this.target.field_70165_t - this.worker.func_226277_ct_();
                double zDiff = this.target.field_70161_v - this.worker.func_226281_cx_();
                double goToX = xDiff > 0.0 ? 0.01 : -0.01;
                double goToZ = zDiff > 0.0 ? 0.01 : -0.01;
                this.worker.func_213315_a(MoverType.SELF, new Vec3d(goToX, 0.0, goToZ));
                this.timeCanSee = 0;
                this.target.func_70604_c((LivingEntity)this.worker);
                this.currentAttackDelay = this.getAttackDelay();
                this.worker.getCitizenItemHandler().damageItemInHand(Hand.MAIN_HAND, 1);
                this.worker.func_184602_cy();
                this.worker.decreaseSaturationForContinuousAction();
            } else if (this.target.field_70163_u > this.worker.func_226278_cu_() + 10.0 + 10.0) {
                this.fleePath = this.worker.getNavigator().moveAwayFromLivingEntity((Entity)this.target, 10.0, this.getCombatMovementSpeed());
                this.fleeing = true;
                this.worker.func_70605_aq().func_188488_a(0.0f, 0.0f);
            }
        } else {
            this.reduceAttackDelay(10);
            if (this.currentAttackDelay <= 0) {
                this.worker.func_184598_c(Hand.MAIN_HAND);
            }
        }
        this.lastDistance = sqDistanceToEntity;
        return AIWorkerState.GUARD_ATTACK_RANGED;
    }

    @Override
    protected void atBuildingActions() {
        super.atBuildingActions();
        UnlockAbilityResearchEffect arrowItemEffect = this.worker.getCitizenColonyHandler().getColony().getResearchManager().getResearchEffects().getEffect("Consume Arrows", UnlockAbilityResearchEffect.class);
        if (arrowItemEffect != null && arrowItemEffect.getEffect().booleanValue()) {
            InventoryUtils.transferXOfFirstSlotInProviderWithIntoNextFreeSlotInItemHandler(this.getOwnBuilding(), item -> item.func_77973_b() instanceof ArrowItem, 64, (IItemHandler)this.worker.getInventoryCitizen());
            if (InventoryUtils.getItemCountInItemHandler((IItemHandler)this.worker.getInventoryCitizen(), item -> item.func_77973_b() instanceof ArrowItem) < 16) {
                this.checkIfRequestForItemExistOrCreateAsynch(new ItemStack((IItemProvider)Items.field_151032_g), 64, 16);
            }
        }
    }

    @Override
    protected int getAttackDelay() {
        if (this.worker.getCitizenData() != null) {
            int attackDelay = 30 - this.worker.getCitizenData().getCitizenSkillHandler().getLevel(Skill.Adaptability) / 2;
            return attackDelay < 20 ? 20 : attackDelay;
        }
        return 30;
    }

    private double getRangedAttackDamage() {
        if (this.worker.getCitizenData() != null) {
            int enchantDmg = 0;
            if (((Boolean)MineColonies.getConfig().getCommon().rangerEnchants.get()).booleanValue()) {
                ItemStack heldItem = this.worker.func_184586_b(Hand.MAIN_HAND);
                enchantDmg = (int)((double)enchantDmg + (double)EnchantmentHelper.func_152377_a((ItemStack)heldItem, (CreatureAttribute)this.target.func_70668_bt()) / 2.5);
                enchantDmg += EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185309_u, (ItemStack)heldItem);
            }
            return (double)(2 + this.getLevelDamage() + enchantDmg) * (Double)MineColonies.getConfig().getCommon().rangerDamageMult.get();
        }
        return 2.0 * (Double)MineColonies.getConfig().getCommon().rangerDamageMult.get();
    }

    public int getLevelDamage() {
        if (this.worker.getCitizenData() == null) {
            return 0;
        }
        return this.worker.getCitizenData().getCitizenSkillHandler().getLevel(Skill.Agility) / 50 * 10;
    }

    @Override
    protected double getCombatSpeedBonus() {
        return (double)this.worker.getCitizenData().getCitizenSkillHandler().getLevel(Skill.Agility) * 0.01;
    }

    private double getAimHeight() {
        return 3.0;
    }

    @Override
    public void moveInAttackPosition() {
        if (this.buildingGuards.getTask() == GuardTask.GUARD) {
            ((MinecoloniesAdvancedPathNavigate)this.worker.getNavigator()).setPathJob(new PathJobCanSee((LivingEntity)this.worker, this.target, this.world, this.buildingGuards.getGuardPos(), 20), null, this.getCombatMovementSpeed());
            return;
        }
        this.worker.getNavigator().tryMoveToBlockPos(this.worker.func_180425_c().func_177967_a(BlockPosUtil.getXZFacing(this.target.func_180425_c(), this.worker.func_180425_c()).func_176734_d(), 8), this.getCombatMovementSpeed());
    }

    @Override
    public void guardMovement() {
        if (this.worker.isWorkerAtSiteWithMove(this.buildingGuards.getGuardPos(), 10) && Math.abs(this.buildingGuards.getGuardPos().func_177956_o() - this.worker.func_180425_c().func_177956_o()) < 3) {
            ((MinecoloniesAdvancedPathNavigate)this.worker.getNavigator()).setPathJob(new PathJobWalkRandomEdge(this.world, this.buildingGuards.getGuardPos(), 20, (LivingEntity)this.worker), null, this.getCombatMovementSpeed());
        }
    }

    @Override
    public Class<AbstractBuildingGuards> getExpectedBuildingClass() {
        return AbstractBuildingGuards.class;
    }
}

