/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity.ai.citizen.miner;

import com.ldtteam.structurize.util.PlacementSettings;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.interactionhandling.ChatPriority;
import com.minecolonies.api.entity.ai.statemachine.AITarget;
import com.minecolonies.api.entity.ai.statemachine.states.AIWorkerState;
import com.minecolonies.api.entity.ai.statemachine.states.IAIState;
import com.minecolonies.api.entity.citizen.VisibleCitizenStatus;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.LoadOnlyStructureHandler;
import com.minecolonies.api.util.Log;
import com.minecolonies.api.util.Vec2i;
import com.minecolonies.coremod.colony.buildings.workerbuildings.BuildingMiner;
import com.minecolonies.coremod.colony.interactionhandling.StandardInteraction;
import com.minecolonies.coremod.colony.jobs.JobMiner;
import com.minecolonies.coremod.colony.workorders.WorkOrderBuildMiner;
import com.minecolonies.coremod.entity.ai.basic.AbstractEntityAIStructureWithWorkOrder;
import com.minecolonies.coremod.entity.ai.citizen.miner.Level;
import com.minecolonies.coremod.entity.ai.citizen.miner.Node;
import com.minecolonies.coremod.entity.ai.util.BuildingStructureHandler;
import com.minecolonies.coremod.research.MultiplierModifierResearchEffect;
import com.minecolonies.coremod.util.WorkerUtil;
import java.util.List;
import net.minecraft.block.AirBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.LadderBlock;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.state.IProperty;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EntityAIStructureMiner
extends AbstractEntityAIStructureWithWorkOrder<JobMiner, BuildingMiner> {
    private static final String MAIN_SHAFT_NAME = "/miner/minermainshaft";
    private static final String X4_SHAFT_NAME = "/miner/minerx4";
    private static final String X2_RIGHT_SHAFT_NAME = "/miner/minerx2right";
    private static final String X2_TOP_SHAFT_NAME = "/miner/minerx2top";
    private static final int OTHER_SIDE_OF_SHAFT = 6;
    private static final int COBBLE_REQUEST_BATCHES = 32;
    private static final int LADDER_REQUEST_BATCHES = 10;
    private static final String RENDER_META_TORCH = "torch";
    private static final String RENDER_META_STONE = "stone";
    private static final int NODE_DISTANCE = 7;
    private static final int MAX_BLOCKS_MINED = 64;
    private static final int LADDER_SEARCH_RANGE = 10;
    private static final int SHAFT_RADIUS = 3;
    private static final int SAFE_CHECK_RANGE = 5;
    private static final int ROTATE_ONCE = 1;
    private static final int ROTATE_TWICE = 2;
    private static final int ROTATE_THREE_TIMES = 3;
    private static final int ROTATE_FOUR_TIMES = 4;
    private static final int LIQUID_CHECK_RANGE = 5;
    private static final VisibleCitizenStatus MINING = new VisibleCitizenStatus(new ResourceLocation("minecolonies", "textures/icons/work/miner.png"), "com.minecolonies.gui.visiblestatus.miner");
    @Nullable
    private BlockPos minerWorkingLocation;
    @Nullable
    private BlockPos currentStandingPosition;
    @Nullable
    private Node workingNode = null;

    public EntityAIStructureMiner(@NotNull JobMiner job) {
        super(job);
        super.registerTargets(new AITarget((IAIState)AIWorkerState.IDLE, AIWorkerState.START_WORKING, 1), new AITarget((IAIState)AIWorkerState.START_WORKING, this::startWorkingAtOwnBuilding, 20), new AITarget((IAIState)AIWorkerState.PREPARING, this::prepareForMining, 1), new AITarget((IAIState)AIWorkerState.MINER_SEARCHING_LADDER, this::lookForLadder, 20), new AITarget((IAIState)AIWorkerState.MINER_WALKING_TO_LADDER, this::goToLadder, 20), new AITarget((IAIState)AIWorkerState.MINER_REPAIRING_LADDER, this::repairLadder, 5), new AITarget((IAIState)AIWorkerState.MINER_CHECK_MINESHAFT, this::checkMineShaft, 20), new AITarget((IAIState)AIWorkerState.MINER_MINING_SHAFT, this::doShaftMining, 5), new AITarget((IAIState)AIWorkerState.MINER_BUILDING_SHAFT, this::doShaftBuilding, 5), new AITarget((IAIState)AIWorkerState.MINER_MINING_NODE, this::executeNodeMining, 5));
        this.worker.func_98053_h(true);
    }

    @Override
    public Class<BuildingMiner> getExpectedBuildingClass() {
        return BuildingMiner.class;
    }

    @NotNull
    private IAIState startWorkingAtOwnBuilding() {
        this.worker.getCitizenData().setVisibleStatus(VisibleCitizenStatus.WORKING);
        if (this.worker.func_226278_cu_() >= (double)((BuildingMiner)this.getOwnBuilding()).getPosition().func_177956_o() && this.walkToBuilding()) {
            return AIWorkerState.START_WORKING;
        }
        return AIWorkerState.PREPARING;
    }

    @Override
    public int getBreakSpeedLevel() {
        return this.getPrimarySkillLevel();
    }

    @Override
    public int getPlaceSpeedLevel() {
        return this.getSecondarySkillLevel();
    }

    @Override
    protected int getActionsDoneUntilDumping() {
        return ((BuildingMiner)this.getOwnBuilding()).getBuildingLevel() * 64;
    }

    @Override
    protected void updateRenderMetaData() {
        this.worker.setRenderMetadata(this.getRenderMetaStone() + this.getRenderMetaTorch());
    }

    @NotNull
    private String getRenderMetaTorch() {
        if (this.worker.getCitizenInventoryHandler().hasItemInInventory(Items.field_221657_bQ)) {
            return RENDER_META_TORCH;
        }
        return "";
    }

    @NotNull
    private String getRenderMetaStone() {
        if (this.worker.getCitizenInventoryHandler().hasItemInInventory(Blocks.field_150347_e)) {
            return RENDER_META_STONE;
        }
        return "";
    }

    @NotNull
    private IAIState prepareForMining() {
        if (this.getOwnBuilding() != null && !((BuildingMiner)this.getOwnBuilding()).hasFoundLadder()) {
            return AIWorkerState.MINER_SEARCHING_LADDER;
        }
        return AIWorkerState.MINER_CHECK_MINESHAFT;
    }

    @NotNull
    private IAIState goToLadder() {
        if (this.walkToLadder()) {
            return AIWorkerState.MINER_WALKING_TO_LADDER;
        }
        return AIWorkerState.MINER_REPAIRING_LADDER;
    }

    private boolean walkToLadder() {
        return this.walkToBlock(((BuildingMiner)this.getOwnBuilding()).getLadderLocation());
    }

    @NotNull
    private IAIState repairLadder() {
        if (!((BuildingMiner)this.getOwnBuilding()).hasFoundLadder()) {
            return AIWorkerState.MINER_SEARCHING_LADDER;
        }
        BlockPos nextCobble = new BlockPos(((BuildingMiner)this.getOwnBuilding()).getCobbleLocation().func_177958_n(), WorkerUtil.getLastLadder(((BuildingMiner)this.getOwnBuilding()).getLadderLocation(), this.world) - 1, ((BuildingMiner)this.getOwnBuilding()).getCobbleLocation().func_177952_p());
        BlockPos nextLadder = new BlockPos(((BuildingMiner)this.getOwnBuilding()).getLadderLocation().func_177958_n(), WorkerUtil.getLastLadder(((BuildingMiner)this.getOwnBuilding()).getLadderLocation(), this.world) - 1, ((BuildingMiner)this.getOwnBuilding()).getLadderLocation().func_177952_p());
        BlockPos safeStand = new BlockPos(((BuildingMiner)this.getOwnBuilding()).getLadderLocation().func_177958_n(), WorkerUtil.getLastLadder(((BuildingMiner)this.getOwnBuilding()).getLadderLocation(), this.world), ((BuildingMiner)this.getOwnBuilding()).getLadderLocation().func_177952_p());
        if (!this.world.func_180495_p(nextCobble).func_200132_m()) {
            if (!this.checkIfRequestForItemExistOrCreate(new ItemStack((IItemProvider)this.getSolidSubstitution(nextCobble).func_177230_c(), 32))) {
                return this.getState();
            }
            if (!this.world.func_180495_p(nextCobble).isAir((IBlockReader)this.world, nextCobble) && !this.mineBlock(nextCobble, safeStand)) {
                return this.getState();
            }
            this.setBlockFromInventory(nextCobble, Blocks.field_150347_e);
            return this.getState();
        }
        if (!this.world.func_180495_p(nextLadder).isLadder((IWorldReader)this.world, nextLadder, (LivingEntity)this.worker) && !this.world.func_180495_p(nextLadder).func_200132_m()) {
            if (!this.checkIfRequestForItemExistOrCreate(new ItemStack((IItemProvider)Blocks.field_150468_ap, 10))) {
                return this.getState();
            }
            if (!this.world.func_180495_p(nextLadder).isAir((IBlockReader)this.world, nextLadder) && !this.mineBlock(nextLadder, safeStand)) {
                return this.getState();
            }
            BlockState metadata = this.getBlockState(safeStand);
            this.setBlockFromInventory(nextLadder, Blocks.field_150468_ap, metadata);
            return this.getState();
        }
        return AIWorkerState.MINER_CHECK_MINESHAFT;
    }

    @NotNull
    private IAIState checkMineShaft() {
        BuildingMiner buildingMiner = (BuildingMiner)this.getOwnBuilding();
        if (WorkerUtil.getLastLadder(buildingMiner.getLadderLocation(), this.world) < buildingMiner.getDepthLimit()) {
            if (buildingMiner.getNumberOfLevels() == 0) {
                this.worker.getCitizenData().triggerInteraction(new StandardInteraction((ITextComponent)new TranslationTextComponent("entity.miner.messagerequiresbetterhut", new Object[0]), ChatPriority.BLOCKING));
                buildingMiner.setClearedShaft(false);
                return AIWorkerState.IDLE;
            }
            this.worker.getCitizenData().setVisibleStatus(MINING);
            buildingMiner.setClearedShaft(true);
            return AIWorkerState.MINER_MINING_NODE;
        }
        this.worker.getCitizenData().setVisibleStatus(MINING);
        buildingMiner.setClearedShaft(false);
        return AIWorkerState.MINER_MINING_SHAFT;
    }

    @Override
    public ItemStack getTotalAmount(ItemStack stack) {
        if (ItemStackUtils.isEmpty(stack).booleanValue()) {
            return null;
        }
        ItemStack copy = stack.func_77946_l();
        copy.func_190920_e(Math.max(super.getTotalAmount(stack).func_190916_E(), copy.func_77976_d() / 2));
        return copy;
    }

    @NotNull
    private IAIState lookForLadder() {
        BuildingMiner buildingMiner = (BuildingMiner)this.getOwnBuilding();
        if (buildingMiner.hasFoundLadder() && buildingMiner.getLadderLocation() != null) {
            if (this.world.func_180495_p(buildingMiner.getLadderLocation()).func_177230_c() == Blocks.field_150468_ap) {
                return AIWorkerState.MINER_WALKING_TO_LADDER;
            }
            buildingMiner.setFoundLadder(false);
            buildingMiner.setLadderLocation(null);
        }
        int posX = buildingMiner.getPosition().func_177958_n();
        int posY = buildingMiner.getPosition().func_177956_o() + 2;
        int posZ = buildingMiner.getPosition().func_177952_p();
        for (int y = posY - 10; y < posY; ++y) {
            for (int x = posX - 10; x < posX + 10; ++x) {
                for (int z = posZ - 10; z < posZ + 10; ++z) {
                    this.tryFindLadderAt(new BlockPos(x, y, z));
                }
            }
        }
        return AIWorkerState.MINER_SEARCHING_LADDER;
    }

    private void tryFindLadderAt(@NotNull BlockPos pos) {
        BuildingMiner buildingMiner = (BuildingMiner)this.getOwnBuilding();
        if (buildingMiner.hasFoundLadder()) {
            return;
        }
        if (this.world.func_180495_p(pos).func_177230_c().equals(Blocks.field_150468_ap)) {
            int firstLadderY = this.getFirstLadder(pos);
            buildingMiner.setLadderLocation(new BlockPos(pos.func_177958_n(), firstLadderY, pos.func_177952_p()));
            this.validateLadderOrientation();
        }
    }

    private void validateLadderOrientation() {
        BuildingMiner buildingMiner = (BuildingMiner)this.getOwnBuilding();
        Direction ladderOrientation = (Direction)this.world.func_180495_p(buildingMiner.getLadderLocation()).func_177229_b((IProperty)LadderBlock.field_176382_a);
        if (ladderOrientation == Direction.WEST) {
            buildingMiner.setVectorX(-1);
            buildingMiner.setVectorZ(0);
        } else if (ladderOrientation == Direction.EAST) {
            buildingMiner.setVectorX(1);
            buildingMiner.setVectorZ(0);
        } else if (ladderOrientation == Direction.SOUTH) {
            buildingMiner.setVectorX(0);
            buildingMiner.setVectorZ(1);
        } else if (ladderOrientation == Direction.NORTH) {
            buildingMiner.setVectorX(0);
            buildingMiner.setVectorZ(-1);
        } else {
            throw new IllegalStateException("Ladder metadata was " + ladderOrientation);
        }
        int x = buildingMiner.getLadderLocation().func_177958_n();
        int y = buildingMiner.getLadderLocation().func_177956_o();
        int z = buildingMiner.getLadderLocation().func_177952_p();
        buildingMiner.setCobbleLocation(new BlockPos(x - buildingMiner.getVectorX(), y, z - buildingMiner.getVectorZ()));
        buildingMiner.setShaftStart(new BlockPos(x, WorkerUtil.getLastLadder(buildingMiner.getLadderLocation(), this.world) - 1, z));
        buildingMiner.setFoundLadder(true);
    }

    private IAIState doShaftMining() {
        this.worker.getCitizenStatusHandler().setLatestStatus(new ITextComponent[]{new TranslationTextComponent("com.minecolonies.coremod.status.mining", new Object[0])});
        this.minerWorkingLocation = this.getNextBlockInShaftToMine();
        if (this.minerWorkingLocation == null) {
            return this.advanceLadder(AIWorkerState.MINER_MINING_SHAFT);
        }
        if (this.mineBlock(this.minerWorkingLocation, this.currentStandingPosition)) {
            this.worker.decreaseSaturationForContinuousAction();
        }
        return AIWorkerState.MINER_MINING_SHAFT;
    }

    private IAIState advanceLadder(IAIState state) {
        if (!this.checkIfRequestForItemExistOrCreate(new ItemStack((IItemProvider)Blocks.field_150347_e, 32), new ItemStack((IItemProvider)Blocks.field_150468_ap, 10))) {
            return state;
        }
        if (this.ladderDamaged()) {
            return AIWorkerState.MINER_REPAIRING_LADDER;
        }
        int xOffset = 3 * ((BuildingMiner)this.getOwnBuilding()).getVectorX();
        int zOffset = 3 * ((BuildingMiner)this.getOwnBuilding()).getVectorZ();
        BlockPos nextLadder = new BlockPos(((BuildingMiner)this.getOwnBuilding()).getLadderLocation().func_177958_n(), WorkerUtil.getLastLadder(((BuildingMiner)this.getOwnBuilding()).getLadderLocation(), this.world) - 1, ((BuildingMiner)this.getOwnBuilding()).getLadderLocation().func_177952_p());
        BlockPos safeCobble = new BlockPos(((BuildingMiner)this.getOwnBuilding()).getLadderLocation().func_177958_n(), WorkerUtil.getLastLadder(((BuildingMiner)this.getOwnBuilding()).getLadderLocation(), this.world) - 2, ((BuildingMiner)this.getOwnBuilding()).getLadderLocation().func_177952_p());
        for (int x = -5; x <= 5; ++x) {
            for (int z = -5; z <= 5; ++z) {
                BlockPos curBlock = new BlockPos(safeCobble.func_177958_n() + x + xOffset, safeCobble.func_177956_o(), safeCobble.func_177952_p() + z + zOffset);
                if (this.secureBlock(curBlock, this.currentStandingPosition)) continue;
                return state;
            }
        }
        BlockPos safeStand = new BlockPos(((BuildingMiner)this.getOwnBuilding()).getLadderLocation().func_177958_n(), WorkerUtil.getLastLadder(((BuildingMiner)this.getOwnBuilding()).getLadderLocation(), this.world), ((BuildingMiner)this.getOwnBuilding()).getLadderLocation().func_177952_p());
        BlockPos nextCobble = new BlockPos(((BuildingMiner)this.getOwnBuilding()).getCobbleLocation().func_177958_n(), WorkerUtil.getLastLadder(((BuildingMiner)this.getOwnBuilding()).getLadderLocation(), this.world) - 1, ((BuildingMiner)this.getOwnBuilding()).getCobbleLocation().func_177952_p());
        if (((BuildingMiner)this.getOwnBuilding()).getStartingLevelShaft() == 0) {
            ((BuildingMiner)this.getOwnBuilding()).setStartingLevelShaft(nextCobble.func_177956_o() - 4);
        }
        if (nextCobble.func_177956_o() < ((BuildingMiner)this.getOwnBuilding()).getStartingLevelShaft()) {
            return AIWorkerState.MINER_BUILDING_SHAFT;
        }
        if (!this.mineBlock(nextCobble, safeStand) || !this.mineBlock(nextLadder, safeStand)) {
            return state;
        }
        BlockState metadata = this.getBlockState(safeStand);
        this.setBlockFromInventory(nextCobble, Blocks.field_150347_e);
        this.setBlockFromInventory(nextLadder, Blocks.field_150468_ap, metadata);
        this.incrementActionsDoneAndDecSaturation();
        return AIWorkerState.MINER_CHECK_MINESHAFT;
    }

    private BlockState getBlockState(@NotNull BlockPos pos) {
        return this.world.func_180495_p(pos);
    }

    @Nullable
    private BlockPos getNextBlockInShaftToMine() {
        double distance;
        BlockPos curBlock;
        int z;
        int x;
        Block block;
        BlockPos ladderPos = ((BuildingMiner)this.getOwnBuilding()).getLadderLocation();
        int lastLadder = WorkerUtil.getLastLadder(ladderPos, this.world);
        if (this.minerWorkingLocation == null) {
            this.minerWorkingLocation = new BlockPos(ladderPos.func_177958_n(), lastLadder + 1, ladderPos.func_177952_p());
        }
        if (!((block = this.getBlock(this.minerWorkingLocation)) instanceof AirBlock || block == Blocks.field_150468_ap || block.equals(Blocks.field_150355_j) || block.equals(Blocks.field_150353_l))) {
            if (this.currentStandingPosition == null) {
                this.currentStandingPosition = this.minerWorkingLocation;
            }
            return this.minerWorkingLocation;
        }
        this.currentStandingPosition = this.minerWorkingLocation;
        BlockPos nextBlockToMine = null;
        double bestDistance = Double.MAX_VALUE;
        int xOffset = 3 * ((BuildingMiner)this.getOwnBuilding()).getVectorX();
        int zOffset = 3 * ((BuildingMiner)this.getOwnBuilding()).getVectorZ();
        for (x = 3 + xOffset + 2; x >= -3 + xOffset - 2; --x) {
            for (z = -3 + zOffset - 2; z <= 3 + zOffset + 2; ++z) {
                if (x == 0 && 0 == z || !(block = this.getBlock(curBlock = new BlockPos(ladderPos.func_177958_n() + x, lastLadder, ladderPos.func_177952_p() + z))).equals(Blocks.field_150355_j) && !block.equals(Blocks.field_150353_l)) continue;
                this.setBlockFromInventory(curBlock, Blocks.field_150347_e);
            }
        }
        for (x = 3 + xOffset; x >= -3 + xOffset; --x) {
            for (z = -3 + zOffset; z <= 3 + zOffset; ++z) {
                if (x == 0 && 0 == z) continue;
                curBlock = new BlockPos(ladderPos.func_177958_n() + x, lastLadder, ladderPos.func_177952_p() + z);
                distance = curBlock.func_177951_i((Vec3i)ladderPos) + Math.pow(curBlock.func_177951_i((Vec3i)this.minerWorkingLocation), 2.0);
                block = this.getBlock(curBlock);
                if (!(distance < bestDistance) || this.world.func_175623_d(curBlock)) continue;
                if (block.equals(Blocks.field_150355_j) || block.equals(Blocks.field_150353_l)) {
                    this.setBlockFromInventory(curBlock, Blocks.field_150347_e);
                }
                nextBlockToMine = curBlock;
                bestDistance = distance;
            }
        }
        bestDistance = Double.MAX_VALUE;
        if (nextBlockToMine != null) {
            for (x = 1; x >= -1; --x) {
                for (z = -1; z <= 1; ++z) {
                    if (x == 0 && 0 == z || !((distance = (curBlock = new BlockPos(nextBlockToMine.func_177958_n() + x, lastLadder, nextBlockToMine.func_177952_p() + z)).func_177951_i((Vec3i)ladderPos)) < bestDistance) || !this.world.func_175623_d(curBlock)) continue;
                    this.currentStandingPosition = curBlock;
                    bestDistance = distance;
                }
            }
        }
        return nextBlockToMine;
    }

    @NotNull
    private IAIState doShaftBuilding() {
        if (this.walkToBuilding()) {
            return AIWorkerState.MINER_BUILDING_SHAFT;
        }
        BlockPos ladderPos = ((BuildingMiner)this.getOwnBuilding()).getLadderLocation();
        int lastLadder = WorkerUtil.getLastLadder(ladderPos, this.world) + 1;
        int xOffset = 3 * ((BuildingMiner)this.getOwnBuilding()).getVectorX();
        int zOffset = 3 * ((BuildingMiner)this.getOwnBuilding()).getVectorZ();
        this.initStructure(null, 0, new BlockPos(ladderPos.func_177958_n() + xOffset, lastLadder + 1, ladderPos.func_177952_p() + zOffset));
        return AIWorkerState.LOAD_STRUCTURE;
    }

    @NotNull
    private IAIState executeNodeMining() {
        Level currentLevel = ((BuildingMiner)this.getOwnBuilding()).getCurrentLevel();
        if (currentLevel == null) {
            Log.getLogger().warn("Current Level not set, resetting...");
            ((BuildingMiner)this.getOwnBuilding()).setCurrentLevel(((BuildingMiner)this.getOwnBuilding()).getNumberOfLevels() - 1);
            return this.executeNodeMining();
        }
        return this.searchANodeToMine(currentLevel);
    }

    private IAIState searchANodeToMine(@NotNull Level currentLevel) {
        BlockPos standingPosition;
        Node parentNode;
        int vectorZ;
        BuildingMiner buildingMiner = (BuildingMiner)this.getOwnBuilding();
        if (buildingMiner == null) {
            return AIWorkerState.IDLE;
        }
        if (this.workingNode == null || this.workingNode.getStatus() == Node.NodeStatus.COMPLETED) {
            this.workingNode = buildingMiner.getActiveNode();
            buildingMiner.setActiveNode(this.workingNode);
            return AIWorkerState.MINER_CHECK_MINESHAFT;
        }
        int rotation = 0;
        int workingNodeX = this.workingNode.getX() > this.workingNode.getParent().getX() ? 1 : 0;
        int workingNodeZ = this.workingNode.getZ() > this.workingNode.getParent().getZ() ? 1 : 0;
        int vectorX = this.workingNode.getX() < this.workingNode.getParent().getX() ? -1 : workingNodeX;
        int n = vectorZ = this.workingNode.getZ() < this.workingNode.getParent().getZ() ? -1 : workingNodeZ;
        if (vectorX == -1) {
            rotation = 2;
        } else if (vectorZ == -1) {
            rotation = 3;
        } else if (vectorZ == 1) {
            rotation = 1;
        }
        if (this.workingNode.getRot().isPresent() && this.workingNode.getRot().get() != rotation) {
            Log.getLogger().warn("Calculated rotation doesn't match recorded: x:" + workingNodeX + " z:" + workingNodeZ);
        }
        if (!((parentNode = currentLevel.getNode(this.workingNode.getParent())) == null || parentNode.getStyle() == Node.NodeType.SHAFT || parentNode.getStatus() == Node.NodeStatus.COMPLETED && this.world.func_180495_p(new BlockPos(parentNode.getX(), currentLevel.getDepth() + 2, parentNode.getZ())).func_177230_c() instanceof AirBlock)) {
            this.workingNode = parentNode;
            this.workingNode.setStatus(Node.NodeStatus.AVAILABLE);
            buildingMiner.setActiveNode(parentNode);
            buildingMiner.markDirty();
            return AIWorkerState.MINER_CHECK_MINESHAFT;
        }
        this.currentStandingPosition = standingPosition = new BlockPos(this.workingNode.getParent().getX(), currentLevel.getDepth(), this.workingNode.getParent().getZ());
        if (!(this.workingNode.getStatus() != Node.NodeStatus.AVAILABLE && this.workingNode.getStatus() != Node.NodeStatus.IN_PROGRESS || this.walkToBlock(standingPosition))) {
            this.workingNode.setRot(rotation);
            return this.executeStructurePlacement(this.workingNode, standingPosition, rotation);
        }
        return AIWorkerState.MINER_CHECK_MINESHAFT;
    }

    private boolean secureBlock(@NotNull BlockPos curBlock, @NotNull BlockPos safeStand) {
        if (!this.getBlockState(curBlock).func_185904_a().func_76230_c() && this.getBlock(curBlock) != Blocks.field_150478_aa || IColonyManager.getInstance().getCompatibilityManager().isOre(this.world.func_180495_p(curBlock))) {
            if (!this.mineBlock(curBlock, safeStand)) {
                this.setDelay(1);
                return false;
            }
            if (!this.checkIfRequestForItemExistOrCreate(new ItemStack((IItemProvider)Blocks.field_150347_e, 32))) {
                return false;
            }
            this.setBlockFromInventory(curBlock, Blocks.field_150347_e);
            return false;
        }
        return true;
    }

    private void initStructure(Node mineNode, int rotateTimes, BlockPos structurePos) {
        String style = ((BuildingMiner)this.getOwnBuilding()).getStyle();
        String requiredName = null;
        int rotateCount = 0;
        if (mineNode == null) {
            rotateCount = this.getRotationFromVector();
            requiredName = this.getCorrectStyleLocation(style, MAIN_SHAFT_NAME);
        } else {
            rotateCount = rotateTimes;
            if (mineNode.getStyle() == Node.NodeType.CROSSROAD) {
                requiredName = this.getCorrectStyleLocation(style, X4_SHAFT_NAME);
            } else if (mineNode.getStyle() == Node.NodeType.BEND) {
                requiredName = this.getCorrectStyleLocation(style, X2_RIGHT_SHAFT_NAME);
            } else if (mineNode.getStyle() == Node.NodeType.TUNNEL) {
                requiredName = this.getCorrectStyleLocation(style, X2_TOP_SHAFT_NAME);
            }
        }
        if (requiredName != null && ((JobMiner)this.job).getWorkOrder() == null) {
            WorkOrderBuildMiner wo = new WorkOrderBuildMiner(requiredName, requiredName, rotateCount, structurePos, false, ((BuildingMiner)this.getOwnBuilding()).getPosition());
            this.worker.getCitizenColonyHandler().getColony().getWorkManager().addWorkOrder(wo, false);
            ((JobMiner)this.job).setWorkOrder(wo);
        }
    }

    private String getCorrectStyleLocation(String style, String shaft) {
        LoadOnlyStructureHandler wrapper = new LoadOnlyStructureHandler(this.world, ((BuildingMiner)this.getOwnBuilding()).getPosition(), "schematics/" + style + shaft, new PlacementSettings(), true);
        if (wrapper.hasBluePrint()) {
            return "schematics/" + style + shaft;
        }
        return "schematics" + shaft;
    }

    private int getRotationFromVector() {
        if (((BuildingMiner)this.getOwnBuilding()).getVectorX() == 1) {
            return 1;
        }
        if (((BuildingMiner)this.getOwnBuilding()).getVectorZ() == 1) {
            return 2;
        }
        if (((BuildingMiner)this.getOwnBuilding()).getVectorX() == -1) {
            return 3;
        }
        if (((BuildingMiner)this.getOwnBuilding()).getVectorZ() == -1) {
            return 4;
        }
        return 0;
    }

    private IAIState executeStructurePlacement(@NotNull Node mineNode, @NotNull BlockPos standingPosition, int rotation) {
        mineNode.setStatus(Node.NodeStatus.IN_PROGRESS);
        ((BuildingMiner)this.getOwnBuilding()).markDirty();
        if (((JobMiner)this.job).getBlueprint() == null) {
            this.initStructure(mineNode, rotation, new BlockPos(mineNode.getX(), ((BuildingMiner)this.getOwnBuilding()).getCurrentLevel().getDepth(), mineNode.getZ()));
            return AIWorkerState.LOAD_STRUCTURE;
        }
        for (int x = -4; x <= 4; ++x) {
            for (int z = -4; z <= 4; ++z) {
                for (int y = -1; y <= 5; ++y) {
                    BlockPos curBlock = new BlockPos(mineNode.getX() + x, standingPosition.func_177956_o() + y, mineNode.getZ() + z);
                    Block block = this.getBlock(curBlock);
                    if (!block.equals(Blocks.field_150355_j) && !block.equals(Blocks.field_150353_l)) continue;
                    this.setBlockFromInventory(curBlock, Blocks.field_150347_e);
                }
            }
        }
        this.workingNode = null;
        if (((JobMiner)this.job).getBlueprint() != null) {
            return AIWorkerState.LOAD_STRUCTURE;
        }
        return AIWorkerState.MINER_MINING_NODE;
    }

    @Override
    public IAIState afterStructureLoading() {
        return AIWorkerState.BUILDING_STEP;
    }

    private void setBlockFromInventory(@NotNull BlockPos location, @NotNull Block block) {
        this.worker.func_184609_a(this.worker.func_184600_cs());
        this.setBlockFromInventory(location, block, block.func_176223_P());
    }

    private void setBlockFromInventory(@NotNull BlockPos location, Block block, BlockState metadata) {
        int slot = block instanceof LadderBlock ? this.worker.getCitizenInventoryHandler().findFirstSlotInInventoryWith(block) : this.worker.getCitizenInventoryHandler().findFirstSlotInInventoryWith(block);
        if (slot != -1) {
            this.getInventory().extractItem(slot, 1, false);
            this.world.func_180501_a(location, metadata, 3);
        }
    }

    private Block getBlock(@NotNull BlockPos loc) {
        return this.world.func_180495_p(loc).func_177230_c();
    }

    private int getFirstLadder(@NotNull BlockPos pos) {
        while (this.world.func_180495_p(pos).isLadder((IWorldReader)this.world, pos, (LivingEntity)this.worker)) {
            pos = pos.func_177984_a();
        }
        return pos.func_177956_o() - 1;
    }

    @Override
    public void executeSpecificCompleteActions() {
        List<WorkOrderBuildMiner> workOrders;
        BuildingMiner minerBuilding = (BuildingMiner)this.getOwnBuilding();
        if (minerBuilding.hasClearedShaft()) {
            Level currentLevel = minerBuilding.getCurrentLevel();
            currentLevel.closeNextNode(((BuildingStructureHandler)((Object)this.structurePlacer.getB())).getSettings().rotation.ordinal(), ((BuildingMiner)this.getOwnBuilding()).getActiveNode(), this.world);
            ((BuildingMiner)this.getOwnBuilding()).setActiveNode(null);
            ((BuildingMiner)this.getOwnBuilding()).setOldNode(this.workingNode);
            WorkerUtil.updateLevelSign(this.world, currentLevel, minerBuilding.getLevelId(currentLevel));
        } else if (((JobMiner)this.job).getBlueprint() != null) {
            BlockPos levelSignPos = WorkerUtil.findFirstLevelSign(((JobMiner)this.job).getBlueprint(), ((JobMiner)this.job).getWorkOrder().getBuildingLocation());
            Level currentLevel = new Level(minerBuilding, ((JobMiner)this.job).getWorkOrder().getBuildingLocation().func_177956_o(), levelSignPos);
            minerBuilding.addLevel(currentLevel);
            minerBuilding.setCurrentLevel(minerBuilding.getNumberOfLevels());
            WorkerUtil.updateLevelSign(this.world, currentLevel, minerBuilding.getLevelId(currentLevel));
        }
        super.executeSpecificCompleteActions();
        ((BuildingMiner)this.getOwnBuilding()).markDirty();
        ((JobMiner)this.job).setBlueprint(null);
        IColony colony = this.worker.getCitizenColonyHandler().getColony();
        if (colony != null && (workOrders = colony.getWorkManager().getWorkOrdersOfType(WorkOrderBuildMiner.class)).size() > 2) {
            for (WorkOrderBuildMiner order : workOrders) {
                if (!((BuildingMiner)this.getOwnBuilding()).getID().equals((Object)order.getMinerBuilding())) continue;
                colony.getWorkManager().removeWorkOrder(order.getID());
            }
        }
    }

    @Override
    public BlockPos getWorkingPosition(BlockPos targetPosition) {
        return this.getNodeMiningPosition(targetPosition);
    }

    private BlockPos getNodeMiningPosition(BlockPos blockToMine) {
        BuildingMiner buildingMiner = (BuildingMiner)this.getOwnBuilding();
        if (buildingMiner.getCurrentLevel() == null || buildingMiner.getActiveNode() == null) {
            return blockToMine;
        }
        Vec2i parentPos = buildingMiner.getActiveNode().getParent();
        if (parentPos != null && buildingMiner.getCurrentLevel().getNode(parentPos) != null && buildingMiner.getCurrentLevel().getNode(parentPos).getStyle() == Node.NodeType.SHAFT) {
            BlockPos ladderPos = buildingMiner.getLadderLocation();
            return new BlockPos(ladderPos.func_177958_n() + buildingMiner.getVectorX() * 6, buildingMiner.getCurrentLevel().getDepth(), ladderPos.func_177952_p() + buildingMiner.getVectorZ() * 6);
        }
        Vec2i pos = buildingMiner.getActiveNode().getParent();
        return new BlockPos(pos.getX(), buildingMiner.getCurrentLevel().getDepth(), pos.getZ());
    }

    @Override
    public boolean shallReplaceSolidSubstitutionBlock(Block worldBlock, BlockState worldMetadata) {
        return IColonyManager.getInstance().getCompatibilityManager().isOre(worldMetadata);
    }

    @Override
    protected void triggerMinedBlock(@NotNull BlockState blockToMine) {
        super.triggerMinedBlock(blockToMine);
        double chance = 1.0;
        MultiplierModifierResearchEffect effect = this.worker.getCitizenColonyHandler().getColony().getResearchManager().getResearchEffects().getEffect("More Ores", MultiplierModifierResearchEffect.class);
        if (effect != null) {
            chance += effect.getEffect().doubleValue();
        }
        if (IColonyManager.getInstance().getCompatibilityManager().isLuckyBlock(new ItemStack((IItemProvider)blockToMine.func_177230_c()))) {
            InventoryUtils.transferItemStackIntoNextBestSlotInItemHandler(IColonyManager.getInstance().getCompatibilityManager().getRandomLuckyOre(chance), (IItemHandler)this.worker.getInventoryCitizen());
        }
    }

    @Override
    public BlockState getSolidSubstitution(BlockPos ignored) {
        return Blocks.field_150347_e.func_176223_P();
    }

    @Override
    protected boolean checkIfCanceled() {
        if (super.checkIfCanceled()) {
            return true;
        }
        if (!this.isThereAStructureToBuild()) {
            switch ((AIWorkerState)this.getState()) {
                case BUILDING_STEP: {
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    private boolean ladderDamaged() {
        BlockPos nextLadder = new BlockPos(((BuildingMiner)this.getOwnBuilding()).getLadderLocation().func_177958_n(), WorkerUtil.getLastLadder(((BuildingMiner)this.getOwnBuilding()).getLadderLocation(), this.world) - 1, ((BuildingMiner)this.getOwnBuilding()).getLadderLocation().func_177952_p());
        return !this.world.func_180495_p(nextLadder).isLadder((IWorldReader)this.world, nextLadder, (LivingEntity)this.worker) && !this.world.func_180495_p(nextLadder).func_200132_m();
    }
}

