/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity.ai.citizen.school;

import com.minecolonies.api.colony.interactionhandling.ChatPriority;
import com.minecolonies.api.entity.ModEntities;
import com.minecolonies.api.entity.ai.statemachine.AITarget;
import com.minecolonies.api.entity.ai.statemachine.states.AIWorkerState;
import com.minecolonies.api.entity.ai.statemachine.states.IAIState;
import com.minecolonies.api.entity.citizen.Skill;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.coremod.Network;
import com.minecolonies.coremod.colony.buildings.workerbuildings.BuildingSchool;
import com.minecolonies.coremod.colony.interactionhandling.StandardInteraction;
import com.minecolonies.coremod.colony.jobs.JobPupil;
import com.minecolonies.coremod.entity.SittingEntity;
import com.minecolonies.coremod.entity.ai.basic.AbstractEntityAIInteract;
import com.minecolonies.coremod.entity.citizen.EntityCitizen;
import com.minecolonies.coremod.network.messages.client.CircleParticleEffectMessage;
import com.minecolonies.coremod.research.MultiplierModifierResearchEffect;
import java.util.function.Predicate;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;

public class EntityAIWorkPupil
extends AbstractEntityAIInteract<JobPupil, BuildingSchool> {
    private static final int STUDY_TO_RECESS_RATIO = 10;
    private final Predicate<ItemStack> PAPER = stack -> stack.func_77973_b() == Items.field_151121_aF;
    private int maxSittingTicks = 0;
    private int sittingTicks = 0;
    private BlockPos studyPos;
    private BlockPos recessPos;

    public EntityAIWorkPupil(@NotNull JobPupil job) {
        super(job);
        super.registerTargets(new AITarget((IAIState)AIWorkerState.IDLE, AIWorkerState.START_WORKING, 1), new AITarget((IAIState)AIWorkerState.START_WORKING, this::startWorkingAtOwnBuilding, 20), new AITarget((IAIState)AIWorkerState.DECIDE, this::decide, 20), new AITarget((IAIState)AIWorkerState.STUDY, this::study, 20), new AITarget((IAIState)AIWorkerState.RECESS, this::recess, 20));
        this.worker.func_98053_h(true);
    }

    private IAIState decide() {
        if (this.worker.getRandom().nextInt(10) < 1) {
            this.recessPos = ((BuildingSchool)this.getOwnBuilding()).getPosition();
            return AIWorkerState.RECESS;
        }
        BuildingSchool school = (BuildingSchool)this.getOwnBuilding();
        BlockPos pos = school.getRandomPlaceToSit();
        if (pos == null) {
            this.worker.getCitizenData().triggerInteraction(new StandardInteraction((ITextComponent)new TranslationTextComponent("com.minecolonies.coremod.school.nocarpet", new Object[0]), ChatPriority.BLOCKING));
            return AIWorkerState.DECIDE;
        }
        this.studyPos = pos;
        return AIWorkerState.STUDY;
    }

    private IAIState recess() {
        if (this.recessPos == null || this.worker.getRandom().nextInt(10) < 1) {
            return AIWorkerState.START_WORKING;
        }
        if (this.walkToBlock(this.recessPos)) {
            return this.getState();
        }
        BlockPos newRecessPos = this.findRandomPositionToWalkTo(10);
        if (newRecessPos != null) {
            this.recessPos = newRecessPos;
        }
        return this.getState();
    }

    private IAIState study() {
        int slot;
        if (this.studyPos == null) {
            return AIWorkerState.DECIDE;
        }
        if (this.walkToBlock(this.studyPos)) {
            return this.getState();
        }
        if (!this.world.func_217357_a(EntityCitizen.class, new AxisAlignedBB((double)this.studyPos.func_177958_n(), (double)this.studyPos.func_177956_o(), (double)this.studyPos.func_177952_p(), (double)this.studyPos.func_177958_n(), (double)this.studyPos.func_177956_o(), (double)this.studyPos.func_177952_p())).isEmpty()) {
            this.studyPos = null;
            return AIWorkerState.DECIDE;
        }
        if (this.sittingTicks == 0 || this.worker.field_184239_as == null) {
            this.maxSittingTicks = this.worker.getRandom().nextInt(60) + 60;
            SittingEntity entity = (SittingEntity)ModEntities.SITTINGENTITY.func_200721_a(this.world);
            entity.func_70107_b(this.studyPos.func_177958_n(), (double)this.studyPos.func_177956_o() - 0.6, this.studyPos.func_177952_p());
            entity.setMaxLifeTime(this.maxSittingTicks * 20);
            this.world.func_217376_c((Entity)entity);
            this.worker.func_184220_m(entity);
            this.worker.getNavigator().func_75499_g();
        }
        if ((slot = InventoryUtils.findFirstSlotInItemHandlerWith((IItemHandler)this.worker.getInventoryCitizen(), this.PAPER)) != -1) {
            Network.getNetwork().sendToTrackingEntity(new CircleParticleEffectMessage(this.worker.func_174791_d().func_72441_c(0.0, 1.0, 0.0), ParticleTypes.field_197623_p, this.sittingTicks), (Entity)this.worker);
        } else {
            Network.getNetwork().sendToTrackingEntity(new CircleParticleEffectMessage(this.worker.func_174791_d().func_72441_c(0.0, 1.0, 0.0), ParticleTypes.field_197632_y, this.sittingTicks), (Entity)this.worker);
        }
        ++this.sittingTicks;
        if (this.sittingTicks < this.maxSittingTicks) {
            return this.getState();
        }
        if (this.worker.field_184239_as != null) {
            this.worker.func_184210_p();
            this.worker.func_70107_b(this.worker.field_70165_t, this.worker.field_70163_u + 1.0, this.worker.field_70161_v);
        }
        if (slot != -1) {
            InventoryUtils.reduceStackInItemHandler((IItemHandler)this.worker.getInventoryCitizen(), new ItemStack((IItemProvider)Items.field_151121_aF), 1);
            double bonus = 25.0;
            MultiplierModifierResearchEffect effect = this.worker.getCitizenColonyHandler().getColony().getResearchManager().getResearchEffects().getEffect("Teaching", MultiplierModifierResearchEffect.class);
            if (effect != null) {
                bonus *= 1.0 + effect.getEffect();
            }
            this.worker.getCitizenData().getCitizenSkillHandler().addXpToSkill(Skill.Intelligence, bonus, this.worker.getCitizenData());
        }
        this.worker.decreaseSaturationForContinuousAction();
        this.maxSittingTicks = 0;
        this.sittingTicks = 0;
        return null;
    }

    @Override
    public Class<BuildingSchool> getExpectedBuildingClass() {
        return BuildingSchool.class;
    }

    private IAIState startWorkingAtOwnBuilding() {
        if (this.walkToBuilding()) {
            return this.getState();
        }
        return AIWorkerState.STUDY;
    }
}

