/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity.ai.citizen.school;

import com.minecolonies.api.colony.requestsystem.requestable.Stack;
import com.minecolonies.api.entity.ModEntities;
import com.minecolonies.api.entity.ai.statemachine.AITarget;
import com.minecolonies.api.entity.ai.statemachine.states.AIWorkerState;
import com.minecolonies.api.entity.ai.statemachine.states.IAIState;
import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import com.minecolonies.api.entity.citizen.Skill;
import com.minecolonies.api.entity.citizen.VisibleCitizenStatus;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.api.util.Tuple;
import com.minecolonies.coremod.colony.buildings.workerbuildings.BuildingSchool;
import com.minecolonies.coremod.colony.jobs.JobPupil;
import com.minecolonies.coremod.colony.jobs.JobTeacher;
import com.minecolonies.coremod.entity.SittingEntity;
import com.minecolonies.coremod.entity.ai.basic.AbstractEntityAIInteract;
import com.minecolonies.coremod.research.MultiplierModifierResearchEffect;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;

public class EntityAIWorkTeacher
extends AbstractEntityAIInteract<JobTeacher, BuildingSchool> {
    private static final int PAPER_TO_REQUEST = 16;
    private final Predicate<ItemStack> PAPER = stack -> stack.func_77973_b() == Items.field_151121_aF;
    private static final VisibleCitizenStatus TEACHING_ICON = new VisibleCitizenStatus(new ResourceLocation("minecolonies", "textures/icons/work/teacher_student.png"), "com.minecolonies.gui.visiblestatus.teacher_student");
    private AxisAlignedBB targetArea = null;
    private AbstractEntityCitizen pupilToTeach;
    private int maxSittingTicks = 0;
    private int sittingTicks = 0;

    public EntityAIWorkTeacher(@NotNull JobTeacher job) {
        super(job);
        super.registerTargets(new AITarget((IAIState)AIWorkerState.IDLE, AIWorkerState.START_WORKING, 1), new AITarget((IAIState)AIWorkerState.START_WORKING, this::startWorkingAtOwnBuilding, 20), new AITarget((IAIState)AIWorkerState.DECIDE, this::decide, 20), new AITarget((IAIState)AIWorkerState.TEACH, this::teach, 20));
        this.worker.func_98053_h(true);
    }

    private IAIState decide() {
        int paperInInv;
        int paperInBuilding = InventoryUtils.getItemCountInProvider(this.getOwnBuilding(), this.PAPER);
        if (paperInBuilding + (paperInInv = InventoryUtils.getItemCountInItemHandler((IItemHandler)this.worker.getInventoryCitizen(), this.PAPER)) <= 0) {
            this.requestPaper();
        }
        if (paperInInv == 0 && paperInBuilding > 0) {
            this.needsCurrently = new Tuple<Predicate<ItemStack>, Integer>(this.PAPER, 16);
            return AIWorkerState.GATHERING_REQUIRED_MATERIALS;
        }
        List pupils = this.world.func_217394_a(ModEntities.CITIZEN, this.getTargetableArea(), cit -> cit.func_70631_g_() && cit.field_184239_as != null && cit.getCitizenJobHandler().getColonyJob() instanceof JobPupil);
        if (pupils.size() > 0) {
            this.pupilToTeach = (AbstractEntityCitizen)pupils.get(this.worker.getRandom().nextInt(pupils.size()));
            return AIWorkerState.TEACH;
        }
        return AIWorkerState.START_WORKING;
    }

    private IAIState teach() {
        int slot;
        if (this.pupilToTeach == null || this.pupilToTeach.field_184239_as == null) {
            return AIWorkerState.START_WORKING;
        }
        this.worker.getCitizenData().setVisibleStatus(TEACHING_ICON);
        if (this.walkToBlock(this.pupilToTeach.func_180425_c())) {
            return this.getState();
        }
        if (this.maxSittingTicks == 0 || this.worker.field_184239_as == null) {
            int jobModifier = (int)(100.0 / Math.max(1.0, (double)this.getSecondarySkillLevel() / 2.0));
            this.maxSittingTicks = this.worker.getRandom().nextInt(jobModifier / 2) + jobModifier / 2;
            SittingEntity entity = (SittingEntity)ModEntities.SITTINGENTITY.func_200721_a(this.world);
            entity.func_70107_b(this.worker.field_70165_t, this.worker.field_70163_u - 1.0, this.worker.field_70161_v);
            entity.setMaxLifeTime(this.maxSittingTicks * 20);
            this.world.func_217376_c((Entity)entity);
            this.worker.func_184220_m(entity);
            this.worker.getNavigator().func_75499_g();
        }
        ++this.sittingTicks;
        if (this.sittingTicks < this.maxSittingTicks) {
            return this.getState();
        }
        if (this.worker.field_184239_as != null) {
            this.worker.func_184210_p();
            this.worker.func_70107_b(this.worker.field_70165_t, this.worker.field_70163_u + 1.0, this.worker.field_70161_v);
        }
        if ((slot = InventoryUtils.findFirstSlotInItemHandlerWith((IItemHandler)this.worker.getInventoryCitizen(), this.PAPER)) != -1) {
            InventoryUtils.transferXOfFirstSlotInItemHandlerWithIntoNextFreeSlotInItemHandler((IItemHandler)this.worker.getInventoryCitizen(), this.PAPER, 1, (IItemHandler)this.pupilToTeach.getInventoryCitizen());
        }
        double xp = 1.0 * (1.0 + (double)this.worker.getCitizenData().getCitizenSkillHandler().getLevel(Skill.Intelligence) / 10.0);
        MultiplierModifierResearchEffect effect = this.worker.getCitizenColonyHandler().getColony().getResearchManager().getResearchEffects().getEffect("Teaching", MultiplierModifierResearchEffect.class);
        if (effect != null) {
            xp *= 1.0 + effect.getEffect();
            xp *= 1.0 + (double)this.getPrimarySkillLevel() / 10.0;
        }
        this.pupilToTeach.getCitizenData().getCitizenSkillHandler().addXpToSkill(Skill.Intelligence, xp, this.pupilToTeach.getCitizenData());
        this.worker.getCitizenExperienceHandler().addExperience(0.1);
        this.worker.decreaseSaturationForContinuousAction();
        this.incrementActionsDone();
        this.maxSittingTicks = 0;
        this.sittingTicks = 0;
        return AIWorkerState.START_WORKING;
    }

    @Override
    protected int getActionsDoneUntilDumping() {
        return 50;
    }

    private void requestPaper() {
        if (!((BuildingSchool)this.getOwnBuilding()).hasWorkerOpenRequestsFiltered(this.worker.getCitizenData(), q -> q.getRequest() instanceof Stack && ((Stack)q.getRequest()).getStack().func_77973_b() == Items.field_151121_aF)) {
            this.worker.getCitizenData().createRequestAsync(new Stack(new ItemStack((IItemProvider)Items.field_151121_aF, 16)));
        }
    }

    @Override
    public Class<BuildingSchool> getExpectedBuildingClass() {
        return BuildingSchool.class;
    }

    private AxisAlignedBB getTargetableArea() {
        if (this.targetArea == null) {
            this.targetArea = ((BuildingSchool)this.getOwnBuilding()).getTargetableArea(this.world);
        }
        return this.targetArea;
    }

    private IAIState startWorkingAtOwnBuilding() {
        if (this.walkToBuilding()) {
            return this.getState();
        }
        return AIWorkerState.DECIDE;
    }
}

