/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity.ai.minimal;

import com.minecolonies.api.entity.ai.statemachine.AITarget;
import com.minecolonies.api.entity.ai.statemachine.states.AIWorkerState;
import com.minecolonies.api.entity.ai.statemachine.states.IAIState;
import com.minecolonies.api.entity.ai.statemachine.tickratestatemachine.ITickRateStateMachine;
import com.minecolonies.api.entity.ai.statemachine.tickratestatemachine.TickRateStateMachine;
import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import com.minecolonies.api.entity.pathfinding.PathResult;
import com.minecolonies.api.util.CompatibilityUtils;
import com.minecolonies.api.util.Log;
import com.minecolonies.coremod.colony.jobs.AbstractJobGuard;
import java.util.EnumSet;
import java.util.Optional;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EntityAICitizenAvoidEntity
extends Goal {
    private static final double TOO_CLOSE_TO_MOB = 4.0;
    private static final int CHECKS_BEFORE_SAFE = 40;
    private static final float MIN_MOVE_AWAY_DIST = 5.0f;
    private static final float MED_MOVE_AWAY_DIST = 10.0f;
    private static final float MAX_MOVE_AWAY_DIST = 20.0f;
    private final AbstractEntityCitizen citizen;
    private final double farSpeed;
    private final double nearSpeed;
    private final float distanceFromEntity;
    private final Class<? extends Entity> targetEntityClass;
    @Nullable
    private Entity closestLivingEntity;
    private int fleeingCounter = 0;
    private PathResult moveAwayPath;
    private final ITickRateStateMachine<IAIState> stateMachine;
    private BlockPos startingPos;
    private final Random rand = new Random();

    public EntityAICitizenAvoidEntity(@NotNull AbstractEntityCitizen entity, @NotNull Class<? extends Entity> targetEntityClass, float distanceFromEntity, double farSpeed, double nearSpeed) {
        this.citizen = entity;
        this.startingPos = entity.func_180425_c();
        this.targetEntityClass = targetEntityClass;
        this.distanceFromEntity = distanceFromEntity;
        this.farSpeed = farSpeed;
        this.nearSpeed = nearSpeed;
        super.func_220684_a(EnumSet.of(Goal.Flag.MOVE));
        this.stateMachine = new TickRateStateMachine<AIWorkerState>(AIWorkerState.SAFE, this::onException);
        this.stateMachine.addTransition(new AITarget(AIWorkerState.SAFE, this::isEntityClose, () -> AIWorkerState.RUNNING, 5));
        this.stateMachine.addTransition(new AITarget(AIWorkerState.RUNNING, this::updateMoving, () -> AIWorkerState.SAFE, 5));
    }

    private void onException(RuntimeException e) {
        Log.getLogger().warn("AvoidAI of:" + this.citizen.func_200200_C_() + " threw an Exception:", (Throwable)e);
    }

    public boolean isEntityClose() {
        if (!this.citizen.isCurrentlyFleeing()) {
            return false;
        }
        ++this.fleeingCounter;
        if (this.fleeingCounter == 40) {
            this.fleeingCounter = 0;
            this.citizen.setFleeingState(false);
            this.citizen.getNavigator().tryMoveToBlockPos(this.startingPos, 1.0);
            return false;
        }
        this.closestLivingEntity = this.getClosestToAvoid();
        return this.closestLivingEntity != null && !(this.citizen.getCitizenJobHandler().getColonyJob() instanceof AbstractJobGuard);
    }

    private Entity getClosestToAvoid() {
        if (this.targetEntityClass == PlayerEntity.class) {
            return CompatibilityUtils.getWorldFromCitizen(this.citizen).func_217362_a((Entity)this.citizen, (double)this.distanceFromEntity);
        }
        Optional<Entity> entityOptional = CompatibilityUtils.getWorldFromCitizen(this.citizen).func_175674_a((Entity)this.citizen, this.citizen.func_174813_aQ().func_72314_b((double)this.distanceFromEntity, 3.0, (double)this.distanceFromEntity), target -> target.func_70089_S() && this.citizen.func_70635_at().func_75522_a(target)).stream().filter(this.targetEntityClass::isInstance).findFirst();
        return entityOptional.orElse(null);
    }

    private boolean performMoveAway() {
        if ((this.moveAwayPath == null || !this.moveAwayPath.isInProgress()) && this.citizen.getNavigator().func_75500_f()) {
            this.moveAwayPath = this.citizen.getNavigator().moveAwayFromXYZ(this.citizen.func_180425_c().func_177982_a(this.rand.nextInt(2), 0, this.rand.nextInt(2)), this.distanceFromEntity + this.getMoveAwayDist(this.citizen), this.nearSpeed);
            this.citizen.getCitizenStatusHandler().setLatestStatus(new ITextComponent[]{new TranslationTextComponent("com.minecolonies.coremod.status.avoiding", new Object[0])});
            return true;
        }
        return false;
    }

    private float getMoveAwayDist(AbstractEntityCitizen citizen) {
        if (citizen.func_110143_aJ() >= citizen.func_110138_aP() - 4.0f) {
            return 5.0f;
        }
        if (citizen.func_110143_aJ() >= citizen.func_110138_aP() / 2.0f) {
            return 10.0f;
        }
        return 20.0f;
    }

    private boolean updateMoving() {
        this.citizen.playMoveAwaySound();
        Entity newClosest = this.getClosestToAvoid();
        if (newClosest != null) {
            if (newClosest.func_145782_y() != this.closestLivingEntity.func_145782_y()) {
                this.citizen.callForHelp(newClosest, 90000);
                this.closestLivingEntity = newClosest;
            }
            this.performMoveAway();
        }
        if (this.moveAwayPath == null || !this.moveAwayPath.isInProgress()) {
            this.fleeingCounter = 0;
            return true;
        }
        if ((double)this.citizen.func_70032_d(this.closestLivingEntity) < 4.0) {
            this.citizen.getNavigator().func_75489_a(this.nearSpeed);
        } else {
            this.citizen.getNavigator().func_75489_a(this.farSpeed);
        }
        return false;
    }

    public boolean func_75250_a() {
        if (this.citizen.isCurrentlyFleeing() && this.citizen.getCitizenJobHandler().shouldRunAvoidance() && (this.citizen.getCitizenJobHandler().getColonyJob() == null || this.citizen.getCitizenJobHandler().getColonyJob().canAIBeInterrupted())) {
            this.startingPos = this.citizen.func_180425_c();
            this.fleeingCounter = 0;
            return !((double)this.citizen.func_110143_aJ() <= 6.0) || this.citizen.getCitizenColonyHandler().getColony() == null || this.citizen.getCitizenColonyHandler().getColony().getBuildingManager().getBestHospital(this.citizen) == null;
        }
        return false;
    }

    public boolean func_75253_b() {
        this.stateMachine.tick();
        if ((double)this.citizen.func_110143_aJ() <= 6.0 && this.citizen.getCitizenColonyHandler().getColony() != null && this.citizen.getCitizenColonyHandler().getColony().getBuildingManager().getBestHospital(this.citizen) != null) {
            return false;
        }
        return this.citizen.isCurrentlyFleeing() && this.citizen.getCitizenJobHandler().shouldRunAvoidance();
    }

    public void func_75251_c() {
        this.closestLivingEntity = null;
        this.moveAwayPath = null;
        this.stateMachine.reset();
    }
}

