/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity.ai.minimal;

import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.CompatibilityUtils;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.FenceGateBlock;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.pathfinding.GroundPathNavigator;
import net.minecraft.pathfinding.Path;
import net.minecraft.pathfinding.PathPoint;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EntityAIGateInteract
extends Goal {
    private static final int HEIGHT_TO_CHECK = 2;
    private static final int LENGTH_TO_CHECK = 2;
    private static final double MIN_DISTANCE = 2.25;
    protected MobEntity theEntity;
    protected BlockPos gatePosition = BlockPos.field_177992_a;
    @Nullable
    protected FenceGateBlock gateBlock;
    private boolean hasStoppedFenceInteraction;
    private double entityPositionX;
    private double entityPositionZ;
    private Direction direction;

    public EntityAIGateInteract(@NotNull MobEntity entityIn) {
        this.theEntity = entityIn;
        if (!(entityIn.func_70661_as() instanceof GroundPathNavigator)) {
            throw new IllegalArgumentException("Unsupported mob type for DoorInteractGoal");
        }
    }

    public boolean func_75250_a() {
        return this.theEntity.field_70123_F && this.checkPath();
    }

    private boolean checkPath() {
        GroundPathNavigator pathnavigateground = (GroundPathNavigator)this.theEntity.func_70661_as();
        Path path = pathnavigateground.func_75505_d();
        return path != null && !path.func_75879_b() && pathnavigateground.func_179686_g() && this.checkFenceGate(path);
    }

    private boolean checkFenceGate(@NotNull Path path) {
        int maxLengthToCheck = Math.min(path.func_75873_e() + 2, path.func_75874_d());
        for (int i = Math.max(0, path.func_75873_e() - 1); i < maxLengthToCheck; ++i) {
            PathPoint pathpoint = path.func_75877_a(i);
            for (int level = 0; level < 2; ++level) {
                this.gatePosition = new BlockPos(pathpoint.field_75839_a, pathpoint.field_75837_b + level, pathpoint.field_75838_c);
                if (!(this.theEntity.func_70092_e((double)this.gatePosition.func_177958_n(), this.theEntity.field_70163_u, (double)this.gatePosition.func_177952_p()) <= 2.25)) continue;
                this.gateBlock = this.getBlockFence(this.gatePosition);
                if (this.gateBlock == null) continue;
                if (i > 0) {
                    PathPoint prevPathPoint = path.func_75877_a(i - 1);
                    this.direction = BlockPosUtil.getFacing(new BlockPos(pathpoint.field_75839_a, 0, pathpoint.field_75838_c), new BlockPos(prevPathPoint.field_75839_a, 0, prevPathPoint.field_75838_c));
                }
                return true;
            }
        }
        this.gatePosition = new BlockPos((Entity)this.theEntity).func_177984_a();
        this.gateBlock = this.getBlockFence(this.gatePosition);
        return this.gateBlock != null;
    }

    private FenceGateBlock getBlockFence(@NotNull BlockPos pos) {
        BlockState blockState = CompatibilityUtils.getWorldFromEntity((Entity)this.theEntity).func_180495_p(pos);
        Block block = blockState.func_177230_c();
        if (!(block instanceof FenceGateBlock) || blockState.func_185904_a() != Material.field_151575_d) {
            block = CompatibilityUtils.getWorldFromEntity((Entity)this.theEntity).func_180495_p(this.theEntity.func_180425_c()).func_177230_c();
            this.gatePosition = this.theEntity.func_180425_c();
        }
        return block instanceof FenceGateBlock && blockState.func_185904_a() == Material.field_151575_d ? (FenceGateBlock)block : null;
    }

    public boolean func_75253_b() {
        return !this.hasStoppedFenceInteraction && this.direction != null;
    }

    public void func_75249_e() {
        this.hasStoppedFenceInteraction = false;
        this.entityPositionX = (double)this.gatePosition.func_177958_n() + 0.5 - this.theEntity.field_70165_t;
        this.entityPositionZ = (double)this.gatePosition.func_177952_p() + 0.5 - this.theEntity.field_70161_v;
    }

    public void func_75246_d() {
        if (this.direction != null) {
            double entityDistX = Math.abs((double)this.gatePosition.func_177958_n() + 0.5 - this.theEntity.func_226277_ct_() + (double)this.direction.func_82601_c());
            double entityDistZ = Math.abs((double)this.gatePosition.func_177952_p() + 0.5 - this.theEntity.func_226281_cx_() + (double)this.direction.func_82599_e());
            if (entityDistX > 0.5 && entityDistX < 1.0 || entityDistZ > 0.5 && entityDistZ < 1.0) {
                this.hasStoppedFenceInteraction = true;
            }
        }
    }
}

