/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity.ai.minimal;

import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.buildings.IBuildingBedProvider;
import com.minecolonies.api.entity.ai.DesiredActivity;
import com.minecolonies.api.entity.ai.Status;
import com.minecolonies.api.entity.ai.statemachine.states.IState;
import com.minecolonies.api.entity.ai.statemachine.tickratestatemachine.TickRateStateMachine;
import com.minecolonies.api.entity.ai.statemachine.tickratestatemachine.TickingTransition;
import com.minecolonies.api.entity.citizen.VisibleCitizenStatus;
import com.minecolonies.api.sounds.EventType;
import com.minecolonies.api.util.CompatibilityUtils;
import com.minecolonies.api.util.Log;
import com.minecolonies.api.util.SoundUtils;
import com.minecolonies.api.util.WorldUtil;
import com.minecolonies.coremod.Network;
import com.minecolonies.coremod.colony.buildings.workerbuildings.BuildingHome;
import com.minecolonies.coremod.entity.citizen.EntityCitizen;
import com.minecolonies.coremod.network.messages.client.SleepingParticleMessage;
import java.util.EnumSet;
import net.minecraft.block.BedBlock;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.state.IProperty;
import net.minecraft.state.properties.BedPart;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;

public class EntityAISleep
extends Goal {
    private static final int TICK_INTERVAL = 30;
    private static final int CHANCE = 33;
    private static final int MAX_BED_TICKS = 10;
    private final EntityCitizen citizen;
    private BlockPos usedBed = null;
    private int bedTicks = 0;
    private TickRateStateMachine<SleepState> stateMachine;

    public EntityAISleep(EntityCitizen citizen) {
        this.func_220684_a(EnumSet.of(Goal.Flag.MOVE));
        this.citizen = citizen;
        this.stateMachine = new TickRateStateMachine<SleepState>(SleepState.AWAKE, e -> Log.getLogger().warn(e));
        this.stateMachine.addTransition(new TickingTransition<SleepState>(SleepState.AWAKE, this::wantSleep, () -> {
            this.initAI();
            return SleepState.WALKING_HOME;
        }, 20));
        this.stateMachine.addTransition(new TickingTransition<SleepState>(SleepState.WALKING_HOME, () -> true, this::walkHome, 30));
        this.stateMachine.addTransition(new TickingTransition<SleepState>(SleepState.FIND_BED, () -> !this.wantSleep(), () -> {
            this.resetAI();
            return SleepState.AWAKE;
        }, 20));
        this.stateMachine.addTransition(new TickingTransition<SleepState>(SleepState.FIND_BED, this::findBed, () -> SleepState.SLEEPING, 30));
        this.stateMachine.addTransition(new TickingTransition<SleepState>(SleepState.SLEEPING, () -> !this.wantSleep(), () -> {
            this.resetAI();
            return SleepState.AWAKE;
        }, 20));
        this.stateMachine.addTransition(new TickingTransition<SleepState>(SleepState.SLEEPING, () -> true, this::sleep, 30));
    }

    private SleepState walkHome() {
        if (!this.citizen.getCitizenColonyHandler().isAtHome()) {
            this.citizen.getCitizenData().setVisibleStatus(VisibleCitizenStatus.SLEEP);
            this.goHome();
            return SleepState.WALKING_HOME;
        }
        return SleepState.FIND_BED;
    }

    private boolean findBed() {
        if (!this.citizen.getCitizenSleepHandler().isAsleep() || this.bedTicks < 10) {
            this.findBedAndTryToSleep();
            return false;
        }
        return true;
    }

    private boolean wantSleep() {
        return this.citizen.func_70643_av() == null && this.citizen.getDesiredActivity() == DesiredActivity.SLEEP;
    }

    public boolean func_75250_a() {
        this.stateMachine.tick();
        return this.stateMachine.getState() != SleepState.AWAKE;
    }

    public boolean func_75253_b() {
        return this.stateMachine.getState() != SleepState.AWAKE && this.wantSleep();
    }

    public void initAI() {
        this.citizen.getCitizenStatusHandler().setStatus(Status.SLEEPING);
        this.usedBed = null;
    }

    public void func_75246_d() {
        this.stateMachine.tick();
    }

    private void findBedAndTryToSleep() {
        IColony colony;
        if (this.usedBed == null && this.citizen.getCitizenData() != null) {
            this.usedBed = this.citizen.getCitizenData().getBedPos();
            if (this.citizen.getCitizenData().getBedPos().equals((Object)BlockPos.field_177992_a)) {
                this.usedBed = null;
            }
        }
        if ((colony = this.citizen.getCitizenColonyHandler().getColony()) != null && colony.getBuildingManager().getBuilding(this.citizen.func_213384_dI()) != null) {
            if (this.usedBed == null) {
                IBuilding hut = colony.getBuildingManager().getBuilding(this.citizen.func_213384_dI());
                if (hut instanceof IBuildingBedProvider) {
                    for (BlockPos pos : ((IBuildingBedProvider)((Object)hut)).getBedList()) {
                        if (!WorldUtil.isEntityBlockLoaded((IWorld)this.citizen.field_70170_p, pos)) continue;
                        World world = this.citizen.field_70170_p;
                        BlockState state = world.func_180495_p(pos);
                        if (!(state = state.func_177230_c().getExtendedState(state, (IBlockReader)world, pos)).func_177230_c().func_203417_a(BlockTags.field_219747_F) || ((Boolean)state.func_177229_b((IProperty)BedBlock.field_176471_b)).booleanValue() || !((BedPart)state.func_177229_b((IProperty)BedBlock.field_176472_a)).equals((Object)BedPart.HEAD) || this.isBedOccupied(hut, pos) || world.func_180495_p(pos.func_177984_a()).func_185904_a().func_76220_a()) continue;
                        this.usedBed = pos;
                        this.setBedOccupied(hut, true);
                        return;
                    }
                }
                this.usedBed = this.citizen.func_213384_dI();
            }
            if (this.citizen.isWorkerAtSiteWithMove(this.usedBed, 3)) {
                ++this.bedTicks;
                if (!this.citizen.getCitizenSleepHandler().trySleep(this.usedBed)) {
                    this.citizen.getCitizenData().setBedPos(BlockPos.field_177992_a);
                    this.usedBed = null;
                }
                this.citizen.getCitizenData().getCitizenHappinessHandler().resetModifier("slepttonight");
            }
        }
    }

    private SleepState sleep() {
        Network.getNetwork().sendToTrackingEntity(new SleepingParticleMessage(this.citizen.field_70165_t, this.citizen.field_70163_u + 1.0, this.citizen.field_70161_v), (Entity)this.citizen);
        return null;
    }

    private void goHome() {
        BlockPos pos = this.citizen.getCitizenSleepHandler().findHomePos();
        this.citizen.isWorkerAtSiteWithMove(pos, 2);
        int chance = this.citizen.getRandom().nextInt(33);
        if (chance <= 1 && this.citizen.getCitizenColonyHandler().getWorkBuilding() != null && this.citizen.getCitizenJobHandler().getColonyJob() != null) {
            SoundUtils.playSoundAtCitizenWith(CompatibilityUtils.getWorldFromCitizen(this.citizen), this.citizen.func_180425_c(), EventType.OFF_TO_BED, this.citizen.getCitizenData());
        }
    }

    private void setBedOccupied(IBuilding hut, boolean occupied) {
        BlockState headState = this.citizen.field_70170_p.func_180495_p(this.usedBed);
        this.citizen.field_70170_p.func_180501_a(this.usedBed, (BlockState)headState.func_206870_a((IProperty)BedBlock.field_176471_b, (Comparable)Boolean.valueOf(occupied)), 3);
        BlockPos feetPos = this.usedBed.func_177972_a(((Direction)headState.func_177229_b((IProperty)BedBlock.field_185512_D)).func_176734_d());
        BlockState feetState = this.citizen.field_70170_p.func_180495_p(feetPos);
        if (feetState.func_177230_c().func_203417_a(BlockTags.field_219747_F)) {
            this.citizen.field_70170_p.func_180501_a(feetPos, (BlockState)feetState.func_206870_a((IProperty)BedBlock.field_176471_b, (Comparable)Boolean.valueOf(occupied)), 3);
        }
    }

    private boolean isBedOccupied(IBuilding hut, BlockPos bed) {
        for (ICitizenData citizen : hut.getAssignedCitizen()) {
            if (this.citizen.getCivilianID() == citizen.getId() || !citizen.getBedPos().equals((Object)bed)) continue;
            return true;
        }
        return false;
    }

    public void func_75251_c() {
        this.resetAI();
        this.stateMachine.reset();
    }

    private void resetAI() {
        this.citizen.getCitizenData().setVisibleStatus(null);
        this.citizen.getCitizenSleepHandler().onWakeUp();
        if (this.usedBed != null) {
            IBuilding hut;
            IColony colony;
            BlockState state = this.citizen.field_70170_p.func_180495_p(this.usedBed);
            if (state.func_177230_c().func_203417_a(BlockTags.field_219747_F) && (colony = this.citizen.getCitizenColonyHandler().getColony()) != null && colony.getBuildingManager().getBuilding(this.citizen.func_213384_dI()) != null && (hut = colony.getBuildingManager().getBuilding(this.citizen.func_213384_dI())) instanceof BuildingHome) {
                this.setBedOccupied((BuildingHome)hut, false);
            }
            this.usedBed = null;
        }
        this.bedTicks = 0;
    }

    public static enum SleepState implements IState
    {
        AWAKE,
        WALKING_HOME,
        FIND_BED,
        SLEEPING;

    }
}

