/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity.citizen;

import com.minecolonies.api.client.render.modeltype.BipedModelType;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.buildings.IBuildingWorker;
import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import com.minecolonies.api.entity.citizen.citizenhandlers.ICitizenColonyHandler;
import com.minecolonies.api.util.Log;
import com.minecolonies.coremod.colony.buildings.workerbuildings.BuildingHome;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import org.jetbrains.annotations.Nullable;

public class CitizenColonyHandler
implements ICitizenColonyHandler {
    protected final AbstractEntityCitizen citizen;
    protected int colonyId;
    @Nullable
    protected IColony colony;
    protected boolean registered = false;

    public CitizenColonyHandler(AbstractEntityCitizen citizen) {
        this.citizen = citizen;
    }

    @Override
    @Nullable
    public IBuildingWorker getWorkBuilding() {
        return this.citizen.getCitizenData() == null ? null : this.citizen.getCitizenData().getWorkBuilding();
    }

    @Override
    @Nullable
    public IBuilding getHomeBuilding() {
        return this.citizen.getCitizenData() == null ? null : this.citizen.getCitizenData().getHomeBuilding();
    }

    @Override
    public void registerWithColony(int colonyID, int citizenID) {
        if (this.registered) {
            return;
        }
        this.colonyId = colonyID;
        this.citizen.setCitizenId(citizenID);
        if (this.colonyId == 0 || this.citizen.getCivilianID() == 0) {
            this.citizen.func_70106_y();
            return;
        }
        IColony colony = IColonyManager.getInstance().getColonyByWorld(this.colonyId, this.citizen.field_70170_p);
        if (colony == null) {
            Log.getLogger().warn(String.format("EntityCitizen '%s' unable to find Colony #%d", this.citizen.func_110124_au(), this.colonyId));
            this.citizen.func_70106_y();
            return;
        }
        this.colony = colony;
        colony.getCitizenManager().registerCivilian(this.citizen);
        this.registered = true;
    }

    @Override
    public void updateColonyClient() {
        if (this.citizen.func_184212_Q().func_187223_a()) {
            if (this.colonyId == 0) {
                this.colonyId = (Integer)this.citizen.func_184212_Q().func_187225_a(AbstractEntityCitizen.DATA_COLONY_ID);
            }
            if (this.citizen.getCivilianID() == 0) {
                this.citizen.setCitizenId((Integer)this.citizen.func_184212_Q().func_187225_a(AbstractEntityCitizen.DATA_CITIZEN_ID));
            }
            this.citizen.setFemale((Integer)this.citizen.func_184212_Q().func_187225_a(AbstractEntityCitizen.DATA_IS_FEMALE) != 0);
            this.citizen.setIsChild((Boolean)this.citizen.func_184212_Q().func_187225_a(AbstractEntityCitizen.DATA_IS_CHILD));
            this.citizen.setModelId(BipedModelType.valueOf((String)this.citizen.func_184212_Q().func_187225_a(AbstractEntityCitizen.DATA_MODEL)));
            this.citizen.setTextureId((Integer)this.citizen.func_184212_Q().func_187225_a(AbstractEntityCitizen.DATA_TEXTURE));
            this.citizen.setRenderMetadata((String)this.citizen.func_184212_Q().func_187225_a(AbstractEntityCitizen.DATA_RENDER_METADATA));
            this.citizen.setTexture();
            this.citizen.func_184212_Q().func_187230_e();
        }
        this.citizen.updateArmSwingProg();
    }

    @Override
    public double getPerBuildingFoodCost() {
        return this.getWorkBuilding() == null || this.getWorkBuilding().getBuildingLevel() == 0 ? 1.0 : 0.02 * Math.pow(2.0, this.getWorkBuilding().getBuildingLevel());
    }

    @Override
    @Nullable
    public IColony getColony() {
        if (this.colony == null && !this.citizen.field_70170_p.field_72995_K) {
            this.registerWithColony(this.getColonyId(), this.citizen.getCivilianID());
        }
        return this.colony;
    }

    @Override
    public int getColonyId() {
        return this.colonyId;
    }

    @Override
    public void setColonyId(int colonyId) {
        this.colonyId = colonyId;
    }

    @Override
    public void onCitizenRemoved() {
        if (this.citizen.getCitizenData() != null && this.registered && this.colony != null) {
            this.colony.getCitizenManager().unregisterCivilian(this.citizen);
            this.citizen.getCitizenData().setLastPosition(this.citizen.func_180425_c());
        }
    }

    @Override
    public boolean isAtHome() {
        IBuilding homeBuilding = this.getHomeBuilding();
        if (homeBuilding instanceof BuildingHome) {
            Tuple<Tuple<Integer, Integer>, Tuple<Integer, Integer>> corners = homeBuilding.getCorners();
            return new AxisAlignedBB((double)((Integer)((Tuple)corners.func_76341_a()).func_76341_a()).intValue(), this.citizen.field_70163_u - 1.0, (double)((Integer)((Tuple)corners.func_76340_b()).func_76341_a()).intValue(), (double)((Integer)((Tuple)corners.func_76341_a()).func_76340_b()).intValue(), this.citizen.field_70163_u + 1.0, (double)((Integer)((Tuple)corners.func_76340_b()).func_76340_b()).intValue()).func_72318_a(new Vec3d((Vec3i)this.citizen.func_180425_c()));
        }
        BlockPos homePosition = this.citizen.func_213384_dI();
        return homePosition.func_218140_a(Math.floor(this.citizen.field_70165_t), this.citizen.field_70163_u, Math.floor(this.citizen.field_70161_v), false) <= 16.0;
    }
}

