/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity.citizen;

import com.ldtteam.structurize.util.LanguageHandler;
import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.ICitizenDataView;
import com.minecolonies.api.colony.ICivilianData;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.IColonyView;
import com.minecolonies.api.colony.IVisitorData;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.permissions.Action;
import com.minecolonies.api.colony.requestsystem.StandardFactoryController;
import com.minecolonies.api.colony.requestsystem.location.ILocation;
import com.minecolonies.api.entity.CustomGoalSelector;
import com.minecolonies.api.entity.ai.DesiredActivity;
import com.minecolonies.api.entity.ai.Status;
import com.minecolonies.api.entity.ai.pathfinding.IWalkToProxy;
import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import com.minecolonies.api.entity.citizen.citizenhandlers.ICitizenChatHandler;
import com.minecolonies.api.entity.citizen.citizenhandlers.ICitizenColonyHandler;
import com.minecolonies.api.entity.citizen.citizenhandlers.ICitizenDiseaseHandler;
import com.minecolonies.api.entity.citizen.citizenhandlers.ICitizenExperienceHandler;
import com.minecolonies.api.entity.citizen.citizenhandlers.ICitizenInventoryHandler;
import com.minecolonies.api.entity.citizen.citizenhandlers.ICitizenItemHandler;
import com.minecolonies.api.entity.citizen.citizenhandlers.ICitizenJobHandler;
import com.minecolonies.api.entity.citizen.citizenhandlers.ICitizenSleepHandler;
import com.minecolonies.api.entity.citizen.citizenhandlers.ICitizenStatusHandler;
import com.minecolonies.api.inventory.InventoryCitizen;
import com.minecolonies.api.inventory.container.ContainerCitizenInventory;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.CompatibilityUtils;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.constant.TypeConstants;
import com.minecolonies.coremod.MineColonies;
import com.minecolonies.coremod.Network;
import com.minecolonies.coremod.colony.buildings.workerbuildings.BuildingTavern;
import com.minecolonies.coremod.entity.ai.minimal.EntityAIOpenFenceGate;
import com.minecolonies.coremod.entity.ai.minimal.EntityAIVisitor;
import com.minecolonies.coremod.entity.citizen.EntityCitizen;
import com.minecolonies.coremod.entity.citizen.VisitorColonyHandler;
import com.minecolonies.coremod.entity.citizen.citizenhandlers.CitizenChatHandler;
import com.minecolonies.coremod.entity.citizen.citizenhandlers.CitizenDiseaseHandler;
import com.minecolonies.coremod.entity.citizen.citizenhandlers.CitizenExperienceHandler;
import com.minecolonies.coremod.entity.citizen.citizenhandlers.CitizenInventoryHandler;
import com.minecolonies.coremod.entity.citizen.citizenhandlers.CitizenItemHandler;
import com.minecolonies.coremod.entity.citizen.citizenhandlers.CitizenJobHandler;
import com.minecolonies.coremod.entity.citizen.citizenhandlers.CitizenSleepHandler;
import com.minecolonies.coremod.entity.citizen.citizenhandlers.CitizenStatusHandler;
import com.minecolonies.coremod.entity.citizen.citizenhandlers.MovementHandler;
import com.minecolonies.coremod.entity.pathfinding.EntityCitizenWalkToProxy;
import com.minecolonies.coremod.network.messages.server.colony.OpenInventoryMessage;
import io.netty.buffer.Unpooled;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookAtWithoutMovingGoal;
import net.minecraft.entity.ai.goal.OpenDoorGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.item.NameTagItem;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VisitorCitizen
extends AbstractEntityCitizen {
    private ICitizenExperienceHandler citizenExperienceHandler;
    private ICitizenStatusHandler citizenStatusHandler;
    private int citizenId = 0;
    private IWalkToProxy proxy;
    @Nullable
    private ICitizenData citizenData;
    private ICitizenChatHandler citizenChatHandler;
    private ICitizenItemHandler citizenItemHandler;
    private ICitizenInventoryHandler citizenInventoryHandler;
    private ICitizenColonyHandler citizenColonyHandler;
    private ICitizenJobHandler citizenJobHandler;
    private ICitizenSleepHandler citizenSleepHandler;
    private boolean currentlyFleeing = false;
    private ICitizenDataView citizenDataView;
    private ILocation location = null;
    private ICitizenDiseaseHandler citizenDiseaseHandler;

    public VisitorCitizen(EntityType<? extends AgeableEntity> type, World world) {
        super(type, world);
        this.field_70714_bg = new CustomGoalSelector(this.field_70714_bg);
        this.field_70715_bh = new CustomGoalSelector(this.field_70715_bh);
        this.citizenChatHandler = new CitizenChatHandler(this);
        this.citizenStatusHandler = new CitizenStatusHandler(this);
        this.citizenItemHandler = new CitizenItemHandler(this);
        this.citizenInventoryHandler = new CitizenInventoryHandler(this);
        this.citizenColonyHandler = new VisitorColonyHandler(this);
        this.citizenJobHandler = new CitizenJobHandler(this);
        this.citizenSleepHandler = new CitizenSleepHandler(this);
        this.citizenExperienceHandler = new CitizenExperienceHandler(this);
        this.citizenDiseaseHandler = new CitizenDiseaseHandler(this);
        this.field_70765_h = new MovementHandler((MobEntity)this);
        this.func_110163_bv();
        this.func_174805_g((Boolean)MineColonies.getConfig().getCommon().alwaysRenderNameTag.get());
        this.initTasks();
    }

    private void initTasks() {
        int priority = 0;
        this.field_70714_bg.func_75776_a(priority, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(++priority, (Goal)new OpenDoorGoal((MobEntity)this, true));
        this.field_70714_bg.func_75776_a(priority, (Goal)new EntityAIOpenFenceGate((MobEntity)this, true));
        this.field_70714_bg.func_75776_a(++priority, (Goal)new LookAtWithoutMovingGoal((MobEntity)this, PlayerEntity.class, 3.0f, 1.0f));
        this.field_70714_bg.func_75776_a(++priority, (Goal)new LookAtWithoutMovingGoal((MobEntity)this, EntityCitizen.class, 5.0f, 0.02f));
        this.field_70714_bg.func_75776_a(++priority, (Goal)new LookAtGoal((MobEntity)this, LivingEntity.class, 6.0f));
        this.field_70714_bg.func_75776_a(++priority, (Goal)new EntityAIVisitor(this));
    }

    @Override
    public ILocation getLocation() {
        if (this.location == null) {
            this.location = StandardFactoryController.getInstance().getNewInstance(TypeConstants.ILOCATION, this, new Object[0]);
        }
        return this.location;
    }

    public boolean func_70097_a(@NotNull DamageSource damageSource, float damage) {
        if (super.func_70097_a(damageSource, damage)) {
            IBuilding home;
            if (damageSource.func_76346_g() instanceof LivingEntity && damage > 1.01f && (home = this.getCitizenData().getHomeBuilding()) instanceof BuildingTavern) {
                for (Integer id : ((BuildingTavern)home).getExternalCitizens()) {
                    ICitizenData data = (ICitizenData)this.citizenColonyHandler.getColony().getVisitorManager().getCivilian(id);
                    if (data == null || !data.getEntity().isPresent() || data.getEntity().get().func_70643_av() != null) continue;
                    data.getEntity().get().func_70604_c((LivingEntity)damageSource.func_76346_g());
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean isWorkerAtSiteWithMove(@NotNull BlockPos site, int range) {
        if (this.proxy == null) {
            this.proxy = new EntityCitizenWalkToProxy(this);
        }
        return this.proxy.walkToBlock(site, range, true);
    }

    @Override
    @Nullable
    public ICitizenData getCitizenData() {
        return this.citizenData;
    }

    @Override
    public void setCivilianData(@Nullable ICivilianData data) {
        if (data != null && data instanceof IVisitorData) {
            this.citizenData = (IVisitorData)data;
            data.initEntityValues();
        }
    }

    @Override
    @NotNull
    public InventoryCitizen getInventoryCitizen() {
        return this.getCitizenData().getInventory();
    }

    @Override
    @NotNull
    public IItemHandler getItemHandlerCitizen() {
        return this.getInventoryCitizen();
    }

    @Override
    public void markDirty() {
        if (this.citizenData != null) {
            this.citizenData.markDirty();
        }
    }

    @Override
    @NotNull
    public DesiredActivity getDesiredActivity() {
        return DesiredActivity.IDLE;
    }

    @Override
    public void setCitizensize(@NotNull float width, @NotNull float height) {
        this.field_213325_aI = new EntitySize(width, height, false);
    }

    @Override
    public void setIsChild(boolean isChild) {
    }

    @Override
    public void playMoveAwaySound() {
    }

    @Override
    public IWalkToProxy getProxy() {
        return this.proxy;
    }

    @Override
    public void decreaseSaturationForAction() {
        if (this.citizenData != null) {
            this.citizenData.decreaseSaturation(this.citizenColonyHandler.getPerBuildingFoodCost());
            this.citizenData.markDirty();
        }
    }

    @Override
    public void decreaseSaturationForContinuousAction() {
        if (this.citizenData != null) {
            this.citizenData.decreaseSaturation(this.citizenColonyHandler.getPerBuildingFoodCost() / 100.0);
            this.citizenData.markDirty();
        }
    }

    @Override
    public int getCivilianID() {
        return this.citizenId;
    }

    @Override
    public void setCitizenId(int id) {
        this.citizenId = id;
    }

    @Override
    public ICitizenExperienceHandler getCitizenExperienceHandler() {
        return this.citizenExperienceHandler;
    }

    @Override
    public ICitizenChatHandler getCitizenChatHandler() {
        return this.citizenChatHandler;
    }

    @Override
    public ICitizenStatusHandler getCitizenStatusHandler() {
        return this.citizenStatusHandler;
    }

    @Override
    public ICitizenItemHandler getCitizenItemHandler() {
        return this.citizenItemHandler;
    }

    @Override
    public ICitizenInventoryHandler getCitizenInventoryHandler() {
        return this.citizenInventoryHandler;
    }

    @Override
    public void setCitizenInventoryHandler(ICitizenInventoryHandler citizenInventoryHandler) {
        this.citizenInventoryHandler = citizenInventoryHandler;
    }

    @Override
    public ICitizenColonyHandler getCitizenColonyHandler() {
        return this.citizenColonyHandler;
    }

    @Override
    public void setCitizenColonyHandler(ICitizenColonyHandler citizenColonyHandler) {
        this.citizenColonyHandler = citizenColonyHandler;
    }

    @Override
    public ICitizenJobHandler getCitizenJobHandler() {
        return this.citizenJobHandler;
    }

    @Override
    public ICitizenSleepHandler getCitizenSleepHandler() {
        return this.citizenSleepHandler;
    }

    @Override
    public ICitizenDiseaseHandler getCitizenDiseaseHandler() {
        return this.citizenDiseaseHandler;
    }

    @Override
    public void setCitizenDiseaseHandler(ICitizenDiseaseHandler citizenDiseaseHandler) {
        this.citizenDiseaseHandler = citizenDiseaseHandler;
    }

    @Override
    public boolean isOkayToEat() {
        return false;
    }

    @Override
    public boolean shouldBeFed() {
        return false;
    }

    @Override
    public boolean isIdlingAtJob() {
        return false;
    }

    @Override
    public boolean isMourning() {
        return false;
    }

    @Override
    public void setMourning(boolean mourning) {
    }

    @Override
    public float getRotationYaw() {
        return this.field_70177_z;
    }

    @Override
    public float getRotationPitch() {
        return this.field_70125_A;
    }

    @Override
    public boolean isDead() {
        return !this.func_70089_S();
    }

    @Override
    public void setCitizenSleepHandler(ICitizenSleepHandler citizenSleepHandler) {
    }

    @Override
    public void setCitizenJobHandler(ICitizenJobHandler citizenJobHandler) {
        this.citizenJobHandler = citizenJobHandler;
    }

    @Override
    public void setCitizenItemHandler(ICitizenItemHandler citizenItemHandler) {
        this.citizenItemHandler = citizenItemHandler;
    }

    @Override
    public void setCitizenChatHandler(ICitizenChatHandler citizenChatHandler) {
        this.citizenChatHandler = citizenChatHandler;
    }

    @Override
    public void setCitizenExperienceHandler(ICitizenExperienceHandler citizenExperienceHandler) {
        this.citizenExperienceHandler = citizenExperienceHandler;
    }

    @Override
    public boolean isCurrentlyFleeing() {
        return this.currentlyFleeing;
    }

    @Override
    public void callForHelp(Entity attacker, int guardHelpRange) {
    }

    @Override
    public void setFleeingState(boolean fleeing) {
        this.currentlyFleeing = fleeing;
    }

    @javax.annotation.Nullable
    public Container createMenu(int id, PlayerInventory playerInventory, PlayerEntity playerEntity) {
        PacketBuffer buffer = new PacketBuffer(Unpooled.buffer());
        buffer.func_150787_b(this.citizenColonyHandler.getColonyId());
        buffer.func_150787_b(this.citizenId);
        return new ContainerCitizenInventory(id, playerInventory, buffer);
    }

    public boolean func_184645_a(PlayerEntity player, @NotNull Hand hand) {
        IColonyView iColonyView = IColonyManager.getInstance().getColonyView((Integer)this.func_184212_Q().func_187225_a(DATA_COLONY_ID), player.field_70170_p.func_201675_m().func_186058_p().func_186068_a());
        if (iColonyView != null && !iColonyView.getPermissions().hasPermission(player, Action.ACCESS_HUTS)) {
            return false;
        }
        if (!ItemStackUtils.isEmpty(player.func_184586_b(hand)).booleanValue() && player.func_184586_b(hand).func_77973_b() instanceof NameTagItem) {
            return super.func_184645_a(player, hand);
        }
        if (CompatibilityUtils.getWorldFromCitizen((AbstractEntityCitizen)this).field_72995_K) {
            if (player.func_225608_bj_()) {
                Network.getNetwork().sendToServer(new OpenInventoryMessage(iColonyView, this.func_200200_C_().func_150254_d(), this.func_145782_y()));
            } else {
                ICitizenDataView citizenDataView = this.getCitizenDataView();
                if (citizenDataView != null) {
                    MineColonies.proxy.showCitizenWindow(citizenDataView);
                }
            }
        }
        return true;
    }

    @Override
    public ICitizenDataView getCitizenDataView() {
        if (this.citizenDataView == null) {
            IColonyView colonyView;
            this.citizenColonyHandler.updateColonyClient();
            if (this.citizenColonyHandler.getColonyId() != 0 && this.citizenId != 0 && (colonyView = IColonyManager.getInstance().getColonyView(this.citizenColonyHandler.getColonyId(), this.field_70170_p.func_201675_m().func_186058_p().func_186068_a())) != null) {
                this.citizenDataView = colonyView.getVisitor(this.citizenId);
                return this.citizenDataView;
            }
        } else {
            return this.citizenDataView;
        }
        return null;
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(DATA_COLONY_ID, (Object)(this.citizenColonyHandler == null ? 0 : this.citizenColonyHandler.getColonyId()));
        this.field_70180_af.func_187214_a(DATA_CITIZEN_ID, (Object)this.citizenId);
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (this.field_70718_bc > 0) {
            this.markDirty();
        }
        if (CompatibilityUtils.getWorldFromCitizen((AbstractEntityCitizen)this).field_72995_K) {
            IColonyView colonyView;
            this.citizenColonyHandler.updateColonyClient();
            if (this.citizenColonyHandler.getColonyId() != 0 && this.citizenId != 0 && this.getOffsetTicks() % 20 == 0 && (colonyView = IColonyManager.getInstance().getColonyView(this.citizenColonyHandler.getColonyId(), this.field_70170_p.func_201675_m().func_186058_p().func_186068_a())) != null) {
                this.citizenDataView = colonyView.getVisitor(this.citizenId);
            }
        } else {
            this.citizenColonyHandler.registerWithColony(this.citizenColonyHandler.getColonyId(), this.citizenId);
        }
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74768_a("status", this.citizenStatusHandler.getStatus().ordinal());
        if (this.citizenColonyHandler.getColony() != null && this.citizenData != null) {
            compound.func_74768_a("colony", this.citizenColonyHandler.getColony().getID());
            compound.func_74768_a("citizen", this.citizenData.getId());
        }
        this.citizenDiseaseHandler.write(compound);
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.citizenStatusHandler.setStatus(Status.values()[compound.func_74762_e("status")]);
        this.citizenColonyHandler.setColonyId(compound.func_74762_e("colony"));
        this.citizenId = compound.func_74762_e("citizen");
        if (this.func_70613_aW()) {
            this.citizenColonyHandler.registerWithColony(this.citizenColonyHandler.getColonyId(), this.citizenId);
        }
        this.citizenDiseaseHandler.read(compound);
    }

    public void func_70645_a(DamageSource cause) {
        IColony colony;
        super.func_70645_a(cause);
        if (!this.field_70170_p.func_201670_d() && (colony = this.getCitizenColonyHandler().getColony()) != null && this.getCitizenData() != null) {
            colony.getVisitorManager().removeCivilian(this.getCitizenData());
            if (this.getCitizenData().getHomeBuilding() instanceof BuildingTavern) {
                BuildingTavern tavern = (BuildingTavern)this.getCitizenData().getHomeBuilding();
                tavern.setNoVisitorTime(this.field_70170_p.func_201674_k().nextInt(5000) + 30000);
            }
            String deathLocation = BlockPosUtil.getString(this.func_180425_c());
            LanguageHandler.sendPlayersMessage(colony.getImportantMessageEntityPlayers(), (String)"com.minecolonies.coremod.gui.tavern.visitordeath", (Object[])new Object[]{this.getCitizenData().getName(), cause.func_76355_l(), deathLocation});
        }
    }

    protected void func_213337_cE() {
        for (int i = 0; i < this.getInventoryCitizen().getSlots(); ++i) {
            ItemStack itemstack = this.getCitizenData().getInventory().getStackInSlot(i);
            if (ItemStackUtils.getSize(itemstack) <= 0) continue;
            this.citizenItemHandler.entityDropItem(itemstack);
        }
    }
}

