/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity.citizen.citizenhandlers;

import com.minecolonies.api.IMinecoloniesAPI;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import com.minecolonies.api.entity.citizen.citizenhandlers.ICitizenDiseaseHandler;
import com.minecolonies.coremod.MineColonies;
import com.minecolonies.coremod.colony.jobs.AbstractJobGuard;
import com.minecolonies.coremod.colony.jobs.JobHealer;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.math.BlockPos;
import org.jetbrains.annotations.NotNull;

public class CitizenDiseaseHandler
implements ICitizenDiseaseHandler {
    public static final double SEEK_DOCTOR_HEALTH = 6.0;
    private static final int DISEASE_FACTOR = 10000;
    private static final int IMMUNITY_TIME = 4200;
    private final AbstractEntityCitizen citizen;
    private String disease = "";
    private int immunityTicks = 0;

    public CitizenDiseaseHandler(AbstractEntityCitizen citizen) {
        this.citizen = citizen;
    }

    @Override
    public void tick() {
        if (this.canBecomeSick()) {
            int citizenModifier = this.citizen.getCitizenJobHandler().getColonyJob() == null ? 1 : this.citizen.getCitizenJobHandler().getColonyJob().getDiseaseModifier();
            int configModifier = (Integer)MineColonies.getConfig().getCommon().diseaseModifier.get();
            if (this.citizen.getRandom().nextInt(configModifier * 10000) < citizenModifier) {
                this.disease = IColonyManager.getInstance().getCompatibilityManager().getRandomDisease();
            }
        }
        if (this.immunityTicks > 0) {
            --this.immunityTicks;
        }
    }

    private boolean canBecomeSick() {
        return !this.isSick() && this.citizen.getCitizenColonyHandler().getColony().isActive() && !(this.citizen.getCitizenJobHandler().getColonyJob() instanceof JobHealer) && this.immunityTicks <= 0 && this.citizen.getCitizenColonyHandler().getColony().getCitizenManager().getCurrentCitizenCount() > (Integer)IMinecoloniesAPI.getInstance().getConfig().getCommon().initialCitizenAmount.get();
    }

    @Override
    public void onCollission(@NotNull AbstractEntityCitizen citizen) {
        if (citizen.getCitizenDiseaseHandler().isSick() && this.canBecomeSick() && citizen.getRandom().nextInt(100) < 1) {
            this.disease = citizen.getCitizenDiseaseHandler().getDisease();
        }
    }

    @Override
    public boolean isSick() {
        return !this.disease.isEmpty() || !(this.citizen.getCitizenJobHandler() instanceof AbstractJobGuard) && (double)this.citizen.func_110143_aJ() <= 6.0;
    }

    @Override
    public void write(CompoundNBT compound) {
        compound.func_74778_a("disease", this.disease);
        compound.func_74768_a("immunity", this.immunityTicks);
    }

    @Override
    public void read(CompoundNBT compound) {
        this.disease = compound.func_74779_i("disease");
        this.immunityTicks = compound.func_74762_e("immunity");
    }

    @Override
    public String getDisease() {
        return this.disease;
    }

    @Override
    public void cure() {
        this.disease = "";
        if (this.citizen.getCitizenSleepHandler().isAsleep()) {
            this.citizen.func_213366_dy();
            BlockPos hospitalPos = this.citizen.getCitizenColonyHandler().getColony().getBuildingManager().getBestHospital(this.citizen);
            IColony colony = this.citizen.getCitizenColonyHandler().getColony();
            IBuilding hospital = colony.getBuildingManager().getBuilding(hospitalPos);
            if (hospital != null) {
                hospital.onWakeUp();
            }
            this.immunityTicks = 4200;
        }
    }
}

