/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity.citizen.citizenhandlers;

import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.buildings.IBuildingWorker;
import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import com.minecolonies.api.entity.citizen.Skill;
import com.minecolonies.api.entity.citizen.citizenhandlers.ICitizenExperienceHandler;
import com.minecolonies.api.util.CompatibilityUtils;
import com.minecolonies.api.util.WorldUtil;
import com.minecolonies.coremod.colony.buildings.AbstractBuildingWorker;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ExperienceOrbEntity;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.GameRules;

public class CitizenExperienceHandler
implements ICitizenExperienceHandler {
    public static final int PRIMARY_DEPENDENCY_SHARE = 10;
    public static final int SECONDARY_DEPENDENCY_SHARE = 5;
    public static final int MAX_XP_PICKUP_ATTEMPTS = 5;
    private final AbstractEntityCitizen citizen;
    private int counterMovedXp = 0;

    public CitizenExperienceHandler(AbstractEntityCitizen citizen) {
        this.citizen = citizen;
    }

    @Override
    public void updateLevel() {
        if (this.citizen.getCitizenData().getJob() != null) {
            this.citizen.getCitizenData().getJob().onLevelUp();
        }
    }

    @Override
    public void addExperience(double xp) {
        IBuilding home = this.citizen.getCitizenColonyHandler().getHomeBuilding();
        double citizenHutLevel = home == null ? 0.0 : (double)home.getBuildingLevel();
        ICitizenData data = this.citizen.getCitizenData();
        IBuildingWorker workBuilding = data.getWorkBuilding();
        if (!(workBuilding instanceof AbstractBuildingWorker)) {
            return;
        }
        double workBuildingLevel = workBuilding.getBuildingLevel();
        double bonusXp = 1.0 + workBuildingLevel * citizenHutLevel / 10.0;
        double localXp = xp * bonusXp;
        double saturation = this.citizen.getCitizenData().getSaturation();
        int intelligenceLevel = data.getCitizenSkillHandler().getLevel(Skill.Intelligence);
        localXp += localXp * ((double)intelligenceLevel / 10.0);
        if (saturation <= 0.0) {
            return;
        }
        if (saturation < 5.0) {
            localXp = saturation < 3.0 ? (localXp -= localXp * 0.05) : (localXp -= localXp * 0.01);
        } else if (saturation > 5.0) {
            localXp = saturation > 7.0 ? (localXp += localXp * 0.05) : (localXp += localXp * 0.01);
        }
        localXp = this.citizen.getCitizenItemHandler().applyMending(localXp);
        Skill primary = ((AbstractBuildingWorker)workBuilding).getPrimarySkill();
        Skill secondary = ((AbstractBuildingWorker)workBuilding).getSecondarySkill();
        data.getCitizenSkillHandler().addXpToSkill(primary, localXp, data);
        data.getCitizenSkillHandler().addXpToSkill(primary.getComplimentary(), localXp / 10.0, data);
        data.getCitizenSkillHandler().removeXpFromSkill(primary.getAdverse(), localXp / 10.0, data);
        data.getCitizenSkillHandler().addXpToSkill(secondary, localXp / 2.0, data);
        data.getCitizenSkillHandler().addXpToSkill(secondary.getComplimentary(), localXp / 20.0, data);
        data.getCitizenSkillHandler().removeXpFromSkill(secondary.getAdverse(), localXp / 20.0, data);
    }

    @Override
    public void dropExperience() {
        if (!CompatibilityUtils.getWorldFromCitizen((AbstractEntityCitizen)this.citizen).field_72995_K && this.citizen.getRecentlyHit() > 0 && this.citizen.checkCanDropLoot() && CompatibilityUtils.getWorldFromCitizen(this.citizen).func_82736_K().func_223586_b(GameRules.field_223602_e)) {
            int j;
            for (int experience = (int)this.citizen.getCitizenData().getCitizenSkillHandler().getTotalXP(); experience > 0; experience -= j) {
                j = ExperienceOrbEntity.func_70527_a((int)experience);
                CompatibilityUtils.getWorldFromCitizen(this.citizen).func_217376_c((Entity)new ExperienceOrbEntity(CompatibilityUtils.getWorldFromCitizen(this.citizen), this.citizen.field_70165_t, this.citizen.field_70163_u, this.citizen.field_70161_v, j));
            }
        }
        int i = 0;
        while ((double)i < 20.0) {
            double d2 = this.citizen.getRandom().nextGaussian() * 0.02;
            double d0 = this.citizen.getRandom().nextGaussian() * 0.02;
            double d1 = this.citizen.getRandom().nextGaussian() * 0.02;
            CompatibilityUtils.getWorldFromCitizen(this.citizen).func_195594_a((IParticleData)ParticleTypes.field_197627_t, this.citizen.field_70165_t + this.citizen.getRandom().nextDouble() * (double)this.citizen.func_213311_cf() * 2.0 - (double)this.citizen.func_213311_cf(), this.citizen.field_70163_u + this.citizen.getRandom().nextDouble() * (double)this.citizen.func_213302_cg(), this.citizen.field_70161_v + this.citizen.getRandom().nextDouble() * (double)this.citizen.func_213311_cf() * 2.0 - (double)this.citizen.func_213311_cf(), d2, d0, d1);
            ++i;
        }
    }

    @Override
    public void gatherXp() {
        if (this.citizen.field_70170_p.field_72995_K) {
            return;
        }
        int growSize = this.counterMovedXp > 0 || this.citizen.getRandom().nextInt(100) < 20 ? 8 : 2;
        AxisAlignedBB box = this.citizen.func_174813_aQ().func_186662_g((double)growSize);
        if (!WorldUtil.isAABBLoaded(this.citizen.field_70170_p, box)) {
            return;
        }
        boolean movedXp = false;
        for (ExperienceOrbEntity orb : this.citizen.field_70170_p.func_217357_a(ExperienceOrbEntity.class, box)) {
            Vec3d vec3d = new Vec3d(this.citizen.field_70165_t - orb.func_226277_ct_(), this.citizen.field_70163_u + (double)this.citizen.func_70047_e() / 2.0 - orb.func_226278_cu_(), this.citizen.func_226281_cx_() - orb.func_226281_cx_());
            double d1 = vec3d.func_189985_c();
            if (d1 < 1.0 || this.counterMovedXp > 5) {
                this.addExperience((double)orb.func_70526_d() / 2.0);
                orb.func_70106_y();
                this.counterMovedXp = 0;
                return;
            }
            double d2 = 1.0 - Math.sqrt(d1) / 8.0;
            orb.func_213317_d(orb.func_213322_ci().func_178787_e(vec3d.func_72432_b().func_186678_a(d2 * d2 * 0.1)));
            movedXp = true;
            ++this.counterMovedXp;
        }
        if (!movedXp) {
            this.counterMovedXp = 0;
        }
    }
}

