/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity.citizen.citizenhandlers;

import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.interactionhandling.ChatPriority;
import com.minecolonies.api.colony.interactionhandling.InteractionValidatorRegistry;
import com.minecolonies.api.entity.citizen.citizenhandlers.ICitizenHappinessHandler;
import com.minecolonies.api.entity.citizen.happiness.ClientHappinessModifier;
import com.minecolonies.api.entity.citizen.happiness.ExpirationBasedHappinessModifier;
import com.minecolonies.api.entity.citizen.happiness.IHappinessModifier;
import com.minecolonies.api.entity.citizen.happiness.StaticHappinessModifier;
import com.minecolonies.api.entity.citizen.happiness.TimeBasedHappinessModifier;
import com.minecolonies.api.util.Tuple;
import com.minecolonies.coremod.colony.interactionhandling.StandardInteraction;
import com.minecolonies.coremod.colony.jobs.AbstractJobGuard;
import com.minecolonies.coremod.colony.jobs.JobPupil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class CitizenHappinessHandler
implements ICitizenHappinessHandler {
    public Map<String, IHappinessModifier> happinessFactors = new HashMap<String, IHappinessModifier>();
    private double cachedHappiness = -1.0;

    public CitizenHappinessHandler(ICitizenData data) {
        this.add(new TimeBasedHappinessModifier("homelessness", 4.0, () -> data.getHomeBuilding() == null ? 0.25 : (double)data.getHomeBuilding().getBuildingLevel() / 2.5, new Tuple[]{new Tuple<Integer, Double>(7, 0.75), new Tuple<Integer, Double>(14, 0.5)}));
        this.add(new TimeBasedHappinessModifier("unemployment", 2.0, () -> data.isChild() ? 1.0 : (data.getWorkBuilding() == null ? 0.5 : (data.getWorkBuilding().getBuildingLevel() > 3 ? 2.0 : 1.0)), new Tuple[]{new Tuple<Integer, Double>(7, 0.75), new Tuple<Integer, Double>(14, 0.5)}));
        this.add(new TimeBasedHappinessModifier("health", 2.0, () -> data.getEntity().isPresent() ? (data.getEntity().get().getCitizenDiseaseHandler().isSick() ? 0.5 : 1.0) : 1.0, new Tuple[]{new Tuple<Integer, Double>(7, 0.5), new Tuple<Integer, Double>(14, 0.1)}));
        this.add(new TimeBasedHappinessModifier("idleatjob", 1.0, () -> data.isIdleAtJob() ? 0.5 : 1.0, new Tuple[]{new Tuple<Integer, Double>(7, 0.5), new Tuple<Integer, Double>(14, 0.1)}));
        this.add(new StaticHappinessModifier("school", 1.0, () -> data.isChild() ? (data.getJob() instanceof JobPupil ? 2.0 : 0.0) : 1.0));
        this.add(new StaticHappinessModifier("security", 5.0, () -> this.getGuardFactor(data.getColony())));
        this.add(new StaticHappinessModifier("social", 2.0, () -> this.getSocialModifier(data.getColony())));
        this.add(new StaticHappinessModifier("saturation", 1.0, () -> data.getSaturation() / 10.0));
        this.add(new ExpirationBasedHappinessModifier("damage", 1.0, () -> 0.0, 1));
        this.add(new ExpirationBasedHappinessModifier("death", 2.0, () -> 0.0, 3));
        this.add(new ExpirationBasedHappinessModifier("raidwithoutdeath", 1.0, () -> 2.0, 3));
        this.add(new ExpirationBasedHappinessModifier("slepttonight", 2.0, () -> data.getJob() instanceof AbstractJobGuard ? 1.0 : 0.0, 3, true));
    }

    public CitizenHappinessHandler() {
        this.add(new ClientHappinessModifier("homelessness", 4.0));
        this.add(new ClientHappinessModifier("unemployment", 2.0));
        this.add(new ClientHappinessModifier("health", 2.0));
        this.add(new ClientHappinessModifier("idleatjob", 1.0));
        this.add(new ClientHappinessModifier("school", 1.0));
        this.add(new ClientHappinessModifier("security", 2.0));
        this.add(new ClientHappinessModifier("social", 2.0));
        this.add(new ClientHappinessModifier("saturation", 1.0));
        this.add(new ClientHappinessModifier("damage", 1.0));
        this.add(new ClientHappinessModifier("death", 2.0));
        this.add(new ClientHappinessModifier("raidwithoutdeath", 1.0));
        this.add(new ClientHappinessModifier("slepttonight", 2.0));
    }

    @Override
    public void resetModifier(String name) {
        if (this.happinessFactors.containsKey(name)) {
            this.happinessFactors.get(name).reset();
        }
        this.cachedHappiness = -1.0;
    }

    @Override
    public IHappinessModifier getModifier(String name) {
        return this.happinessFactors.get(name);
    }

    @Override
    public void processDailyHappiness(ICitizenData citizenData) {
        for (IHappinessModifier happinessModifier : this.happinessFactors.values()) {
            happinessModifier.dayEnd();
            if (InteractionValidatorRegistry.hasValidator(new TranslationTextComponent("com.minecolonies.coremod.entity.citizen.no." + happinessModifier.getId(), new Object[0]))) {
                citizenData.triggerInteraction(new StandardInteraction((ITextComponent)new TranslationTextComponent("com.minecolonies.coremod.entity.citizen.no." + happinessModifier.getId(), new Object[0]), ChatPriority.CHITCHAT));
            }
            if (!InteractionValidatorRegistry.hasValidator(new TranslationTextComponent("com.minecolonies.coremod.entity.citizen.demands." + happinessModifier.getId(), new Object[0]))) continue;
            citizenData.triggerInteraction(new StandardInteraction((ITextComponent)new TranslationTextComponent("com.minecolonies.coremod.entity.citizen.demands." + happinessModifier.getId(), new Object[0]), ChatPriority.CHITCHAT));
        }
        this.cachedHappiness = -1.0;
    }

    @Override
    public double getHappiness() {
        if (this.cachedHappiness == -1.0) {
            double total = 0.0;
            double totalWeight = 0.0;
            for (IHappinessModifier happinessModifier : this.happinessFactors.values()) {
                total += happinessModifier.getFactor() * happinessModifier.getWeight();
                totalWeight += happinessModifier.getWeight();
            }
            this.cachedHappiness = Math.min(10.0 * (total / totalWeight), 10.0);
        }
        return this.cachedHappiness;
    }

    @Override
    public void read(CompoundNBT compound) {
        CompoundNBT tag = compound.func_74775_l("happinessHandler");
        for (IHappinessModifier happinessModifier : this.happinessFactors.values()) {
            if (!tag.func_74764_b(happinessModifier.getId())) continue;
            happinessModifier.read(tag.func_74775_l(happinessModifier.getId()));
        }
    }

    @Override
    public void write(CompoundNBT compound) {
        CompoundNBT tag = new CompoundNBT();
        for (IHappinessModifier happinessModifier : this.happinessFactors.values()) {
            CompoundNBT compoundNbt = new CompoundNBT();
            happinessModifier.write(compoundNbt);
            tag.func_218657_a(happinessModifier.getId(), (INBT)compoundNbt);
        }
        compound.func_218657_a("happinessHandler", (INBT)tag);
    }

    @Override
    public List<String> getModifiers() {
        return new ArrayList<String>(this.happinessFactors.keySet());
    }

    private void add(IHappinessModifier modifier) {
        this.happinessFactors.put(modifier.getId(), modifier);
    }

    private double getSocialModifier(IColony colony) {
        double total = colony.getCitizenManager().getCitizens().size();
        double unemployment = 0.0;
        double homelessness = 0.0;
        double sickPeople = 0.0;
        double hungryPeople = 0.0;
        for (ICitizenData citizen : colony.getCitizenManager().getCitizens()) {
            if (!citizen.isChild() && citizen.getJob() == null) {
                unemployment += 1.0;
            }
            if (citizen.getHomeBuilding() == null) {
                homelessness += 1.0;
            }
            if (citizen.getEntity().isPresent() && citizen.getEntity().get().getCitizenDiseaseHandler().isSick()) {
                sickPeople += 1.0;
            }
            if (!(citizen.getSaturation() <= 1.0)) continue;
            hungryPeople += 1.0;
        }
        return (total - (unemployment + homelessness + sickPeople + hungryPeople)) / total;
    }

    private double getGuardFactor(IColony colony) {
        double guards = 1.0;
        double workers = 1.0;
        for (ICitizenData citizen : colony.getCitizenManager().getCitizens()) {
            if (citizen.getJob() instanceof AbstractJobGuard) {
                guards += 1.0;
                continue;
            }
            workers += 1.0;
        }
        return Math.min(guards / (workers * 2.0 / 3.0), 2.0);
    }
}

