/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity.citizen.citizenhandlers;

import com.google.common.collect.ImmutableMap;
import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.buildings.IBuildingWorker;
import com.minecolonies.api.colony.buildings.views.IBuildingView;
import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import com.minecolonies.api.entity.citizen.Skill;
import com.minecolonies.api.entity.citizen.citizenhandlers.ICitizenSkillHandler;
import com.minecolonies.coremod.Network;
import com.minecolonies.coremod.colony.buildings.AbstractBuildingWorker;
import com.minecolonies.coremod.network.messages.client.VanillaParticleMessage;
import com.minecolonies.coremod.util.ExperienceUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.Tuple;
import org.jetbrains.annotations.NotNull;

public class CitizenSkillHandler
implements ICitizenSkillHandler {
    private static final int CHANCE_TO_LEVEL = 50;
    private static final int CHILD_STATS_VARIANCE = 3;
    private static final int MAX_INHERITANCE = 10;
    public Map<Skill, Tuple<Integer, Double>> skillMap = new HashMap<Skill, Tuple<Integer, Double>>();

    @Override
    public void init(int levelCap) {
        if (levelCap <= 1) {
            for (Skill skill : Skill.values()) {
                this.skillMap.put(skill, (Tuple<Integer, Double>)new Tuple((Object)1, (Object)0.0));
            }
        } else {
            Random random = new Random();
            for (Skill skill : Skill.values()) {
                this.skillMap.put(skill, (Tuple<Integer, Double>)new Tuple((Object)(random.nextInt(levelCap - 1) + 1), (Object)0.0));
            }
        }
    }

    @Override
    public void init(@NotNull ICitizenData mom, @NotNull ICitizenData dad, Random rand) {
        for (Skill skill : Skill.values()) {
            this.skillMap.put(skill, (Tuple<Integer, Double>)new Tuple((Object)Math.max(1, (Math.min(10, mom.getCitizenSkillHandler().getLevel(skill)) + Math.min(10, dad.getCitizenSkillHandler().getLevel(skill))) / 2 + rand.nextInt(3) - rand.nextInt(3)), (Object)0.0));
        }
    }

    @Override
    @NotNull
    public CompoundNBT write() {
        CompoundNBT compoundNBT = new CompoundNBT();
        ListNBT levelTagList = new ListNBT();
        for (Map.Entry<Skill, Tuple<Integer, Double>> entry : this.skillMap.entrySet()) {
            if (entry.getKey() == null || entry.getValue() == null) continue;
            CompoundNBT levelCompound = new CompoundNBT();
            levelCompound.func_74768_a("skill", entry.getKey().ordinal());
            levelCompound.func_74768_a("level", ((Integer)entry.getValue().func_76341_a()).intValue());
            levelCompound.func_74780_a("experience", ((Double)entry.getValue().func_76340_b()).doubleValue());
            levelTagList.add((Object)levelCompound);
        }
        compoundNBT.func_218657_a("levelMap", (INBT)levelTagList);
        return compoundNBT;
    }

    @Override
    public void read(@NotNull CompoundNBT compoundNBT) {
        ListNBT levelTagList = compoundNBT.func_150295_c("levelMap", 10);
        for (int i = 0; i < levelTagList.size(); ++i) {
            CompoundNBT levelExperienceAtJob = levelTagList.func_150305_b(i);
            this.skillMap.put(Skill.values()[levelExperienceAtJob.func_74762_e("skill")], (Tuple<Integer, Double>)new Tuple((Object)Math.max(1, Math.min(levelExperienceAtJob.func_74762_e("level"), 99)), (Object)levelExperienceAtJob.func_74769_h("experience")));
        }
    }

    @Override
    public void tryLevelUpIntelligence(@NotNull Random random, int customChance, @NotNull ICitizenData citizen) {
        if (customChance > 0 && random.nextInt(customChance) > 0 || customChance < 1 && random.nextInt(50) > 0) {
            return;
        }
        int levelCap = (int)citizen.getCitizenHappinessHandler().getHappiness();
        if ((Double)this.skillMap.get((Object)Skill.Intelligence).func_76340_b() < (double)(levelCap * 9)) {
            this.addXpToSkill(Skill.Intelligence, 10.0, citizen);
        }
    }

    @Override
    public int getLevel(@NotNull Skill skill) {
        return (Integer)this.skillMap.get((Object)skill).func_76341_a();
    }

    @Override
    public void incrementLevel(@NotNull Skill skill, int level) {
        Tuple<Integer, Double> current = this.skillMap.get((Object)skill);
        this.skillMap.put(skill, (Tuple<Integer, Double>)new Tuple((Object)Math.min(99, Math.max((Integer)current.func_76341_a() + level, 1)), current.func_76340_b()));
    }

    @Override
    public void addXpToSkill(Skill skill, double xp, ICitizenData data) {
        double citizenHutMaxLevel;
        Tuple<Integer, Double> tuple = this.skillMap.getOrDefault((Object)skill, (Tuple<Integer, Double>)new Tuple((Object)0, (Object)0.0));
        int level = (Integer)tuple.func_76341_a();
        double currentXp = (Double)tuple.func_76340_b();
        IBuilding home = data.getHomeBuilding();
        double citizenHutLevel = home == null ? 0.0 : (double)home.getBuildingLevel();
        double d = citizenHutMaxLevel = home == null ? 5.0 : (double)home.getMaxBuildingLevel();
        if (citizenHutLevel < citizenHutMaxLevel && citizenHutLevel * 10.0 <= (double)level || level >= 99) {
            return;
        }
        double xpToLevelUp = Math.min(Double.MAX_VALUE, currentXp + xp);
        while (xpToLevelUp > 0.0) {
            double nextLevel = ExperienceUtils.getXPNeededForNextLevel(level);
            if (nextLevel > xpToLevelUp) {
                this.skillMap.put(skill, (Tuple<Integer, Double>)new Tuple((Object)Math.min(99, level), (Object)xpToLevelUp));
                xpToLevelUp = 0.0;
                continue;
            }
            xpToLevelUp -= nextLevel;
            ++level;
        }
        if (level > (Integer)tuple.func_76341_a()) {
            this.levelUp(data);
            data.markDirty();
        }
    }

    @Override
    public void removeXpFromSkill(@NotNull Skill skill, double xp, @NotNull ICitizenData data) {
        Tuple<Integer, Double> tuple = this.skillMap.get((Object)skill);
        int level = (Integer)tuple.func_76341_a();
        double currentXp = (Double)tuple.func_76340_b();
        double xpToDiscount = xp;
        while (xpToDiscount > 0.0) {
            if (currentXp >= xpToDiscount) {
                this.skillMap.put(skill, (Tuple<Integer, Double>)new Tuple((Object)Math.max(1, level), (Object)(currentXp - xpToDiscount)));
                xpToDiscount = 0.0;
                continue;
            }
            xpToDiscount -= currentXp;
            currentXp = ExperienceUtils.getXPNeededForNextLevel(level - 1);
            --level;
        }
        if (level < (Integer)tuple.func_76341_a()) {
            data.markDirty();
        }
    }

    @Override
    public void levelUp(ICitizenData data) {
        if (data.getEntity().isPresent()) {
            AbstractEntityCitizen citizen = data.getEntity().get();
            Network.getNetwork().sendToTrackingEntity(new VanillaParticleMessage(citizen.func_226277_ct_(), citizen.func_226278_cu_(), citizen.func_226281_cx_(), ParticleTypes.field_197632_y), (Entity)data.getEntity().get());
        }
        if (data.getJob() != null) {
            data.getJob().onLevelUp();
        }
    }

    @Override
    public int getJobModifier(@NotNull ICitizenData data) {
        IBuildingWorker workBuilding = data.getWorkBuilding();
        if (workBuilding instanceof AbstractBuildingWorker) {
            Skill primary = ((AbstractBuildingWorker)workBuilding).getPrimarySkill();
            Skill secondary = ((AbstractBuildingWorker)workBuilding).getSecondarySkill();
            return (this.getLevel(primary) + this.getLevel(secondary)) / 4;
        }
        return 0;
    }

    @Override
    public int getJobModifier(@NotNull IBuildingView workBuilding) {
        if (workBuilding instanceof AbstractBuildingWorker.View) {
            Skill primary = ((AbstractBuildingWorker.View)workBuilding).getPrimarySkill();
            Skill secondary = ((AbstractBuildingWorker.View)workBuilding).getSecondarySkill();
            return (this.getLevel(primary) + this.getLevel(secondary)) / 4;
        }
        return 0;
    }

    @Override
    public double getTotalXP() {
        double totalXp = 0.0;
        for (Tuple<Integer, Double> tuple : this.skillMap.values()) {
            totalXp += ((Double)tuple.func_76340_b()).doubleValue();
        }
        return totalXp;
    }

    @Override
    public Map<Skill, Tuple<Integer, Double>> getSkills() {
        return ImmutableMap.copyOf(this.skillMap);
    }
}

