/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity.citizen.citizenhandlers;

import com.minecolonies.api.entity.ai.Status;
import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import com.minecolonies.api.entity.citizen.citizenhandlers.ICitizenStatusHandler;
import com.minecolonies.coremod.MineColonies;
import java.util.Objects;
import net.minecraft.util.text.ITextComponent;

public class CitizenStatusHandler
implements ICitizenStatusHandler {
    private final AbstractEntityCitizen citizen;
    protected Status status = Status.IDLE;
    private boolean enabled;
    private final ITextComponent[] latestStatus;

    public CitizenStatusHandler(AbstractEntityCitizen citizen) {
        this.enabled = (Boolean)MineColonies.getConfig().getCommon().enableInDevelopmentFeatures.get();
        this.latestStatus = new ITextComponent[4];
        this.citizen = citizen;
    }

    @Override
    public ITextComponent[] getLatestStatus() {
        return (ITextComponent[])this.latestStatus.clone();
    }

    @Override
    public void setLatestStatus(ITextComponent ... status) {
        if (!this.enabled) {
            return;
        }
        boolean hasChanged = false;
        for (int i = 0; i < this.latestStatus.length; ++i) {
            ITextComponent newStatus = i >= status.length ? null : status[i];
            if (Objects.equals(this.latestStatus[i], newStatus)) continue;
            this.latestStatus[i] = newStatus;
            hasChanged = true;
        }
        if (hasChanged) {
            this.citizen.markDirty();
        }
    }

    @Override
    public void addLatestStatus(ITextComponent status) {
        System.arraycopy(this.latestStatus, 0, this.latestStatus, 1, this.latestStatus.length - 1);
        this.latestStatus[0] = status;
        this.citizen.markDirty();
    }

    @Override
    public Status getStatus() {
        return this.status;
    }

    @Override
    public void setStatus(Status status) {
        this.status = status;
    }
}

