/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity.mobs.aitasks;

import com.minecolonies.api.entity.mobs.AbstractEntityMinecoloniesMob;
import com.minecolonies.api.entity.mobs.RaiderMobUtils;
import com.minecolonies.api.util.EntityUtils;
import com.minecolonies.api.util.SoundUtils;
import com.minecolonies.coremod.MineColonies;
import java.util.EnumSet;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundEvents;

public class EntityAIRaiderAttackMelee
extends Goal {
    private static final int MAX_ATTACK_DELAY = 60;
    private static final double HALF_ROTATION = 180.0;
    private static final double MIN_DISTANCE_FOR_ATTACK = 2.5;
    private static final double ATTACK_SPEED = 1.3;
    public static final int MUTEX_BITS = 3;
    private static final double EXTENDED_REACH_DIFFICUTLY = 1.9;
    private static final double EXTENDED_REACH = 0.4;
    private static final double ADD_SPEED_DIFFICULTY = 2.3;
    private static final double ADD_SPEED = 0.3;
    private final AbstractEntityMinecoloniesMob entity;
    private LivingEntity target;
    private int lastAttack = 0;
    private int tickTimer = 0;

    public EntityAIRaiderAttackMelee(AbstractEntityMinecoloniesMob creatureIn) {
        this.entity = creatureIn;
        this.func_220684_a(EnumSet.of(Goal.Flag.MOVE));
    }

    public boolean func_75250_a() {
        this.target = this.entity.func_70638_az() != null ? this.entity.func_70638_az() : this.entity.func_94060_bK();
        return this.target != null && !EntityUtils.isFlying(this.target);
    }

    public boolean func_75253_b() {
        this.target = this.entity.func_70638_az();
        if (this.target != null && this.target.func_70089_S() && this.entity.func_70089_S() && this.entity.func_70685_l((Entity)this.target) && !EntityUtils.isFlying(this.target)) {
            this.attack(this.target);
            return true;
        }
        return false;
    }

    public void func_75249_e() {
        this.attack(this.target);
    }

    private void attack(LivingEntity target) {
        if (this.tickTimer > 0) {
            --this.tickTimer;
            --this.lastAttack;
            return;
        }
        this.tickTimer = 10;
        if (target != null) {
            double damageToBeDealt = this.entity.func_110148_a(RaiderMobUtils.MOB_ATTACK_DAMAGE).func_111126_e();
            double d = this.entity.func_70032_d((Entity)target);
            double d2 = this.entity.getDifficulty() < 1.9 ? 2.5 : 2.9;
            if (d <= d2 && this.lastAttack <= 0 && this.entity.func_70685_l((Entity)target)) {
                target.func_70097_a((DamageSource)new EntityDamageSource(this.entity.func_200600_R().func_210760_d(), (Entity)this.entity), (float)damageToBeDealt);
                this.entity.func_184609_a(Hand.MAIN_HAND);
                this.entity.func_184185_a(SoundEvents.field_187730_dW, 1.0f, (float)SoundUtils.getRandomPitch(this.entity.func_70681_au()));
                target.func_70604_c((LivingEntity)this.entity);
                this.lastAttack = this.getAttackDelay();
            }
            if (this.lastAttack > 0) {
                --this.lastAttack;
            }
            this.entity.func_70625_a((Entity)target, 180.0f, 180.0f);
            this.entity.func_70671_ap().func_75651_a((Entity)target, 180.0f, 180.0f);
            this.entity.getNavigator().func_75497_a((Entity)target, this.entity.getDifficulty() < 2.3 ? 1.3 : 1.6);
        }
    }

    protected int getAttackDelay() {
        return 60 - (Integer)MineColonies.getConfig().getCommon().barbarianHordeDifficulty.get() * 4;
    }
}

