/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity.pathfinding;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.entity.MinecoloniesMinecart;
import com.minecolonies.api.entity.ModEntities;
import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import com.minecolonies.api.entity.mobs.barbarians.AbstractEntityBarbarian;
import com.minecolonies.api.entity.mobs.pirates.AbstractEntityPirate;
import com.minecolonies.api.entity.pathfinding.AbstractAdvancedPathNavigate;
import com.minecolonies.api.entity.pathfinding.IStuckHandler;
import com.minecolonies.api.entity.pathfinding.PathFindingStatus;
import com.minecolonies.api.entity.pathfinding.PathResult;
import com.minecolonies.api.entity.pathfinding.PathingStuckHandler;
import com.minecolonies.api.entity.pathfinding.RandomPathResult;
import com.minecolonies.api.entity.pathfinding.TreePathResult;
import com.minecolonies.api.entity.pathfinding.WaterPathResult;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.CompatibilityUtils;
import com.minecolonies.api.util.Log;
import com.minecolonies.api.util.Tuple;
import com.minecolonies.coremod.entity.pathfinding.PathPointExtended;
import com.minecolonies.coremod.entity.pathfinding.Pathfinding;
import com.minecolonies.coremod.entity.pathfinding.pathjobs.AbstractPathJob;
import com.minecolonies.coremod.entity.pathfinding.pathjobs.PathJobFindTree;
import com.minecolonies.coremod.entity.pathfinding.pathjobs.PathJobFindWater;
import com.minecolonies.coremod.entity.pathfinding.pathjobs.PathJobMoveAwayFromLocation;
import com.minecolonies.coremod.entity.pathfinding.pathjobs.PathJobMoveToLocation;
import com.minecolonies.coremod.entity.pathfinding.pathjobs.PathJobRandomPos;
import com.minecolonies.coremod.util.WorkerUtil;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ExecutionException;
import net.minecraft.block.AbstractRailBlock;
import net.minecraft.block.BlockState;
import net.minecraft.block.VineBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.pathfinding.Path;
import net.minecraft.pathfinding.PathFinder;
import net.minecraft.pathfinding.PathPoint;
import net.minecraft.pathfinding.WalkNodeProcessor;
import net.minecraft.state.properties.RailShape;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MinecoloniesAdvancedPathNavigate
extends AbstractAdvancedPathNavigate {
    private static final double ON_PATH_SPEED_MULTIPLIER = 1.3;
    private static final double PIRATE_SWIM_BONUS = 30.0;
    private static final double BARBARIAN_SWIM_BONUS = 15.0;
    private static final double CITIZEN_SWIM_BONUS = 10.0;
    public static final double MIN_Y_DISTANCE = 0.001;
    public static final int MAX_SPEED_ALLOWED = 100;
    @Nullable
    private PathResult pathResult;
    private long pathStartTime = 0L;
    private BlockPos spawnedPos = BlockPos.field_177992_a;
    private BlockPos desiredPos;
    private int desiredPosTimeout = 0;
    private IStuckHandler stuckHandler;

    public MinecoloniesAdvancedPathNavigate(@NotNull MobEntity entity, World world) {
        super(entity, world);
        this.field_179695_a = new WalkNodeProcessor();
        this.field_179695_a.func_186317_a(true);
        this.getPathingOptions().setEnterDoors(true);
        this.field_179695_a.func_186321_b(true);
        this.getPathingOptions().setCanOpenDoors(true);
        this.field_179695_a.func_186316_c(true);
        this.getPathingOptions().setCanSwim(true);
        this.stuckHandler = PathingStuckHandler.createStuckHandler().withTakeDamageOnStuck(0.2f).withTeleportSteps(6).withTeleportOnFullStuck();
    }

    @Override
    public BlockPos getDestination() {
        return this.destination;
    }

    @Override
    @Nullable
    public PathResult moveAwayFromXYZ(BlockPos avoid, double range, double speed) {
        BlockPos start = AbstractPathJob.prepareStart((LivingEntity)this.ourEntity);
        return this.setPathJob(new PathJobMoveAwayFromLocation(CompatibilityUtils.getWorldFromEntity((Entity)this.ourEntity), start, avoid, (int)range, (int)this.ourEntity.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111126_e(), (LivingEntity)this.ourEntity), null, speed);
    }

    @Override
    @Nullable
    public RandomPathResult moveToRandomPos(double range, double speed) {
        if (this.pathResult instanceof RandomPathResult && this.pathResult.isComputing()) {
            return (RandomPathResult)this.pathResult;
        }
        int theRange = (int)((double)this.field_75515_a.func_70681_au().nextInt((int)range) + range / 2.0);
        BlockPos start = AbstractPathJob.prepareStart((LivingEntity)this.ourEntity);
        return (RandomPathResult)this.setPathJob(new PathJobRandomPos(CompatibilityUtils.getWorldFromEntity((Entity)this.ourEntity), start, theRange, (int)this.ourEntity.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111126_e(), (LivingEntity)this.ourEntity), null, speed);
    }

    @Nullable
    public PathResult setPathJob(@NotNull AbstractPathJob job, BlockPos dest, double speed) {
        if (dest != null && dest.equals((Object)this.desiredPos) && this.calculationFuture != null && this.pathResult != null) {
            return this.pathResult;
        }
        this.func_75499_g();
        this.destination = dest;
        this.originalDestination = dest;
        if (dest != null) {
            this.desiredPos = dest;
            this.desiredPosTimeout = 1000;
        }
        this.walkSpeed = speed;
        if (speed > 100.0) {
            Log.getLogger().error("Tried to set a too high speed for entity:" + this.ourEntity, (Throwable)new Exception());
            return null;
        }
        job.setPathingOptions(this.getPathingOptions());
        this.calculationFuture = Pathfinding.enqueue(job);
        this.pathResult = job.getResult();
        return this.pathResult;
    }

    public boolean func_75500_f() {
        return this.calculationFuture == null && super.func_75500_f();
    }

    public void func_75501_e() {
        if (this.desiredPosTimeout > 0 && this.desiredPosTimeout-- <= 0) {
            this.desiredPos = null;
        }
        if (this.calculationFuture != null) {
            if (!this.calculationFuture.isDone()) {
                return;
            }
            try {
                if (this.processCompletedCalculationResult()) {
                    return;
                }
            }
            catch (InterruptedException | ExecutionException e) {
                Log.getLogger().catching((Throwable)e);
            }
            this.calculationFuture = null;
        }
        int oldIndex = this.func_75500_f() ? 0 : this.func_75505_d().func_75873_e();
        this.field_75515_a.func_226284_e_(false);
        this.ourEntity.func_70657_f(0.0f);
        if (this.handleLadders(oldIndex)) {
            return;
        }
        if (this.handleRails()) {
            return;
        }
        super.func_75501_e();
        if (this.pathResult != null && this.func_75500_f()) {
            this.pathResult.setStatus(PathFindingStatus.COMPLETE);
            this.pathResult = null;
        }
        this.stuckHandler.checkStuck(this);
    }

    @Override
    @Nullable
    public PathResult moveToXYZ(double x, double y, double z, double speed) {
        int newX = MathHelper.func_76128_c((double)x);
        int newY = (int)y;
        int newZ = MathHelper.func_76128_c((double)z);
        if (this.pathResult != null && (this.pathResult.isComputing() || this.destination != null && BlockPosUtil.isEqual(this.destination, newX, newY, newZ) || this.originalDestination != null && BlockPosUtil.isEqual(this.originalDestination, newX, newY, newZ))) {
            return this.pathResult;
        }
        BlockPos start = AbstractPathJob.prepareStart((LivingEntity)this.ourEntity);
        this.desiredPos = new BlockPos(newX, newY, newZ);
        return this.setPathJob(new PathJobMoveToLocation(CompatibilityUtils.getWorldFromEntity((Entity)this.ourEntity), start, this.desiredPos, (int)this.ourEntity.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111126_e(), (LivingEntity)this.ourEntity), this.desiredPos, speed);
    }

    @Override
    public boolean tryMoveToBlockPos(BlockPos pos, double speed) {
        this.moveToXYZ(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), speed);
        return true;
    }

    protected PathFinder func_179679_a(int p_179679_1_) {
        return null;
    }

    protected boolean func_75485_k() {
        if (this.ourEntity.field_184239_as != null) {
            PathPointExtended pEx = (PathPointExtended)this.func_75505_d().func_75877_a(this.func_75505_d().func_75873_e());
            if (pEx.isRailsExit()) {
                Entity entity = this.ourEntity.field_184239_as;
                this.ourEntity.func_184210_p();
                entity.func_70106_y();
            } else if (!pEx.isOnRails()) {
                if (this.ourEntity.field_184239_as instanceof MinecoloniesMinecart) {
                    Entity entity = this.ourEntity.field_184239_as;
                    this.ourEntity.func_184210_p();
                    entity.func_70106_y();
                } else {
                    this.ourEntity.func_184210_p();
                }
            } else if ((Math.abs((double)pEx.field_75839_a - this.field_75515_a.field_70165_t) > 7.0 || Math.abs((double)pEx.field_75838_c - this.field_75515_a.field_70161_v) > 7.0) && this.ourEntity.field_184239_as != null) {
                Entity entity = this.ourEntity.field_184239_as;
                this.ourEntity.func_184210_p();
                entity.func_70106_y();
            }
        }
        return true;
    }

    @NotNull
    protected Vec3d func_75502_i() {
        return this.ourEntity.func_174791_d();
    }

    public Path func_179680_a(BlockPos pos, int p_179680_2_) {
        return null;
    }

    protected boolean func_75493_a(Vec3d start, Vec3d end, int sizeX, int sizeY, int sizeZ) {
        return !WorkerUtil.isPathBlock(this.field_75513_b.func_180495_p(new BlockPos(start.field_72450_a, start.field_72448_b - 1.0, start.field_72449_c)).func_177230_c()) && super.func_75493_a(start, end, sizeX, sizeY, sizeZ);
    }

    public double getSpeed() {
        if (this.ourEntity instanceof AbstractEntityPirate && this.ourEntity.func_70090_H()) {
            this.field_75511_d = this.walkSpeed * 30.0;
            return this.field_75511_d;
        }
        if (this.ourEntity instanceof AbstractEntityBarbarian && this.ourEntity.func_70090_H()) {
            this.field_75511_d = this.walkSpeed * 15.0;
            return this.field_75511_d;
        }
        if (this.ourEntity instanceof AbstractEntityCitizen && this.ourEntity.func_70090_H()) {
            this.field_75511_d = this.walkSpeed * 10.0;
            return this.field_75511_d;
        }
        this.field_75511_d = this.walkSpeed;
        return this.walkSpeed;
    }

    public void func_75489_a(double d) {
        if (d > 100.0) {
            Log.getLogger().error("Tried to set a too high speed for entity:" + this.ourEntity, (Throwable)new Exception());
            return;
        }
        this.walkSpeed = d;
    }

    public boolean func_75492_a(double x, double y, double z, double speed) {
        if (x == 0.0 && y == 0.0 && z == 0.0) {
            return false;
        }
        this.moveToXYZ(x, y, z, speed);
        return true;
    }

    public boolean func_75497_a(Entity entityIn, double speedIn) {
        return this.tryMoveToBlockPos(entityIn.func_180425_c(), speedIn);
    }

    protected void func_75487_m() {
    }

    public boolean func_75484_a(@Nullable Path path, double speed) {
        if (path == null) {
            this.func_75499_g();
            return false;
        }
        this.pathStartTime = this.field_75513_b.func_82737_E();
        return super.func_75484_a(this.convertPath(path), speed);
    }

    private Path convertPath(Path path) {
        int pathLength = path.func_75874_d();
        Path tempPath = null;
        if (pathLength > 0 && !(path.func_75877_a(0) instanceof PathPointExtended)) {
            PathPointExtended[] newPoints = new PathPointExtended[pathLength];
            for (int i = 0; i < pathLength; ++i) {
                PathPoint point = path.func_75877_a(i);
                newPoints[i] = !(point instanceof PathPointExtended) ? new PathPointExtended(new BlockPos(point.field_75839_a, point.field_75837_b, point.field_75838_c)) : (PathPointExtended)point;
            }
            tempPath = new Path(Arrays.asList(newPoints), path.func_224770_k(), path.func_224771_h());
            PathPointExtended finalPoint = newPoints[pathLength - 1];
            this.destination = new BlockPos(finalPoint.field_75839_a, finalPoint.field_75837_b, finalPoint.field_75838_c);
        }
        return tempPath == null ? path : tempPath;
    }

    private boolean processCompletedCalculationResult() throws InterruptedException, ExecutionException {
        if (this.calculationFuture.get() == null) {
            this.calculationFuture = null;
            return true;
        }
        this.func_75484_a((Path)this.calculationFuture.get(), this.getSpeed());
        this.pathResult.setPathLength(this.func_75505_d().func_75874_d());
        this.pathResult.setStatus(PathFindingStatus.IN_PROGRESS_FOLLOWING);
        PathPoint p = this.func_75505_d().func_75870_c();
        if (p != null && this.destination == null) {
            this.destination = new BlockPos(p.field_75839_a, p.field_75837_b, p.field_75838_c);
            this.pathResult.setPathReachesDestination(true);
        }
        return false;
    }

    private boolean handleLadders(int oldIndex) {
        if (!this.func_75500_f()) {
            PathPointExtended pEx = (PathPointExtended)this.func_75505_d().func_75877_a(this.func_75505_d().func_75873_e());
            PathPointExtended pExNext = this.func_75505_d().func_75874_d() > this.func_75505_d().func_75873_e() + 1 ? (PathPointExtended)this.func_75505_d().func_75877_a(this.func_75505_d().func_75873_e() + 1) : null;
            for (int i = this.field_75514_c.func_75873_e(); i < Math.min(this.field_75514_c.func_75874_d(), this.field_75514_c.func_75873_e() + 3); ++i) {
                PathPointExtended nextPoints = (PathPointExtended)this.func_75505_d().func_75877_a(i);
                if (!nextPoints.isOnLadder()) continue;
                Vec3d motion = this.field_75515_a.func_213322_ci();
                double x = motion.field_72450_a < -0.1 ? -0.1 : Math.min(motion.field_72450_a, 0.1);
                double z = motion.field_72450_a < -0.1 ? -0.1 : Math.min(motion.field_72449_c, 0.1);
                this.ourEntity.func_213293_j(x, motion.field_72448_b, z);
                break;
            }
            if (pEx.isOnLadder() && pExNext != null && (pEx.field_75837_b != pExNext.field_75837_b || this.field_75515_a.field_70163_u > (double)pEx.field_75837_b)) {
                return this.handlePathPointOnLadder(pEx);
            }
            if (this.ourEntity.func_70090_H()) {
                return this.handleEntityInWater(oldIndex, pEx);
            }
            this.field_75511_d = WorkerUtil.isPathBlock(this.field_75513_b.func_180495_p(this.findBlockUnderEntity((Entity)this.ourEntity)).func_177230_c()) ? 1.3 * this.getSpeed() : this.getSpeed();
        }
        return false;
    }

    private BlockPos findBlockUnderEntity(@NotNull Entity parEntity) {
        int blockX = (int)Math.round(parEntity.field_70165_t);
        int blockY = MathHelper.func_76128_c((double)(parEntity.field_70163_u - 0.2));
        int blockZ = (int)Math.round(parEntity.field_70161_v);
        return new BlockPos(blockX, blockY, blockZ);
    }

    private boolean handleRails() {
        if (!this.func_75500_f()) {
            PathPointExtended pExNext;
            PathPointExtended pEx = (PathPointExtended)this.func_75505_d().func_75877_a(this.func_75505_d().func_75873_e());
            PathPointExtended pathPointExtended = pExNext = this.func_75505_d().func_75874_d() > this.func_75505_d().func_75873_e() + 1 ? (PathPointExtended)this.func_75505_d().func_75877_a(this.func_75505_d().func_75873_e() + 1) : null;
            if (pEx.isOnRails() || pEx.isRailsExit()) {
                return this.handlePathOnRails(pEx, pExNext);
            }
        }
        return false;
    }

    private boolean handlePathOnRails(PathPointExtended pEx, PathPointExtended pExNext) {
        BlockPos blockPos;
        if (pEx.isRailsEntry()) {
            blockPos = new BlockPos(pEx.field_75839_a, pEx.field_75837_b, pEx.field_75838_c);
            if (!this.spawnedPos.equals((Object)blockPos)) {
                BlockState blockstate = this.field_75513_b.func_180495_p(blockPos);
                RailShape railshape = blockstate.func_177230_c() instanceof AbstractRailBlock ? ((AbstractRailBlock)blockstate.func_177230_c()).getRailDirection(blockstate, (IBlockReader)this.field_75513_b, blockPos, null) : RailShape.NORTH_SOUTH;
                double yOffset = 0.0;
                if (railshape.func_208092_c()) {
                    yOffset = 0.5;
                }
                if (this.field_75515_a.field_184239_as instanceof MinecoloniesMinecart) {
                    ((MinecoloniesMinecart)this.field_75515_a.field_184239_as).func_70494_i(1);
                } else {
                    MinecoloniesMinecart minecart = (MinecoloniesMinecart)ModEntities.MINECART.func_200721_a(this.field_75513_b);
                    double x = (double)pEx.field_75839_a + 0.5;
                    double y = (double)pEx.field_75837_b + 0.625 + yOffset;
                    double z = (double)pEx.field_75838_c + 0.5;
                    minecart.func_70107_b(x, y, z);
                    minecart.func_213317_d(Vec3d.field_186680_a);
                    minecart.field_70169_q = x;
                    minecart.field_70167_r = y;
                    minecart.field_70166_s = z;
                    this.field_75513_b.func_217376_c((Entity)minecart);
                    minecart.func_70494_i(1);
                    this.field_75515_a.func_184205_a((Entity)minecart, true);
                }
                this.spawnedPos = blockPos;
            }
        } else {
            this.spawnedPos = BlockPos.field_177992_a;
        }
        if (this.field_75515_a.field_184239_as instanceof MinecoloniesMinecart && pExNext != null) {
            blockPos = new BlockPos(pEx.field_75839_a, pEx.field_75837_b, pEx.field_75838_c);
            BlockPos blockPosNext = new BlockPos(pExNext.field_75839_a, pExNext.field_75837_b, pExNext.field_75838_c);
            Vec3d motion = this.field_75515_a.field_184239_as.func_213322_ci();
            switch (BlockPosUtil.getXZFacing(blockPos, blockPosNext).func_176734_d()) {
                case EAST: {
                    double forward = Math.min(Math.max(motion.func_82615_a() - 0.01, -1.0), 0.0);
                    this.field_75515_a.field_184239_as.func_213317_d(motion.func_72441_c(forward == -1.0 ? -1.0 : -0.01, 0.0, 0.0));
                    break;
                }
                case WEST: {
                    double forward = Math.max(Math.min(motion.func_82615_a() + 0.01, 1.0), 0.0);
                    this.field_75515_a.field_184239_as.func_213317_d(motion.func_72441_c(forward == 1.0 ? 1.0 : 0.01, 0.0, 0.0));
                    break;
                }
                case NORTH: {
                    double forward = Math.max(Math.min(motion.func_82616_c() + 0.01, 1.0), 0.0);
                    this.field_75515_a.field_184239_as.func_213317_d(motion.func_72441_c(0.0, 0.0, forward == 1.0 ? 1.0 : 0.01));
                    break;
                }
                case SOUTH: {
                    double forward = Math.min(Math.max(motion.func_82616_c() - 0.01, -1.0), 0.0);
                    this.field_75515_a.field_184239_as.func_213317_d(motion.func_72441_c(0.0, 0.0, forward == -1.0 ? -1.0 : -0.01));
                    break;
                }
            }
        }
        return false;
    }

    private boolean handlePathPointOnLadder(PathPointExtended pEx) {
        Vec3d vec3 = this.func_75505_d().func_75878_a((Entity)this.ourEntity);
        if (vec3.func_186679_c(this.ourEntity.field_70165_t, vec3.field_72448_b, this.ourEntity.field_70161_v) < Math.random() * 0.1) {
            double newSpeed = 0.05;
            switch (pEx.getLadderFacing()) {
                case NORTH: {
                    vec3 = vec3.func_72441_c(0.0, 0.0, 1.0);
                    break;
                }
                case SOUTH: {
                    vec3 = vec3.func_72441_c(0.0, 0.0, -1.0);
                    break;
                }
                case WEST: {
                    vec3 = vec3.func_72441_c(1.0, 0.0, 0.0);
                    break;
                }
                case EAST: {
                    vec3 = vec3.func_72441_c(-1.0, 0.0, 0.0);
                    break;
                }
                case UP: {
                    vec3 = vec3.func_72441_c(0.0, 1.0, 0.0);
                    break;
                }
                default: {
                    newSpeed = 0.0;
                    this.field_75515_a.func_226284_e_(true);
                }
            }
            if (newSpeed > 0.0) {
                if (this.field_75513_b.func_180495_p(this.ourEntity.func_180425_c()).func_177230_c() instanceof VineBlock) {
                    this.ourEntity.func_213317_d(this.ourEntity.func_213322_ci().func_72441_c(0.0, 0.1, 0.0));
                }
                this.ourEntity.func_70605_aq().func_75642_a(vec3.field_72450_a, vec3.field_72448_b, vec3.field_72449_c, newSpeed);
            } else {
                if (this.field_75513_b.func_180495_p(this.ourEntity.func_180425_c().func_177977_b()).isLadder((IWorldReader)this.field_75513_b, this.ourEntity.func_180425_c().func_177977_b(), (LivingEntity)this.ourEntity)) {
                    this.ourEntity.func_70657_f(-0.5f);
                } else {
                    this.ourEntity.func_70661_as().func_75499_g();
                }
                return true;
            }
        }
        return false;
    }

    private boolean handleEntityInWater(int oldIndex, PathPointExtended pEx) {
        int curIndex = this.func_75505_d().func_75873_e();
        if (curIndex > 0 && curIndex + 1 < this.func_75505_d().func_75874_d() && this.func_75505_d().func_75877_a((int)(curIndex - 1)).field_75837_b != pEx.field_75837_b) {
            oldIndex = curIndex + 1;
        }
        this.func_75505_d().func_75872_c(oldIndex);
        Vec3d vec3d = this.func_75505_d().func_75878_a((Entity)this.ourEntity);
        Vec3d vec3d2 = new Vec3d(this.ourEntity.field_70165_t, vec3d.field_72448_b, this.ourEntity.field_70161_v);
        if (vec3d.func_72436_e(vec3d2) < 0.1 && Math.abs(this.ourEntity.field_70163_u - vec3d.field_72448_b) < 0.5) {
            this.func_75505_d().func_75875_a();
            if (this.func_75500_f()) {
                return true;
            }
            vec3d = this.func_75505_d().func_75878_a((Entity)this.ourEntity);
        }
        this.ourEntity.func_70659_e((float)this.getSpeed());
        this.ourEntity.func_70605_aq().func_75642_a(vec3d.field_72450_a, vec3d.field_72448_b, vec3d.field_72449_c, this.getSpeed());
        return false;
    }

    protected void func_75508_h() {
        this.getSpeed();
        int curNode = this.field_75514_c.func_75873_e();
        int curNodeNext = curNode + 1;
        if (curNodeNext < this.field_75514_c.func_75874_d()) {
            if (!(this.field_75514_c.func_75877_a(curNode) instanceof PathPointExtended)) {
                this.field_75514_c = this.convertPath(this.field_75514_c);
            }
            PathPointExtended pEx = (PathPointExtended)this.field_75514_c.func_75877_a(curNode);
            PathPointExtended pExNext = (PathPointExtended)this.field_75514_c.func_75877_a(curNodeNext);
            if (pEx.isOnLadder() && pEx.getLadderFacing() == Direction.DOWN && !pExNext.isOnLadder()) {
                Vec3d vec3 = this.func_75502_i();
                if (vec3.field_72448_b - (double)pEx.field_75837_b < 0.001) {
                    this.field_75514_c.func_75872_c(curNodeNext);
                }
                this.func_179677_a(vec3);
                return;
            }
        }
        Vec3d vec3d = this.func_75502_i();
        this.field_188561_o = this.field_75515_a.func_213311_cf() > 0.75f ? this.field_75515_a.func_213311_cf() / 2.0f : 0.75f - this.field_75515_a.func_213311_cf() / 2.0f;
        Vec3d vec3d1 = this.field_75514_c.func_75881_a((Entity)this.field_75515_a, this.field_75514_c.func_75873_e());
        if (Math.abs(this.field_75515_a.func_226277_ct_() - vec3d1.field_72450_a) < (double)this.field_188561_o && Math.abs(this.field_75515_a.func_226281_cx_() - vec3d1.field_72449_c) < (double)this.field_188561_o && Math.abs(this.field_75515_a.func_226278_cu_() - vec3d1.field_72448_b) < 1.0) {
            this.field_75514_c.func_75875_a();
        } else {
            for (int i = this.field_75514_c.func_75873_e(); i < Math.min(this.field_75514_c.func_75874_d(), this.field_75514_c.func_75873_e() + 4); ++i) {
                Vec3d vec3d2 = this.field_75514_c.func_75881_a((Entity)this.field_75515_a, i);
                if (!(Math.abs(this.field_75515_a.func_226277_ct_() - vec3d2.field_72450_a) < (double)this.field_188561_o) || !(Math.abs(this.field_75515_a.func_226281_cx_() - vec3d2.field_72449_c) < (double)this.field_188561_o) || !(Math.abs(this.field_75515_a.func_226278_cu_() - vec3d2.field_72448_b) < 1.0)) continue;
                this.field_75514_c.func_75872_c(i);
                break;
            }
        }
        this.func_179677_a(vec3d);
    }

    public void func_188554_j() {
    }

    protected void func_179677_a(@NotNull Vec3d positionVec3) {
    }

    public void func_75499_g() {
        if (this.calculationFuture != null) {
            this.calculationFuture.cancel(true);
            this.calculationFuture = null;
        }
        if (this.pathResult != null) {
            this.pathResult.setStatus(PathFindingStatus.CANCELLED);
            this.pathResult = null;
        }
        this.destination = null;
        super.func_75499_g();
    }

    @Override
    @Nullable
    public WaterPathResult moveToWater(int range, double speed, List<Tuple<BlockPos, BlockPos>> ponds) {
        BlockPos start = AbstractPathJob.prepareStart((LivingEntity)this.ourEntity);
        return (WaterPathResult)this.setPathJob(new PathJobFindWater(CompatibilityUtils.getWorldFromEntity((Entity)this.ourEntity), start, ((AbstractEntityCitizen)this.ourEntity).getCitizenColonyHandler().getWorkBuilding().getPosition(), range, ponds, (LivingEntity)this.ourEntity), null, speed);
    }

    @Override
    public TreePathResult moveToTree(BlockPos startRestriction, BlockPos endRestriction, double speed, List<ItemStorage> treesToCut, IColony colony) {
        BlockPos start = AbstractPathJob.prepareStart((LivingEntity)this.ourEntity);
        BlockPos buildingPos = ((AbstractEntityCitizen)this.field_75515_a).getCitizenColonyHandler().getWorkBuilding().getPosition();
        PathJobFindTree job = new PathJobFindTree(CompatibilityUtils.getWorldFromEntity((Entity)this.field_75515_a), start, buildingPos, startRestriction, endRestriction, treesToCut, colony, (LivingEntity)this.ourEntity);
        return (TreePathResult)this.setPathJob(job, null, speed);
    }

    @Override
    public TreePathResult moveToTree(int range, double speed, List<ItemStorage> treesToCut, IColony colony) {
        BlockPos start = AbstractPathJob.prepareStart((LivingEntity)this.ourEntity);
        BlockPos buildingPos = ((AbstractEntityCitizen)this.field_75515_a).getCitizenColonyHandler().getWorkBuilding().getPosition();
        if (BlockPosUtil.getDistance2D(buildingPos, this.field_75515_a.func_180425_c()) > (long)(range * 4)) {
            start = buildingPos;
        }
        return (TreePathResult)this.setPathJob(new PathJobFindTree(CompatibilityUtils.getWorldFromEntity((Entity)this.field_75515_a), start, buildingPos, range, treesToCut, colony, (LivingEntity)this.ourEntity), null, speed);
    }

    @Override
    @Nullable
    public PathResult moveToLivingEntity(@NotNull Entity e, double speed) {
        return this.moveToXYZ(e.field_70165_t, e.field_70163_u, e.field_70161_v, speed);
    }

    @Override
    @Nullable
    public PathResult moveAwayFromLivingEntity(@NotNull Entity e, double distance, double speed) {
        return this.moveAwayFromXYZ(e.func_180425_c(), distance, speed);
    }

    public void func_212239_d(boolean canSwim) {
        super.func_212239_d(canSwim);
        this.getPathingOptions().setCanSwim(canSwim);
    }

    @Override
    public BlockPos getDesiredPos() {
        return this.desiredPos;
    }

    @Override
    public void setStuckHandler(IStuckHandler stuckHandler) {
        this.stuckHandler = stuckHandler;
    }
}

