/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity.pathfinding.pathjobs;

import com.minecolonies.api.util.Log;
import com.minecolonies.coremod.MineColonies;
import com.minecolonies.coremod.entity.pathfinding.Node;
import com.minecolonies.coremod.entity.pathfinding.pathjobs.AbstractPathJob;
import net.minecraft.entity.LivingEntity;
import net.minecraft.pathfinding.Path;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PathJobMoveToLocation
extends AbstractPathJob {
    private static final float DESTINATION_SLACK_NONE = 0.1f;
    private static final float DESTINATION_SLACK_ADJACENT = (float)Math.sqrt(2.0);
    @NotNull
    private final BlockPos destination;
    private float destinationSlack = 0.1f;

    public PathJobMoveToLocation(World world, @NotNull BlockPos start, @NotNull BlockPos end, int range, LivingEntity entity) {
        super(world, start, end, range, entity);
        this.destination = new BlockPos((Vec3i)end);
    }

    @Override
    @Nullable
    protected Path search() {
        if ((Integer)MineColonies.getConfig().getCommon().pathfindingDebugVerbosity.get() > 0) {
            Log.getLogger().info(String.format("Pathfinding from [%d,%d,%d] to [%d,%d,%d]", this.start.func_177958_n(), this.start.func_177956_o(), this.start.func_177952_p(), this.destination.func_177958_n(), this.destination.func_177956_o(), this.destination.func_177952_p()));
        }
        if (this.getGroundHeight(null, this.destination) != this.destination.func_177956_o()) {
            this.destinationSlack = DESTINATION_SLACK_ADJACENT;
        }
        return super.search();
    }

    @Override
    protected BlockPos getPathTargetPos(Node finalNode) {
        return this.destination;
    }

    @Override
    protected double computeHeuristic(@NotNull BlockPos pos) {
        return Math.sqrt(this.destination.func_177951_i((Vec3i)pos));
    }

    @Override
    protected boolean isAtDestination(@NotNull Node n) {
        if (this.destinationSlack <= 0.1f) {
            return n.pos.func_177958_n() == this.destination.func_177958_n() && n.pos.func_177956_o() == this.destination.func_177956_o() && n.pos.func_177952_p() == this.destination.func_177952_p();
        }
        if (n.pos.func_177956_o() == this.destination.func_177956_o() - 1) {
            return this.destination.func_218141_a(new Vec3i(n.pos.func_177958_n(), this.destination.func_177956_o(), n.pos.func_177952_p()), (double)DESTINATION_SLACK_ADJACENT);
        }
        return this.destination.func_218141_a((Vec3i)n.pos, (double)DESTINATION_SLACK_ADJACENT);
    }

    @Override
    protected double getNodeResultScore(@NotNull Node n) {
        return this.destination.func_177951_i((Vec3i)n.pos);
    }
}

