/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.generation.defaults;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.ldtteam.datagenerators.loot_table.LootTableJson;
import com.ldtteam.datagenerators.loot_table.LootTableTypeEnum;
import com.ldtteam.datagenerators.loot_table.pool.PoolJson;
import com.ldtteam.datagenerators.loot_table.pool.conditions.survives_explosion.SurvivesExplosionConditionJson;
import com.ldtteam.datagenerators.loot_table.pool.entry.EntryJson;
import com.ldtteam.datagenerators.loot_table.pool.entry.EntryTypeEnum;
import com.ldtteam.datagenerators.loot_table.pool.entry.functions.copy_name.CopyNameFunctionJson;
import com.minecolonies.api.blocks.AbstractBlockHut;
import com.minecolonies.api.blocks.ModBlocks;
import com.minecolonies.coremod.blocks.BlockMinecoloniesRack;
import com.minecolonies.coremod.generation.DataGeneratorConstants;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DirectoryCache;
import net.minecraft.data.IDataProvider;
import org.jetbrains.annotations.NotNull;

public class DefaultBlockLootTableProvider
implements IDataProvider {
    private final DataGenerator generator;

    public DefaultBlockLootTableProvider(DataGenerator generator) {
        this.generator = generator;
    }

    public void func_200398_a(@NotNull DirectoryCache cache) throws IOException {
        this.saveBlocks(Arrays.asList(ModBlocks.getHuts()), cache);
        this.saveBlock(ModBlocks.blockHutWareHouse, cache);
        this.saveBlock(ModBlocks.blockPostBox, cache);
        this.saveBlock(ModBlocks.blockStash, cache);
        this.saveBlock((Block)ModBlocks.blockConstructionTape, cache);
        this.saveBlock(ModBlocks.blockRack, cache);
        this.saveBlock(ModBlocks.blockWayPoint, cache);
        this.saveBlock((Block)ModBlocks.blockBarrel, cache);
        this.saveBlock((Block)ModBlocks.blockDecorationPlaceholder, cache);
        this.saveBlock(ModBlocks.blockScarecrow, cache);
        this.saveBlock(ModBlocks.blockBarracksTowerSubstitution, cache);
        this.saveBlock((Block)ModBlocks.blockColonyBanner, cache);
        this.saveBlock((Block)ModBlocks.blockIronGate, cache);
        this.saveBlock((Block)ModBlocks.blockWoodenGate, cache);
    }

    private <T extends Block> void saveBlocks(List<T> blocks, DirectoryCache cache) throws IOException {
        for (Block block : blocks) {
            this.saveBlock(block, cache);
        }
    }

    private void saveBlock(Block block, DirectoryCache cache) throws IOException {
        if (block.getRegistryName() != null) {
            EntryJson entryJson = new EntryJson();
            entryJson.setType(EntryTypeEnum.ITEM);
            entryJson.setName(block.getRegistryName().toString());
            if (block instanceof AbstractBlockHut || block instanceof BlockMinecoloniesRack) {
                entryJson.setFunctions(Collections.singletonList(new CopyNameFunctionJson()));
            }
            PoolJson poolJson = new PoolJson();
            poolJson.setEntries(Collections.singletonList(entryJson));
            poolJson.setRolls(1);
            poolJson.setConditions(Collections.singletonList(new SurvivesExplosionConditionJson()));
            LootTableJson lootTableJson = new LootTableJson();
            lootTableJson.setType(LootTableTypeEnum.BLOCK);
            lootTableJson.setPools(Collections.singletonList(poolJson));
            Path savePath = this.generator.func_200391_b().resolve("data/minecolonies/loot_tables/blocks").resolve(block.getRegistryName().func_110623_a() + ".json");
            IDataProvider.func_218426_a((Gson)DataGeneratorConstants.GSON, (DirectoryCache)cache, (JsonElement)lootTableJson.serialize(), (Path)savePath);
        }
    }

    @NotNull
    public String func_200397_b() {
        return "Default Block Loot Table Provider";
    }
}

