/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.items;

import com.ldtteam.structurize.util.LanguageHandler;
import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.IColonyView;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.buildings.IGuardBuilding;
import com.minecolonies.api.colony.buildings.views.IBuildingView;
import com.minecolonies.api.entity.ai.citizen.guards.GuardTask;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.coremod.client.gui.WindowGuardControl;
import com.minecolonies.coremod.colony.buildings.AbstractBuildingGuards;
import com.minecolonies.coremod.items.AbstractItemMinecolonies;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;

public class ItemScepterGuard
extends AbstractItemMinecolonies {
    private static final String TAG_LAST_POS = "lastPos";

    public ItemScepterGuard(Item.Properties properties) {
        super("scepterguard", properties.func_200917_a(1).func_200918_c(2));
    }

    @NotNull
    public ActionResultType func_195939_a(ItemUseContext ctx) {
        BlockPos lastPos;
        CompoundNBT compound;
        if (ctx.func_195991_k().field_72995_K) {
            return ActionResultType.FAIL;
        }
        ItemStack scepter = ctx.func_195999_j().func_184586_b(ctx.func_221531_n());
        if (!scepter.func_77942_o()) {
            scepter.func_77982_d(new CompoundNBT());
        }
        if ((compound = scepter.func_77978_p()).func_150296_c().contains(TAG_LAST_POS) && (lastPos = BlockPosUtil.read(compound, TAG_LAST_POS)).equals((Object)ctx.func_195995_a())) {
            ctx.func_195999_j().field_71071_by.func_70304_b(ctx.func_195999_j().field_71071_by.field_70461_c);
            LanguageHandler.sendPlayerMessage((PlayerEntity)ctx.func_195999_j(), (String)"com.minecolonies.coremod.job.guard.toolDoubleClick", (Object[])new Object[0]);
            return ActionResultType.FAIL;
        }
        return ItemScepterGuard.handleItemUsage(ctx.func_195991_k(), ctx.func_195995_a(), compound, ctx.func_195999_j());
    }

    @NotNull
    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, @NotNull Hand hand) {
        ItemStack stack = playerIn.func_184586_b(hand);
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new CompoundNBT());
        }
        CompoundNBT compound = stack.func_77978_p();
        if (worldIn.field_72995_K && compound != null) {
            if (!compound.func_150296_c().contains("id")) {
                return ActionResult.func_226249_b_((Object)stack);
            }
            IColonyView colony = IColonyManager.getInstance().getColonyView(compound.func_74762_e("id"), Minecraft.func_71410_x().field_71441_e.func_201675_m().func_186058_p().func_186068_a());
            if (colony == null) {
                return ActionResult.func_226249_b_((Object)stack);
            }
            BlockPos guardTower = BlockPosUtil.read(compound, "pos");
            IBuildingView hut = colony.getBuilding(guardTower);
            if (hut instanceof AbstractBuildingGuards.View && playerIn.func_225608_bj_()) {
                WindowGuardControl window = new WindowGuardControl((AbstractBuildingGuards.View)hut);
                window.open();
            }
        }
        return ActionResult.func_226248_a_((Object)stack);
    }

    @NotNull
    private static ActionResultType handleItemUsage(World worldIn, BlockPos pos, CompoundNBT compound, PlayerEntity playerIn) {
        if (!compound.func_150296_c().contains("id")) {
            return ActionResultType.FAIL;
        }
        IColony colony = IColonyManager.getInstance().getColonyByWorld(compound.func_74762_e("id"), worldIn);
        if (colony == null) {
            return ActionResultType.FAIL;
        }
        BlockPos guardTower = BlockPosUtil.read(compound, "pos");
        IBuilding hut = colony.getBuildingManager().getBuilding(guardTower);
        if (!(hut instanceof AbstractBuildingGuards)) {
            return ActionResultType.FAIL;
        }
        IGuardBuilding tower = (IGuardBuilding)hut;
        if (BlockPosUtil.getDistance2D(pos, guardTower) > (long)tower.getPatrolDistance()) {
            LanguageHandler.sendPlayerMessage((PlayerEntity)playerIn, (String)"com.minecolonies.coremod.job.guard.toolClickGuardTooFar", (Object[])new Object[0]);
            return ActionResultType.FAIL;
        }
        GuardTask task = GuardTask.values()[compound.func_74762_e("task")];
        ICitizenData citizen = tower.getMainCitizen();
        String name = "";
        if (citizen != null) {
            name = " " + citizen.getName();
        }
        if (task.equals((Object)GuardTask.GUARD)) {
            LanguageHandler.sendPlayerMessage((PlayerEntity)playerIn, (String)"com.minecolonies.coremod.job.guard.toolClickGuard", (Object[])new Object[]{pos, name});
            tower.setGuardPos(pos);
            playerIn.field_71071_by.func_70304_b(playerIn.field_71071_by.field_70461_c);
        } else {
            if (!compound.func_150296_c().contains(TAG_LAST_POS)) {
                tower.resetPatrolTargets();
            }
            tower.addPatrolTargets(pos);
            LanguageHandler.sendPlayerMessage((PlayerEntity)playerIn, (String)"com.minecolonies.coremod.job.guard.toolClickPatrol", (Object[])new Object[]{pos, name});
        }
        BlockPosUtil.write(compound, TAG_LAST_POS, pos);
        return ActionResultType.SUCCESS;
    }
}

