/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.items;

import com.ldtteam.structurize.util.LanguageHandler;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.coremod.colony.buildings.AbstractFilterableListBuilding;
import com.minecolonies.coremod.colony.buildings.workerbuildings.BuildingLumberjack;
import com.minecolonies.coremod.items.AbstractItemMinecolonies;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class ItemScepterLumberjack
extends AbstractItemMinecolonies {
    private static final String NBT_START_POS = "minecolonies:start_pos";
    private static final String NBT_END_POS = "minecolonies:end_pos";
    private boolean hasSetFirstPosition = false;

    public ItemScepterLumberjack(Item.Properties properties) {
        super("scepterlumberjack", properties.func_200917_a(1));
    }

    public ActionResultType func_195939_a(ItemUseContext useContext) {
        if (useContext.func_195991_k().field_72995_K) {
            return ActionResultType.FAIL;
        }
        ItemStack scepter = useContext.func_195999_j().func_184586_b(useContext.func_221531_n());
        if (!scepter.func_77942_o()) {
            scepter.func_77982_d(new CompoundNBT());
        }
        CompoundNBT compound = scepter.func_77978_p();
        if (!this.hasSetFirstPosition) {
            LanguageHandler.sendPlayerMessage((PlayerEntity)useContext.func_195999_j(), (String)"item.minecolonies.scepterlumberjack.usedstart", (Object[])new Object[0]);
            this.setPosition(compound, NBT_START_POS, useContext.func_195995_a());
        } else {
            LanguageHandler.sendPlayerMessage((PlayerEntity)useContext.func_195999_j(), (String)"item.minecolonies.scepterlumberjack.usedend", (Object[])new Object[0]);
            this.setPosition(compound, NBT_END_POS, useContext.func_195995_a());
            this.storeRestrictedArea(useContext.func_195999_j(), useContext.func_221531_n(), useContext.func_195991_k());
        }
        return super.func_195939_a(useContext);
    }

    private void storeRestrictedArea(PlayerEntity player, Hand hand, World worldIn) {
        ItemStack scepter = player.func_184586_b(hand);
        if (!scepter.func_77942_o()) {
            scepter.func_77982_d(new CompoundNBT());
        }
        CompoundNBT compound = scepter.func_77978_p();
        BlockPos startRestriction = BlockPosUtil.read(compound, NBT_START_POS);
        BlockPos endRestriction = BlockPosUtil.read(compound, NBT_END_POS);
        int minX = Math.min(startRestriction.func_177958_n(), endRestriction.func_177958_n());
        int minZ = Math.min(startRestriction.func_177952_p(), endRestriction.func_177952_p());
        int maxX = Math.max(startRestriction.func_177958_n(), endRestriction.func_177958_n());
        int maxZ = Math.max(startRestriction.func_177952_p(), endRestriction.func_177952_p());
        int distX = maxX - minX;
        int distZ = maxZ - minZ;
        int area = distX * distZ;
        int radius = 50;
        double maxArea = 3.14 * Math.pow(50.0, 2.0);
        if ((double)area > maxArea) {
            LanguageHandler.sendPlayerMessage((PlayerEntity)player, (String)"item.minecolonies.scepterlumberjack.restrictiontoobig", (Object[])new Object[]{area, maxArea});
            return;
        }
        LanguageHandler.sendPlayerMessage((PlayerEntity)player, (String)"item.minecolonies.scepterlumberjack.restrictionset", (Object[])new Object[]{area, maxArea});
        IColony colony = IColonyManager.getInstance().getColonyByWorld(compound.func_74762_e("id"), worldIn);
        BlockPos hutPos = BlockPosUtil.read(compound, "pos");
        IBuilding hut = colony.getBuildingManager().getBuilding(hutPos);
        AbstractFilterableListBuilding abstractBuilding = (AbstractFilterableListBuilding)hut;
        BuildingLumberjack lumberjackBuilding = (BuildingLumberjack)abstractBuilding;
        lumberjackBuilding.setRestrictedArea(startRestriction, endRestriction);
        player.field_71071_by.func_70304_b(player.field_71071_by.field_70461_c);
    }

    private void setPosition(CompoundNBT compound, String NBT2, BlockPos pos) {
        this.hasSetFirstPosition = !this.hasSetFirstPosition;
        BlockPosUtil.write(compound, NBT2, pos);
    }
}

