/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.items;

import com.ldtteam.structurize.util.LanguageHandler;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.IColonyView;
import com.minecolonies.api.creativetab.ModCreativeTabs;
import com.minecolonies.coremod.Network;
import com.minecolonies.coremod.items.AbstractItemMinecolonies;
import com.minecolonies.coremod.network.messages.server.colony.ChangeFreeToInteractBlockMessage;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;

public class ItemScepterPermission
extends AbstractItemMinecolonies {
    private static final String TAG_ITEM_MODE = "scepterMode";
    private static final String TAG_VALUE_MODE_BLOCK = "modeBlock";
    private static final String TAG_VALUE_MODE_LOCATION = "modeLocation";

    public ItemScepterPermission(Item.Properties properties) {
        super("scepterpermission", properties.func_200917_a(1).func_200918_c(2).func_200916_a(ModCreativeTabs.MINECOLONIES));
    }

    @NotNull
    private static ActionResultType handleAddBlockType(PlayerEntity playerIn, World worldIn, BlockPos pos, IColonyView iColonyView) {
        BlockState blockState = iColonyView.getWorld().func_180495_p(pos);
        Block block = blockState.func_177230_c();
        ChangeFreeToInteractBlockMessage message = new ChangeFreeToInteractBlockMessage(iColonyView, block, ChangeFreeToInteractBlockMessage.MessageType.ADD_BLOCK);
        Network.getNetwork().sendToServer(message);
        return ActionResultType.SUCCESS;
    }

    @NotNull
    private static ActionResultType handleAddLocation(PlayerEntity playerIn, World worldIn, BlockPos pos, IColonyView iColonyView) {
        ChangeFreeToInteractBlockMessage message = new ChangeFreeToInteractBlockMessage(iColonyView, pos, ChangeFreeToInteractBlockMessage.MessageType.ADD_BLOCK);
        Network.getNetwork().sendToServer(message);
        return ActionResultType.SUCCESS;
    }

    @NotNull
    public ActionResultType func_195939_a(ItemUseContext ctx) {
        IColonyView iColonyView;
        if (!ctx.func_195991_k().field_72995_K) {
            return ActionResultType.SUCCESS;
        }
        ItemStack scepter = ctx.func_195999_j().func_184586_b(ctx.func_221531_n());
        if (!scepter.func_77942_o()) {
            scepter.func_77982_d(new CompoundNBT());
        }
        if ((iColonyView = IColonyManager.getInstance().getClosestColonyView(ctx.func_195991_k(), ctx.func_195995_a())) == null) {
            return ActionResultType.FAIL;
        }
        CompoundNBT compound = scepter.func_77978_p();
        return ItemScepterPermission.handleItemAction(compound, ctx.func_195999_j(), ctx.func_195991_k(), ctx.func_195995_a(), iColonyView);
    }

    @NotNull
    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand hand) {
        ItemStack scepter = playerIn.func_184586_b(hand);
        if (worldIn.field_72995_K) {
            return new ActionResult(ActionResultType.SUCCESS, (Object)scepter);
        }
        if (!scepter.func_77942_o()) {
            scepter.func_77982_d(new CompoundNBT());
        }
        CompoundNBT compound = scepter.func_77978_p();
        ItemScepterPermission.toggleItemMode(playerIn, compound);
        return new ActionResult(ActionResultType.SUCCESS, (Object)scepter);
    }

    private static void toggleItemMode(PlayerEntity playerIn, CompoundNBT compound) {
        String itemMode;
        switch (itemMode = compound.func_74779_i(TAG_ITEM_MODE)) {
            case "modeBlock": {
                compound.func_74778_a(TAG_ITEM_MODE, TAG_VALUE_MODE_LOCATION);
                LanguageHandler.sendPlayerMessage((PlayerEntity)playerIn, (String)"com.minecolonies.coremod.item.permissionscepter.setmode", (Object[])new Object[]{"location"});
                break;
            }
            default: {
                compound.func_74778_a(TAG_ITEM_MODE, TAG_VALUE_MODE_BLOCK);
                LanguageHandler.sendPlayerMessage((PlayerEntity)playerIn, (String)"com.minecolonies.coremod.item.permissionscepter.setmode", (Object[])new Object[]{"block"});
            }
        }
    }

    @NotNull
    private static ActionResultType handleItemAction(CompoundNBT compound, PlayerEntity playerIn, World worldIn, BlockPos pos, IColonyView iColonyView) {
        String tagItemMode;
        switch (tagItemMode = compound.func_74779_i(TAG_ITEM_MODE)) {
            case "modeBlock": {
                return ItemScepterPermission.handleAddBlockType(playerIn, worldIn, pos, iColonyView);
            }
            case "modeLocation": {
                return ItemScepterPermission.handleAddLocation(playerIn, worldIn, pos, iColonyView);
            }
        }
        ItemScepterPermission.toggleItemMode(playerIn, compound);
        return ItemScepterPermission.handleItemAction(compound, playerIn, worldIn, pos, iColonyView);
    }
}

