/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.network.messages.client;

import com.minecolonies.api.network.IMessage;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.network.PacketBuffer;
import net.minecraft.particles.BasicParticleType;
import net.minecraft.particles.IParticleData;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CircleParticleEffectMessage
implements IMessage {
    private static final Random RAND = new Random();
    private BasicParticleType type;
    private double posX;
    private double posY;
    private double posZ;
    private int stage;

    public CircleParticleEffectMessage() {
    }

    public CircleParticleEffectMessage(Vec3d pos, BasicParticleType type, int stage) {
        this.posX = pos.field_72450_a;
        this.posY = pos.field_72448_b - 0.5;
        this.posZ = pos.field_72449_c;
        this.stage = stage;
        this.type = type;
    }

    @Override
    public void fromBytes(@NotNull PacketBuffer buf) {
        this.posX = buf.readDouble();
        this.posY = buf.readDouble();
        this.posZ = buf.readDouble();
        this.stage = buf.readInt();
        this.type = (BasicParticleType)ForgeRegistries.PARTICLE_TYPES.getValue(buf.func_192575_l());
    }

    @Override
    public void toBytes(@NotNull PacketBuffer buf) {
        buf.writeDouble(this.posX);
        buf.writeDouble(this.posY);
        buf.writeDouble(this.posZ);
        buf.writeInt(this.stage);
        buf.func_192572_a(this.type.getRegistryName());
    }

    @Override
    @Nullable
    public LogicalSide getExecutionSide() {
        return LogicalSide.CLIENT;
    }

    @Override
    public void onExecute(NetworkEvent.Context ctxIn, boolean isLogicalServer) {
        ClientWorld world = Minecraft.func_71410_x().field_71441_e;
        double x = 1.0 * Math.cos((double)this.stage * 45.0) + this.posX;
        double z = 1.0 * Math.sin((double)this.stage * 45.0) + this.posZ;
        for (int i = 0; i < 5; ++i) {
            Vec3d randomPos = new Vec3d(RAND.nextDouble() * 0.1 + 0.1, RAND.nextDouble() * 0.1 + 0.1, RAND.nextDouble() * 0.1 + 0.1);
            Vec3d randomOffset = new Vec3d((RAND.nextDouble() - 0.5) * 0.1, (RAND.nextDouble() - 0.5) * 0.1, (RAND.nextDouble() - 0.5) * 0.1);
            world.func_195594_a((IParticleData)this.type, x + randomOffset.field_72450_a, this.posY + randomOffset.field_72448_b, z + randomOffset.field_72449_c, randomPos.field_72450_a, randomPos.field_72448_b + 0.05, randomPos.field_72449_c);
        }
    }
}

