/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.network.messages.client.colony;

import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.network.IMessage;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.network.NetworkEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ColonyViewBuildingViewMessage
implements IMessage {
    private int colonyId;
    private BlockPos buildingId;
    private PacketBuffer buildingData;
    private int dimension;

    public ColonyViewBuildingViewMessage() {
    }

    public ColonyViewBuildingViewMessage(@NotNull IBuilding building) {
        this.colonyId = building.getColony().getID();
        this.buildingId = building.getID();
        this.buildingData = new PacketBuffer(Unpooled.buffer());
        building.serializeToView(this.buildingData);
        this.dimension = building.getColony().getDimension();
    }

    @Override
    public void fromBytes(@NotNull PacketBuffer buf) {
        this.colonyId = buf.readInt();
        this.buildingId = buf.func_179259_c();
        this.dimension = buf.readInt();
        this.buildingData = new PacketBuffer(Unpooled.buffer((int)buf.readableBytes()));
        buf.readBytes((ByteBuf)this.buildingData, buf.readableBytes());
    }

    @Override
    public void toBytes(@NotNull PacketBuffer buf) {
        buf.writeInt(this.colonyId);
        buf.func_179255_a(this.buildingId);
        buf.writeInt(this.dimension);
        buf.writeBytes((ByteBuf)this.buildingData);
    }

    @Override
    @Nullable
    public LogicalSide getExecutionSide() {
        return LogicalSide.CLIENT;
    }

    @Override
    public void onExecute(NetworkEvent.Context ctxIn, boolean isLogicalServer) {
        IColonyManager.getInstance().handleColonyBuildingViewMessage(this.colonyId, this.buildingId, this.buildingData, this.dimension);
    }
}

