/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.network.messages.client.colony;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.IColonyView;
import com.minecolonies.api.colony.IVisitorData;
import com.minecolonies.api.colony.IVisitorViewData;
import com.minecolonies.api.network.IMessage;
import com.minecolonies.api.util.Log;
import com.minecolonies.coremod.colony.VisitorDataView;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.network.NetworkEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ColonyVisitorViewDataMessage
implements IMessage {
    private int colonyId;
    private boolean refresh = false;
    private int dimension;
    private Set<IVisitorData> visitors;
    private Set<IVisitorViewData> visitorViews = new HashSet<IVisitorViewData>();

    public ColonyVisitorViewDataMessage() {
    }

    public ColonyVisitorViewDataMessage(@NotNull IColony colony, @NotNull Set<IVisitorData> visitors, boolean refresh) {
        this.colonyId = colony.getID();
        this.dimension = colony.getDimension();
        this.visitors = visitors;
        this.refresh = refresh;
    }

    @Override
    public void fromBytes(@NotNull PacketBuffer buf) {
        this.colonyId = buf.readInt();
        this.dimension = buf.readInt();
        this.refresh = buf.readBoolean();
        IColonyView colony = IColonyManager.getInstance().getColonyView(this.colonyId, this.dimension);
        if (colony == null) {
            Log.getLogger().warn("Received visitor data for nonexisting colony:" + this.colonyId + " dim:" + this.dimension);
            return;
        }
        this.visitors = new HashSet<IVisitorData>();
        int i = buf.readInt();
        for (int j = 0; j < i; ++j) {
            int id = buf.readInt();
            VisitorDataView dataView = new VisitorDataView(id, colony);
            dataView.deserialize(buf);
            this.visitorViews.add(dataView);
        }
    }

    @Override
    public void toBytes(@NotNull PacketBuffer buf) {
        buf.writeInt(this.colonyId);
        buf.writeInt(this.dimension);
        buf.writeBoolean(this.refresh);
        buf.writeInt(this.visitors.size());
        for (IVisitorData data : this.visitors) {
            buf.writeInt(data.getId());
            data.serializeViewNetworkData(buf);
        }
    }

    @Override
    @Nullable
    public LogicalSide getExecutionSide() {
        return LogicalSide.CLIENT;
    }

    @Override
    public void onExecute(NetworkEvent.Context ctxIn, boolean isLogicalServer) {
        IColonyView colony = IColonyManager.getInstance().getColonyView(this.colonyId, this.dimension);
        if (colony == null) {
            Log.getLogger().warn("Received visitor data for nonexisting colony:" + this.colonyId + " dim:" + this.dimension);
            return;
        }
        colony.handleColonyViewVisitorMessage(this.refresh, this.visitorViews);
    }
}

