/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.network.messages.server;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.permissions.Action;
import com.minecolonies.api.network.IMessage;
import com.minecolonies.coremod.blocks.BlockDecorationController;
import com.minecolonies.coremod.colony.workorders.WorkOrderBuildDecoration;
import com.minecolonies.coremod.tileentities.TileEntityDecorationController;
import java.util.Map;
import java.util.Optional;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.state.IProperty;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.network.NetworkEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DecorationBuildRequestMessage
implements IMessage {
    private BlockPos pos;
    private String name;
    private int level;
    private int dimension;

    public DecorationBuildRequestMessage() {
    }

    public DecorationBuildRequestMessage(@NotNull BlockPos pos, String name, int level, int dimension) {
        this.pos = pos;
        this.name = name;
        this.level = level;
        this.dimension = dimension;
    }

    @Override
    public void fromBytes(@NotNull PacketBuffer buf) {
        this.pos = buf.func_179259_c();
        this.name = buf.func_150789_c(Short.MAX_VALUE);
        this.level = buf.readInt();
        this.dimension = buf.readInt();
    }

    @Override
    public void toBytes(@NotNull PacketBuffer buf) {
        buf.func_179255_a(this.pos);
        buf.func_180714_a(this.name);
        buf.writeInt(this.level);
        buf.writeInt(this.dimension);
    }

    @Override
    @Nullable
    public LogicalSide getExecutionSide() {
        return LogicalSide.SERVER;
    }

    @Override
    public void onExecute(NetworkEvent.Context ctxIn, boolean isLogicalServer) {
        IColony colony = IColonyManager.getInstance().getColonyByPosFromDim(this.dimension, this.pos);
        if (colony == null) {
            return;
        }
        ServerPlayerEntity player = ctxIn.getSender();
        if (!colony.getPermissions().hasPermission((PlayerEntity)player, Action.MANAGE_HUTS)) {
            return;
        }
        TileEntity entity = player.func_130014_f_().func_175625_s(this.pos);
        if (entity instanceof TileEntityDecorationController) {
            Optional<Map.Entry> wo = colony.getWorkManager().getWorkOrders().entrySet().stream().filter(entry -> entry.getValue() instanceof WorkOrderBuildDecoration).filter(entry -> ((WorkOrderBuildDecoration)entry.getValue()).getBuildingLocation().equals((Object)this.pos)).findFirst();
            if (wo.isPresent()) {
                colony.getWorkManager().removeWorkOrder((Integer)wo.get().getKey());
                return;
            }
            BlockState state = player.func_130014_f_().func_180495_p(this.pos);
            Direction facing = (Direction)state.func_177229_b((IProperty)BlockDecorationController.field_185512_D);
            Direction basic = ((TileEntityDecorationController)entity).getBasicFacing();
            int difference = facing.func_176736_b() - basic.func_176736_b();
            if (difference < 0) {
                difference += 4;
            }
            WorkOrderBuildDecoration order = new WorkOrderBuildDecoration(this.name + this.level, this.name + this.level, difference, this.pos, (Boolean)state.func_177229_b((IProperty)BlockDecorationController.MIRROR));
            if (this.level != ((TileEntityDecorationController)entity).getLevel()) {
                order.setLevelUp();
            }
            colony.getWorkManager().addWorkOrder(order, false);
        }
    }
}

