/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.network.messages.server.colony.building.home;

import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.buildings.views.IBuildingView;
import com.minecolonies.coremod.colony.buildings.workerbuildings.BuildingHome;
import com.minecolonies.coremod.network.messages.server.AbstractBuildingServerMessage;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;
import org.jetbrains.annotations.NotNull;

public class AssignUnassignMessage
extends AbstractBuildingServerMessage<BuildingHome> {
    private boolean assign;
    private int citizenID;

    public AssignUnassignMessage() {
    }

    public AssignUnassignMessage(@NotNull IBuildingView building, boolean assign, int citizenID) {
        super(building);
        this.assign = assign;
        this.citizenID = citizenID;
    }

    @Override
    public void fromBytesOverride(@NotNull PacketBuffer buf) {
        this.assign = buf.readBoolean();
        this.citizenID = buf.readInt();
    }

    @Override
    public void toBytesOverride(@NotNull PacketBuffer buf) {
        buf.writeBoolean(this.assign);
        buf.writeInt(this.citizenID);
    }

    @Override
    public boolean errorIfCastFails() {
        return false;
    }

    @Override
    public void onExecute(NetworkEvent.Context ctxIn, boolean isLogicalServer, IColony colony, BuildingHome building) {
        ICitizenData citizen = colony.getCitizenManager().getCivilian(this.citizenID);
        if (this.assign && !building.isFull() && !building.equals(citizen.getHomeBuilding())) {
            if (citizen.getHomeBuilding() != null) {
                citizen.getHomeBuilding().removeCitizen(citizen);
            }
            building.assignCitizen(citizen);
        } else if (building.hasAssignedCitizen(citizen)) {
            building.removeCitizen(citizen);
        }
    }
}

