/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.network.messages.server.colony.building.postbox;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.requestsystem.requestable.Stack;
import com.minecolonies.coremod.colony.buildings.views.AbstractBuildingView;
import com.minecolonies.coremod.colony.buildings.workerbuildings.PostBox;
import com.minecolonies.coremod.network.messages.server.AbstractBuildingServerMessage;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;
import org.jetbrains.annotations.NotNull;

public class PostBoxRequestMessage
extends AbstractBuildingServerMessage<PostBox> {
    private ItemStack itemStack;
    private boolean deliverAvailable;
    private int reqQuantity;

    public PostBoxRequestMessage() {
    }

    public PostBoxRequestMessage(@NotNull AbstractBuildingView building, ItemStack itemStack, int quantity, boolean deliverAvailable) {
        super(building);
        this.itemStack = itemStack;
        this.reqQuantity = quantity;
        this.deliverAvailable = deliverAvailable;
    }

    @Override
    public void toBytesOverride(@NotNull PacketBuffer buf) {
        buf.func_150788_a(this.itemStack);
        buf.writeBoolean(this.deliverAvailable);
        buf.writeInt(this.reqQuantity);
    }

    @Override
    public void fromBytesOverride(@NotNull PacketBuffer buf) {
        this.itemStack = buf.func_150791_c();
        this.deliverAvailable = buf.readBoolean();
        this.reqQuantity = buf.readInt();
    }

    @Override
    protected void onExecute(NetworkEvent.Context ctxIn, boolean isLogicalServer, IColony colony, PostBox building) {
        int minCount = this.deliverAvailable ? 1 : this.reqQuantity;
        Stack requestStack = new Stack(this.itemStack, this.reqQuantity, minCount);
        building.createRequest(requestStack, false);
    }
}

