/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.network.messages.server.colony.building.worker;

import com.ldtteam.structurize.util.LanguageHandler;
import com.minecolonies.api.advancements.AdvancementTriggers;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.buildings.IBuildingWorker;
import com.minecolonies.api.colony.buildings.IBuildingWorkerView;
import com.minecolonies.api.colony.buildings.views.IBuildingView;
import com.minecolonies.api.colony.requestsystem.StandardFactoryController;
import com.minecolonies.api.colony.requestsystem.token.IToken;
import com.minecolonies.api.crafting.IRecipeStorage;
import com.minecolonies.api.util.constant.TypeConstants;
import com.minecolonies.coremod.network.messages.server.AbstractBuildingServerMessage;
import com.minecolonies.coremod.util.AdvancementUtils;
import java.util.List;
import net.minecraft.block.Blocks;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;
import org.jetbrains.annotations.NotNull;

public class AddRemoveRecipeMessage
extends AbstractBuildingServerMessage<IBuildingWorker> {
    private boolean remove;
    private IRecipeStorage storage;

    public AddRemoveRecipeMessage() {
    }

    public AddRemoveRecipeMessage(IBuildingWorkerView building, boolean remove, IRecipeStorage storage) {
        super(building);
        this.remove = remove;
        this.storage = storage;
    }

    public AddRemoveRecipeMessage(IBuildingView building, List<ItemStack> input, int gridSize, ItemStack primaryOutput, boolean remove) {
        super(building);
        this.remove = remove;
        this.storage = gridSize == 1 ? (IRecipeStorage)StandardFactoryController.getInstance().getNewInstance(TypeConstants.RECIPE, StandardFactoryController.getInstance().getNewInstance(TypeConstants.ITOKEN), new Object[]{input, gridSize, primaryOutput, Blocks.field_150460_al}) : (IRecipeStorage)StandardFactoryController.getInstance().getNewInstance(TypeConstants.RECIPE, StandardFactoryController.getInstance().getNewInstance(TypeConstants.ITOKEN), new Object[]{input, gridSize, primaryOutput});
    }

    @Override
    public void fromBytesOverride(@NotNull PacketBuffer buf) {
        this.storage = (IRecipeStorage)StandardFactoryController.getInstance().deserialize(buf);
        this.remove = buf.readBoolean();
    }

    @Override
    public void toBytesOverride(@NotNull PacketBuffer buf) {
        StandardFactoryController.getInstance().serialize(buf, this.storage);
        buf.writeBoolean(this.remove);
    }

    @Override
    public void onExecute(NetworkEvent.Context ctxIn, boolean isLogicalServer, IColony colony, IBuildingWorker building) {
        ServerPlayerEntity player = ctxIn.getSender();
        if (player == null) {
            return;
        }
        IToken<?> token = IColonyManager.getInstance().getRecipeManager().checkOrAddRecipe(this.storage);
        if (this.remove) {
            building.removeRecipe(token);
        } else if (!building.addRecipe(token)) {
            LanguageHandler.sendPlayerMessage((PlayerEntity)player, (String)"com.minecolonies.coremod.recipe.unable", (Object[])new Object[]{building.getJobName()});
        } else {
            AdvancementUtils.TriggerAdvancementPlayersForColony(colony, playerMP -> AdvancementTriggers.BUILDING_ADD_RECIPE.trigger((ServerPlayerEntity)playerMP, this.storage));
            LanguageHandler.sendPlayerMessage((PlayerEntity)player, (String)"com.minecolonies.coremod.gui.recipe.done", (Object[])new Object[0]);
        }
        building.markDirty();
    }
}

