/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.network.messages.server.colony.building.worker;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.buildings.IBuildingWorker;
import com.minecolonies.api.colony.buildings.views.IBuildingView;
import com.minecolonies.coremod.network.messages.server.AbstractBuildingServerMessage;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;
import org.jetbrains.annotations.NotNull;

public class ChangeRecipePriorityMessage
extends AbstractBuildingServerMessage<IBuildingWorker> {
    private int recipeLocation;
    private boolean up;

    public ChangeRecipePriorityMessage() {
    }

    public ChangeRecipePriorityMessage(@NotNull IBuildingView building, int location, boolean up) {
        super(building);
        this.recipeLocation = location;
        this.up = up;
    }

    @Override
    public void fromBytesOverride(@NotNull PacketBuffer buf) {
        this.recipeLocation = buf.readInt();
        this.up = buf.readBoolean();
    }

    @Override
    public void toBytesOverride(@NotNull PacketBuffer buf) {
        buf.writeInt(this.recipeLocation);
        buf.writeBoolean(this.up);
    }

    @Override
    protected void onExecute(NetworkEvent.Context ctxIn, boolean isLogicalServer, IColony colony, IBuildingWorker building) {
        if (this.up) {
            building.switchIndex(this.recipeLocation, this.recipeLocation - 1);
        } else {
            building.switchIndex(this.recipeLocation, this.recipeLocation + 1);
        }
    }
}

