/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.network.messages.server.colony.citizen;

import com.ldtteam.structurize.util.LanguageHandler;
import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.buildings.workerbuildings.ITownHall;
import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import com.minecolonies.api.util.Log;
import com.minecolonies.coremod.network.messages.server.AbstractColonyServerMessage;
import com.minecolonies.coremod.util.TeleportHelper;
import java.util.Optional;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkEvent;

public class RecallTownhallMessage
extends AbstractColonyServerMessage {
    public RecallTownhallMessage() {
    }

    public RecallTownhallMessage(IColony colony) {
        super(colony);
    }

    @Override
    protected void onExecute(NetworkEvent.Context ctxIn, boolean isLogicalServer, IColony colony) {
        ITownHall building = colony.getBuildingManager().getTownHall();
        if (building != null) {
            BlockPos location = building.getPosition();
            World world = colony.getWorld();
            for (ICitizenData citizenData : colony.getCitizenManager().getCitizens()) {
                Optional<AbstractEntityCitizen> optionalEntityCitizen = citizenData.getEntity();
                if (!optionalEntityCitizen.isPresent()) {
                    Log.getLogger().warn(String.format("Citizen #%d:%d has gone AWOL, respawning them!", colony.getID(), citizenData.getId()));
                    citizenData.updateEntityIfNecessary();
                    optionalEntityCitizen = citizenData.getEntity();
                }
                if (!optionalEntityCitizen.isPresent() || TeleportHelper.teleportCitizen(optionalEntityCitizen.get(), world, location)) continue;
                ServerPlayerEntity player = ctxIn.getSender();
                if (player == null) {
                    return;
                }
                LanguageHandler.sendPlayerMessage((PlayerEntity)player, (String)"com.minecolonies.coremod.workerhuts.recallFail", (Object[])new Object[0]);
            }
        }
    }

    @Override
    protected void toBytesOverride(PacketBuffer buf) {
    }

    @Override
    protected void fromBytesOverride(PacketBuffer buf) {
    }
}

