/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.permissions;

import com.ldtteam.structurize.items.ItemScanTool;
import com.ldtteam.structurize.util.LanguageHandler;
import com.minecolonies.api.blocks.AbstractBlockHut;
import com.minecolonies.api.blocks.ModBlocks;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.permissions.Action;
import com.minecolonies.api.colony.permissions.PermissionEvent;
import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import com.minecolonies.api.util.EntityUtils;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.coremod.MineColonies;
import com.minecolonies.coremod.colony.Colony;
import com.minecolonies.coremod.colony.jobs.AbstractJobGuard;
import com.minecolonies.coremod.colony.permissions.Permissions;
import com.minecolonies.coremod.entity.citizen.EntityCitizen;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.block.AirBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.ContainerBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.PotionItem;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.entity.item.ItemTossEvent;
import net.minecraftforge.event.entity.player.ArrowLooseEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.event.entity.player.FillBucketEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.event.world.ExplosionEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ColonyPermissionEventHandler {
    private final Colony colony;
    private int breakProgressOnTownHall = 0;
    private long lastTownHallBreakingTick = 0L;
    private boolean validTownHallBreak = false;
    private Map<UUID, Long> lastPlayerNotificationTick = new HashMap<UUID, Long>();

    public ColonyPermissionEventHandler(Colony colony) {
        this.colony = colony;
    }

    @SubscribeEvent
    public void on(BlockEvent.EntityPlaceEvent event) {
        Action action;
        Action action2 = action = event.getPlacedBlock().func_177230_c() instanceof AbstractBlockHut ? Action.PLACE_HUTS : Action.PLACE_BLOCKS;
        if (((Boolean)MineColonies.getConfig().getCommon().enableColonyProtection.get()).booleanValue() && this.checkBlockEventDenied(event.getWorld(), event.getPos(), event.getEntity(), event.getPlacedBlock(), action)) {
            this.cancelEvent((Event)event, event.getEntity(), this.colony, action, event.getPos());
        }
    }

    private boolean checkBlockEventDenied(IWorld worldIn, BlockPos posIn, Entity entity, BlockState blockState, Action action) {
        if (entity instanceof PlayerEntity) {
            PlayerEntity player = EntityUtils.getPlayerOfFakePlayer((PlayerEntity)entity, entity.field_70170_p);
            if (this.colony.isCoordInColony(entity.field_70170_p, posIn)) {
                if (!this.colony.getPermissions().isColonyMember(player)) {
                    return true;
                }
                if (blockState.func_177230_c() instanceof AbstractBlockHut && this.colony.getPermissions().hasPermission(player, action)) {
                    return false;
                }
                return !this.colony.getPermissions().hasPermission(player, action);
            }
        }
        return false;
    }

    private void cancelEvent(Event event, @Nullable Entity entity, Colony colony, Action action, BlockPos pos) {
        event.setResult(Event.Result.DENY);
        if (event.isCancelable()) {
            event.setCanceled(true);
            if (entity == null) {
                if (colony.hasTownHall()) {
                    colony.getBuildingManager().getTownHall().addPermissionEvent(new PermissionEvent(null, "-", action, pos));
                }
                return;
            }
            if (colony.hasTownHall()) {
                colony.getBuildingManager().getTownHall().addPermissionEvent(new PermissionEvent(entity.func_110124_au(), entity.func_200200_C_().func_150254_d(), action, pos));
            }
            if (entity instanceof FakePlayer) {
                return;
            }
            long worldTime = entity.field_70170_p.func_82737_E();
            if (!this.lastPlayerNotificationTick.containsKey(entity.func_110124_au()) || this.lastPlayerNotificationTick.get(entity.func_110124_au()) + (long)(20 * (Integer)MineColonies.getConfig().getCommon().secondsBetweenPermissionMessages.get()) < worldTime) {
                LanguageHandler.sendPlayerMessage((PlayerEntity)((PlayerEntity)entity), (String)"com.minecolonies.coremod.permission.no", (Object[])new Object[0]);
                this.lastPlayerNotificationTick.put(entity.func_110124_au(), worldTime);
            }
        }
    }

    @SubscribeEvent
    public void on(BlockEvent.BreakEvent event) {
        IWorld world = event.getWorld();
        if (!((Boolean)MineColonies.getConfig().getCommon().enableColonyProtection.get()).booleanValue() || world.func_201670_d()) {
            return;
        }
        if (event.getState().func_177230_c() instanceof AbstractBlockHut) {
            IBuilding building = IColonyManager.getInstance().getBuilding(event.getPlayer().field_70170_p, event.getPos());
            if (building == null) {
                return;
            }
            if (event.getState().func_177230_c() == ModBlocks.blockHutTownHall && !this.validTownHallBreak && !event.getPlayer().func_184812_l_()) {
                this.cancelEvent((Event)event, (Entity)event.getPlayer(), this.colony, Action.BREAK_HUTS, event.getPos());
                return;
            }
            if (!building.getColony().getPermissions().hasPermission(event.getPlayer(), Action.BREAK_HUTS) && this.checkEventCancelation(Action.BREAK_HUTS, event.getPlayer(), event.getPlayer().func_130014_f_(), (Event)event, event.getPos())) {
                return;
            }
            building.destroy();
            if (((Boolean)MineColonies.getConfig().getCommon().pvp_mode.get()).booleanValue() && event.getState().func_177230_c() == ModBlocks.blockHutTownHall) {
                IColonyManager.getInstance().deleteColonyByWorld(building.getColony().getID(), false, event.getPlayer().field_70170_p);
            }
        } else {
            this.checkEventCancelation(Action.BREAK_BLOCKS, event.getPlayer(), event.getPlayer().func_130014_f_(), (Event)event, event.getPos());
        }
    }

    @SubscribeEvent
    public void on(ExplosionEvent.Detonate event) {
        if (!((Boolean)MineColonies.getConfig().getCommon().turnOffExplosionsInColonies.get()).booleanValue()) {
            return;
        }
        World eventWorld = event.getWorld();
        Predicate<BlockPos> getBlocksInColony = pos -> this.colony.isCoordInColony(eventWorld, (BlockPos)pos);
        Predicate<Entity> getEntitiesInColony = entity -> this.colony.isCoordInColony(entity.func_130014_f_(), entity.func_180425_c());
        List blocksToRemove = event.getAffectedBlocks().stream().filter(getBlocksInColony).collect(Collectors.toList());
        List entitiesToRemove = event.getAffectedEntities().stream().filter(getEntitiesInColony).collect(Collectors.toList());
        event.getAffectedBlocks().removeAll(blocksToRemove);
        event.getAffectedEntities().removeAll(entitiesToRemove);
    }

    @SubscribeEvent
    public void on(ExplosionEvent.Start event) {
        if (((Boolean)MineColonies.getConfig().getCommon().enableColonyProtection.get()).booleanValue() && ((Boolean)MineColonies.getConfig().getCommon().turnOffExplosionsInColonies.get()).booleanValue() && this.colony.isCoordInColony(event.getWorld(), new BlockPos(event.getExplosion().getPosition()))) {
            this.cancelEvent((Event)event, null, this.colony, Action.EXPLODE, new BlockPos(event.getExplosion().getPosition()));
        }
    }

    @SubscribeEvent
    public void on(PlayerInteractEvent event) {
        if (this.colony.isCoordInColony(event.getWorld(), event.getPos()) && !(event instanceof PlayerInteractEvent.EntityInteract) && !(event instanceof PlayerInteractEvent.EntityInteractSpecific)) {
            Block block = event.getWorld().func_180495_p(event.getPos()).func_177230_c();
            if (event instanceof PlayerInteractEvent.RightClickBlock && block instanceof AbstractBlockHut && !this.colony.getPermissions().hasPermission(event.getPlayer(), Action.ACCESS_HUTS)) {
                this.cancelEvent((Event)event, (Entity)event.getPlayer(), this.colony, Action.ACCESS_HUTS, event.getPos());
                return;
            }
            Permissions perms = this.colony.getPermissions();
            if (this.isFreeToInteractWith(block, event.getPos()) && perms.hasPermission(event.getPlayer(), Action.ACCESS_FREE_BLOCKS)) {
                return;
            }
            if (((Boolean)MineColonies.getConfig().getCommon().enableColonyProtection.get()).booleanValue()) {
                if (!perms.hasPermission(event.getPlayer(), Action.RIGHTCLICK_BLOCK) && !(block instanceof AirBlock)) {
                    this.checkEventCancelation(Action.RIGHTCLICK_BLOCK, event.getPlayer(), event.getWorld(), (Event)event, event.getPos());
                    return;
                }
                if (block instanceof ContainerBlock && !perms.hasPermission(event.getPlayer(), Action.OPEN_CONTAINER)) {
                    this.cancelEvent((Event)event, (Entity)event.getPlayer(), this.colony, Action.OPEN_CONTAINER, event.getPos());
                    return;
                }
                if (event.getWorld().func_175625_s(event.getPos()) != null && !perms.hasPermission(event.getPlayer(), Action.RIGHTCLICK_ENTITY)) {
                    this.checkEventCancelation(Action.RIGHTCLICK_ENTITY, event.getPlayer(), event.getWorld(), (Event)event, event.getPos());
                    return;
                }
                ItemStack stack = event.getItemStack();
                if (ItemStackUtils.isEmpty(stack).booleanValue() || stack.func_77973_b().func_219971_r()) {
                    return;
                }
                if (stack.func_77973_b() instanceof PotionItem) {
                    this.checkEventCancelation(Action.THROW_POTION, event.getPlayer(), event.getWorld(), (Event)event, event.getPos());
                    return;
                }
                if (stack.func_77973_b() instanceof ItemScanTool && !perms.hasPermission(event.getPlayer(), Action.USE_SCAN_TOOL)) {
                    this.cancelEvent((Event)event, (Entity)event.getPlayer(), this.colony, Action.USE_SCAN_TOOL, event.getPos());
                }
            }
        }
    }

    private boolean isFreeToInteractWith(@Nullable Block block, BlockPos pos) {
        return block != null && this.colony.getFreeBlocks().stream().anyMatch(b -> b.equals(block)) || this.colony.getFreePositions().stream().anyMatch(position -> position.equals((Object)pos));
    }

    @SubscribeEvent
    public void on(PlayerInteractEvent.EntityInteract event) {
        if (this.isFreeToInteractWith(null, event.getPos()) && this.colony.getPermissions().hasPermission(event.getPlayer(), Action.ACCESS_FREE_BLOCKS)) {
            return;
        }
        this.checkEventCancelation(Action.RIGHTCLICK_ENTITY, event.getPlayer(), event.getWorld(), (Event)event, event.getPos());
    }

    @SubscribeEvent
    public void on(PlayerEvent.BreakSpeed event) {
        if (this.colony.isCoordInColony(event.getEntity().field_70170_p, event.getPos()) && ((Boolean)MineColonies.getConfig().getCommon().pvp_mode.get()).booleanValue() && event.getState().func_177230_c() == ModBlocks.blockHutTownHall && event.getPlayer().field_70170_p instanceof ServerWorld) {
            World world = event.getPlayer().field_70170_p;
            double localProgress = this.breakProgressOnTownHall;
            double hardness = (double)event.getState().func_185887_b((IBlockReader)world, event.getPos()) * 20.0 * 1.5 / (double)event.getNewSpeed();
            if (localProgress >= hardness / 10.0 * 9.0 && localProgress <= hardness / 10.0 * 9.0 + 1.0) {
                LanguageHandler.sendPlayersMessage(this.colony.getMessagePlayerEntities(), (String)"com.minecolonies.coremod.pvp.townhall.broke", (Object[])new Object[]{event.getPlayer().func_200200_C_(), 90});
            }
            if (localProgress >= hardness / 4.0 * 3.0 && localProgress <= hardness / 4.0 * 3.0 + 1.0) {
                LanguageHandler.sendPlayersMessage(this.colony.getMessagePlayerEntities(), (String)"com.minecolonies.coremod.pvp.townhall.broke", (Object[])new Object[]{event.getPlayer().func_200200_C_(), 75});
            } else if (localProgress >= hardness / 2.0 && localProgress <= hardness / 2.0 + 1.0) {
                LanguageHandler.sendPlayersMessage(this.colony.getMessagePlayerEntities(), (String)"com.minecolonies.coremod.pvp.townhall.broke", (Object[])new Object[]{event.getPlayer().func_200200_C_(), 50});
            } else if (localProgress >= hardness / 4.0 && localProgress <= hardness / 4.0 + 1.0) {
                LanguageHandler.sendPlayersMessage(this.colony.getMessagePlayerEntities(), (String)"com.minecolonies.coremod.pvp.townhall.broke", (Object[])new Object[]{event.getPlayer().func_200200_C_(), 25});
            }
            if (localProgress >= hardness - 1.0) {
                this.validTownHallBreak = true;
            }
            if (world.func_82737_E() - this.lastTownHallBreakingTick == 1L) {
                ++this.breakProgressOnTownHall;
            } else {
                LanguageHandler.sendPlayersMessage(this.colony.getImportantMessageEntityPlayers(), (String)"com.minecolonies.coremod.pvp.townhall.break.start", (Object[])new Object[]{event.getPlayer().func_200200_C_()});
                this.breakProgressOnTownHall = 0;
                this.validTownHallBreak = false;
            }
            this.lastTownHallBreakingTick = world.func_82737_E();
        } else if (!((Boolean)MineColonies.getConfig().getCommon().pvp_mode.get()).booleanValue()) {
            this.validTownHallBreak = true;
        }
    }

    private boolean checkEventCancelation(Action action, @NotNull PlayerEntity playerIn, @NotNull World world, @NotNull Event event, @Nullable BlockPos pos) {
        PlayerEntity player = EntityUtils.getPlayerOfFakePlayer(playerIn, world);
        BlockPos positionToCheck = pos;
        if (null == positionToCheck) {
            positionToCheck = player.func_180425_c();
        }
        if (((Boolean)MineColonies.getConfig().getCommon().enableColonyProtection.get()).booleanValue() && this.colony.isCoordInColony(player.func_130014_f_(), positionToCheck) && !this.colony.getPermissions().hasPermission(player, action)) {
            if (((Boolean)MineColonies.getConfig().getCommon().pvp_mode.get()).booleanValue()) {
                if (!world.field_72995_K && this.colony.isValidAttackingPlayer(playerIn)) {
                    return false;
                }
            } else {
                this.cancelEvent(event, (Entity)player, this.colony, action, positionToCheck);
                return true;
            }
        }
        return false;
    }

    @SubscribeEvent
    public void on(PlayerInteractEvent.EntityInteractSpecific event) {
        if (this.isFreeToInteractWith(null, event.getPos()) && this.colony.getPermissions().hasPermission(event.getPlayer(), Action.ACCESS_FREE_BLOCKS)) {
            return;
        }
        this.checkEventCancelation(Action.RIGHTCLICK_ENTITY, event.getPlayer(), event.getWorld(), (Event)event, event.getPos());
    }

    @SubscribeEvent
    public void on(ItemTossEvent event) {
        if (this.checkEventCancelation(Action.TOSS_ITEM, event.getPlayer(), event.getPlayer().func_130014_f_(), (Event)event, event.getPlayer().func_180425_c())) {
            event.getPlayer().field_71071_by.func_70441_a(event.getEntityItem().func_92059_d());
        }
    }

    @SubscribeEvent
    public void on(EntityItemPickupEvent event) {
        this.checkEventCancelation(Action.PICKUP_ITEM, event.getPlayer(), event.getPlayer().func_130014_f_(), (Event)event, event.getPlayer().func_180425_c());
    }

    @SubscribeEvent
    public void on(FillBucketEvent event) {
        BlockPos targetBlockPos = null;
        if (event.getTarget() instanceof BlockRayTraceResult) {
            targetBlockPos = ((BlockRayTraceResult)event.getTarget()).func_216350_a();
        } else if (event.getTarget() instanceof EntityRayTraceResult) {
            targetBlockPos = ((EntityRayTraceResult)event.getTarget()).func_216348_a().func_180425_c();
        }
        this.checkEventCancelation(Action.FILL_BUCKET, event.getPlayer(), event.getPlayer().func_130014_f_(), (Event)event, targetBlockPos);
    }

    @SubscribeEvent
    public void on(ArrowLooseEvent event) {
        this.checkEventCancelation(Action.SHOOT_ARROW, event.getPlayer(), event.getPlayer().func_130014_f_(), (Event)event, event.getEntity().func_180425_c());
    }

    @SubscribeEvent
    public void on(AttackEntityEvent event) {
        if (event.getTarget() instanceof MobEntity) {
            return;
        }
        PlayerEntity player = EntityUtils.getPlayerOfFakePlayer(event.getPlayer(), event.getPlayer().func_130014_f_());
        if (((Boolean)MineColonies.getConfig().getCommon().enableColonyProtection.get()).booleanValue() && this.colony.isCoordInColony(player.func_130014_f_(), player.func_180425_c())) {
            Permissions perms = this.colony.getPermissions();
            if (event.getTarget() instanceof EntityCitizen) {
                AbstractEntityCitizen citizen = (AbstractEntityCitizen)event.getTarget();
                if (citizen.getCitizenJobHandler().getColonyJob() instanceof AbstractJobGuard && perms.hasPermission(event.getPlayer(), Action.GUARDS_ATTACK)) {
                    return;
                }
                if (perms.hasPermission(event.getPlayer(), Action.ATTACK_CITIZEN)) {
                    return;
                }
                this.cancelEvent((Event)event, (Entity)event.getPlayer(), this.colony, Action.ATTACK_CITIZEN, event.getTarget().func_180425_c());
                return;
            }
            if (!(event.getTarget() instanceof MobEntity) && !perms.hasPermission(event.getPlayer(), Action.ATTACK_ENTITY)) {
                this.cancelEvent((Event)event, (Entity)event.getPlayer(), this.colony, Action.ATTACK_ENTITY, event.getTarget().func_180425_c());
            }
        }
    }
}

